/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.dataItems;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.dataItems.FieldData;
import mockit.coverage.dataItems.InstanceFieldData;
import mockit.coverage.dataItems.StaticFieldData;

public final class PerFileDataCoverage
implements PerFileCoverage {
    private static final long serialVersionUID = -4561686103982673490L;
    @Nonnull
    public final List<String> allFields = new ArrayList<String>(2);
    @Nonnull
    public final Map<String, StaticFieldData> staticFieldsData = new LinkedHashMap<String, StaticFieldData>();
    @Nonnull
    public final Map<String, InstanceFieldData> instanceFieldsData = new LinkedHashMap<String, InstanceFieldData>();
    private transient int coveredDataItems = -1;

    private void readObject(@Nonnull ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.coveredDataItems = -1;
        in.defaultReadObject();
    }

    public void addField(@Nonnull String className, @Nonnull String fieldName, boolean isStatic) {
        String classAndField = className + '.' + fieldName;
        if (!this.allFields.contains(classAndField)) {
            this.allFields.add(classAndField);
        }
        if (isStatic) {
            this.staticFieldsData.put(classAndField, new StaticFieldData());
        } else {
            this.instanceFieldsData.put(classAndField, new InstanceFieldData());
        }
    }

    public boolean isFieldWithCoverageData(@Nonnull String classAndFieldNames) {
        return this.instanceFieldsData.containsKey(classAndFieldNames) || this.staticFieldsData.containsKey(classAndFieldNames);
    }

    public void registerAssignmentToStaticField(@Nonnull String classAndFieldNames) {
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        if (staticData != null) {
            staticData.registerAssignment();
        }
    }

    @Nullable
    public StaticFieldData getStaticFieldData(@Nonnull String classAndFieldNames) {
        return this.staticFieldsData.get(classAndFieldNames);
    }

    public void registerReadOfStaticField(@Nonnull String classAndFieldNames) {
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        if (staticData != null) {
            staticData.registerRead();
        }
    }

    public void registerAssignmentToInstanceField(@Nonnull Object instance, @Nonnull String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        if (instanceData != null) {
            instanceData.registerAssignment(instance);
        }
    }

    @Nullable
    public InstanceFieldData getInstanceFieldData(@Nonnull String classAndFieldNames) {
        return this.instanceFieldsData.get(classAndFieldNames);
    }

    public void registerReadOfInstanceField(@Nonnull Object instance, @Nonnull String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        if (instanceData != null) {
            instanceData.registerRead(instance);
        }
    }

    public boolean hasFields() {
        return !this.allFields.isEmpty();
    }

    public boolean isCovered(@Nonnull String classAndFieldNames) {
        InstanceFieldData instanceData = this.getInstanceFieldData(classAndFieldNames);
        if (instanceData != null && instanceData.isCovered()) {
            return true;
        }
        StaticFieldData staticData = this.getStaticFieldData(classAndFieldNames);
        return staticData != null && staticData.isCovered();
    }

    @Override
    public int getTotalItems() {
        return this.staticFieldsData.size() + this.instanceFieldsData.size();
    }

    @Override
    public int getCoveredItems() {
        if (this.coveredDataItems >= 0) {
            return this.coveredDataItems;
        }
        this.coveredDataItems = 0;
        for (StaticFieldData staticData : this.staticFieldsData.values()) {
            if (!staticData.isCovered()) continue;
            ++this.coveredDataItems;
        }
        for (InstanceFieldData instanceData : this.instanceFieldsData.values()) {
            if (!instanceData.isCovered()) continue;
            ++this.coveredDataItems;
        }
        return this.coveredDataItems;
    }

    @Override
    public int getCoveragePercentage() {
        int totalFields = this.getTotalItems();
        if (totalFields == 0) {
            return -1;
        }
        return CoveragePercentage.calculate(this.getCoveredItems(), totalFields);
    }

    public void mergeInformation(@Nonnull PerFileDataCoverage previousInfo) {
        PerFileDataCoverage.addInfoFromPreviousTestRun(this.staticFieldsData, previousInfo.staticFieldsData);
        PerFileDataCoverage.addFieldsFromPreviousTestRunIfAbsent(this.staticFieldsData, previousInfo.staticFieldsData);
        PerFileDataCoverage.addInfoFromPreviousTestRun(this.instanceFieldsData, previousInfo.instanceFieldsData);
        PerFileDataCoverage.addFieldsFromPreviousTestRunIfAbsent(this.instanceFieldsData, previousInfo.instanceFieldsData);
    }

    private static <FI extends FieldData> void addInfoFromPreviousTestRun(@Nonnull Map<String, FI> currentInfo, @Nonnull Map<String, FI> previousInfo) {
        for (Map.Entry<String, FI> nameAndInfo : currentInfo.entrySet()) {
            String fieldName = nameAndInfo.getKey();
            FieldData previousFieldInfo = (FieldData)previousInfo.get(fieldName);
            if (previousFieldInfo == null) continue;
            FieldData fieldInfo = (FieldData)nameAndInfo.getValue();
            fieldInfo.addCountsFromPreviousTestRun(previousFieldInfo);
        }
    }

    private static <FI extends FieldData> void addFieldsFromPreviousTestRunIfAbsent(@Nonnull Map<String, FI> currentInfo, @Nonnull Map<String, FI> previousInfo) {
        for (Map.Entry<String, FI> nameAndInfo : previousInfo.entrySet()) {
            String fieldName = nameAndInfo.getKey();
            if (currentInfo.containsKey(fieldName)) continue;
            currentInfo.put(fieldName, previousInfo.get(fieldName));
        }
    }
}

