/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.standalone;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import javax.annotation.Nonnull;

public final class AgentLoader {
    private static final float JAVA_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    @Nonnull
    private final String processIdForTargetVM;

    public AgentLoader(@Nonnull String processIdForTargetVM) {
        if (JAVA_VERSION < 1.6f) {
            throw new IllegalStateException("JMockit Coverage requires a Java 6+ VM");
        }
        this.processIdForTargetVM = processIdForTargetVM;
    }

    public void loadAgent() {
        try {
            VirtualMachine vm = VirtualMachine.attach(this.processIdForTargetVM);
            String jarFilePath = this.getPathToJarFile();
            vm.loadAgent(jarFilePath, null);
            vm.detach();
        }
        catch (AttachNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (AgentLoadException e) {
            throw new IllegalStateException(e);
        }
        catch (AgentInitializationException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private String getPathToJarFile() {
        URI jarFileURI;
        CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
        URL location = codeSource.getLocation();
        try {
            jarFileURI = location.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!"file".equals(jarFileURI.getScheme())) {
            String locationPath = location.toExternalForm();
            int p = locationPath.indexOf(58);
            return locationPath.substring(p + 2);
        }
        return new File(jarFileURI).getPath();
    }
}

