/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.BaseInvocation;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.ParameterTypeRedefinitions;
import mockit.internal.state.CascadingTypes;
import mockit.internal.util.Utilities;

public final class ExecutingTest {
    @Nullable
    private RecordAndReplayExecution currentRecordAndReplay;
    @Nullable
    private RecordAndReplayExecution recordAndReplayForLastTestMethod;
    @Nonnull
    private final ThreadLocal<Boolean> shouldIgnoreMockingCallbacks = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    @Nonnull
    private final ThreadLocal<BaseInvocation> proceedingInvocation = new ThreadLocal();
    private boolean proceeding;
    @Nullable
    private ParameterTypeRedefinitions parameterTypeRedefinitions;
    @Nonnull
    private final List<Object> regularMocks = new ArrayList<Object>();
    @Nonnull
    private final List<Object> injectableMocks = new ArrayList<Object>();
    @Nonnull
    private final List<Object> strictMocks = new ArrayList<Object>();
    @Nonnull
    private final Map<Object, Object> originalToCapturedInstance = new IdentityHashMap<Object, Object>(4);
    @Nonnull
    private final CascadingTypes cascadingTypes = new CascadingTypes();

    ExecutingTest() {
    }

    @Nonnull
    public RecordAndReplayExecution getOrCreateRecordAndReplay() {
        if (this.currentRecordAndReplay == null) {
            this.setRecordAndReplay(new RecordAndReplayExecution());
        }
        return this.currentRecordAndReplay;
    }

    @Nullable
    public RecordAndReplayExecution getPreviousRecordAndReplay() {
        RecordAndReplayExecution previous = this.currentRecordAndReplay;
        this.currentRecordAndReplay = null;
        return previous;
    }

    public void setRecordAndReplay(@Nullable RecordAndReplayExecution newRecordAndReplay) {
        this.recordAndReplayForLastTestMethod = null;
        this.currentRecordAndReplay = newRecordAndReplay;
    }

    @Nullable
    public RecordAndReplayExecution getCurrentRecordAndReplay() {
        return this.currentRecordAndReplay;
    }

    public boolean isShouldIgnoreMockingCallbacks() {
        return this.shouldIgnoreMockingCallbacks.get();
    }

    public boolean setShouldIgnoreMockingCallbacks(boolean flag) {
        boolean previousFlag = this.shouldIgnoreMockingCallbacks.get();
        this.shouldIgnoreMockingCallbacks.set(flag);
        return previousFlag;
    }

    public boolean isProceedingIntoRealImplementation() {
        boolean result = this.proceeding;
        this.proceeding = false;
        return result;
    }

    public void markAsProceedingIntoRealImplementation() {
        this.proceeding = true;
    }

    @Nullable
    public BaseInvocation getProceedingInvocation() {
        return this.proceedingInvocation.get();
    }

    public void markAsProceedingIntoRealImplementation(@Nonnull BaseInvocation invocation) {
        BaseInvocation previousInvocation = this.proceedingInvocation.get();
        if (previousInvocation != null) {
            invocation.setPrevious(previousInvocation);
        }
        this.proceedingInvocation.set(invocation);
        this.proceeding = true;
    }

    public boolean shouldProceedIntoRealImplementation(@Nullable Object mock, @Nonnull String classDesc) {
        BaseInvocation pendingInvocation = this.proceedingInvocation.get();
        if (pendingInvocation != null && pendingInvocation.isMethodInSuperclass(mock, classDesc)) {
            return true;
        }
        return this.isProceedingIntoRealImplementation();
    }

    public void clearProceedingState() {
        BaseInvocation pendingInvocation = this.proceedingInvocation.get();
        BaseInvocation previousInvocation = pendingInvocation.getPrevious();
        this.proceedingInvocation.set(previousInvocation);
    }

    @Nonnull
    RecordAndReplayExecution getRecordAndReplayForVerifications() {
        if (this.currentRecordAndReplay == null) {
            this.currentRecordAndReplay = this.recordAndReplayForLastTestMethod != null ? this.recordAndReplayForLastTestMethod : new RecordAndReplayExecution();
        }
        RecordAndReplayExecution.TEST_ONLY_PHASE_LOCK.lock();
        return this.currentRecordAndReplay;
    }

    @Nullable
    public ParameterTypeRedefinitions getParameterRedefinitions() {
        return this.parameterTypeRedefinitions;
    }

    public void setParameterRedefinitions(@Nonnull ParameterTypeRedefinitions redefinitions) {
        this.parameterTypeRedefinitions = redefinitions;
    }

    public void clearInjectableAndNonStrictMocks() {
        this.regularMocks.clear();
        this.injectableMocks.clear();
        this.originalToCapturedInstance.clear();
    }

    public void addInjectableMock(@Nonnull Object mock) {
        if (!this.isInjectableMock(mock)) {
            this.injectableMocks.add(mock);
        }
    }

    public boolean isInjectableMock(@Nonnull Object instance) {
        return Utilities.containsReference(this.injectableMocks, (Object)instance);
    }

    public boolean isClassWithInjectableMocks(@Nonnull Class<?> aClass) {
        int n = this.injectableMocks.size();
        for (int i = 0; i < n; ++i) {
            Object injectableMock = this.injectableMocks.get(i);
            if (injectableMock.getClass() != aClass) continue;
            return true;
        }
        return false;
    }

    public boolean isRegularMockedInstance(@Nonnull Object instance) {
        return Utilities.containsReference(this.regularMocks, (Object)instance);
    }

    public boolean isMockedInstance(@Nonnull Object instance) {
        return Utilities.containsReference(this.regularMocks, (Object)instance) || this.isInjectableMock(instance);
    }

    public void addCapturedInstanceForInjectableMock(@Nullable Object originalInstance, @Nonnull Object capturedInstance) {
        this.injectableMocks.add(capturedInstance);
        this.addCapturedInstance(originalInstance, capturedInstance);
    }

    public void addCapturedInstance(@Nullable Object originalInstance, @Nonnull Object capturedInstance) {
        this.originalToCapturedInstance.put(capturedInstance, originalInstance);
    }

    public boolean isInvokedInstanceEquivalentToCapturedInstance(@Nonnull Object invokedInstance, @Nonnull Object capturedInstance) {
        return invokedInstance == this.originalToCapturedInstance.get(capturedInstance) || capturedInstance == this.originalToCapturedInstance.get(invokedInstance);
    }

    public void addStrictMock(@Nullable Object mock, @Nullable String mockClassDesc) {
        String uniqueMockClassDesc;
        this.addStrictMock(mock);
        if (mockClassDesc != null && !this.containsStrictMock(uniqueMockClassDesc = mockClassDesc.intern())) {
            this.strictMocks.add(uniqueMockClassDesc);
        }
    }

    private void addStrictMock(@Nullable Object mock) {
        if (mock != null && !this.containsStrictMock(mock)) {
            this.strictMocks.add(mock);
        }
    }

    private boolean containsStrictMock(@Nonnull Object mockOrClassDesc) {
        return Utilities.containsReference(this.strictMocks, (Object)mockOrClassDesc);
    }

    public static boolean isInstanceMethodWithStandardBehavior(@Nullable Object mock, @Nonnull String nameAndDesc) {
        return mock != null && nameAndDesc.charAt(0) != '<' && ("equals(Ljava/lang/Object;)Z hashCode()I toString()Ljava/lang/String;".contains(nameAndDesc) || mock instanceof Comparable && nameAndDesc.startsWith("compareTo(L") && nameAndDesc.endsWith(";)I"));
    }

    public void registerMock(@Nonnull MockedType typeMetadata, @Nonnull Object mock) {
        if (typeMetadata.injectable) {
            this.addInjectableMock(mock);
        } else if (!Utilities.containsReference(this.regularMocks, (Object)mock)) {
            this.regularMocks.add(mock);
        }
    }

    public boolean isStrictInvocation(@Nullable Object mock, @Nonnull String mockClassDesc, @Nonnull String mockNameAndDesc) {
        if (ExecutingTest.isInstanceMethodWithStandardBehavior(mock, mockNameAndDesc)) {
            return false;
        }
        for (Object strictMock : this.strictMocks) {
            if (strictMock == mock) {
                return true;
            }
            if (strictMock != mockClassDesc) continue;
            this.addStrictMock(mock);
            return true;
        }
        return false;
    }

    @Nonnull
    public CascadingTypes getCascadingTypes() {
        return this.cascadingTypes;
    }

    void finishExecution() {
        this.recordAndReplayForLastTestMethod = this.currentRecordAndReplay;
        this.currentRecordAndReplay = null;
        if (this.parameterTypeRedefinitions != null) {
            this.parameterTypeRedefinitions.cleanUp();
            this.parameterTypeRedefinitions = null;
        }
        this.strictMocks.clear();
        this.cascadingTypes.clearNonSharedCascadingTypes();
    }
}

