/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.util.Comparator;
import jodd.util.CharUtil;

public class NaturalOrderComparator<T>
implements Comparator<T> {
    protected final boolean ignoreCase;

    public NaturalOrderComparator() {
        this.ignoreCase = false;
    }

    public NaturalOrderComparator(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    protected int compareDigits(String str1, int ndx1, String str2, int ndx2) {
        int bias = 0;
        while (true) {
            char char1 = NaturalOrderComparator.charAt(str1, ndx1);
            char char2 = NaturalOrderComparator.charAt(str2, ndx2);
            boolean isDigitChar1 = CharUtil.isDigit(char1);
            boolean isDigitChar2 = CharUtil.isDigit(char2);
            if (!isDigitChar1 && !isDigitChar2) {
                return bias;
            }
            if (!isDigitChar1) {
                return -1;
            }
            if (!isDigitChar2) {
                return 1;
            }
            if (char1 < char2) {
                if (bias == 0) {
                    bias = -1;
                }
            } else if (char1 > char2) {
                if (bias == 0) {
                    bias = 1;
                }
            } else if (char1 == '\u0000' && char2 == '\u0000') {
                return bias;
            }
            ++ndx1;
            ++ndx2;
        }
    }

    @Override
    public int compare(T o1, T o2) {
        String str1 = o1.toString();
        String str2 = o2.toString();
        int ndx1 = 0;
        int ndx2 = 0;
        while (true) {
            int zeroCount2 = 0;
            int zeroCount1 = 0;
            char char1 = NaturalOrderComparator.charAt(str1, ndx1);
            char char2 = NaturalOrderComparator.charAt(str2, ndx2);
            while (Character.isSpaceChar(char1) || char1 == '0') {
                zeroCount1 = char1 == '0' ? ++zeroCount1 : 0;
                char1 = NaturalOrderComparator.charAt(str1, ++ndx1);
            }
            while (Character.isSpaceChar(char2) || char2 == '0') {
                zeroCount2 = char2 == '0' ? ++zeroCount2 : 0;
                char2 = NaturalOrderComparator.charAt(str2, ++ndx2);
            }
            boolean isDigitChar1 = CharUtil.isDigit(char1);
            boolean isDigitChar2 = CharUtil.isDigit(char2);
            if (isDigitChar1 && isDigitChar2) {
                int result = this.compareDigits(str1, ndx1, str2, ndx2);
                if (result != 0) {
                    return result;
                }
                if (zeroCount1 != zeroCount2) {
                    return zeroCount1 - zeroCount2;
                }
            }
            if (char1 == '\u0000' && char2 == '\u0000') {
                return zeroCount1 - zeroCount2;
            }
            if ((isDigitChar1 || isDigitChar2) && zeroCount1 != zeroCount2) {
                return zeroCount2 - zeroCount1;
            }
            if (zeroCount1 != zeroCount2) {
                return zeroCount1 - zeroCount2;
            }
            if (this.ignoreCase) {
                char1 = Character.toLowerCase(char1);
                char2 = Character.toLowerCase(char2);
            }
            if (char1 < char2) {
                return -1;
            }
            if (char1 > char2) {
                return 1;
            }
            ++ndx1;
            ++ndx2;
        }
    }

    private static char charAt(String s, int i) {
        if (i >= s.length()) {
            return '\u0000';
        }
        return s.charAt(i);
    }
}

