/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image;

import com.idrsolutions.image.png.PngCompressor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JDeli {
    private static final Color BACKGROUND_COLOR = new Color(84, 130, 31);
    private static final Color FOREGROUND_COLOR = Color.WHITE;
    private static final Font FONT = new Font("SansSerif", 1, 13);

    private static void doAction(String actionAsString, String[] args) {
        Action action;
        try {
            action = Action.valueOf(actionAsString.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            action = null;
        }
        if (action == null) {
            System.out.println("JDeli action '" + actionAsString + "' not recognised. Available actions are: " + Arrays.toString((Object[])Action.values()));
        } else {
            switch (action) {
                case COMPRESSPNG: {
                    PngCompressor.main(args);
                }
            }
        }
    }

    private static String[] removeFirstValue(String[] inputValues) {
        int newArraySize = inputValues.length - 1;
        String[] outputValues = new String[newArraySize];
        System.arraycopy(inputValues, 1, outputValues, 0, newArraySize);
        return outputValues;
    }

    private static JLabel getStyledLabel(JLabel label) {
        label.setFont(FONT);
        label.setForeground(FOREGROUND_COLOR);
        return label;
    }

    private static void showHelpWindow() {
        final JFrame jf = new JFrame("JDeli - Java Decoding and Encoding Library for Images");
        jf.setSize(440, 400);
        jf.setDefaultCloseOperation(3);
        final JPanel panel = new JPanel();
        panel.setBackground(BACKGROUND_COLOR);
        panel.setLayout(new GridLayout(0, 1));
        ImageIcon logo = new ImageIcon(JDeli.class.getClass().getResource("/com/idrsolutions/image/res/logo.png"));
        JLabel idrLogo = new JLabel(logo);
        jf.getContentPane().add((Component)idrLogo, "North");
        panel.add(JDeli.getStyledLabel(new JLabel(" JDeli - Java Decoding and Encoding Library for Images")));
        panel.add(JDeli.getStyledLabel(new JLabel(" ")));
        panel.add(JDeli.getStyledLabel(new JLabel(" Features: ")));
        panel.add(JDeli.getStyledLabel(new JLabel("          TiffEncoder (Single/Multi Page)")));
        panel.add(JDeli.getStyledLabel(new JLabel("          TiffDecoder (Single/Multi Page)")));
        panel.add(JDeli.getStyledLabel(new JLabel("          PngEncoder")));
        panel.add(JDeli.getStyledLabel(new JLabel("          PngCompressor")));
        panel.add(JDeli.getStyledLabel(new JLabel("          JpegEncoder")));
        panel.add(JDeli.getStyledLabel(new JLabel("          JpegDecoder")));
        panel.add(JDeli.getStyledLabel(new JLabel("          Jpeg2000Decoder")));
        panel.add(JDeli.getStyledLabel(new JLabel(" ")));
        final JLabel homeURL = new JLabel("<html>&nbsp;Homepage: https://www.idrsolutions.com/jdeli</html>");
        homeURL.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
                homeURL.setText("<html>&nbsp;Homepage: <u>https://www.idrsolutions.com/jdeli</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
                homeURL.setText("<html>&nbsp;Homepage: https://www.idrsolutions.com/jdeli</html>");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.idrsolutions.com/jdeli"));
                }
                catch (IOException e1) {
                    JDeli.writeLog("Exception: " + e1.getMessage());
                }
                catch (URISyntaxException ex) {
                    JDeli.writeLog("Exception: " + ex.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        panel.add(JDeli.getStyledLabel(homeURL));
        final JLabel licenceURL = new JLabel("<html>&nbsp;License: https://www.idrsolutions.com/jdeli/license</html>");
        licenceURL.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
                licenceURL.setText("<html>&nbsp;License: <u>https://www.idrsolutions.com/jdeli/license</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
                licenceURL.setText("<html>&nbsp;License: https://www.idrsolutions.com/jdeli/license</html>");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://www.idrsolutions.com/jdeli/license"));
                }
                catch (URISyntaxException e1) {
                    JDeli.writeLog("Exception: " + e1.getMessage());
                }
                catch (IOException ex) {
                    JDeli.writeLog("Exception :" + ex.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        panel.add(JDeli.getStyledLabel(licenceURL));
        final JLabel javadocURL = new JLabel("<html>&nbsp;Javadoc: https://files.idrsolutions.com/jdeli-javadoc/</html>");
        javadocURL.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setCursor(new Cursor(12));
                javadocURL.setText("<html>&nbsp;Javadoc: <u>https://files.idrsolutions.com/jdeli-javadoc/</u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setCursor(new Cursor(0));
                javadocURL.setText("<html>&nbsp;Javadoc: https://files.idrsolutions.com/jdeli-javadoc/</html>");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://files.idrsolutions.com/jdeli-javadoc/"));
                }
                catch (IOException e1) {
                    JDeli.writeLog("Exception: " + e1.getMessage());
                }
                catch (URISyntaxException ex) {
                    JDeli.writeLog("Exception: " + ex.getMessage());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        panel.add(JDeli.getStyledLabel(javadocURL));
        panel.add(JDeli.getStyledLabel(new JLabel(" ")));
        panel.add(JDeli.getStyledLabel(new JLabel(" Available command line arguments are: " + Arrays.toString((Object[])Action.values()))));
        panel.add(JDeli.getStyledLabel(new JLabel(" ")));
        jf.getContentPane().add((Component)panel, "Center");
        JPanel bPanel = new JPanel();
        bPanel.setBackground(BACKGROUND_COLOR);
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jf.dispose();
            }
        });
        button.setSize(150, 75);
        button.setMaximumSize(new Dimension(150, 75));
        bPanel.add(button);
        jf.getContentPane().add((Component)bPanel, "South");
        jf.setVisible(true);
        jf.setLocationRelativeTo(null);
        jf.setResizable(false);
    }

    private static void writeLog(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JDeli.showHelp();
        } else {
            JDeli.doAction(args[0], JDeli.removeFirstValue(args));
        }
    }

    private static void showHelp() {
        String info = "JDeli - Java Decoding and Encoding Library for Images\n\nFeatures:\n\tTiffEncoder (Single/Multi Page)\n\tTiffDecoder (Single/Multi Page)\n\tPngEncoder\n\tPngCompressor\n\tJpegEncoder\n\tJpegDecoder\n\tJpeg2000Decoder\n\nHomepage: https://www.idrsolutions.com/jdeli\nLicense: https://www.idrsolutions.com/jdeli/license\nJavadoc: https://files.idrsolutions.com/jdeli-javadoc/\n\nAvailable command line arguments are: " + Arrays.toString((Object[])Action.values());
        if (System.console() != null) {
            System.out.println(info);
        } else if (!GraphicsEnvironment.isHeadless()) {
            JDeli.showHelpWindow();
        }
    }

    private static enum Action {
        COMPRESSPNG;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

