/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.IndexMap;
import com.idrsolutions.image.jpeg.JpegLUT;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Stack;

public class JpegHuffman {
    private int bitsToPut;
    private int bufferToPut;
    private final int[] DC_matrix0;
    private final int[] AC_matrix0;
    private final int[] DC_matrix1;
    private final int[] AC_matrix1;
    public final ArrayList<int[]> bitList = new ArrayList();
    public final ArrayList<int[]> valList;
    private static final int[] bitsDCchrominance = new int[]{1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final int[] bitsDCluminance = new int[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] bitsACchrominance = new int[]{17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    private static final int[] bitsACluminance = new int[]{16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    private static final int[] valDCchrominance = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] valDCluminance = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] valACchrominance = new int[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private static final int[] valACluminance = new int[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private final int AC0_0;
    private final int AC0_1;
    private final int AC0_480;
    private final int AC0_481;
    private final int AC1_0;
    private final int AC1_1;
    private final int AC1_480;
    private final int AC1_481;

    public JpegHuffman() {
        int i;
        int l;
        this.bitList.add(bitsDCluminance);
        this.bitList.add(bitsACluminance);
        this.bitList.add(bitsDCchrominance);
        this.bitList.add(bitsACchrominance);
        this.valList = new ArrayList();
        this.valList.add(valDCluminance);
        this.valList.add(valACluminance);
        this.valList.add(valDCchrominance);
        this.valList.add(valACchrominance);
        this.DC_matrix0 = new int[24];
        this.DC_matrix1 = new int[24];
        this.AC_matrix0 = new int[510];
        this.AC_matrix1 = new int[510];
        int[] huffsize = new int[257];
        int[] huffcode = new int[257];
        int p = 0;
        for (int l2 = 1; l2 <= 16; ++l2) {
            for (int i2 = 1; i2 <= bitsDCchrominance[l2]; ++i2) {
                huffsize[p++] = l2;
            }
        }
        huffsize[p] = 0;
        int lastp = p;
        int code = 0;
        int si = huffsize[0];
        p = 0;
        while (huffsize[p] != 0) {
            while (huffsize[p] == si) {
                huffcode[p++] = code++;
            }
            code <<= 1;
            ++si;
        }
        int dp = 0;
        for (p = 0; p < lastp; ++p) {
            this.DC_matrix1[dp++] = huffcode[p];
            this.DC_matrix1[dp++] = huffsize[p];
        }
        p = 0;
        for (l = 1; l <= 16; ++l) {
            for (i = 1; i <= bitsACchrominance[l]; ++i) {
                huffsize[p++] = l;
            }
        }
        huffsize[p] = 0;
        lastp = p;
        code = 0;
        si = huffsize[0];
        p = 0;
        while (huffsize[p] != 0) {
            while (huffsize[p] == si) {
                huffcode[p++] = code++;
            }
            code <<= 1;
            ++si;
        }
        for (p = 0; p < lastp; ++p) {
            dp = valACchrominance[p] << 1;
            this.AC_matrix1[dp] = huffcode[p];
            this.AC_matrix1[dp + 1] = huffsize[p];
        }
        p = 0;
        for (l = 1; l <= 16; ++l) {
            for (i = 1; i <= bitsDCluminance[l]; ++i) {
                huffsize[p++] = l;
            }
        }
        huffsize[p] = 0;
        lastp = p;
        code = 0;
        si = huffsize[0];
        p = 0;
        while (huffsize[p] != 0) {
            while (huffsize[p] == si) {
                huffcode[p++] = code++;
            }
            code <<= 1;
            ++si;
        }
        dp = 0;
        for (p = 0; p < lastp; ++p) {
            this.DC_matrix0[dp++] = huffcode[p];
            this.DC_matrix0[dp++] = huffsize[p];
        }
        p = 0;
        for (l = 1; l <= 16; ++l) {
            for (i = 1; i <= bitsACluminance[l]; ++i) {
                huffsize[p++] = l;
            }
        }
        huffsize[p] = 0;
        lastp = p;
        code = 0;
        si = huffsize[0];
        p = 0;
        while (huffsize[p] != 0) {
            while (huffsize[p] == si) {
                huffcode[p++] = code++;
            }
            code <<= 1;
            ++si;
        }
        for (int q = 0; q < lastp; ++q) {
            dp = valACluminance[q] << 1;
            this.AC_matrix0[dp] = huffcode[q];
            this.AC_matrix0[dp + 1] = huffsize[q];
        }
        this.AC0_0 = this.AC_matrix0[0];
        this.AC0_1 = this.AC_matrix0[1];
        this.AC0_480 = this.AC_matrix0[480];
        this.AC0_481 = this.AC_matrix0[481];
        this.AC1_0 = this.AC_matrix1[0];
        this.AC1_1 = this.AC_matrix1[1];
        this.AC1_480 = this.AC_matrix1[480];
        this.AC1_481 = this.AC_matrix1[481];
    }

    public void encodeBlock(OutputStream outStream, int[] zigzag, int previous, int code) throws IOException {
        if (code == 0) {
            int temp2 = zigzag[0] - previous;
            int temp = temp2;
            if (temp < 0) {
                temp = -temp;
                --temp2;
            }
            int nbits = 0;
            while (temp != 0) {
                ++nbits;
                temp >>= 1;
            }
            int mp = nbits << 1;
            this.accumulate(outStream, this.DC_matrix0[mp], this.DC_matrix0[mp + 1]);
            if (nbits != 0) {
                this.accumulate(outStream, temp2, nbits);
            }
            int r = 0;
            for (int k = 1; k < 64; ++k) {
                temp = zigzag[JpegLUT.ZIGZAGORDER[k]];
                if (temp == 0) {
                    ++r;
                    continue;
                }
                while (r > 15) {
                    this.accumulate(outStream, this.AC0_480, this.AC0_481);
                    r -= 16;
                }
                temp2 = temp;
                if (temp < 0) {
                    temp = -temp;
                    --temp2;
                }
                nbits = 1;
                while ((temp >>= 1) != 0) {
                    ++nbits;
                }
                mp = (r << 4) + nbits << 1;
                this.accumulate(outStream, this.AC_matrix0[mp], this.AC_matrix0[mp + 1]);
                this.accumulate(outStream, temp2, nbits);
                r = 0;
            }
            if (r > 0) {
                this.accumulate(outStream, this.AC0_0, this.AC0_1);
            }
        } else {
            int temp2 = zigzag[0] - previous;
            int temp = temp2;
            if (temp < 0) {
                temp = -temp;
                --temp2;
            }
            int nbits = 0;
            while (temp != 0) {
                ++nbits;
                temp >>= 1;
            }
            int mp = nbits << 1;
            this.accumulate(outStream, this.DC_matrix1[mp], this.DC_matrix1[mp + 1]);
            if (nbits != 0) {
                this.accumulate(outStream, temp2, nbits);
            }
            int r = 0;
            for (int k = 1; k < 64; ++k) {
                temp = zigzag[JpegLUT.ZIGZAGORDER[k]];
                if (temp == 0) {
                    ++r;
                    continue;
                }
                while (r > 15) {
                    this.accumulate(outStream, this.AC1_480, this.AC1_481);
                    r -= 16;
                }
                temp2 = temp;
                if (temp < 0) {
                    temp = -temp;
                    --temp2;
                }
                nbits = 1;
                while ((temp >>= 1) != 0) {
                    ++nbits;
                }
                mp = (r << 4) + nbits << 1;
                this.accumulate(outStream, this.AC_matrix1[mp], this.AC_matrix1[mp + 1]);
                this.accumulate(outStream, temp2, nbits);
                r = 0;
            }
            if (r > 0) {
                this.accumulate(outStream, this.AC1_0, this.AC1_1);
            }
        }
    }

    private void accumulate(OutputStream outStream, int code, int size) throws IOException {
        int PutBuffer = code;
        int PutBits = this.bitsToPut;
        PutBuffer &= (1 << size) - 1;
        PutBuffer <<= 24 - (PutBits += size);
        PutBuffer |= this.bufferToPut;
        while (PutBits >= 8) {
            int c = PutBuffer >> 16 & 0xFF;
            outStream.write(c);
            if (c == 255) {
                outStream.write(0);
            }
            PutBuffer <<= 8;
            PutBits -= 8;
        }
        this.bufferToPut = PutBuffer;
        this.bitsToPut = PutBits;
    }

    public void end(OutputStream outStream) throws IOException {
        int c;
        int PutBits;
        int PutBuffer = this.bufferToPut;
        for (PutBits = this.bitsToPut; PutBits >= 8; PutBits -= 8) {
            c = PutBuffer >> 16 & 0xFF;
            outStream.write(c);
            if (c == 255) {
                outStream.write(0);
            }
            PutBuffer <<= 8;
        }
        if (PutBits > 0) {
            c = PutBuffer >> 16 & 0xFF;
            outStream.write(c);
        }
    }

    public static Object[] generateHuffmanTable(int[] codeLengths, int[] symbols) {
        int length;
        int k = 0;
        Stack<IndexMap> code = new Stack<IndexMap>();
        for (length = 16; length > 0 && codeLengths[length - 1] == 0; --length) {
        }
        IndexMap p = new IndexMap(0, new Object[2]);
        code.push(p);
        for (int i = 0; i < length; ++i) {
            IndexMap q;
            int cc = codeLengths[i];
            for (int j = 0; j < cc; ++j) {
                p = (IndexMap)code.pop();
                p.children[p.index] = symbols[k];
                while (p.index > 0) {
                    p = (IndexMap)code.pop();
                }
                ++p.index;
                code.push(p);
                while (code.size() <= i) {
                    q = new IndexMap(0, new Object[2]);
                    code.push(q);
                    p.children[p.index] = q.children;
                    p = q;
                }
                ++k;
            }
            if (i + 1 >= length) continue;
            q = new IndexMap(0, new Object[2]);
            code.push(q);
            p.children[p.index] = q.children;
            p = q;
        }
        return ((IndexMap)code.elementAt((int)0)).children;
    }
}

