/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

public class JPXBitReader {
    private int p;
    private final byte[] data;
    private int bufferSize;
    private int buffer;

    public JPXBitReader(byte[] data) {
        this.data = data;
    }

    public JPXBitReader(byte data) {
        this(new byte[]{data});
    }

    public int readBits(int lenToRead) {
        while (this.bufferSize < lenToRead) {
            int b = this.data[this.p] & 0xFF;
            ++this.p;
            this.buffer = this.buffer << 8 | b;
            this.bufferSize += 8;
        }
        this.bufferSize -= lenToRead;
        return this.buffer >>> this.bufferSize & (1 << lenToRead) - 1;
    }

    public void reset() {
        this.p = 0;
    }

    public static void main(String[] args) {
        JPXBitReader r = new JPXBitReader(new byte[]{44, 19});
        System.out.println(r.readBits(5));
        System.out.println(r.readBits(11));
    }
}

