/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import java.io.IOException;
import java.io.OutputStream;

public class JPXBitWriter {
    private byte buffer;
    private int bitCount;
    private final OutputStream stream;

    public JPXBitWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void writeUShort(int value) {
        byte[] b = new byte[]{(byte)(value >> 8), (byte)value};
        for (int i = 0; i < b.length; ++i) {
            this.writeByte(b[i]);
        }
    }

    public void writeUInt(long value) {
        byte[] b = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        for (int i = 0; i < b.length; ++i) {
            this.writeByte(b[i]);
        }
    }

    public void writeBit(int bit) {
        this.buffer = (byte)(this.buffer << 1);
        this.buffer = (byte)(this.buffer | bit & 1);
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.bitCount = 0;
            try {
                this.stream.write(this.buffer);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void writeByte(byte b) {
        if (this.bitCount == 0) {
            try {
                this.stream.write(b);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            for (int j = 7; j >= 0; --j) {
                this.writeBit(b >> j & 1);
            }
        }
    }

    public void end() {
        if (this.bitCount > 0) {
            byte b = this.buffer = (byte)(this.buffer << 8 - this.bitCount);
            try {
                this.stream.write(b);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.bitCount = 0;
        }
    }
}

