/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import java.nio.ByteBuffer;

public class JPXReader {
    private final ByteBuffer buffer;

    public JPXReader(byte[] data) {
        this.buffer = ByteBuffer.wrap(data);
    }

    public int getLimit() {
        return this.buffer.limit();
    }

    public byte readByte() {
        return this.buffer.get();
    }

    public byte readByte(int index) {
        return this.buffer.get(index);
    }

    public int readUByte() {
        return this.buffer.get() & 0xFF;
    }

    public byte[] readBytes(int length) {
        byte[] dst = new byte[length];
        this.buffer.get(dst);
        return dst;
    }

    public byte[] readBytes(int offset, int length) {
        byte[] dst = new byte[length];
        this.buffer.get(dst, offset, length);
        return dst;
    }

    public int readUnsignedByte(int index) {
        return this.buffer.get(index) & 0xFF;
    }

    public int readUShort() {
        return this.buffer.getShort() & 0xFFFF;
    }

    public int readUShort(int index) {
        return this.buffer.getShort(index) & 0xFFFF;
    }

    public short readShort() {
        return this.buffer.getShort();
    }

    public short readShort(int index) {
        return this.buffer.getShort(index);
    }

    public int readInt() {
        return this.buffer.getInt();
    }

    public int readInt(int index) {
        return this.buffer.getInt(index);
    }

    public int getPosition() {
        return this.buffer.position();
    }

    public long readLong() {
        return this.buffer.getLong();
    }

    public long readLong(int index) {
        return this.buffer.getLong(index);
    }

    public void setPosition(int pos) {
        this.buffer.position(pos);
    }

    public int getRemaining() {
        return this.buffer.remaining();
    }
}

