/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.Info;
import com.idrsolutions.image.jpeg2000.Packet;
import com.idrsolutions.image.jpeg2000.Progression;
import com.idrsolutions.image.jpeg2000.SIZ;
import com.idrsolutions.image.jpeg2000.Tile;
import com.idrsolutions.image.jpeg2000.TileBand;
import com.idrsolutions.image.jpeg2000.TileComponent;
import com.idrsolutions.image.jpeg2000.TileResolution;

public class LRCP
implements Progression {
    private final int layersCount;
    private final int componentsCount;
    private final int maxNL;
    private final Tile tile;
    private int comp;
    private int res;
    private int layer;
    private int prec;

    public LRCP(Info info, int tileIndex) {
        SIZ siz = info.siz;
        this.tile = info.tilesMap.get(tileIndex);
        this.layersCount = this.tile.cod.nLayers;
        this.componentsCount = siz.nComp;
        this.maxNL = this.tile.cod.nDecompLevel;
    }

    @Override
    public Packet getNextPacket() {
        while (this.layer < this.layersCount) {
            while (this.res <= this.maxNL) {
                while (this.comp < this.componentsCount) {
                    TileComponent component = this.tile.components.get(this.comp);
                    if (this.res > this.maxNL) continue;
                    TileResolution resolution = component.resolutions.get(this.res);
                    int numprecincts = resolution.precinctInfo.numPrecincts;
                    if (this.prec < numprecincts) {
                        Packet pack = this.createPacket(resolution, this.prec, this.layer);
                        ++this.prec;
                        return pack;
                    }
                    this.prec = 0;
                    ++this.comp;
                }
                this.comp = 0;
                ++this.res;
            }
            this.res = 0;
            ++this.layer;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution resolution, int precintNumber, int layerNumber) {
        Packet packet = new Packet();
        packet.layerNumber = layerNumber;
        for (TileBand subband : resolution.tileBands) {
            for (CodeBlock codeBlock : subband.codeBlocks) {
                if (codeBlock.precinctNumber != precintNumber) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }
}

