/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.Info;
import com.idrsolutions.image.jpeg2000.Packet;
import com.idrsolutions.image.jpeg2000.Progression;
import com.idrsolutions.image.jpeg2000.SIZ;
import com.idrsolutions.image.jpeg2000.Tile;
import com.idrsolutions.image.jpeg2000.TileBand;
import com.idrsolutions.image.jpeg2000.TileComponent;
import com.idrsolutions.image.jpeg2000.TileResolution;

public class RLCP
implements Progression {
    private final int layersCount;
    private final int componentsCount;
    private final int maxNL;
    private final Tile tile;
    private int res;
    private int layer;
    private int c;
    private int p;

    public RLCP(Info info, int tileIndex) {
        SIZ siz = info.siz;
        this.tile = info.tilesMap.get(tileIndex);
        this.layersCount = this.tile.cod.nLayers;
        this.componentsCount = siz.nComp;
        this.maxNL = this.tile.cod.nDecompLevel;
    }

    @Override
    public Packet getNextPacket() {
        while (this.res <= this.maxNL) {
            while (this.layer < this.layersCount) {
                while (this.c < this.componentsCount) {
                    TileComponent component = this.tile.components.get(this.c);
                    if (this.res > this.tile.cod.nDecompLevel) continue;
                    TileResolution resolution = component.resolutions.get(this.res);
                    int numprecincts = resolution.precinctInfo.numPrecincts;
                    if (this.p < numprecincts) {
                        Packet packet = this.createPacket(resolution, this.p, this.layer);
                        ++this.p;
                        return packet;
                    }
                    this.p = 0;
                    ++this.c;
                }
                this.c = 0;
                ++this.layer;
            }
            this.layer = 0;
            ++this.res;
        }
        return null;
    }

    @Override
    public Packet createPacket(TileResolution resolution, int precintNumber, int layerNumber) {
        Packet packet = new Packet();
        packet.layerNumber = layerNumber;
        for (TileBand subband : resolution.tileBands) {
            for (CodeBlock codeBlock : subband.codeBlocks) {
                if (codeBlock.precinctNumber != precintNumber) continue;
                packet.codeBlocks.add(codeBlock);
            }
        }
        return packet;
    }
}

