/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.EntropyDecoder;
import com.idrsolutions.image.jpeg2000.LUT;
import com.idrsolutions.image.jpeg2000.TileBand;

public class Tier1Decoder {
    public static final byte BYTEMB = 0;
    public static final byte SHORTMB = 1;
    public static final byte INTMB = 2;
    private static final byte UNIFORM = 17;
    private static final byte RUNLENGTH = 18;
    private final int width;
    private final int height;
    private EntropyDecoder decoder;
    private final byte[] contextLableTable;
    public byte[] neighborSigns;
    public byte[] coefficientsSign;
    public Object magnitude;
    public byte[] currentFlag;
    public byte[] bitsDecoded;
    public byte[] cx;
    public final int mbType;

    public Tier1Decoder(int width, int height, TileBand subband, int zeroBitPlanes, int mb) {
        this.width = width;
        this.height = height;
        this.contextLableTable = subband.type == 3 ? LUT.ContextHH : (subband.type == 2 ? LUT.ContextHL : LUT.ContextLL);
        int cc = width * height;
        this.neighborSigns = new byte[cc];
        this.coefficientsSign = new byte[cc];
        int n = mb > 14 ? 2 : (this.mbType = mb > 6 ? 1 : 0);
        this.magnitude = mb > 14 ? new int[cc] : (mb > 6 ? (Object[])new short[cc] : (Object[])new byte[cc]);
        this.currentFlag = new byte[cc];
        this.bitsDecoded = new byte[cc];
        if (zeroBitPlanes != 0) {
            for (int i = 0; i < cc; ++i) {
                this.bitsDecoded[i] = (byte)zeroBitPlanes;
            }
        }
        this.cx = new byte[19];
        this.cx[0] = 8;
        this.cx[17] = 92;
        this.cx[18] = 6;
    }

    public void setDecoder(EntropyDecoder decoder) {
        this.decoder = decoder;
    }

    public void setNeighborSigns(int y, int x, int index) {
        int i;
        boolean right;
        boolean left = x > 0;
        boolean bl = right = x + 1 < this.width;
        if (y > 0) {
            i = index - this.width;
            if (left) {
                this.neighborSigns[i - 1] = (byte)((this.neighborSigns[i - 1] & 0xFF) + 16);
            }
            if (right) {
                this.neighborSigns[i + 1] = (byte)((this.neighborSigns[i + 1] & 0xFF) + 16);
            }
            this.neighborSigns[i] = (byte)((this.neighborSigns[i] & 0xFF) + 4);
        }
        if (y + 1 < this.height) {
            i = index + this.width;
            if (left) {
                this.neighborSigns[i - 1] = (byte)((this.neighborSigns[i - 1] & 0xFF) + 16);
            }
            if (right) {
                this.neighborSigns[i + 1] = (byte)((this.neighborSigns[i + 1] & 0xFF) + 16);
            }
            this.neighborSigns[i] = (byte)((this.neighborSigns[i] & 0xFF) + 4);
        }
        if (left) {
            this.neighborSigns[index - 1] = (byte)((this.neighborSigns[index - 1] & 0xFF) + 1);
        }
        if (right) {
            this.neighborSigns[index + 1] = (byte)((this.neighborSigns[index + 1] & 0xFF) + 1);
        }
        this.neighborSigns[index] = (byte)(this.neighborSigns[index] & 0xFF | 0x80);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void runSPP() {
        int processedInverseMask = -2;
        int processedMask = 1;
        int firstMagnitudeBitMask = 2;
        int i0 = 0;
        block10: while (i0 < this.height) {
            int j = 0;
            while (true) {
                int i;
                int index;
                if (j < this.width) {
                    index = i0 * this.width + j;
                } else {
                    i0 += 4;
                    continue block10;
                }
                block12: for (int i1 = 0; i1 < 4 && (i = i0 + i1) < this.height; ++i1, index += this.width) {
                    this.currentFlag[index] = (byte)(this.currentFlag[index] & 0xFF & processedInverseMask);
                    switch (this.mbType) {
                        case 0: {
                            if (((byte[])this.magnitude)[index] == 0 && this.neighborSigns[index] != 0) break;
                            continue block12;
                        }
                        case 1: {
                            if (((short[])this.magnitude)[index] == 0 && this.neighborSigns[index] != 0) break;
                            continue block12;
                        }
                        case 2: {
                            if (((int[])this.magnitude)[index] != 0 || this.neighborSigns[index] == 0) continue block12;
                        }
                    }
                    byte contextLabel = this.contextLableTable[this.neighborSigns[index] & 0xFF];
                    int decision = this.decoder.decodeBit(this.cx, contextLabel);
                    if (decision != 0) {
                        int sign = this.decodeSignBit(i, j, index);
                        this.coefficientsSign[index] = (byte)sign;
                        switch (this.mbType) {
                            case 0: {
                                ((byte[])this.magnitude)[index] = 1;
                                break;
                            }
                            case 1: {
                                ((short[])this.magnitude)[index] = 1;
                                break;
                            }
                            case 2: {
                                ((int[])this.magnitude)[index] = 1;
                                break;
                            }
                        }
                        this.setNeighborSigns(i, j, index);
                        this.currentFlag[index] = (byte)(this.currentFlag[index] & 0xFF | firstMagnitudeBitMask);
                    }
                    int n = index;
                    this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                    this.currentFlag[index] = (byte)(this.currentFlag[index] & 0xFF | processedMask);
                }
                ++j;
            }
            break;
        }
        return;
    }

    private long getCoMag(int pos) {
        switch (this.mbType) {
            case 0: {
                return ((byte[])this.magnitude)[pos] & 0xFF;
            }
            case 1: {
                return ((short[])this.magnitude)[pos] & 0xFFFF;
            }
            case 2: {
                return ((int[])this.magnitude)[pos];
            }
        }
        return 0L;
    }

    public int decodeSignBit(int y, int x, int index) {
        int decoded;
        int contribution;
        int sign0;
        int sign1;
        boolean significance1;
        boolean bl = significance1 = x > 0 && this.getCoMag(index - 1) != 0L;
        if (x + 1 < this.width && this.getCoMag(index + 1) != 0L) {
            sign1 = this.coefficientsSign[index + 1] & 0xFF;
            if (significance1) {
                sign0 = this.coefficientsSign[index - 1] & 0xFF;
                contribution = 1 - sign1 - sign0;
            } else {
                contribution = 1 - sign1 - sign1;
            }
        } else if (significance1) {
            sign0 = this.coefficientsSign[index - 1] & 0xFF;
            contribution = 1 - sign0 - sign0;
        } else {
            contribution = 0;
        }
        int horizontalContribution = 3 * contribution;
        boolean bl2 = significance1 = y > 0 && this.getCoMag(index - this.width) != 0L;
        if (y + 1 < this.height && this.getCoMag(index + this.width) != 0L) {
            sign1 = this.coefficientsSign[index + this.width] & 0xFF;
            if (significance1) {
                sign0 = this.coefficientsSign[index - this.width] & 0xFF;
                contribution = 1 - sign1 - sign0 + horizontalContribution;
            } else {
                contribution = 1 - sign1 - sign1 + horizontalContribution;
            }
        } else if (significance1) {
            sign0 = this.coefficientsSign[index - this.width] & 0xFF;
            contribution = 1 - sign0 - sign0 + horizontalContribution;
        } else {
            contribution = horizontalContribution;
        }
        if (contribution >= 0) {
            int contextLabel = 9 + contribution;
            decoded = this.decoder.decodeBit(this.cx, contextLabel);
        } else {
            int contextLabel = 9 - contribution;
            decoded = this.decoder.decodeBit(this.cx, contextLabel) ^ 1;
        }
        return decoded;
    }

    public void runMRP() {
        int processedMask = 1;
        int msbMask = 2;
        int dim = this.width * this.height;
        int width4 = this.width * 4;
        int idx0 = 0;
        while (idx0 < dim) {
            int indexNext = Math.min(dim, idx0 + width4);
            for (int j = 0; j < this.width; ++j) {
                for (int index = idx0 + j; index < indexNext; index += this.width) {
                    long cmIndex = 0L;
                    switch (this.mbType) {
                        case 0: {
                            cmIndex = ((byte[])this.magnitude)[index] & 0xFF;
                            break;
                        }
                        case 1: {
                            cmIndex = ((short[])this.magnitude)[index] & 0xFFFF;
                            break;
                        }
                        case 2: {
                            cmIndex = ((int[])this.magnitude)[index];
                        }
                    }
                    if (cmIndex == 0L || (this.currentFlag[index] & 0xFF & processedMask) != 0) continue;
                    int contextLabel = 16;
                    if ((this.currentFlag[index] & 0xFF & msbMask) != 0) {
                        this.currentFlag[index] = (byte)(this.currentFlag[index] & 0xFF ^ msbMask);
                        int significance = this.neighborSigns[index] & 0xFF & 0x7F;
                        contextLabel = significance == 0 ? 15 : 14;
                    }
                    int bit = this.decoder.decodeBit(this.cx, contextLabel);
                    switch (this.mbType) {
                        case 0: {
                            ((byte[])this.magnitude)[index] = (byte)(cmIndex << 1 | (long)bit);
                            break;
                        }
                        case 1: {
                            ((short[])this.magnitude)[index] = (short)(cmIndex << 1 | (long)bit);
                            break;
                        }
                        case 2: {
                            ((int[])this.magnitude)[index] = (int)(cmIndex << 1 | (long)bit);
                        }
                    }
                    int n = index;
                    this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                    this.currentFlag[index] = (byte)(this.currentFlag[index] & 0xFF | processedMask);
                }
            }
            idx0 = indexNext;
        }
    }

    public void runCP() {
        int processedMask = 1;
        int firstMagnitudeBitMask = 2;
        int w1 = this.width;
        int w2 = this.width * 2;
        int w3 = this.width * 3;
        int i0 = 0;
        while (i0 < this.height) {
            int nextBit = Math.min(i0 + 4, this.height);
            int indexBase = i0 * this.width;
            boolean checkAllEmpty = i0 + 3 < this.height;
            for (int j = 0; j < this.width; ++j) {
                int sign;
                int index0 = indexBase + j;
                boolean allEmpty = checkAllEmpty && this.currentFlag[index0] == 0 && this.currentFlag[index0 + w1] == 0 && this.currentFlag[index0 + w2] == 0 && this.currentFlag[index0 + w3] == 0 && this.neighborSigns[index0] == 0 && this.neighborSigns[index0 + w1] == 0 && this.neighborSigns[index0 + w2] == 0 && this.neighborSigns[index0 + w3] == 0;
                int i1 = 0;
                int index = index0;
                int i = i0;
                if (allEmpty) {
                    int hasSignificantCoefficent = this.decoder.decodeBit(this.cx, 18);
                    if (hasSignificantCoefficent == 0) {
                        int n = index0;
                        this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                        int n2 = index0 + w1;
                        this.bitsDecoded[n2] = (byte)(this.bitsDecoded[n2] + 1);
                        int n3 = index0 + w2;
                        this.bitsDecoded[n3] = (byte)(this.bitsDecoded[n3] + 1);
                        int n4 = index0 + w3;
                        this.bitsDecoded[n4] = (byte)(this.bitsDecoded[n4] + 1);
                        continue;
                    }
                    i1 = this.decoder.decodeBit(this.cx, 17) << 1 | this.decoder.decodeBit(this.cx, 17);
                    if (i1 != 0) {
                        i = i0 + i1;
                        index += i1 * this.width;
                    }
                    sign = this.decodeSignBit(i, j, index);
                    this.coefficientsSign[index] = (byte)sign;
                    switch (this.mbType) {
                        case 0: {
                            ((byte[])this.magnitude)[index] = 1;
                            break;
                        }
                        case 1: {
                            ((short[])this.magnitude)[index] = 1;
                            break;
                        }
                        case 2: {
                            ((int[])this.magnitude)[index] = 1;
                        }
                    }
                    this.setNeighborSigns(i, j, index);
                    this.currentFlag[index] = (byte)(this.currentFlag[index] & 0xFF | firstMagnitudeBitMask);
                    index = index0;
                    for (int i2 = i0; i2 <= i; ++i2) {
                        int n = index;
                        this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                        index += this.width;
                    }
                    ++i1;
                }
                i = i0 + i1;
                while (i < nextBit) {
                    long coefIndex = 0L;
                    switch (this.mbType) {
                        case 0: {
                            coefIndex = ((byte[])this.magnitude)[index];
                            break;
                        }
                        case 1: {
                            coefIndex = ((short[])this.magnitude)[index];
                            break;
                        }
                        case 2: {
                            coefIndex = ((int[])this.magnitude)[index];
                        }
                    }
                    if (coefIndex == 0L && (this.currentFlag[index] & 0xFF & processedMask) == 0) {
                        byte contextLabel = this.contextLableTable[this.neighborSigns[index] & 0xFF];
                        int decision = this.decoder.decodeBit(this.cx, contextLabel);
                        if (decision == 1) {
                            sign = this.decodeSignBit(i, j, index);
                            this.coefficientsSign[index] = (byte)sign;
                            switch (this.mbType) {
                                case 0: {
                                    ((byte[])this.magnitude)[index] = 1;
                                    break;
                                }
                                case 1: {
                                    ((short[])this.magnitude)[index] = 1;
                                    break;
                                }
                                case 2: {
                                    ((int[])this.magnitude)[index] = 1;
                                }
                            }
                            this.setNeighborSigns(i, j, index);
                            this.currentFlag[index] = (byte)(this.currentFlag[index] & 0xFF | firstMagnitudeBitMask);
                        }
                        int n = index;
                        this.bitsDecoded[n] = (byte)(this.bitsDecoded[n] + 1);
                    }
                    ++i;
                    index += this.width;
                }
            }
            i0 = nextBit;
        }
    }
}

