/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class Deflate {
    public static byte[] decompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
                bos.close();
            }
            catch (IOException ex) {
                Deflate.writeLog("Exception: " + ex.getMessage());
            }
            catch (DataFormatException ex) {
                Deflate.writeLog("Exception: " + ex.getMessage());
            }
        }
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] pixels) throws IOException {
        Deflater deflater = new Deflater(1);
        deflater.setInput(pixels);
        int min = Math.min(pixels.length / 2, 4096);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(min);
        deflater.finish();
        byte[] buffer = new byte[min];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        deflater.end();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private static void writeLog(String msg) {
        System.out.println(msg);
    }
}

