/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PackBits {
    public static byte[] decompress(byte[] input, int expected) throws IOException {
        int total = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length * 2);
        int i = 0;
        while (total < expected) {
            byte n;
            if (i >= input.length) {
                throw new IOException("Error in packbit decompression ");
            }
            if ((n = input[i++]) >= 0 && n <= 127) {
                int cc = n + 1;
                total += cc;
                for (int j = 0; j < cc; ++j) {
                    bos.write(input[i++]);
                }
                continue;
            }
            if (n >= -127 && n <= -1) {
                byte b = input[i++];
                int count = -n + 1;
                total += count;
                for (int j = 0; j < count; ++j) {
                    bos.write(b);
                }
                continue;
            }
            if (n != -128) continue;
            throw new IOException("Error in packbit decompression ");
        }
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] data, int imageW, int imageH, int nComp) throws IOException {
        int rowByteCount = imageW * nComp;
        int offset = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < imageH; ++i) {
            byte[] temp = new byte[rowByteCount];
            System.arraycopy(data, offset, temp, 0, rowByteCount);
            offset += rowByteCount;
            bos.write(PackBits.compressRow(temp));
        }
        bos.close();
        return bos.toByteArray();
    }

    private static byte[] compressRow(byte[] bytes) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int pos = 0;
        while (pos < bytes.length) {
            int nextptr;
            int nextdup;
            int runlen;
            int dataLen;
            int len;
            int dup = PackBits.getNextDup(bytes, pos);
            if (dup == pos) {
                len = PackBits.getNextRun(bytes, dup);
                dataLen = Math.min(len, 128);
                bos.write(-(dataLen - 1));
                bos.write(bytes[pos]);
                pos += dataLen;
                continue;
            }
            len = dup - pos;
            if (dup > 0 && (runlen = PackBits.getNextRun(bytes, dup)) < 3 && (nextdup = PackBits.getNextDup(bytes, nextptr = pos + len + runlen)) != nextptr) {
                dup = nextdup;
                len = dup - pos;
            }
            if (dup < 0) {
                len = bytes.length - pos;
            }
            dataLen = Math.min(len, 128);
            bos.write(dataLen - 1);
            for (int i = 0; i < dataLen; ++i) {
                bos.write(bytes[pos]);
                ++pos;
            }
        }
        bos.close();
        return bos.toByteArray();
    }

    private static int getNextDup(byte[] bytes, int offset) {
        if (offset >= bytes.length) {
            return -1;
        }
        byte temp = bytes[offset];
        for (int i = offset + 1; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == temp) {
                return i - 1;
            }
            temp = b;
        }
        return -1;
    }

    private static int getNextRun(byte[] bytes, int offset) {
        byte b = bytes[offset];
        int c = 0;
        int len = bytes.length;
        int i = offset + 1;
        while (i < len && bytes[i] == b) {
            c = i++;
        }
        return c - offset;
    }
}

