/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RandomHandler {
    public static final int BIGENDIAN = 1;
    public static final int LITTLEENDIAN = 2;
    private int byteOrder = 1;
    private ByteBuffer buffer;
    private RandomAccessFile raf;
    private final boolean isBuff;

    public RandomHandler(byte[] data) {
        this.buffer = ByteBuffer.wrap(data);
        this.isBuff = true;
    }

    public RandomHandler(RandomAccessFile raf) {
        this.raf = raf;
        this.isBuff = false;
    }

    public int getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(int byteOrder) {
        this.byteOrder = byteOrder;
        if (this.isBuff) {
            if (byteOrder == 2) {
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.buffer.order(ByteOrder.BIG_ENDIAN);
            }
        }
    }

    public void get(byte[] temp) throws IOException {
        if (this.isBuff) {
            this.buffer.get(temp);
        } else {
            this.raf.read(temp);
        }
    }

    public int getUint8() throws IOException {
        if (this.isBuff) {
            return this.buffer.get() & 0xFF;
        }
        return this.raf.read();
    }

    public int getUint8(int index) throws IOException {
        if (this.isBuff) {
            return this.buffer.get(index) & 0xFF;
        }
        this.raf.seek(index);
        return this.raf.read();
    }

    public int getUint16() throws IOException {
        if (this.isBuff) {
            return this.buffer.getShort() & 0xFFFF;
        }
        if (this.byteOrder == 1) {
            return this.raf.readUnsignedShort();
        }
        int a = this.raf.read();
        int b = this.raf.read();
        return b << 8 | a;
    }

    public int getUint16(int index) throws IOException {
        if (this.isBuff) {
            return this.buffer.getShort(index) & 0xFFFF;
        }
        this.raf.seek(index);
        if (this.byteOrder == 1) {
            return this.raf.readUnsignedShort();
        }
        int a = this.raf.read();
        int b = this.raf.read();
        return b << 8 | a;
    }

    public int getInt() throws IOException {
        if (this.isBuff) {
            return this.buffer.getInt();
        }
        if (this.byteOrder == 1) {
            return this.raf.readInt();
        }
        int a = this.raf.read();
        int b = this.raf.read();
        int c = this.raf.read();
        int d = this.raf.read();
        return d << 24 | c << 16 | b << 8 | a;
    }

    public int getInt(int index) throws IOException {
        if (this.isBuff) {
            return this.buffer.getInt(index);
        }
        this.raf.seek(index);
        if (this.byteOrder == 1) {
            return this.raf.readInt();
        }
        int a = this.raf.read();
        int b = this.raf.read();
        int c = this.raf.read();
        int d = this.raf.read();
        return d << 24 | c << 16 | b << 8 | a;
    }

    public long getLong() throws IOException {
        if (this.isBuff) {
            return this.buffer.getLong();
        }
        if (this.byteOrder == 1) {
            return this.raf.readLong();
        }
        long a = this.raf.read();
        long b = this.raf.read();
        long c = this.raf.read();
        long d = this.raf.read();
        long e = this.raf.read();
        long f = this.raf.read();
        long g = this.raf.read();
        long h = this.raf.read();
        return h << 56 | g << 48 | f << 40 | e << 32 | d << 24 | c << 16 | b << 8 | a;
    }

    public int getPosition() throws IOException {
        if (this.isBuff) {
            return this.buffer.position();
        }
        return (int)this.raf.getFilePointer();
    }

    public void setPosition(int position) throws IOException {
        if (this.isBuff) {
            this.buffer.position(position);
        } else {
            this.raf.seek(position);
        }
    }
}

