/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import com.idrsolutions.image.jpeg.JpegDecoder;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.jpeg2000.JPXBitReader;
import com.idrsolutions.image.tiff.CCITT;
import com.idrsolutions.image.tiff.Deflate;
import com.idrsolutions.image.tiff.IFD;
import com.idrsolutions.image.tiff.LZW;
import com.idrsolutions.image.tiff.PackBits;
import com.idrsolutions.image.tiff.RandomHandler;
import com.idrsolutions.image.tiff.Tile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class TiffDecoder {
    private final RandomHandler reader;
    private int pageCount;
    final List<IFD> ifds = new ArrayList<IFD>();

    public TiffDecoder(byte[] rawTiffData) throws Exception {
        this.reader = new RandomHandler(rawTiffData);
        int a = this.reader.getUint8();
        int b = this.reader.getUint8();
        if (a == 77 && b == 77) {
            this.reader.setByteOrder(1);
        } else if (a == 73 && b == 73) {
            this.reader.setByteOrder(2);
        }
        int magicNumber = this.reader.getUint16();
        if (magicNumber != 42) {
            if (magicNumber == 43) {
                throw new Exception("Big Tiff File Support not added");
            }
            throw new Exception("This is not a valid Tiff File");
        }
        int ifdOffset = this.reader.getInt();
        while (ifdOffset != 0) {
            IFD ifd = TiffDecoder.getIFD(this.reader, ifdOffset);
            this.ifds.add(ifd);
            ifdOffset = ifd.nextIFD;
            ++this.pageCount;
        }
    }

    public TiffDecoder(RandomAccessFile randomAccessFile) throws Exception {
        this.reader = new RandomHandler(randomAccessFile);
        int a = this.reader.getUint8();
        int b = this.reader.getUint8();
        if (a == 77 && b == 77) {
            this.reader.setByteOrder(1);
        } else if (a == 73 && b == 73) {
            this.reader.setByteOrder(2);
        }
        int magicNumber = this.reader.getUint16();
        if (magicNumber != 42) {
            if (magicNumber == 43) {
                throw new Exception("Big Tiff File Support not added");
            }
            throw new Exception("This is not a valid Tiff File");
        }
        int ifdOffset = this.reader.getInt();
        while (ifdOffset != 0) {
            IFD ifd = TiffDecoder.getIFD(this.reader, ifdOffset);
            this.ifds.add(ifd);
            ifdOffset = ifd.nextIFD;
            ++this.pageCount;
        }
    }

    public BufferedImage read() throws Exception {
        return this.read(1);
    }

    public BufferedImage read(int pageNumber) throws Exception {
        if (pageNumber == 0) {
            throw new Exception("PageNumber should start from 1");
        }
        if (pageNumber > this.pageCount) {
            throw new Exception("PageNumber should not be greater than Total page count");
        }
        IFD ifd = this.ifds.get(pageNumber - 1);
        return TiffDecoder.generateImageFromIFD(this.reader, ifd);
    }

    private static IFD getIFD(RandomHandler reader, int ifdOffset) throws IOException {
        reader.setPosition(ifdOffset);
        int nEntries = reader.getUint16();
        IFD ifd = new IFD();
        block26: for (int i = 0; i < nEntries; ++i) {
            int fieldName = reader.getUint16();
            int fieldType = reader.getUint16();
            int nValues = reader.getInt();
            switch (fieldName) {
                case 256: {
                    ifd.imageWidth = TiffDecoder.getShortOrInt(reader, fieldType);
                    continue block26;
                }
                case 257: {
                    ifd.imageHeight = TiffDecoder.getShortOrInt(reader, fieldType);
                    continue block26;
                }
                case 258: {
                    ifd.bps = new int[nValues];
                    if (nValues == 1) {
                        ifd.bps[0] = reader.getUint16();
                        reader.getUint16();
                        continue block26;
                    }
                    if (nValues == 2) {
                        ifd.bps[0] = reader.getUint16();
                        ifd.bps[1] = reader.getUint16();
                        continue block26;
                    }
                    int sampleOffset = reader.getInt();
                    int current = reader.getPosition();
                    ifd.bps = TiffDecoder.readBitsPerSamples(reader, sampleOffset, nValues);
                    reader.setPosition(current);
                    continue block26;
                }
                case 259: {
                    ifd.compressionType = reader.getUint16();
                    reader.getUint16();
                    continue block26;
                }
                case 262: {
                    ifd.photometric = reader.getUint16();
                    reader.getUint16();
                    continue block26;
                }
                case 278: {
                    ifd.rowsPerStrip = TiffDecoder.getShortOrInt(reader, fieldType);
                    continue block26;
                }
                case 273: {
                    if (nValues == 1) {
                        ifd.stripOffsets = new int[1];
                        ifd.stripOffsets[0] = reader.getInt();
                        continue block26;
                    }
                    int stripOffset = reader.getInt();
                    int current = reader.getPosition();
                    ifd.stripOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
                    reader.setPosition(current);
                    continue block26;
                }
                case 279: {
                    if (nValues == 1) {
                        ifd.stripByteCounts = new int[1];
                        ifd.stripByteCounts[0] = reader.getInt();
                        continue block26;
                    }
                    int stripOffset = reader.getInt();
                    int current = reader.getPosition();
                    ifd.stripByteCounts = TiffDecoder.readStripTileByteCounts(reader, stripOffset, nValues, fieldType);
                    reader.setPosition(current);
                    continue block26;
                }
                case 277: {
                    ifd.samplesPerPixel = reader.getUint16();
                    reader.getUint16();
                    continue block26;
                }
                case 320: {
                    int cmapOffset = reader.getInt();
                    int current = reader.getPosition();
                    ifd.colorMap = TiffDecoder.readColorMap(reader, cmapOffset, nValues);
                    reader.setPosition(current);
                    continue block26;
                }
                case 284: {
                    ifd.planarConfiguration = reader.getUint16();
                    reader.getUint16();
                    continue block26;
                }
                case 322: {
                    ifd.tileWidth = TiffDecoder.getShortOrInt(reader, fieldType);
                    continue block26;
                }
                case 323: {
                    ifd.tileLength = TiffDecoder.getShortOrInt(reader, fieldType);
                    continue block26;
                }
                case 324: {
                    if (nValues == 1) {
                        ifd.tileOffsets = new int[1];
                        ifd.tileOffsets[0] = reader.getInt();
                        continue block26;
                    }
                    int stripOffset = reader.getInt();
                    int cur = reader.getPosition();
                    ifd.tileOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
                    reader.setPosition(cur);
                    continue block26;
                }
                case 325: {
                    if (nValues == 1) {
                        ifd.tileByteCounts = new int[1];
                        ifd.tileByteCounts[0] = reader.getInt();
                        continue block26;
                    }
                    int stripOffset = reader.getInt();
                    int cur = reader.getPosition();
                    ifd.tileByteCounts = TiffDecoder.readStripTileByteCounts(reader, stripOffset, nValues, fieldType);
                    reader.setPosition(cur);
                    continue block26;
                }
                case 347: {
                    int tableOffset = reader.getInt();
                    int cc = reader.getPosition();
                    reader.setPosition(tableOffset);
                    byte[] tableBytes = new byte[nValues];
                    reader.get(tableBytes);
                    reader.setPosition(cc);
                    ifd.jpegTables = new byte[nValues - 2];
                    System.arraycopy(tableBytes, 0, ifd.jpegTables, 0, nValues - 2);
                    continue block26;
                }
                case 519: {
                    if (nValues == 1) {
                        ifd.jpegQOffsets = new int[1];
                        ifd.jpegQOffsets[0] = reader.getInt();
                        continue block26;
                    }
                    int stripOffset = reader.getInt();
                    int cur = reader.getPosition();
                    ifd.jpegQOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
                    reader.setPosition(cur);
                    continue block26;
                }
                case 520: {
                    if (nValues == 1) {
                        ifd.jpegDCOffsets = new int[1];
                        ifd.jpegDCOffsets[0] = reader.getInt();
                        continue block26;
                    }
                    int stripOffset = reader.getInt();
                    int cur = reader.getPosition();
                    ifd.jpegDCOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
                    reader.setPosition(cur);
                    continue block26;
                }
                case 521: {
                    if (nValues == 1) {
                        ifd.jpegACOffsets = new int[1];
                        ifd.jpegACOffsets[0] = reader.getInt();
                        continue block26;
                    }
                    int stripOffset = reader.getInt();
                    int cur = reader.getPosition();
                    ifd.jpegACOffsets = TiffDecoder.readOffsets(reader, stripOffset, nValues, fieldType);
                    reader.setPosition(cur);
                    continue block26;
                }
                case 34675: {
                    int iccOffset = reader.getInt();
                    int current = reader.getPosition();
                    reader.setPosition(iccOffset);
                    ifd.iccProfile = new byte[nValues];
                    reader.get(ifd.iccProfile);
                    reader.setPosition(current);
                    continue block26;
                }
                case 266: {
                    ifd.fillOrder = reader.getInt();
                    continue block26;
                }
                case 317: {
                    ifd.predictor = reader.getUint16();
                    reader.getUint16();
                    continue block26;
                }
                case 339: {
                    if (nValues == 1) {
                        ifd.sampleFormat = new int[1];
                        ifd.sampleFormat[0] = reader.getInt();
                        continue block26;
                    }
                    int sampleOffset = reader.getInt();
                    int current = reader.getPosition();
                    ifd.sampleFormat = TiffDecoder.readOffsets(reader, sampleOffset, nValues, fieldType);
                    reader.setPosition(current);
                    continue block26;
                }
                case 254: 
                case 255: 
                case 263: 
                case 264: 
                case 265: 
                case 269: 
                case 270: 
                case 271: 
                case 272: 
                case 274: 
                case 280: 
                case 281: 
                case 282: 
                case 283: 
                case 285: 
                case 286: 
                case 287: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 292: 
                case 293: 
                case 296: 
                case 297: 
                case 301: 
                case 305: 
                case 306: 
                case 315: 
                case 316: 
                case 318: 
                case 319: 
                case 321: 
                case 330: 
                case 332: 
                case 333: 
                case 334: 
                case 336: 
                case 337: 
                case 338: 
                case 340: 
                case 341: 
                case 342: 
                case 343: 
                case 344: 
                case 345: 
                case 346: 
                case 512: 
                case 513: 
                case 514: 
                case 515: 
                case 517: 
                case 518: 
                case 529: 
                case 530: 
                case 531: 
                case 532: 
                case 559: 
                case 700: 
                case 32781: 
                case 33432: 
                case 34665: 
                case 36864: 
                case 36867: 
                case 36868: 
                case 37121: 
                case 37122: 
                case 37378: 
                case 37393: 
                case 37395: 
                case 40962: 
                case 40963: 
                case 655361: {
                    reader.getInt();
                    continue block26;
                }
                default: {
                    reader.getInt();
                }
            }
        }
        ifd.nextIFD = reader.getInt();
        if (ifd.rowsPerStrip == 0 || ifd.rowsPerStrip > ifd.imageHeight) {
            ifd.rowsPerStrip = ifd.imageHeight;
        }
        return ifd;
    }

    private static int getShortOrInt(RandomHandler reader, int fieldType) throws IOException {
        int value;
        if (fieldType == 3) {
            value = reader.getUint16();
            reader.getUint16();
        } else {
            value = reader.getInt();
        }
        return value;
    }

    private static BufferedImage getDataFromStrips(RandomHandler reader, IFD ifd) throws Exception {
        int k;
        int stripSamples;
        int iw = ifd.imageWidth;
        int ih = ifd.imageHeight;
        int dim = iw * ih;
        boolean isPlanar = ifd.planarConfiguration == 2;
        boolean hasPalette = ifd.colorMap != null;
        int rps = ifd.rowsPerStrip;
        int bps = ifd.bps[0];
        int sampleLen = 0;
        int n = stripSamples = isPlanar ? 1 : ifd.bps.length;
        if (isPlanar) {
            sampleLen = ifd.bps[0];
        } else {
            for (int i = 0; i < ifd.bps.length; ++i) {
                sampleLen += ifd.bps[i];
            }
        }
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        int planarStrip = ifd.stripOffsets.length / ifd.samplesPerPixel;
        for (int t = 0; t < ifd.stripOffsets.length; ++t) {
            int balance;
            int stripMod;
            int balance2;
            reader.setPosition(ifd.stripOffsets[t]);
            byte[] tileData = new byte[ifd.stripByteCounts[t]];
            reader.get(tileData);
            int height = isPlanar ? ((balance2 = ih - rps * (stripMod = t % planarStrip)) < rps ? balance2 : rps) : ((balance = ih - rps * t) < rps ? balance : rps);
            byte[] output = null;
            int expectation = ((iw * sampleLen + 7) / 8 * 8 * height + 7) / 8;
            switch (ifd.compressionType) {
                case 1: {
                    output = tileData;
                    break;
                }
                case 2: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, iw, height);
                    fax.decompress1D(output, tileData, 0, height);
                    break;
                }
                case 3: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, iw, height);
                    fax.decompressFax3(output, tileData, height);
                    break;
                }
                case 4: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, iw, height);
                    fax.decompressFax4(output, tileData, height);
                    break;
                }
                case 5: {
                    output = new byte[expectation];
                    LZW lzw = new LZW();
                    lzw.decompress(output, tileData, iw, height);
                    break;
                }
                case 6: {
                    throw new Exception("Old style jpeg compression is not supported");
                }
                case 7: {
                    if (ifd.jpegTables != null) {
                        int ifdLen = ifd.jpegTables.length;
                        byte[] temp = new byte[ifdLen + tileData.length - 2];
                        System.arraycopy(ifd.jpegTables, 0, temp, 0, ifdLen);
                        System.arraycopy(tileData, 2, temp, ifdLen, tileData.length - 2);
                        tileData = temp;
                    }
                    JpegDecoder decoder = new JpegDecoder();
                    output = decoder.readComponentsAsRawBytes(tileData);
                    break;
                }
                case 32773: {
                    int exp = (iw * height * sampleLen + 7) / 8;
                    output = PackBits.decompress(tileData, exp);
                    break;
                }
                case 8: 
                case 32946: {
                    output = Deflate.decompress(tileData);
                    break;
                }
                default: {
                    System.err.println("unrecognized compression found");
                }
            }
            if (ifd.predictor == 2) {
                for (int j = 0; j < height; ++j) {
                    int count = stripSamples * (j * iw + 1);
                    for (int i = stripSamples; i < iw * stripSamples; ++i) {
                        int n2 = count;
                        output[n2] = (byte)(output[n2] + output[count - stripSamples]);
                        ++count;
                    }
                }
            }
            int n3 = 0;
            if (ifd.photometric == 0) {
                for (int i = 0; i < output.length; ++i) {
                    output[i] = (byte)(output[n3++] & 0xFF ^ 0xFF);
                }
            }
            Tile tile = new Tile();
            int bp = 0;
            int iw8 = iw * bps * stripSamples % 8;
            if (bps != 8) {
                int shift;
                tileData = new byte[height * iw * stripSamples];
                JPXBitReader bitReader = new JPXBitReader(output);
                if (bps == 1) {
                    for (int i = 0; i < height; ++i) {
                        for (int j = 0; j < iw - 1; ++j) {
                            for (int k2 = 0; k2 < stripSamples; ++k2) {
                                tileData[bp++] = hasPalette ? (byte)bitReader.readBits(bps) : (byte)(bitReader.readBits(bps) * 255);
                            }
                        }
                        if (iw8 == 0) continue;
                        bitReader.readBits(8 - iw8);
                    }
                } else if (bps < 8) {
                    shift = 8 - bps;
                    for (int i = 0; i < height; ++i) {
                        for (int j = 0; j < iw; ++j) {
                            for (int k3 = 0; k3 < stripSamples; ++k3) {
                                tileData[bp++] = hasPalette ? (byte)bitReader.readBits(bps) : (byte)(bitReader.readBits(bps) << shift);
                            }
                        }
                        if (iw8 == 0) continue;
                        bitReader.readBits(8 - iw8);
                    }
                } else {
                    int j;
                    int i;
                    shift = bps - 8;
                    int sampleFormat = ifd.sampleFormat[0];
                    if (hasPalette) {
                        tileData = new byte[height * iw * 3];
                        for (i = 0; i < height; ++i) {
                            for (j = 0; j < iw; ++j) {
                                int v = bitReader.readBits(bps) * 3;
                                tileData[bp++] = ifd.colorMap[v++];
                                tileData[bp++] = ifd.colorMap[v++];
                                tileData[bp++] = ifd.colorMap[v];
                            }
                            if (iw8 == 0) continue;
                            bitReader.readBits(8 - iw8);
                        }
                    } else {
                        for (i = 0; i < height; ++i) {
                            for (j = 0; j < iw; ++j) {
                                for (k = 0; k < stripSamples; ++k) {
                                    tileData[bp++] = sampleFormat == 3 ? (byte)(TiffDecoder.toFloat(bitReader.readBits(bps), bps) * 255.0f) : (byte)(bitReader.readBits(bps) >> shift);
                                }
                            }
                            if (iw8 == 0) continue;
                            bitReader.readBits(8 - iw8);
                        }
                    }
                }
            } else {
                tileData = output;
            }
            tile.data = tileData;
            tiles.add(tile);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (isPlanar) {
            int spp = ifd.samplesPerPixel;
            byte[][] planars = new byte[spp][dim];
            int n4 = 0;
            int iter = tiles.size() / spp;
            for (int s = 0; s < spp; ++s) {
                for (int i = 0; i < iter; ++i) {
                    bos.write(((Tile)tiles.get((int)n4++)).data);
                }
                planars[s] = bos.toByteArray();
                bos.reset();
            }
            for (int i = 0; i < dim; ++i) {
                for (int s = 0; s < spp; ++s) {
                    bos.write(planars[s][i]);
                }
            }
        } else {
            for (Tile tile : tiles) {
                bos.write(tile.data);
            }
        }
        BufferedImage image = TiffDecoder.allocateBufferedImage(ifd);
        int bp = 0;
        byte[] data = bos.toByteArray();
        switch (ifd.photometric) {
            case 6: {
                int b;
                int g;
                int r;
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (int i = 0; i < dim; ++i) {
                    int yy = data[bp++] & 0xFF;
                    int cb = data[bp++] & 0xFF;
                    int cr = data[bp++] & 0xFF;
                    int u2 = (cb -= 128) >> 2;
                    int v35 = ((cr -= 128) >> 3) + (cr >> 5);
                    r = yy + cr + (cr >> 2) + v35;
                    g = yy - (u2 + (cb >> 4) + (cb >> 5)) - ((cr >> 1) + v35 + (cr >> 4));
                    b = yy + cb + (cb >> 1) + u2 + (cb >> 6);
                    int n5 = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                    int n6 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                    b = b < 0 ? 0 : (b > 255 ? 255 : b);
                    intPixels[i] = r << 16 | g << 8 | b;
                }
                break;
            }
            case 2: {
                int b;
                int g;
                int r;
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                if (ifd.samplesPerPixel == 3) {
                    for (int i = 0; i < dim; ++i) {
                        r = data[bp++] & 0xFF;
                        g = data[bp++] & 0xFF;
                        b = data[bp++] & 0xFF;
                        intPixels[i] = r << 16 | g << 8 | b;
                    }
                } else {
                    for (int i = 0; i < dim; ++i) {
                        r = data[bp++] & 0xFF;
                        g = data[bp++] & 0xFF;
                        b = data[bp++] & 0xFF;
                        int a = data[bp++] & 0xFF;
                        intPixels[i] = a << 24 | r << 16 | g << 8 | b;
                    }
                }
                break;
            }
            case 5: {
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                EnumeratedSpace cmyk = new EnumeratedSpace();
                for (int i = 0; i < dim; ++i) {
                    byte c = data[bp++];
                    byte m = data[bp++];
                    byte y = data[bp++];
                    k = data[bp++];
                    byte[] rgb = cmyk.getRGB(c, m, y, (byte)k);
                    intPixels[i] = (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF;
                }
                break;
            }
            case 3: {
                int b;
                int g;
                int r;
                if (ifd.bps[0] > 8) {
                    int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                    for (int i = 0; i < dim; ++i) {
                        r = data[bp++] & 0xFF;
                        g = data[bp++] & 0xFF;
                        b = data[bp++] & 0xFF;
                        intPixels[i] = r << 16 | g << 8 | b;
                    }
                    break;
                }
                byte[] bytePixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int min = Math.min(bytePixels.length, data.length);
                System.arraycopy(data, 0, bytePixels, 0, min);
                break;
            }
            default: {
                byte[] bytePixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int min = Math.min(bytePixels.length, data.length);
                System.arraycopy(data, 0, bytePixels, 0, min);
            }
        }
        return image;
    }

    private static BufferedImage getImageFromTiles(RandomHandler reader, IFD ifd) throws Exception {
        int p;
        int k;
        int i;
        int j;
        if (ifd.tileOffsets == null) {
            ifd.tileOffsets = ifd.stripOffsets;
        }
        if (ifd.tileByteCounts == null) {
            ifd.tileByteCounts = ifd.stripByteCounts;
        }
        int iw = ifd.imageWidth;
        int ih = ifd.imageHeight;
        int tw = ifd.tileWidth;
        int th = ifd.tileLength;
        boolean isPlanar = ifd.planarConfiguration == 2;
        int tileComp = isPlanar ? 1 : ifd.samplesPerPixel;
        boolean hasPalette = ifd.colorMap != null;
        int xTiles = (iw + (tw - 1)) / tw;
        int yTiles = (ih + (th - 1)) / th;
        int totalTiles = ifd.tileOffsets.length;
        int bps = ifd.bps[0];
        int sampleLen = 0;
        if (ifd.planarConfiguration == 2) {
            sampleLen = ifd.bps[0];
        } else {
            for (int i2 = 0; i2 < ifd.bps.length; ++i2) {
                sampleLen += ifd.bps[i2];
            }
        }
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (int t = 0; t < totalTiles; ++t) {
            reader.setPosition(ifd.tileOffsets[t]);
            byte[] tileData = new byte[ifd.tileByteCounts[t]];
            reader.get(tileData);
            byte[] output = null;
            int expectation = ((tw * sampleLen + 7) / 8 * 8 * th + 7) / 8;
            switch (ifd.compressionType) {
                case 1: {
                    output = tileData;
                    break;
                }
                case 2: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, tw, th);
                    fax.decompress1D(output, tileData, 0, th);
                    break;
                }
                case 3: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, tw, th);
                    fax.decompressFax3(output, tileData, th);
                    break;
                }
                case 4: {
                    output = new byte[expectation];
                    CCITT fax = new CCITT(ifd.fillOrder, tw, th);
                    fax.decompressFax4(output, tileData, th);
                    break;
                }
                case 5: {
                    output = new byte[expectation];
                    LZW lzw = new LZW();
                    lzw.decompress(output, tileData, tw, th);
                    break;
                }
                case 6: {
                    throw new Exception("Old style jpeg compression is not supported");
                }
                case 7: {
                    if (ifd.jpegTables != null) {
                        int ifdLen = ifd.jpegTables.length;
                        byte[] temp = new byte[ifdLen + tileData.length - 2];
                        System.arraycopy(ifd.jpegTables, 0, temp, 0, ifdLen);
                        System.arraycopy(tileData, 2, temp, ifdLen, tileData.length - 2);
                        tileData = temp;
                    }
                    JpegDecoder decoder = new JpegDecoder();
                    output = decoder.readComponentsAsRawBytes(tileData);
                    break;
                }
                case 32773: {
                    int exp = (tw * th * sampleLen + 7) / 8;
                    output = PackBits.decompress(tileData, exp);
                    break;
                }
                case 8: 
                case 32946: {
                    output = Deflate.decompress(tileData);
                    break;
                }
                default: {
                    System.err.println("unrecognized compression found");
                }
            }
            if (ifd.predictor == 2) {
                for (int j2 = 0; j2 < th; ++j2) {
                    int count = tileComp * (j2 * tw + 1);
                    for (int i3 = tileComp; i3 < tw * tileComp; ++i3) {
                        int n = count;
                        output[n] = (byte)(output[n] + output[count - tileComp]);
                        ++count;
                    }
                }
            }
            if (ifd.photometric == 0) {
                int n = 0;
                for (int i4 = 0; i4 < output.length; ++i4) {
                    output[i4] = (byte)(output[n++] & 0xFF ^ 0xFF);
                }
            }
            Tile tile = new Tile();
            int iw8 = tw * bps * tileComp % 8;
            if (bps != 8) {
                int shift;
                tileData = new byte[th * tw * tileComp];
                JPXBitReader bitReader = new JPXBitReader(output);
                int bp = 0;
                if (bps == 1) {
                    for (int i5 = 0; i5 < th; ++i5) {
                        for (j = 0; j < tw; ++j) {
                            for (int k2 = 0; k2 < tileComp; ++k2) {
                                tileData[bp++] = hasPalette ? (byte)bitReader.readBits(bps) : (byte)(bitReader.readBits(bps) * 255);
                            }
                        }
                        if (iw8 == 0) continue;
                        bitReader.readBits(8 - iw8);
                    }
                } else if (bps < 8) {
                    shift = 8 - bps;
                    for (int i6 = 0; i6 < th; ++i6) {
                        for (int j3 = 0; j3 < tw; ++j3) {
                            for (int k3 = 0; k3 < tileComp; ++k3) {
                                tileData[bp++] = hasPalette ? (byte)bitReader.readBits(bps) : (byte)(bitReader.readBits(bps) << shift);
                            }
                        }
                        if (iw8 == 0) continue;
                        bitReader.readBits(8 - iw8);
                    }
                } else {
                    int j4;
                    shift = bps - 8;
                    int sampleFormat = ifd.sampleFormat[0];
                    if (hasPalette) {
                        tileData = new byte[th * tw * 3];
                        tileComp = 3;
                        for (i = 0; i < th; ++i) {
                            for (j4 = 0; j4 < tw; ++j4) {
                                int v = bitReader.readBits(bps) * 3;
                                tileData[bp++] = ifd.colorMap[v++];
                                tileData[bp++] = ifd.colorMap[v++];
                                tileData[bp++] = ifd.colorMap[v];
                            }
                            if (iw8 == 0) continue;
                            bitReader.readBits(8 - iw8);
                        }
                    } else {
                        for (i = 0; i < th; ++i) {
                            for (j4 = 0; j4 < tw; ++j4) {
                                for (k = 0; k < tileComp; ++k) {
                                    tileData[bp++] = sampleFormat == 3 ? (byte)(TiffDecoder.toFloat(bitReader.readBits(bps), bps) * 255.0f) : (byte)(bitReader.readBits(bps) >> shift);
                                }
                            }
                            if (iw8 == 0) continue;
                            bitReader.readBits(8 - iw8);
                        }
                    }
                }
            } else {
                tileData = output;
            }
            tile.data = tileData;
            tiles.add(tile);
        }
        int[][] tileDim = new int[th * yTiles][tw * xTiles];
        if (isPlanar) {
            int tp = 0;
            int planarTiles = tiles.size() / ifd.samplesPerPixel;
            for (int z = 0; z < ifd.samplesPerPixel; ++z) {
                for (int t = 0; t < planarTiles; ++t) {
                    Tile tile = (Tile)tiles.get(tp++);
                    byte[] output = tile.data;
                    p = t % xTiles;
                    int q = t / xTiles;
                    int tx = p * tw;
                    int ty = q * th;
                    int bp = 0;
                    for (i = 0; i < th; ++i) {
                        int iPos = ty + i;
                        for (int j5 = 0; j5 < tw; ++j5) {
                            int jPos = tx + j5;
                            int value = output[bp++] & 0xFF;
                            tileDim[iPos][jPos] = tileDim[iPos][jPos] << 8 | value;
                        }
                    }
                }
            }
        } else {
            for (int t = 0; t < tiles.size(); ++t) {
                Tile tile = (Tile)tiles.get(t);
                byte[] output = tile.data;
                p = t % xTiles;
                int q = t / xTiles;
                int tx = p * tw;
                int ty = q * th;
                int bp = 0;
                for (int i7 = 0; i7 < th; ++i7) {
                    int iPos = ty + i7;
                    for (j = 0; j < tw; ++j) {
                        int jPos = tx + j;
                        int value = 0;
                        for (k = tileComp; k > 0; --k) {
                            value |= (output[bp++] & 0xFF) << 8 * (k - 1);
                        }
                        tileDim[iPos][jPos] = value;
                    }
                }
            }
        }
        if (ifd.samplesPerPixel == 4 && ifd.photometric == 2) {
            for (int i8 = 0; i8 < tileDim.length; ++i8) {
                for (int j6 = 0; j6 < tileDim[0].length; ++j6) {
                    int value = tileDim[i8][j6];
                    int r = value >> 24 & 0xFF;
                    int g = value >> 16 & 0xFF;
                    int b = value >> 8 & 0xFF;
                    int a = value & 0xFF;
                    tileDim[i8][j6] = a << 24 | r << 16 | g << 8 | b;
                }
            }
        }
        BufferedImage image = TiffDecoder.allocateBufferedImage(ifd);
        int bp = 0;
        switch (ifd.photometric) {
            case 6: {
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (int i9 = 0; i9 < ih; ++i9) {
                    for (int j7 = 0; j7 < iw; ++j7) {
                        int val = tileDim[i9][j7];
                        int yy = val >> 16 & 0xFF;
                        int cb = val >> 8 & 0xFF;
                        int cr = val & 0xFF;
                        int u2 = (cb -= 128) >> 2;
                        int v35 = ((cr -= 128) >> 3) + (cr >> 5);
                        int r = yy + cr + (cr >> 2) + v35;
                        int g = yy - (u2 + (cb >> 4) + (cb >> 5)) - ((cr >> 1) + v35 + (cr >> 4));
                        int b = yy + cb + (cb >> 1) + u2 + (cb >> 6);
                        int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                        int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                        b = b < 0 ? 0 : (b > 255 ? 255 : b);
                        intPixels[bp++] = r << 16 | g << 8 | b;
                    }
                }
                break;
            }
            case 2: {
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                for (int i10 = 0; i10 < ih; ++i10) {
                    for (int j8 = 0; j8 < iw; ++j8) {
                        intPixels[bp++] = tileDim[i10][j8];
                    }
                }
                break;
            }
            case 5: {
                int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                EnumeratedSpace cmyk = new EnumeratedSpace();
                for (int i11 = 0; i11 < ih; ++i11) {
                    for (int j9 = 0; j9 < iw; ++j9) {
                        int val = tileDim[i11][j9];
                        byte c = (byte)(val >> 24 & 0xFF);
                        byte m = (byte)(val >> 16 & 0xFF);
                        byte y = (byte)(val >> 8 & 0xFF);
                        byte k4 = (byte)(val & 0xFF);
                        byte[] rgb = cmyk.getRGB(c, m, y, k4);
                        intPixels[bp++] = (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF;
                    }
                }
                break;
            }
            case 3: {
                if (ifd.bps[0] > 8) {
                    int[] intPixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                    for (int i12 = 0; i12 < ih; ++i12) {
                        for (int j10 = 0; j10 < iw; ++j10) {
                            intPixels[bp++] = tileDim[i12][j10];
                        }
                    }
                } else {
                    byte[] bytePixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    for (int i13 = 0; i13 < ih; ++i13) {
                        for (int j11 = 0; j11 < iw; ++j11) {
                            bytePixels[bp++] = (byte)tileDim[i13][j11];
                        }
                    }
                }
                break;
            }
            default: {
                byte[] bytePixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int i14 = 0; i14 < ih; ++i14) {
                    for (int j12 = 0; j12 < iw; ++j12) {
                        bytePixels[bp++] = (byte)tileDim[i14][j12];
                    }
                }
            }
        }
        return image;
    }

    private static BufferedImage generateImageFromIFD(RandomHandler reader, IFD ifd) throws Exception {
        if (ifd.tileWidth != 0) {
            return TiffDecoder.getImageFromTiles(reader, ifd);
        }
        return TiffDecoder.getDataFromStrips(reader, ifd);
    }

    private static BufferedImage allocateBufferedImage(IFD ifd) {
        int imageWidth = ifd.imageWidth;
        int imageHeight = ifd.imageHeight;
        if (ifd.photometric == 3) {
            if (ifd.bps[0] > 8) {
                return new BufferedImage(imageWidth, imageHeight, 1);
            }
            IndexColorModel indexedCM = new IndexColorModel(8, ifd.colorMap.length / 3, ifd.colorMap, 0, false);
            WritableRaster ras = indexedCM.createCompatibleWritableRaster(ifd.imageWidth, ifd.imageHeight);
            return new BufferedImage(indexedCM, ras, false, null);
        }
        switch (ifd.samplesPerPixel) {
            case 0: 
            case 1: 
            case 2: {
                return new BufferedImage(imageWidth, imageHeight, 10);
            }
            case 3: {
                return new BufferedImage(imageWidth, imageHeight, 1);
            }
            case 4: {
                if (ifd.photometric == 5) {
                    return new BufferedImage(imageWidth, imageHeight, 1);
                }
                return new BufferedImage(imageWidth, imageHeight, 2);
            }
        }
        return new BufferedImage(imageWidth, imageHeight, 2);
    }

    private static int[] readBitsPerSamples(RandomHandler reader, int offset, int nSamples) throws IOException {
        reader.setPosition(offset);
        int[] temp = new int[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            temp[i] = reader.getUint16();
        }
        return temp;
    }

    private static int[] readOffsets(RandomHandler reader, int offset, int nOffsets, int fieldType) throws IOException {
        reader.setPosition(offset);
        int[] temp = new int[nOffsets];
        if (fieldType == 3) {
            for (int i = 0; i < nOffsets; ++i) {
                temp[i] = reader.getUint16();
            }
        } else {
            for (int i = 0; i < nOffsets; ++i) {
                temp[i] = reader.getInt();
            }
        }
        return temp;
    }

    private static int[] readStripTileByteCounts(RandomHandler reader, int offset, int nCount, int fieldType) throws IOException {
        reader.setPosition(offset);
        int[] temp = new int[nCount];
        if (fieldType == 3) {
            for (int i = 0; i < nCount; ++i) {
                temp[i] = reader.getUint16();
            }
        } else {
            for (int i = 0; i < nCount; ++i) {
                temp[i] = reader.getInt();
            }
        }
        return temp;
    }

    private static byte[] readColorMap(RandomHandler reader, int cmapOffset, int nValues) throws IOException {
        int sv;
        int j;
        reader.setPosition(cmapOffset);
        int totalColors = nValues / 3;
        byte[] rr = new byte[totalColors];
        byte[] gg = new byte[totalColors];
        byte[] bb = new byte[totalColors];
        for (j = 0; j < totalColors; ++j) {
            sv = reader.getUint16();
            rr[j] = (byte)(sv >> 8);
        }
        for (j = 0; j < totalColors; ++j) {
            sv = reader.getUint16();
            gg[j] = (byte)(sv >> 8);
        }
        for (j = 0; j < totalColors; ++j) {
            sv = reader.getUint16();
            bb[j] = (byte)(sv >> 8);
        }
        byte[] temp = new byte[nValues];
        int p = 0;
        for (int i = 0; i < totalColors; ++i) {
            temp[p++] = rr[i];
            temp[p++] = gg[i];
            temp[p++] = bb[i];
        }
        return temp;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    private static float toFloat(int hbits, int bps) {
        if (bps == 16) {
            int mant = hbits & 0x3FF;
            int exp = hbits & 0x7C00;
            if (exp == 31744) {
                exp = 261120;
            } else if (exp != 0) {
                if (mant == 0 && (exp += 114688) > 115712) {
                    return Float.intBitsToFloat((hbits & 0x8000) << 16 | exp << 13 | 0x3FF);
                }
            } else if (mant != 0) {
                exp = 115712;
                do {
                    exp -= 1024;
                } while (((mant <<= 1) & 0x400) == 0);
                mant &= 0x3FF;
            }
            return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
        }
        return Float.intBitsToFloat(hbits);
    }
}

