/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class AxialShadeContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final PDFFunction[] function;
    private final float[] background;
    private float[] domain;
    private boolean[] extension;
    final float t0;
    final float t1;
    final double x0;
    final double y0;
    final double x1;
    final double y1;
    final double deltaX;
    final double deltaY;
    final double multiXY;
    private final AffineTransform shadeAffine;
    private AffineTransform inversed;

    public AxialShadeContext(AffineTransform xform, GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] mm, PDFFunction[] function, int textX, int textY) {
        block5: {
            this.domain = new float[]{0.0f, 1.0f};
            this.shadingColorSpace = shadingColorSpace;
            this.function = function;
            float[] newDomain = shadingObject.getFloatArray(1026641277);
            if (newDomain != null) {
                this.domain = newDomain;
            }
            this.background = background;
            this.extension = shadingObject.getBooleanArray(1144345468);
            if (this.extension == null) {
                this.extension = new boolean[]{false, false};
            }
            this.t0 = this.domain[0];
            this.t1 = this.domain[1];
            this.shadeAffine = mm == null ? new AffineTransform() : new AffineTransform(mm[0][0], mm[0][1], mm[1][0], mm[1][1], mm[2][0], mm[2][1]);
            try {
                this.inversed = xform.createInverse();
            }
            catch (NoninvertibleTransformException ex) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + ex + ' ');
                }
                if (this.inversed != null) break block5;
                this.inversed = new AffineTransform();
            }
        }
        float[] coords = shadingObject.getFloatArray(1061308290);
        GeneralPath coordPath = ShadingUtils.getPathFromBBox(coords);
        PathIterator iter = coordPath.getPathIterator(this.shadeAffine);
        double[] temp = new double[6];
        iter.currentSegment(temp);
        this.x0 = temp[0];
        this.y0 = temp[1];
        iter.next();
        iter.currentSegment(temp);
        this.x1 = temp[0];
        this.y1 = temp[1];
        this.deltaX = this.x1 - this.x0;
        this.deltaY = this.y1 - this.y0;
        this.multiXY = this.deltaX * this.deltaX + this.deltaY * this.deltaY;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        int rastSize = w * h * 4;
        int[] data = new int[rastSize];
        if (this.background != null) {
            this.shadingColorSpace.setColor(this.background, 4);
            Color c = (Color)((Object)this.shadingColorSpace.getColor());
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    int base = (i * w + j) * 4;
                    data[base] = c.getRed();
                    data[base + 1] = c.getGreen();
                    data[base + 2] = c.getBlue();
                    data[base + 3] = 255;
                }
            }
        }
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                boolean render = true;
                double[] src = new double[]{startX + j, startY + i};
                this.inversed.transform(src, 0, src, 0, 1);
                double x = src[0];
                double y = src[1];
                float t = 0.0f;
                double xp = (this.deltaX * (x - this.x0) + this.deltaY * (y - this.y0)) / this.multiXY;
                if (xp >= 0.0 && xp <= 1.0) {
                    t = (float)((double)this.t0 + (double)(this.t1 - this.t0) * xp);
                } else if (xp < 0.0 && this.extension[0]) {
                    t = this.t0;
                } else if (xp > 1.0 && this.extension[1]) {
                    t = this.t1;
                } else {
                    render = false;
                }
                if (!render) continue;
                Color c = this.calculateColor(t);
                int base = (i * w + j) * 4;
                data[base] = c.getRed();
                data[base + 1] = c.getGreen();
                data[base + 2] = c.getBlue();
                data[base + 3] = 255;
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private Color calculateColor(float val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, new float[]{val});
        this.shadingColorSpace.setColor(colValues, colValues.length);
        Color col = (Color)((Object)this.shadingColorSpace.getColor());
        return col;
    }
}

