/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.Shape67;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;

public class CoonsContext
implements PaintContext {
    private GenericColorSpace shadingColorSpace;
    private final float[] background;
    private int bitsPerCoordinate;
    private int bitsPerComponent;
    private int bitsPerFlag;
    private int colCompCount;
    private float[] decodeArr;
    private float[][] matrix;
    private ArrayList<Point2D> pp;
    private ArrayList<Color> pc;
    private final ArrayList<Shape67> shapes;
    private BitReader reader;
    private PDFFunction[] function;
    private final Shape67[] duplicates;
    private final boolean isRecursive;

    CoonsContext(AffineTransform xform, ArrayList<Shape67> shapes, float[] background, int pageHeight, float scaling, int offX, int offY) {
        this.shapes = shapes;
        this.background = background;
        this.duplicates = new Shape67[shapes.size()];
        for (int i = 0; i < shapes.size(); ++i) {
            Shape67 temp = shapes.get(i).cloneShape();
            temp.applyTransformation(xform);
            this.duplicates[i] = temp;
        }
        this.isRecursive = this.duplicates.length < 50;
    }

    CoonsContext(AffineTransform xform, GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] matrix, int pageHeight, float scaling, int offX, int offY, PDFFunction[] function) {
        this.shadingColorSpace = shadingColorSpace;
        this.background = background;
        this.bitsPerComponent = shadingObject.getInt(-1344207655);
        this.bitsPerFlag = shadingObject.getInt(1500422077);
        this.bitsPerCoordinate = shadingObject.getInt(-335950113);
        this.decodeArr = shadingObject.getFloatArray(859785322);
        boolean hasSmallBits = this.bitsPerFlag < 8 || this.bitsPerComponent < 8 || this.bitsPerCoordinate < 8;
        this.reader = new BitReader(shadingObject.getDecodedStream(), hasSmallBits);
        this.colCompCount = shadingColorSpace.getColorComponentCount();
        if (this.decodeArr != null) {
            this.colCompCount = (this.decodeArr.length - 4) / 2;
        }
        this.function = function;
        this.matrix = matrix;
        this.pp = new ArrayList();
        this.pc = new ArrayList();
        this.shapes = new ArrayList();
        this.process();
        this.adjustPoints();
        this.duplicates = new Shape67[this.shapes.size()];
        for (int i = 0; i < this.shapes.size(); ++i) {
            Shape67 temp = this.shapes.get(i).cloneShape();
            temp.applyTransformation(xform);
            this.duplicates[i] = temp;
        }
        this.isRecursive = this.duplicates.length < 50;
    }

    private void process() {
        block6: while (this.reader.getPointer() < this.reader.getTotalBitLen()) {
            int flag = this.reader.getPositive(this.bitsPerFlag);
            Point2D[] a4 = new Point2D[4];
            Color[] a2 = new Color[2];
            float[] cc = new float[this.colCompCount];
            switch (flag) {
                case 0: {
                    Color color;
                    Point2D p;
                    int i;
                    for (i = 0; i < 12; ++i) {
                        p = this.getPointCoords();
                        this.pp.add(p);
                    }
                    for (i = 0; i < 4; ++i) {
                        for (int z = 0; z < this.colCompCount; ++z) {
                            cc[z] = this.reader.getFloat(this.bitsPerComponent);
                        }
                        color = this.calculateColor(cc);
                        this.pc.add(color);
                    }
                    continue block6;
                }
                case 1: {
                    Color color;
                    Point2D p;
                    int i;
                    a4[0] = this.pp.get(this.pp.size() - 9);
                    a4[1] = this.pp.get(this.pp.size() - 8);
                    a4[2] = this.pp.get(this.pp.size() - 7);
                    a4[3] = this.pp.get(this.pp.size() - 6);
                    this.pp.addAll(Arrays.asList(a4).subList(0, 4));
                    for (i = 0; i < 8; ++i) {
                        p = this.getPointCoords();
                        this.pp.add(p);
                    }
                    a2[0] = this.pc.get(this.pc.size() - 3);
                    a2[1] = this.pc.get(this.pc.size() - 2);
                    this.pc.addAll(Arrays.asList(a2));
                    for (i = 0; i < 2; ++i) {
                        for (int z = 0; z < this.colCompCount; ++z) {
                            cc[z] = this.reader.getFloat(this.bitsPerComponent);
                        }
                        color = this.calculateColor(cc);
                        this.pc.add(color);
                    }
                    continue block6;
                }
                case 2: {
                    Color color;
                    Point2D p;
                    int i;
                    a4[0] = this.pp.get(this.pp.size() - 6);
                    a4[1] = this.pp.get(this.pp.size() - 5);
                    a4[2] = this.pp.get(this.pp.size() - 4);
                    a4[3] = this.pp.get(this.pp.size() - 3);
                    this.pp.addAll(Arrays.asList(a4).subList(0, 4));
                    for (i = 0; i < 8; ++i) {
                        p = this.getPointCoords();
                        this.pp.add(p);
                    }
                    a2[0] = this.pc.get(this.pc.size() - 2);
                    a2[1] = this.pc.get(this.pc.size() - 1);
                    this.pc.addAll(Arrays.asList(a2));
                    for (i = 0; i < 2; ++i) {
                        for (int z = 0; z < this.colCompCount; ++z) {
                            cc[z] = this.reader.getFloat(this.bitsPerComponent);
                        }
                        color = this.calculateColor(cc);
                        this.pc.add(color);
                    }
                    continue block6;
                }
                case 3: {
                    Color color;
                    Point2D p;
                    int i;
                    a4[0] = this.pp.get(this.pp.size() - 3);
                    a4[1] = this.pp.get(this.pp.size() - 2);
                    a4[2] = this.pp.get(this.pp.size() - 1);
                    a4[3] = this.pp.get(this.pp.size() - 12);
                    this.pp.addAll(Arrays.asList(a4).subList(0, 4));
                    for (i = 0; i < 8; ++i) {
                        p = this.getPointCoords();
                        this.pp.add(p);
                    }
                    a2[0] = this.pc.get(this.pc.size() - 1);
                    a2[1] = this.pc.get(this.pc.size() - 4);
                    this.pc.addAll(Arrays.asList(a2));
                    for (i = 0; i < 2; ++i) {
                        for (int z = 0; z < this.colCompCount; ++z) {
                            cc[z] = this.reader.getFloat(this.bitsPerComponent);
                        }
                        color = this.calculateColor(cc);
                        this.pc.add(color);
                    }
                    break;
                }
            }
        }
    }

    private void adjustPoints() {
        if (this.decodeArr != null) {
            float xMin = this.decodeArr[0];
            float xMax = this.decodeArr[1];
            float yMin = this.decodeArr[2];
            float yMax = this.decodeArr[3];
            float xw = xMax - xMin;
            float yw = yMax - yMin;
            ArrayList<Point2D.Double> tempPoints = new ArrayList<Point2D.Double>();
            for (Point2D point2D : this.pp) {
                double xx = point2D.getX();
                double yy = point2D.getY();
                xx = (double)xw * xx + (double)xMin;
                yy = (double)yw * yy + (double)yMin;
                tempPoints.add(new Point2D.Double(xx, yy));
            }
            this.pp.clear();
            for (Point2D point2D : tempPoints) {
                this.pp.add(point2D);
            }
        }
        Point2D[] pArr = new Point2D[this.pp.size()];
        for (int i = 0; i < pArr.length; ++i) {
            pArr[i] = this.pp.get(i);
        }
        int totalPatches = this.pp.size() / 12;
        int offset = 0;
        double[] mm = new double[]{this.matrix[0][0], this.matrix[0][1], this.matrix[1][0], this.matrix[1][1], this.matrix[2][0], this.matrix[2][1]};
        AffineTransform affine = new AffineTransform(mm);
        for (int i = 0; i < totalPatches; ++i) {
            Point2D[] pointArr = new Point2D[12];
            Color[] colors = new Color[]{this.pc.get(i * 4), this.pc.get(i * 4 + 1), this.pc.get(i * 4 + 2), this.pc.get(i * 4 + 3)};
            System.arraycopy(pArr, offset, pointArr, 0, 12);
            Shape67 shape67 = new Shape67(pointArr, colors);
            shape67.applyTransformation(affine);
            this.shapes.add(shape67);
            offset += 12;
        }
    }

    private Point2D getPointCoords() {
        double x = 0.0;
        double y = 0.0;
        block4: for (int z = 0; z < 2; ++z) {
            switch (z) {
                case 0: {
                    x = this.reader.getFloat(this.bitsPerCoordinate);
                    continue block4;
                }
                case 1: {
                    y = this.reader.getFloat(this.bitsPerCoordinate);
                }
            }
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public void dispose() {
        this.reader = null;
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xStart, int yStart, int w, int h) {
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
        if (this.background != null) {
            int pos = 0;
            this.shadingColorSpace.setColor(this.background, 4);
            Color c = (Color)((Object)this.shadingColorSpace.getColor());
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    data[pos++] = 0xFF000000 | c.getRGB();
                }
            }
        }
        Rectangle rect = new Rectangle(xStart, yStart, w, h);
        ArrayList<Shape67> foundList = new ArrayList<Shape67>();
        for (Shape67 sh : this.duplicates) {
            if (!sh.getShape().intersects(rect)) continue;
            foundList.add(sh);
        }
        for (Shape67 sh : foundList) {
            GeneralPath path = sh.getShape();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    Point p;
                    Color result;
                    int xx = x + xStart;
                    int yy = y + yStart;
                    if (!path.contains(xx, yy) || (result = sh.findPointColor(p = new Point(xx, yy), this.isRecursive)) == null) continue;
                    int base = y * w + x;
                    data[base] = 0xFF000000 | result.getRGB();
                }
            }
        }
        return raster;
    }

    private Color calculateColor(float[] val) {
        Color col;
        if (this.function == null) {
            this.shadingColorSpace.setColor(val, this.colCompCount);
            col = new Color(this.shadingColorSpace.getColor().getRGB());
        } else {
            float[] colValues = ShadingFactory.applyFunctions(this.function, val);
            this.shadingColorSpace.setColor(colValues, colValues.length);
            col = (Color)((Object)this.shadingColorSpace.getColor());
        }
        return col;
    }

    public ArrayList<Shape67> getShapes() {
        return this.shapes;
    }
}

