/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.parser.DecoderOptions;

public class FunctionContext
implements PaintContext {
    final GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private final PDFFunction[] function;
    private final int pageHeight;
    private final boolean colorsReversed;
    private int xstart;
    private int ystart;

    FunctionContext(int pHeight, float scaling, GenericColorSpace shadingColorSpace, boolean colorsReversed, PDFFunction[] function) {
        this.colorsReversed = colorsReversed;
        this.pageHeight = pHeight;
        this.shadingColorSpace = shadingColorSpace;
        this.function = function;
        this.scaling = scaling;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xstart, int ystart, int w, int h) {
        this.xstart = xstart;
        this.ystart = ystart;
        int[] data = new int[w * h * 4];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int cb;
                int cg;
                int cr;
                Color c = this.calculateColor(x, y);
                if (this.colorsReversed) {
                    cr = 255 - c.getRed();
                    cg = 255 - c.getGreen();
                    cb = 255 - c.getBlue();
                } else {
                    cr = c.getRed();
                    cg = c.getGreen();
                    cb = c.getBlue();
                }
                int base = (y * w + x) * 4;
                data[base] = cr;
                data[base + 1] = cg;
                data[base + 2] = cb;
                data[base + 3] = 255;
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private Color calculateColor(float x, float y) {
        float cy;
        float cx;
        if (DecoderOptions.isRunningOnMac) {
            cx = this.scaling * (x + (float)this.xstart);
            cy = this.scaling * (y + (float)this.ystart);
        } else {
            cx = this.scaling * (x + (float)this.xstart);
            cy = this.scaling * ((float)this.pageHeight - (y + (float)this.ystart));
        }
        float[] values = new float[]{cx, cy};
        float[] colValues = ShadingFactory.applyFunctions(this.function, values);
        int count = colValues.length;
        this.shadingColorSpace.setColor(colValues, count);
        return (Color)((Object)this.shadingColorSpace.getColor());
    }
}

