/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;

public class RadialContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final float[] background;
    private final PdfObject shadingObj;
    private final PDFFunction[] function;
    private final float[] coords;
    private boolean[] extended = new boolean[]{false, false};
    private float t0;
    private float t1 = 1.0f;
    private final float x0;
    private final float y0;
    private final float r0;
    private final float x1;
    private final float y1;
    private final float r1;
    private final float deltaX;
    private final float deltaY;
    private final float deltaR;
    private final float deltaC;
    private final float powerR0;
    private final Color colorT0;
    private final Color colorT1;

    RadialContext(AffineTransform xForm, boolean isPrinting, GenericColorSpace shadingColorSpace, float[] background, PdfObject shading, float[][] matrix, PDFFunction[] function) {
        float[] domain;
        this.shadingColorSpace = shadingColorSpace;
        this.background = background;
        this.shadingObj = shading;
        this.function = function;
        float[] src = shading.getFloatArray(1061308290);
        boolean[] extension = this.shadingObj.getBooleanArray(1144345468);
        if (extension != null) {
            this.extended = extension;
        }
        if ((domain = this.shadingObj.getFloatArray(1026641277)) != null) {
            this.t0 = domain[0];
            this.t1 = domain[1];
        }
        this.coords = new float[src.length];
        System.arraycopy(src, 0, this.coords, 0, src.length);
        AffineTransform affine = new AffineTransform(matrix[0][0], matrix[0][1], matrix[1][0], matrix[1][1], matrix[2][0], matrix[2][1]);
        double[] temp = new double[6];
        GeneralPath gp = new GeneralPath();
        gp.moveTo(this.coords[0], this.coords[1]);
        gp.lineTo(this.coords[0] + this.coords[2], this.coords[1]);
        PathIterator iter = gp.getPathIterator(affine);
        iter.currentSegment(temp);
        Point2D.Double pointXY0 = new Point2D.Double(temp[0], temp[1]);
        iter.next();
        iter.currentSegment(temp);
        Point2D.Double temp0 = new Point2D.Double(temp[0], temp[1]);
        gp = new GeneralPath();
        gp.moveTo(this.coords[3], this.coords[4]);
        gp.lineTo(this.coords[3] + this.coords[5], this.coords[4]);
        iter = gp.getPathIterator(affine);
        iter.currentSegment(temp);
        Point2D.Double pointXY1 = new Point2D.Double(temp[0], temp[1]);
        iter.next();
        iter.currentSegment(temp);
        Point2D.Double temp1 = new Point2D.Double(temp[0], temp[1]);
        Point2D[] points = new Point2D[]{pointXY0, pointXY1, temp0, temp1};
        xForm.transform(points, 0, points, 0, 4);
        this.x0 = (float)points[0].getX();
        this.y0 = (float)points[0].getY();
        this.x1 = (float)points[1].getX();
        this.y1 = (float)points[1].getY();
        this.r0 = (float)points[0].distance(points[2]);
        this.r1 = (float)points[1].distance(points[3]);
        this.colorT0 = this.calculateColor(this.t0);
        this.colorT1 = this.calculateColor(this.t1);
        this.deltaX = this.x1 - this.x0;
        this.deltaY = this.y1 - this.y0;
        this.deltaR = this.r1 - this.r0;
        this.deltaC = this.deltaX * this.deltaX + this.deltaY * this.deltaY - this.deltaR * this.deltaR;
        this.powerR0 = this.r0 * this.r0;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    private Color calculateColor(float val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, new float[]{val});
        this.shadingColorSpace.setColor(colValues, colValues.length);
        return (Color)((Object)this.shadingColorSpace.getColor());
    }

    @Override
    public Raster getRaster(int startX, int startY, int w, int h) {
        int x;
        int y;
        int[] data = new int[w * h * 4];
        if (this.background != null) {
            for (y = 0; y < h; ++y) {
                for (x = 0; x < w; ++x) {
                    this.shadingColorSpace.setColor(this.background, this.shadingColorSpace.getColorComponentCount());
                    Color c = (Color)((Object)this.shadingColorSpace.getColor());
                    int base = (y * w + x) * 4;
                    data[base] = c.getRed();
                    data[base + 1] = c.getGreen();
                    data[base + 2] = c.getBlue();
                    data[base + 3] = 255;
                }
            }
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                float[] xy = new float[]{x + startX, y + startY};
                Color result = null;
                float[] qr = this.quadraticEquate(xy[0], xy[1]);
                if (qr[1] >= 0.0f && qr[1] <= 1.0f) {
                    result = this.calculateColor(this.getTfromS(qr[1]));
                } else if (this.extended[1] && qr[1] >= 0.0f && this.r1 + qr[1] * this.deltaR >= 0.0f) {
                    result = this.colorT1;
                } else if (qr[0] >= 0.0f && qr[0] <= 1.0f) {
                    result = this.calculateColor(this.getTfromS(qr[0]));
                } else if (this.extended[0] && qr[1] <= 0.0f && this.r1 + qr[1] * this.deltaR >= 0.0f) {
                    result = this.calculateColor(this.getTfromS(qr[1]));
                } else if (this.extended[0] && qr[0] <= 1.0f && this.r1 + qr[0] * this.deltaR >= 0.0f) {
                    result = this.colorT0;
                }
                if (result == null) continue;
                int base = (y * w + x) * 4;
                data[base] = result.getRed();
                data[base + 1] = result.getGreen();
                data[base + 2] = result.getBlue();
                data[base + 3] = 255;
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private float getTfromS(float s) {
        return s * (this.t1 - this.t0) + this.t0;
    }

    private float[] quadraticEquate(float x, float y) {
        float[] fArray;
        float xDiff = x - this.x0;
        float yDiff = y - this.y0;
        float p = -xDiff * this.deltaX - yDiff * this.deltaY - this.r0 * this.deltaR;
        float q = xDiff * xDiff + yDiff * yDiff - this.powerR0;
        float sqrt = (float)Math.sqrt(p * p - this.deltaC * q);
        float sA = (sqrt - p) / this.deltaC;
        float sB = (-p - sqrt) / this.deltaC;
        if (this.deltaC < 0.0f) {
            float[] fArray2 = new float[2];
            fArray2[0] = sA;
            fArray = fArray2;
            fArray2[1] = sB;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = sB;
            fArray = fArray3;
            fArray3[1] = sA;
        }
        return fArray;
    }
}

