/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import org.jpedal.color.DeviceCMYKColorSpace;

public class CMYKtoRGB {
    public static BufferedImage convert(Raster ras, int w, int h) {
        byte[] rasData = ((DataBufferByte)ras.getDataBuffer()).getData();
        return CMYKtoRGB.decode(rasData, w, h);
    }

    public static BufferedImage convert(byte[] cmyk, int w, int h) {
        return CMYKtoRGB.decode(cmyk, w, h);
    }

    public static BufferedImage decode(byte[] rasData, int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 1);
        int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        ColorSpace CMYK = DeviceCMYKColorSpace.getColorSpaceInstance();
        int dim = w * h;
        int p = 0;
        for (int i = 0; i < dim; ++i) {
            int c = rasData[p++] & 0xFF;
            int m = rasData[p++] & 0xFF;
            int y = rasData[p++] & 0xFF;
            int k = rasData[p++] & 0xFF;
            float[] RGB = CMYK.toRGB(new float[]{(float)c / 255.0f, (float)m / 255.0f, (float)y / 255.0f, (float)k / 255.0f});
            int r = (int)(RGB[0] * 255.0f);
            int g = (int)(RGB[1] * 255.0f);
            int b = (int)(RGB[2] * 255.0f);
            imageData[i] = r << 16 | g << 8 | b;
        }
        return image;
    }
}

