/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.util.Map;
import org.jpedal.color.CalGrayColorSpace;
import org.jpedal.color.CalRGBColorSpace;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceNColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.ICCColorSpace;
import org.jpedal.color.LabColorSpace;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class ColorspaceFactory {
    private ColorspaceFactory() {
    }

    public static final GenericColorSpace getColorSpaceInstance(PdfObjectReader currentPdfFile, PdfObject colorSpace, Map colorspacesObjects) {
        String key = colorSpace.getStatus() == 0 ? colorSpace.getObjectRefAsString() : new String(colorSpace.getUnresolvedData());
        GenericColorSpace col = null;
        Object cachedValue = colorspacesObjects.get(key);
        if (cachedValue != null) {
            col = (GenericColorSpace)cachedValue;
            col.reset();
        }
        if (col == null && (col = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, colorSpace)).getID() == 1247168582) {
            colorspacesObjects.put(key, col);
        }
        return col;
    }

    public static final GenericColorSpace getColorSpaceInstance(PdfObjectReader currentPdfFile, PdfObject colorSpace) {
        currentPdfFile.checkResolved(colorSpace);
        int ID2 = colorSpace.getParameterConstant(2087749783);
        if (ID2 == 320678171) {
            ID2 = 1498837125;
        }
        boolean isIndexed = false;
        int size = 0;
        byte[] lookup = null;
        int rawID = -1;
        if (ID2 == 895578984 || ID2 == 25) {
            isIndexed = true;
            size = colorSpace.getInt(960901492);
            lookup = colorSpace.getDictionary(1060856191).getDecodedStream();
            colorSpace = colorSpace.getDictionary(895578984);
            rawID = ID2 = colorSpace.getParameterConstant(2087749783);
        }
        GenericColorSpace currentColorData = ColorspaceFactory.getColorspace(currentPdfFile, colorSpace, ID2);
        if (isIndexed) {
            if (rawID == 1247168582 && lookup.length < 3) {
                currentColorData = new DeviceGrayColorSpace();
            }
            currentColorData.setIndex(lookup, size);
        }
        currentColorData.setAlternateColorSpace(colorSpace.getParameterConstant(2054519176));
        return currentColorData;
    }

    private static GenericColorSpace getColorspace(PdfObjectReader currentPdfFile, PdfObject colorSpace, int ID2) {
        GenericColorSpace currentColorData = new DeviceRGBColorSpace();
        switch (ID2) {
            case -2073385820: {
                currentColorData = new SeparationColorSpace(currentPdfFile, colorSpace);
                break;
            }
            case 960981604: {
                currentColorData = new DeviceNColorSpace(currentPdfFile, colorSpace);
                break;
            }
            case 1568372915: {
                currentColorData = new DeviceGrayColorSpace();
                break;
            }
            case 1498837125: {
                currentColorData = new DeviceCMYKColorSpace();
                currentColorData.setRawColorSpace(1498837125);
                break;
            }
            case 391471749: {
                currentColorData = ColorspaceFactory.getCalGrayColorspace(colorSpace);
                break;
            }
            case 1008872003: {
                currentColorData = ColorspaceFactory.getCalRGBColorspace(colorSpace);
                break;
            }
            case 1847602: {
                currentColorData = ColorspaceFactory.getLabColorspace(colorSpace);
                break;
            }
            case 1247168582: {
                currentColorData = ColorspaceFactory.getICCColorspace(colorSpace);
                break;
            }
            case 1146450818: {
                PdfObject col = colorSpace.getDictionary(-1247101998);
                GenericColorSpace patternColorSpace = null;
                if (col != null) {
                    patternColorSpace = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, col);
                }
                currentColorData = new PatternColorSpace(currentPdfFile, patternColorSpace);
            }
        }
        return currentColorData;
    }

    private static GenericColorSpace getICCColorspace(PdfObject colorSpace) {
        GenericColorSpace currentColorData = new DeviceRGBColorSpace();
        int alt = colorSpace.getParameterConstant(2054519176);
        if (alt != 1568372915) {
            currentColorData = new ICCColorSpace(colorSpace);
        }
        int type = currentColorData.getType();
        if (alt == 1498837125 && currentColorData.isInvalid()) {
            currentColorData = new DeviceCMYKColorSpace();
        } else if (type == 9) {
            currentColorData = new DeviceCMYKColorSpace();
        } else if (type == 5) {
            currentColorData = new DeviceRGBColorSpace();
        } else if (type == 6) {
            currentColorData = new DeviceGrayColorSpace();
        }
        currentColorData.setRawColorSpace(1247168582);
        return currentColorData;
    }

    private static GenericColorSpace getLabColorspace(PdfObject colorSpace) {
        float[] R = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
        float[] W = new float[]{0.0f, 1.0f, 0.0f};
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float[] rangeArray = colorSpace.getFloatArray(826160983);
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (rangeArray != null) {
            R = rangeArray;
        }
        return new LabColorSpace(W, R);
    }

    private static GenericColorSpace getCalRGBColorspace(PdfObject colorSpace) {
        float[] W = new float[]{0.0f, 1.0f, 0.0f};
        float[] G2 = new float[]{1.0f, 1.0f, 1.0f};
        float[] Ma = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] gammaArray = colorSpace.getFloatArray(826096968);
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float[] matrixArray = colorSpace.getFloatArray(1145198201);
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (gammaArray != null) {
            G2 = gammaArray;
        }
        if (matrixArray != null) {
            Ma = matrixArray;
        }
        return new CalRGBColorSpace(W, Ma, G2);
    }

    private static GenericColorSpace getCalGrayColorspace(PdfObject colorSpace) {
        float[] W = new float[]{0.0f, 1.0f, 0.0f};
        float[] G2 = new float[]{1.0f, 1.0f, 1.0f};
        float[] gammaArray = null;
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float rawGamma = colorSpace.getFloatNumber(826096968);
        if (rawGamma != -1.0f) {
            gammaArray = new float[]{rawGamma};
        }
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (gammaArray != null) {
            G2 = gammaArray;
        }
        return new CalGrayColorSpace(W, G2);
    }
}

