/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class DeviceNColorSpace
extends SeparationColorSpace {
    private static final long serialVersionUID = -1372268945371555187L;
    private final Map cache = new HashMap();

    public DeviceNColorSpace(PdfObjectReader currentPdfFile, PdfObject colorSpace) {
        this.setType(960981604);
        this.processColorToken(currentPdfFile, colorSpace);
    }

    @Override
    public void setColor(String[] operand, int opCount) {
        float[] values = new float[opCount];
        for (int j = 0; j < opCount; ++j) {
            values[j] = Float.parseFloat(operand[j]);
        }
        this.setColor(values, opCount);
    }

    @Override
    public void setColor(float[] raw, int opCount) {
        float[] newOp;
        int[] lookup = new int[3];
        int opNumbers = raw.length;
        if (opNumbers > 3) {
            opNumbers = 3;
        }
        for (int i = 0; i < opNumbers; ++i) {
            lookup[i] = (int)(raw[i] * 255.0f);
        }
        boolean isCached = false;
        if (this.cmykMapping == 1009857357 && opCount == 1) {
            newOp = new float[]{0.0f, 0.0f, 0.0f, raw[0]};
            this.altCS.setColor(newOp, newOp.length);
        } else if (opCount < 4 && this.cache.get((lookup[0] << 16) + (lookup[1] << 8) + lookup[2]) != null) {
            isCached = true;
            Object val = this.cache.get((lookup[0] << 16) + (lookup[1] << 8) + lookup[2]);
            int rawValue = (Integer)val;
            int r = rawValue >> 16 & 0xFF;
            int g = rawValue >> 8 & 0xFF;
            int b = rawValue & 0xFF;
            this.altCS.currentColor = new PdfColor(r, g, b);
        } else if (this.cmykMapping == 9 && opCount == 4) {
            newOp = new float[]{raw[0], raw[1], raw[2], raw[3]};
            this.altCS.setColor(newOp, newOp.length);
        } else if (this.cmykMapping == 1 && opCount == 3) {
            newOp = new float[]{0.0f, raw[0], raw[1], raw[2]};
            this.altCS.setColor(newOp, newOp.length);
        } else if (this.cmykMapping == 2 && opCount == 3) {
            newOp = new float[]{raw[0], raw[1], raw[2], 0.0f};
            this.altCS.setColor(newOp, newOp.length);
        } else if (this.cmykMapping == 4 && opCount == 3) {
            newOp = new float[]{raw[0], raw[1], 0.0f, raw[2]};
            this.altCS.setColor(newOp, newOp.length);
        } else if (this.cmykMapping == 5 && opCount == 2) {
            newOp = new float[]{raw[0], 0.0f, raw[1], 0.0f};
            this.altCS.setColor(newOp, newOp.length);
        } else if (this.cmykMapping == 8 && opCount == 2) {
            newOp = new float[]{raw[0], raw[1], 0.0f, 0.0f};
            this.altCS.setColor(newOp, newOp.length);
        } else if (this.cmykMapping == 6 && opCount == 2) {
            newOp = new float[]{0.0f, raw[0], raw[1], 0.0f};
            this.altCS.setColor(newOp, newOp.length);
        } else {
            float[] operand = this.colorMapper.getOperandFloat(raw);
            this.altCS.setColor(operand, operand.length);
        }
        if (!isCached) {
            this.altCS.getColor().getRGB();
            int rawValue = this.altCS.getColor().getRGB();
            this.cache.put((lookup[0] << 16) + (lookup[1] << 8) + lookup[2], rawValue);
        }
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image = this.createImage(w, h, data, false);
        return image;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int ww, int hh, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        BufferedImage image = null;
        Raster ras = JPEGDecoder.getRasterFromJPEG(data, "JPEG");
        if (ras != null) {
            ras = DeviceNColorSpace.cleanupRaster(ras, pX, pY, this.componentCount);
            int w = ras.getWidth();
            int h = ras.getHeight();
            DataBufferByte rgb = (DataBufferByte)ras.getDataBuffer();
            image = this.createImage(w, h, rgb.getData(), arrayInverted);
        }
        return image;
    }

    @Override
    BufferedImage createImage(int w, int h, byte[] rawData, boolean arrayInverted) {
        byte[] rgb = new byte[w * h * 3];
        int bytesCount = rawData.length;
        int byteCount = rawData.length / this.componentCount;
        float[] values = new float[this.componentCount];
        int j = 0;
        int j2 = 0;
        for (int i = 0; i < byteCount && j < bytesCount; ++i) {
            for (int comp = 0; comp < this.componentCount; ++comp) {
                values[comp] = (float)(rawData[j] & 0xFF) / 255.0f;
                ++j;
            }
            this.setColor(values, this.componentCount);
            int foreground = this.altCS.currentColor.getRGB();
            rgb[j2] = (byte)(foreground >> 16 & 0xFF);
            rgb[j2 + 1] = (byte)(foreground >> 8 & 0xFF);
            rgb[j2 + 2] = (byte)(foreground & 0xFF);
            j2 += 3;
        }
        int[] bands = new int[]{0, 1, 2};
        BufferedImage image = new BufferedImage(w, h, 1);
        DataBufferByte dataBuf = new DataBufferByte(rgb, rgb.length);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuf, w, h, w * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }
}

