/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.image.jpeg2000.Jpeg2000Decoder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    protected GenericColorSpace altCS;
    static final int Black = 1009857357;
    static final int PANTONE_BLACK = 573970506;
    private static final int Cyan = 323563838;
    private static final int Magenta = 895186280;
    public static final int Yellow = 1010591868;
    protected ColorMapping colorMapper;
    private float[] domain;
    protected int cmykMapping = -1;
    protected static final int NOCMYK = -1;
    protected static final int MYK = 1;
    protected static final int CMY = 2;
    protected static final int CMK = 4;
    protected static final int CY = 5;
    protected static final int MY = 6;
    protected static final int CM = 8;
    protected static final int CMYK = 7;
    protected static final int CMYB = 9;

    public SeparationColorSpace() {
    }

    public SeparationColorSpace(PdfObjectReader currentPdfFile, PdfObject colorSpace) {
        this.setType(-2073385820);
        this.processColorToken(currentPdfFile, colorSpace);
    }

    protected void processColorToken(PdfObjectReader currentPdfFile, PdfObject colorSpace) {
        PdfObject indexed = colorSpace.getDictionary(895578984);
        PdfObject functionObj = colorSpace.getDictionary(-1313946392);
        this.domain = null;
        byte[] name = null;
        Object components = null;
        if (this.getID() == -2073385820) {
            name = colorSpace.getStringValueAsByte(506543413);
            if (name != null) {
                components = new byte[][]{name};
            }
            this.componentCount = 1;
        } else {
            components = colorSpace.getStringArray(1920898752);
            this.componentCount = ((byte[][])components).length;
        }
        this.cmykMapping = -1;
        int[] values = new int[this.componentCount];
        if (components != null) {
            for (int ii = 0; ii < this.componentCount; ++ii) {
                values[ii] = PdfDictionary.generateChecksum(1, components[ii].length - 1, components[ii]);
            }
        }
        switch (this.componentCount) {
            case 1: {
                if (components == null || values[0] != 1009857357 && values[0] != 573970506) break;
                this.cmykMapping = 1009857357;
                break;
            }
            case 2: {
                if (values[0] == 323563838) {
                    if (values[1] == 1010591868) {
                        this.cmykMapping = 5;
                        break;
                    }
                    if (values[1] != 895186280) break;
                    this.cmykMapping = 8;
                    break;
                }
                if (values[0] != 895186280 || values[1] != 1010591868) break;
                this.cmykMapping = 6;
                break;
            }
            case 3: {
                if (values[0] == 895186280 && values[1] == 1010591868 && values[2] == 1009857357) {
                    this.cmykMapping = 1;
                    break;
                }
                if (values[0] == 323563838 && values[1] == 895186280 && values[2] == 1010591868) {
                    this.cmykMapping = 2;
                    break;
                }
                if (values[0] != 323563838 || values[1] != 895186280 || values[2] != 1009857357) break;
                this.cmykMapping = 4;
                break;
            }
            case 4: {
                if (values[0] != 323563838 || values[1] != 895186280 || values[2] != 1010591868 || values[3] != 1009857357) break;
                this.cmykMapping = 9;
                break;
            }
            case 5: {
                if (values[0] != 323563838 || values[1] != 895186280 || values[2] != 1010591868 || values[3] != 1009857357) break;
                this.cmykMapping = 7;
                break;
            }
            case 6: {
                if (values[0] != 323563838 || values[1] != 895186280 || values[2] != 1010591868 || values[3] != 1009857357) break;
                this.cmykMapping = 7;
            }
        }
        if (this.cmykMapping != -1) {
            this.altCS = new DeviceCMYKColorSpace();
        } else {
            colorSpace = colorSpace.getDictionary(-1247101998);
            this.altCS = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, colorSpace);
            if (this.altCS.getID() == 1247168582 && colorSpace.getParameterConstant(2054519176) == 1498837125) {
                this.altCS = new DeviceCMYKColorSpace();
            }
        }
        if (name != null) {
            int len = name.length;
            int jj = 0;
            byte[] tempName = new byte[len];
            for (int i = 0; i < len; ++i) {
                if (name[i] == 35) {
                    int topHex;
                    if ((topHex = name[++i]) >= 65 && topHex <= 70) {
                        topHex -= 55;
                    } else if (topHex >= 97 && topHex <= 102) {
                        topHex -= 87;
                    } else if (topHex >= 48 && topHex <= 57) {
                        topHex -= 48;
                    }
                    ++i;
                    while (name[i] == 32 || name[i] == 10 || name[i] == 13) {
                        ++i;
                    }
                    int bottomHex = name[i];
                    if (bottomHex >= 65 && bottomHex <= 70) {
                        bottomHex -= 55;
                    } else if (bottomHex >= 97 && bottomHex <= 102) {
                        bottomHex -= 87;
                    } else if (bottomHex >= 48 && bottomHex <= 57) {
                        bottomHex -= 48;
                    }
                    tempName[jj] = (byte)(bottomHex + (topHex << 4));
                } else {
                    tempName[jj] = name[i];
                }
                ++jj;
            }
            if (jj != len) {
                name = new byte[jj];
                System.arraycopy(tempName, 0, name, 0, jj);
            }
            this.pantoneName = new String(name);
        }
        if (functionObj == null) {
            colorSpace.getDictionary(-1313946392);
        }
        if (functionObj == null && indexed != null) {
            functionObj = indexed.getDictionary(-1313946392);
        }
        this.colorMapper = new ColorMapping(currentPdfFile, functionObj);
        this.domain = functionObj.getFloatArray(1026641277);
    }

    private void setColor(float value) {
        if (this.cmykMapping == 1009857357) {
            float[] newOp = new float[]{0.0f, 0.0f, 0.0f, value};
            this.altCS.setColor(newOp, 1);
        } else {
            int elements = 1;
            if (this.domain != null) {
                elements = this.domain.length / 2;
            }
            float[] values = new float[elements];
            for (int j = 0; j < elements; ++j) {
                values[j] = value;
            }
            float[] operand = this.colorMapper.getOperandFloat(values);
            this.altCS.setColor(operand, operand.length);
        }
    }

    @Override
    public void setColor(float[] operand, int opCount) {
        this.setColor(operand[0]);
    }

    @Override
    public void setColor(String[] operand, int opCount) {
        float[] f = new float[]{Float.parseFloat(operand[0])};
        this.setColor(f, 1);
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int ww, int hh, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        BufferedImage image;
        block9: {
            ImageInputStream iin;
            ImageReader iir;
            ByteArrayInputStream in;
            block8: {
                in = null;
                iir = null;
                iin = null;
                try {
                    ImageReader o;
                    in = new ByteArrayInputStream(data);
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
                    }
                    ImageIO.setUseCache(false);
                    iin = ImageIO.createImageInputStream(in);
                    iir.setInput(iin, true);
                    Raster ras = iir.readRaster(0, null);
                    ras = SeparationColorSpace.cleanupRaster(ras, pX, pY, 1);
                    int w = ras.getWidth();
                    int h = ras.getHeight();
                    DataBufferByte rgb = (DataBufferByte)ras.getDataBuffer();
                    byte[] rawData = rgb.getData();
                    if (this.altCS.getID() == 1568372915) {
                        for (int aa = 0; aa < rawData.length; ++aa) {
                            rawData[aa] = (byte)(rawData[aa] ^ 0xFF);
                        }
                        int[] bands = new int[]{0};
                        image = new BufferedImage(w, h, 10);
                        WritableRaster raster = Raster.createInterleavedRaster(new DataBufferByte(rawData, rawData.length), w, h, w, 1, bands, null);
                        image.setData(raster);
                    } else {
                        image = this.createImage(w, h, rawData, arrayInverted);
                    }
                }
                catch (Exception ee) {
                    image = null;
                    if (!LogWriter.isOutput()) break block8;
                    LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
                }
            }
            try {
                in.close();
                iir.dispose();
                iin.close();
            }
            catch (Exception ee) {
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Problem closing  " + ee);
            }
        }
        return image;
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, int d) throws PdfException {
        BufferedImage image;
        block3: {
            try {
                Jpeg2000Decoder decoder = new Jpeg2000Decoder();
                image = decoder.read(data);
                this.IndexedColorMap = null;
                if (this.IndexedColorMap == null) {
                    image = SeparationColorSpace.cleanupImage(image, pX, pY);
                }
                int iw = image.getWidth();
                int ih = image.getHeight();
                DataBufferByte rgb = (DataBufferByte)image.getRaster().getDataBuffer();
                byte[] rawData = rgb.getData();
                image = this.getID() == 960981604 ? this.createImageN(iw, ih, rawData) : this.createImage(iw, ih, rawData, false);
            }
            catch (Exception ee) {
                image = null;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception in JPEG2000ToRGBImage: " + ee);
            }
        }
        return image;
    }

    private BufferedImage createImageN(int w, int h, byte[] rawData) {
        byte[] rgb = new byte[w * h * 3];
        int bytesCount = rawData.length;
        int byteCount = this.IndexedColorMap != null ? rawData.length : rawData.length / this.componentCount;
        float[] values = new float[this.componentCount];
        int j = 0;
        int j2 = 0;
        for (int i = 0; i < byteCount && j < bytesCount; ++i) {
            int comp;
            if (this.IndexedColorMap != null) {
                int index = (rawData[i] & 0xFF) * this.componentCount;
                for (comp = 0; comp < this.componentCount; ++comp) {
                    values[comp] = (float)(this.IndexedColorMap[index + comp] & 0xFF) / 255.0f;
                }
            } else {
                for (comp = 0; comp < this.componentCount; ++comp) {
                    values[comp] = (float)(rawData[j] & 0xFF) / 255.0f;
                    ++j;
                }
            }
            this.setColor(values, this.componentCount);
            int foreground = this.altCS.currentColor.getRGB();
            rgb[j2] = (byte)(foreground >> 16 & 0xFF);
            rgb[j2 + 1] = (byte)(foreground >> 8 & 0xFF);
            rgb[j2 + 2] = (byte)(foreground & 0xFF);
            j2 += 3;
        }
        int[] bands = new int[]{0, 1, 2};
        BufferedImage image = new BufferedImage(w, h, 1);
        DataBufferByte dataBuf = new DataBufferByte(rgb, rgb.length);
        WritableRaster raster = Raster.createInterleavedRaster(dataBuf, w, h, w * 3, 3, bands, null);
        image.setData(raster);
        return image;
    }

    @Override
    public BufferedImage dataToRGB(byte[] data, int w, int h) {
        BufferedImage image;
        block2: {
            try {
                image = this.createImage(w, h, data, false);
            }
            catch (Exception ee) {
                image = null;
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Couldn't convert Separation colorspace data: " + ee);
            }
        }
        return image;
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] rgb, int w, int h, boolean arrayInverted) {
        int pixelCount = 3 * w * h;
        byte[] imageData = new byte[pixelCount];
        int pixelReached = 0;
        float[][] lookuptable = new float[3][256];
        for (int i = 0; i < 256; ++i) {
            lookuptable[0][i] = -1.0f;
        }
        for (byte aRgb : rgb) {
            int value = aRgb & 0xFF;
            if (lookuptable[0][value] == -1.0f) {
                if (arrayInverted) {
                    this.setColor(1.0f - (float)value / 255.0f);
                } else {
                    this.setColor((float)value / 255.0f);
                }
                lookuptable[0][value] = ((Color)((Object)this.getColor())).getRed();
                lookuptable[1][value] = ((Color)((Object)this.getColor())).getGreen();
                lookuptable[2][value] = ((Color)((Object)this.getColor())).getBlue();
            }
            for (int comp = 0; comp < 3; ++comp) {
                imageData[pixelReached] = (byte)lookuptable[comp][value];
                ++pixelReached;
            }
        }
        return imageData;
    }

    BufferedImage createImage(int w, int h, byte[] rgb, boolean arrayInverted) {
        byte[] imageData = this.dataToRGBByteArray(rgb, w, h, arrayInverted);
        BufferedImage image = new BufferedImage(w, h, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(imageData, w, h);
        image.setData(raster);
        return image;
    }

    @Override
    public byte[] convertIndexToRGB(byte[] data) {
        byte[] newdata;
        block6: {
            this.isConverted = true;
            newdata = new byte[768];
            try {
                int outputReached = 0;
                int byteCount = data.length;
                float[] values = new float[this.componentCount];
                for (int i = 0; i < byteCount; i += this.componentCount) {
                    Color currentCol;
                    if (this.componentCount == 1 && this.getID() == -2073385820 && this.colorMapper == null) {
                        float[] opValues = new float[1];
                        opValues[1] = data[i] & 0xFF;
                        this.setColor(opValues, 1);
                        currentCol = (Color)((Object)this.getColor());
                    } else {
                        for (int j = 0; j < this.componentCount; ++j) {
                            values[j] = (float)(data[i + j] & 0xFF) / 255.0f;
                        }
                        float[] operand = this.colorMapper.getOperandFloat(values);
                        this.altCS.setColor(operand, operand.length);
                        currentCol = (Color)((Object)this.altCS.getColor());
                    }
                    newdata[outputReached] = (byte)currentCol.getRed();
                    newdata[++outputReached] = (byte)currentCol.getGreen();
                    newdata[++outputReached] = (byte)currentCol.getBlue();
                    ++outputReached;
                }
            }
            catch (Exception ee) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception  " + ee + " converting colorspace");
            }
        }
        return newdata;
    }

    @Override
    public PdfPaint getColor() {
        return this.altCS.getColor();
    }

    @Override
    public final Object clone() {
        Object o;
        this.setColorStatus();
        try {
            o = super.clone();
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Unable to close " + e);
            }
            throw new RuntimeException("Unable to clone object");
        }
        return o;
    }

    private void setColorStatus() {
        int foreground = this.altCS.currentColor.getRGB();
        this.r = foreground >> 16 & 0xFF;
        this.g = foreground >> 8 & 0xFF;
        this.b = foreground & 0xFF;
    }

    @Override
    public void restoreColorStatus() {
        this.altCS.currentColor = new PdfColor(this.r, this.g, this.b);
        this.altCS.clearCache();
    }
}

