/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Point;

public class DisplayOffsets {
    protected boolean dragLeft;
    protected boolean dragTop;
    private int userOffsetX;
    private int userOffsetY;
    private int userPrintOffsetX;
    private int userPrintOffsetY;
    private int facingCursorX = 10000;
    private int facingCursorY = 10000;

    public void setUserOffsets(int x, int y, int h, int mode) {
        switch (mode) {
            case 0: {
                this.userOffsetX = x;
                this.userOffsetY = y;
                break;
            }
            case 1: {
                this.userPrintOffsetX = x;
                this.userPrintOffsetY = -y;
                break;
            }
            case 995: {
                this.facingCursorX = 0;
                this.facingCursorY = h;
                this.setDragCorner(mode);
                break;
            }
            case 998: {
                this.facingCursorX = x;
                this.facingCursorY = y;
                this.setDragCorner(mode);
                break;
            }
            case 999: {
                this.facingCursorX = x;
                this.facingCursorY = y;
                this.setDragCorner(mode);
                break;
            }
            case 996: {
                this.facingCursorX = x;
                this.facingCursorY = y;
                this.setDragCorner(mode);
                break;
            }
            case 997: {
                this.facingCursorX = x;
                this.facingCursorY = y;
                this.setDragCorner(mode);
                break;
            }
            default: {
                throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
            }
        }
    }

    public Point getUserOffsets(int mode) {
        switch (mode) {
            case 0: {
                return new Point(this.userOffsetX, this.userOffsetY);
            }
            case 1: {
                return new Point(this.userPrintOffsetX, this.userPrintOffsetY);
            }
            case 999: {
                return new Point(this.facingCursorX, this.facingCursorY);
            }
        }
        throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
    }

    public int getUserPrintOffsetX() {
        return this.userPrintOffsetX;
    }

    public int getUserPrintOffsetY() {
        return this.userPrintOffsetY;
    }

    public int getUserOffsetX() {
        return this.userOffsetX;
    }

    public int getUserOffsetY() {
        return this.userOffsetY;
    }

    public void setDragCorner(int a) {
        this.dragLeft = a == 998 || a == 996 || a == 995;
        this.dragTop = a == 996 || a == 997;
    }

    public boolean getDragLeft() {
        return this.dragLeft;
    }

    public boolean getDragTop() {
        return this.dragTop;
    }
}

