/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.CacheHint;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PageFlowFX
extends AnchorPane {
    private final boolean isFX;
    protected final PdfDecoderInt pdf;
    private boolean stopAddingPages;
    private final int pageCount;
    private int displayRotation;
    protected int pageNumber;
    private int pagesToGenerate = 21;
    private static final int textureSize = 256;
    private Page[] pages;
    private double totalPageWidth;
    private Rectangle backgroundTop;
    private Rectangle backgroundBottom;
    private NavBar navBar;
    private ZoomBar zoomBar;
    private CheckBox perspectiveCheckBox;
    private CheckBox reflectionCheckBox;
    private Cursor defaultCursor;
    private Cursor grabbingCursor;
    private Cursor grabCursor;
    private double sceneXOffset;
    private double sceneYOffset;
    private boolean currentlyAddingPages;
    private boolean memoryWarningShown;
    private boolean pageFlowEnding;
    private double scaling = 1.5;
    private double pageFocus = 1.0;
    private int currentZPosition = -1;
    private boolean formsIgnoredStore;
    private int pagesInMemory;
    private final long memoryLimit;
    private final Runtime runtime;
    private final int pageLimit;
    private boolean pageClickEvent;
    private boolean enableReflection = true;
    private boolean enablePerspectiveTransform = true;
    private double newSceneWidth;
    private double newSceneHeight;
    private volatile double x;
    private volatile boolean isAnimating;
    private volatile boolean stopAnimating;
    private int newDestination;
    private double speed;
    final DoubleProperty pageNumberProperty = new SimpleDoubleProperty();
    private boolean isUpdateMemory;
    private String memoryMessage;

    public PageFlowFX(PdfDecoderInt pdfDecoder, boolean isFX) {
        Platform.setImplicitExit((boolean)false);
        this.pdf = pdfDecoder;
        this.isFX = isFX;
        this.pageCount = this.pdf.getPageCount();
        this.setPageNumber(pdfDecoder.getPageNumber());
        this.pageFocus = this.pageNumber;
        this.pagesInMemory = 0;
        this.runtime = Runtime.getRuntime();
        long maxMem = this.runtime.maxMemory();
        this.memoryLimit = (float)maxMem * 0.25f < 3.6E7f ? maxMem - 36000000L : (long)((float)maxMem * 0.75f);
        AcroRenderer formRenderer = this.pdf.getFormRenderer();
        if (formRenderer != null) {
            this.formsIgnoredStore = formRenderer.ignoreForms();
            formRenderer.setIgnoreForms(true);
        }
        this.pages = new Page[this.pageCount];
        this.createScene();
        this.pageLimit = 50;
    }

    private void createScene() {
        ObservableList children = this.getChildren();
        this.sceneXOffset = this.newSceneWidth / 2.0;
        this.sceneYOffset = this.newSceneHeight / 2.0;
        this.backgroundTop = new Rectangle(0.0, 0.0, this.newSceneWidth, this.newSceneHeight / 2.0);
        this.backgroundTop.setFill((Paint)new Color(0.21568627655506134, 0.21568627655506134, 0.2549019753932953, 1.0));
        this.backgroundBottom = new Rectangle(0.0, this.newSceneHeight / 2.0, this.newSceneWidth, this.newSceneHeight / 2.0);
        this.backgroundBottom.setFill((Paint)new Color(0.10980392247438431, 0.10980392247438431, 0.125490203499794, 1.0));
        this.navBar = new NavBar();
        this.zoomBar = new ZoomBar();
        this.perspectiveCheckBox = new CheckBox("Perspectives");
        this.perspectiveCheckBox.setLayoutX(5.0);
        this.perspectiveCheckBox.setLayoutY(5.0);
        this.perspectiveCheckBox.setTextFill((Paint)Color.WHITE);
        this.perspectiveCheckBox.setSelected(true);
        this.perspectiveCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                PageFlowFX.this.togglePerspectives();
            }
        });
        this.reflectionCheckBox = new CheckBox("Reflections");
        this.reflectionCheckBox.setLayoutX(5.0);
        this.reflectionCheckBox.setLayoutY(25.0);
        this.reflectionCheckBox.setTextFill((Paint)Color.WHITE);
        this.reflectionCheckBox.setSelected(true);
        this.reflectionCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                PageFlowFX.this.toggleReflections();
            }
        });
        if (DecoderOptions.isRunningOnLinux) {
            this.toggleReflections();
            this.togglePerspectives();
        }
        children.addAll((Object[])new Node[]{this.backgroundTop, this.backgroundBottom, this.navBar, this.zoomBar, this.perspectiveCheckBox, this.reflectionCheckBox});
        this.setupMouseHandlers();
        this.setupWindowResizeListeners();
        this.addPages();
    }

    private void repositionObjects() {
        this.newSceneWidth = this.getWidth();
        this.newSceneHeight = this.getHeight();
        this.sceneXOffset = this.newSceneWidth / 2.0;
        this.totalPageWidth = (double)this.pageCount * this.getPageWidthOrHeight();
        this.sceneYOffset = this.newSceneHeight / 2.0;
        this.navBar.update();
        this.zoomBar.update();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PageFlowFX.this.backgroundTop.setWidth(PageFlowFX.this.newSceneWidth);
                PageFlowFX.this.backgroundBottom.setWidth(PageFlowFX.this.newSceneWidth);
                PageFlowFX.this.backgroundTop.setHeight(PageFlowFX.this.newSceneHeight);
                PageFlowFX.this.backgroundBottom.setHeight(PageFlowFX.this.newSceneHeight);
                PageFlowFX.this.backgroundBottom.setY(PageFlowFX.this.newSceneHeight / 2.0);
                if (PageFlowFX.this.pages[PageFlowFX.this.pageNumber - 1] != null) {
                    PageFlowFX.this.pages[PageFlowFX.this.pageNumber - 1].setMain(true);
                }
                for (Page page : PageFlowFX.this.pages) {
                    if (page == null) continue;
                    page.update();
                }
            }
        });
    }

    private void setupWindowResizeListeners() {
        this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
                PageFlowFX.this.repositionObjects();
            }
        });
        this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
                PageFlowFX.this.repositionObjects();
            }
        });
    }

    private void setupMouseHandlers() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (GUIDisplay.allowChangeCursor) {
                    PageFlowFX.this.setCursor(PageFlowFX.this.grabbingCursor);
                }
                if (!PageFlowFX.this.navBar.isNavBarPress(mouseEvent) && !PageFlowFX.this.zoomBar.isZoomBarPress(mouseEvent)) {
                    if (PageFlowFX.this.isAnimating) {
                        PageFlowFX.this.stopAnimating = true;
                    }
                    PageFlowFX.this.x = mouseEvent.getSceneX();
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (!PageFlowFX.this.navBar.isNavBarDrag(mouseEvent) && !PageFlowFX.this.zoomBar.isZoomBarDrag(mouseEvent)) {
                    int newPageNumber;
                    double newPosition = PageFlowFX.this.pageFocus - (mouseEvent.getSceneX() - PageFlowFX.this.x) / PageFlowFX.this.totalPageWidth * 4.0 * (double)PageFlowFX.this.pageCount;
                    if (newPosition > 1.0 && newPosition < (double)PageFlowFX.this.pageCount) {
                        PageFlowFX.this.isAnimating = true;
                        PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, false);
                        PageFlowFX.this.pageFocus = newPosition;
                        PageFlowFX.this.navBar.update();
                        for (Page page : PageFlowFX.this.pages) {
                            if (page == null) continue;
                            page.update();
                        }
                        PageFlowFX.this.isAnimating = false;
                    }
                    if (PageFlowFX.this.pageNumber != (newPageNumber = (int)(PageFlowFX.this.pageFocus + 0.5))) {
                        PageFlowFX.this.setPageNumber(newPageNumber);
                    }
                    PageFlowFX.this.addPages();
                    PageFlowFX.this.x = mouseEvent.getSceneX();
                }
            }
        });
        this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (GUIDisplay.allowChangeCursor) {
                    PageFlowFX.this.setCursor(PageFlowFX.this.grabCursor);
                }
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (GUIDisplay.allowChangeCursor) {
                            PageFlowFX.this.setCursor(PageFlowFX.this.defaultCursor);
                        }
                    }
                }, 350L);
                if (!PageFlowFX.this.navBar.isNavBarRelease(mouseEvent) && !PageFlowFX.this.zoomBar.isZoomBarRelease()) {
                    if (!PageFlowFX.this.pageClickEvent) {
                        if (PageFlowFX.this.pageFocus < 1.0) {
                            PageFlowFX.this.pageFocus = 1.0;
                        } else if (PageFlowFX.this.pageFocus > (double)PageFlowFX.this.pageCount) {
                            PageFlowFX.this.pageFocus = PageFlowFX.this.pageCount;
                        }
                        PageFlowFX.this.goTo((int)(PageFlowFX.this.pageFocus + 0.5));
                    } else {
                        PageFlowFX.this.pageClickEvent = false;
                    }
                }
            }
        });
        this.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (PageFlowFX.this.navBar.isNavBarHover(mouseEvent) || PageFlowFX.this.zoomBar.isZoomBarHover(mouseEvent)) {
                    if (GUIDisplay.allowChangeCursor) {
                        PageFlowFX.this.setCursor(PageFlowFX.this.grabCursor);
                    }
                } else if (GUIDisplay.allowChangeCursor) {
                    PageFlowFX.this.setCursor(PageFlowFX.this.defaultCursor);
                }
            }
        });
        this.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                KeyCode key = keyEvent.getCode();
                switch (key) {
                    case RIGHT: {
                        int dest = PageFlowFX.this.pageNumber + 1;
                        if (dest > PageFlowFX.this.pageCount) break;
                        PageFlowFX.this.goTo(dest);
                        break;
                    }
                    case LEFT: {
                        int dest = PageFlowFX.this.pageNumber - 1;
                        if (dest <= 0) break;
                        PageFlowFX.this.goTo(dest);
                        break;
                    }
                    case R: {
                        PageFlowFX.this.toggleReflections();
                        break;
                    }
                    case T: {
                        PageFlowFX.this.togglePerspectives();
                    }
                }
            }
        });
        this.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                double value = event.getDeltaY();
                if (event.isControlDown()) {
                    if (value < 0.0) {
                        if (PageFlowFX.this.scaling < 2.0) {
                            PageFlowFX.this.scaling = PageFlowFX.this.scaling + 0.1;
                            if (PageFlowFX.this.scaling > 2.0) {
                                PageFlowFX.this.scaling = 2.0;
                            }
                            PageFlowFX.this.zoomBar.update();
                            for (Page page : PageFlowFX.this.pages) {
                                if (page == null) continue;
                                page.update();
                            }
                        }
                    } else if (value > 0.0 && PageFlowFX.this.scaling > 1.0) {
                        PageFlowFX.this.scaling = PageFlowFX.this.scaling - 0.1;
                        if (PageFlowFX.this.scaling < 1.0) {
                            PageFlowFX.this.scaling = 1.0;
                        }
                        PageFlowFX.this.zoomBar.update();
                        for (Page page : PageFlowFX.this.pages) {
                            if (page == null) continue;
                            page.update();
                        }
                    }
                } else if (value > 0.0) {
                    int dest = PageFlowFX.this.pageNumber - 1;
                    if (dest > 0) {
                        PageFlowFX.this.goTo(dest);
                    }
                } else {
                    int dest = PageFlowFX.this.pageNumber + 1;
                    if (dest <= PageFlowFX.this.pageCount) {
                        PageFlowFX.this.goTo(dest);
                    }
                }
            }
        });
        this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (PageFlowFX.this.scaling != 1.0) {
                        PageFlowFX.this.scaling = 1.0;
                    } else {
                        PageFlowFX.this.scaling = 2.0;
                    }
                    PageFlowFX.this.zoomBar.update();
                    for (Page page : PageFlowFX.this.pages) {
                        if (page == null) continue;
                        page.update();
                    }
                }
            }
        });
    }

    private void reorderPages(double pageFocus, boolean forceReorder) {
        final int position = (int)(pageFocus + 0.5);
        if (!(forceReorder || this.currentZPosition != position && position >= 1 && position <= this.pageCount)) {
            return;
        }
        this.currentZPosition = position;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int i;
                PageFlowFX.this.getChildren().clear();
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.backgroundTop);
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.backgroundBottom);
                for (i = PageFlowFX.this.pageCount; i > position; --i) {
                    if (PageFlowFX.this.pages[i - 1] == null) continue;
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[i - 1]);
                    if (!PageFlowFX.this.enableReflection) continue;
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[i - 1].getReflection());
                }
                for (i = 1; i < position; ++i) {
                    if (PageFlowFX.this.pages[i - 1] == null) continue;
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[i - 1]);
                    if (!PageFlowFX.this.enableReflection) continue;
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[i - 1].getReflection());
                }
                if (PageFlowFX.this.pages[position - 1] != null) {
                    PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[position - 1]);
                    if (PageFlowFX.this.enableReflection) {
                        PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.pages[position - 1].getReflection());
                    }
                }
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.navBar);
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.zoomBar);
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.perspectiveCheckBox);
                PageFlowFX.this.getChildren().add((Object)PageFlowFX.this.reflectionCheckBox);
            }
        });
    }

    public void setRotation(int displayRotation) {
        if (this.displayRotation != displayRotation) {
            this.displayRotation = displayRotation;
            for (Page p : this.pages) {
                if (p == null) continue;
                p.dispose();
            }
            this.stop();
            this.stopAddingPages = false;
            this.goTo(this.pageNumber);
        }
    }

    private void toggleReflections() {
        if (this.enableReflection) {
            this.enableReflection = false;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PageFlowFX.this.reflectionCheckBox.setSelected(false);
                }
            });
            for (Page page : this.pages) {
                if (page == null) continue;
                page.disposeReflection();
            }
            this.reorderPages(this.pageFocus, true);
        } else if (this.enablePerspectiveTransform) {
            this.enableReflection = true;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PageFlowFX.this.reflectionCheckBox.setSelected(true);
                }
            });
            for (Page page : this.pages) {
                if (page == null) continue;
                page.setupReflection();
                page.update();
            }
            this.reorderPages(this.pageFocus, true);
        }
    }

    private void togglePerspectives() {
        if (this.enablePerspectiveTransform) {
            if (this.enableReflection) {
                this.toggleReflections();
            }
            this.enablePerspectiveTransform = false;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PageFlowFX.this.perspectiveCheckBox.setSelected(false);
                    PageFlowFX.this.reflectionCheckBox.setDisable(true);
                }
            });
            for (Page page : this.pages) {
                if (page == null) continue;
                page.disposePerspectiveTransform();
                page.update();
            }
        } else {
            this.enablePerspectiveTransform = true;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PageFlowFX.this.perspectiveCheckBox.setSelected(true);
                    PageFlowFX.this.reflectionCheckBox.setDisable(false);
                }
            });
            for (Page page : this.pages) {
                if (page == null) continue;
                page.setupPerspectiveTransform();
                page.update();
            }
        }
    }

    public void setCursors(BufferedImage grab, BufferedImage grabbing) {
        this.grabCursor = grab != null ? new ImageCursor((Image)SwingFXUtils.toFXImage((BufferedImage)grab, (WritableImage)new WritableImage(grab.getWidth(), grab.getHeight())), 8.0, 8.0) : Cursor.DEFAULT;
        this.grabbingCursor = grabbing != null ? new ImageCursor((Image)SwingFXUtils.toFXImage((BufferedImage)grabbing, (WritableImage)new WritableImage(grabbing.getWidth(), grabbing.getHeight())), 8.0, 8.0) : Cursor.DEFAULT;
        this.defaultCursor = Cursor.DEFAULT;
    }

    public void goTo(final int firstDestination) {
        this.setPageNumber(firstDestination);
        for (int i = 0; i < this.pageCount; ++i) {
            if (this.pages[i] == null || i == this.pageNumber - 1) continue;
            this.pages[i].setMain(false);
        }
        if (this.pages[this.pageNumber - 1] != null) {
            this.pages[this.pageNumber - 1].setMain(true);
        }
        this.pdf.setPageParameters(-100.0f, firstDestination);
        this.addPages();
        if (this.isAnimating) {
            this.newDestination = firstDestination;
            return;
        }
        Thread thread = new Thread("PageFlow-goTo"){

            @Override
            public void run() {
                int destination = firstDestination;
                while (!PageFlowFX.this.stopAnimating && (PageFlowFX.this.pageFocus > (double)destination || PageFlowFX.this.pageFocus < (double)destination)) {
                    block13: {
                        if (PageFlowFX.this.newDestination != 0) {
                            destination = PageFlowFX.this.newDestination;
                            PageFlowFX.this.newDestination = 0;
                        }
                        if (PageFlowFX.this.pageFocus < (double)destination) {
                            if (PageFlowFX.this.speed < (double)0.2f) {
                                PageFlowFX.this.speed = 0.2f;
                            }
                            PageFlowFX.this.speed = PageFlowFX.this.speed * (double)1.15f;
                        } else {
                            if (PageFlowFX.this.speed > (double)-0.2f) {
                                PageFlowFX.this.speed = -0.2f;
                            }
                            PageFlowFX.this.speed = PageFlowFX.this.speed * (double)1.15f;
                        }
                        double maxSpeed = ((double)destination - PageFlowFX.this.pageFocus) / 4.0;
                        if (Math.abs(PageFlowFX.this.speed) > Math.abs(maxSpeed)) {
                            PageFlowFX.this.speed = maxSpeed;
                        }
                        PageFlowFX.this.pageFocus = PageFlowFX.this.pageFocus + PageFlowFX.this.speed;
                        if (PageFlowFX.this.pageFocus - (double)((int)PageFlowFX.this.pageFocus) > 0.99) {
                            PageFlowFX.this.pageFocus = (int)PageFlowFX.this.pageFocus + 1;
                        } else if (PageFlowFX.this.pageFocus - (double)((int)PageFlowFX.this.pageFocus) < 0.01) {
                            PageFlowFX.this.pageFocus = (int)PageFlowFX.this.pageFocus;
                        }
                        PageFlowFX.this.navBar.update();
                        PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, false);
                        for (Page page : PageFlowFX.this.pages) {
                            if (page == null) continue;
                            page.update();
                        }
                        try {
                            Thread.sleep(40L);
                        }
                        catch (Exception e) {
                            if (!LogWriter.isOutput()) break block13;
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                    }
                    if (PageFlowFX.this.newDestination == 0) continue;
                    destination = PageFlowFX.this.newDestination;
                    PageFlowFX.this.newDestination = 0;
                }
                PageFlowFX.this.stopAnimating = false;
                PageFlowFX.this.isAnimating = false;
            }
        };
        thread.setDaemon(true);
        this.isAnimating = true;
        thread.start();
    }

    private synchronized Image getPageImage(int pageNumber, int rotation, int quality) {
        int height;
        if (pageNumber != this.pageNumber && quality > 256) {
            return null;
        }
        int width = this.pdf.getPdfPageData().getCropBoxWidth(pageNumber);
        float scale = width > (height = this.pdf.getPdfPageData().getCropBoxHeight(pageNumber)) ? (float)quality / (float)width : (float)quality / (float)height;
        try {
            float currentScaling = this.pdf.getScaling();
            this.pdf.setScaling(scale);
            BufferedImage raw = this.pdf.getPageAsImage(pageNumber);
            this.pdf.setScaling(currentScaling);
            BufferedImage result = new BufferedImage(quality, quality, 2);
            Graphics2D g2 = (Graphics2D)result.getGraphics();
            g2.rotate((double)rotation / 180.0 * Math.PI, quality / 2, quality / 2);
            int x = (quality - raw.getWidth()) / 2;
            int y = quality - raw.getHeight();
            g2.drawImage(raw, x, y, raw.getWidth(), raw.getHeight(), null);
            return SwingFXUtils.toFXImage((BufferedImage)result, (WritableImage)new WritableImage(result.getWidth(), result.getHeight()));
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            return null;
        }
    }

    public void dispose() {
        for (Page page : this.pages) {
            if (page == null) continue;
            page.dispose();
        }
        this.pages = null;
        AcroRenderer formRenderer = this.pdf.getFormRenderer();
        if (formRenderer != null) {
            formRenderer.setIgnoreForms(this.formsIgnoredStore);
        }
    }

    public void stop() {
        this.stopAddingPages = true;
        if (!this.isFX) {
            while (this.currentlyAddingPages) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    private void addPages() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                PageFlowFX.this.currentlyAddingPages = true;
                int firstPage = PageFlowFX.this.pageNumber;
                for (int i = 0; i <= PageFlowFX.this.pagesToGenerate; ++i) {
                    Page page;
                    int pn;
                    block25: {
                        if (PageFlowFX.this.checkMemory()) {
                            return null;
                        }
                        int spacesLeft = PageFlowFX.this.pagesToGenerate * 2 - 1 - PageFlowFX.this.pagesInMemory;
                        if (spacesLeft < 2) {
                            PageFlowFX.this.removeFurthestPages(2 - spacesLeft);
                        }
                        if (i == PageFlowFX.this.pagesToGenerate - 1) {
                            long used = PageFlowFX.this.runtime.totalMemory() - PageFlowFX.this.runtime.freeMemory();
                            if (used < PageFlowFX.this.memoryLimit && PageFlowFX.this.pagesToGenerate < PageFlowFX.this.pageCount && PageFlowFX.this.pagesToGenerate < PageFlowFX.this.pageLimit) {
                                PageFlowFX.this.pagesToGenerate++;
                            } else {
                                used = PageFlowFX.this.runtime.totalMemory() - PageFlowFX.this.runtime.freeMemory();
                                if (used < PageFlowFX.this.memoryLimit && PageFlowFX.this.pagesToGenerate < PageFlowFX.this.pageCount && PageFlowFX.this.pagesToGenerate < PageFlowFX.this.pageLimit) {
                                    PageFlowFX.this.pagesToGenerate++;
                                }
                            }
                        }
                        if (PageFlowFX.this.stopAddingPages) {
                            PageFlowFX.this.currentlyAddingPages = false;
                            PageFlowFX.this.stopAddingPages = false;
                            return null;
                        }
                        pn = firstPage + i;
                        if (i > 40) {
                            pn += i - 40;
                            if ((pn -= pn & 1) > PageFlowFX.this.pageCount && ((pn -= PageFlowFX.this.pageCount - (firstPage + 40)) & 1) == 0) {
                                --pn;
                            }
                        }
                        if (pn <= PageFlowFX.this.pageCount && PageFlowFX.this.pages != null && PageFlowFX.this.pages[pn - 1] == null) {
                            try {
                                page = new Page(pn);
                                if (PageFlowFX.this.pages != null) {
                                    ((PageFlowFX)PageFlowFX.this).pages[pn - 1] = page;
                                    PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, true);
                                    PageFlowFX.this.pagesInMemory++;
                                    if (pn == PageFlowFX.this.pageNumber) {
                                        page.setMain(true);
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (PageFlowFX.this.pages != null) {
                                    ((PageFlowFX)PageFlowFX.this).pages[pn - 1] = null;
                                }
                                PageFlowFX.this.pagesInMemory--;
                                if (!LogWriter.isOutput()) break block25;
                                LogWriter.writeLog("Exception: " + e.getMessage());
                            }
                        }
                    }
                    if (PageFlowFX.this.stopAddingPages) {
                        PageFlowFX.this.currentlyAddingPages = false;
                        PageFlowFX.this.stopAddingPages = false;
                        return null;
                    }
                    pn = firstPage - i;
                    if (i > 40) {
                        pn -= i - 40;
                        if ((pn += pn & 1) < 1 && ((pn += firstPage - 41) & 1) == 0) {
                            --pn;
                        }
                    }
                    if (pn > 0 && PageFlowFX.this.pages != null && PageFlowFX.this.pages[pn - 1] == null) {
                        page = new Page(pn);
                        if (PageFlowFX.this.pages != null) {
                            ((PageFlowFX)PageFlowFX.this).pages[pn - 1] = page;
                            PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, true);
                            PageFlowFX.this.pagesInMemory++;
                        }
                    }
                    if (firstPage != PageFlowFX.this.pageNumber) {
                        i = -1;
                        firstPage = PageFlowFX.this.pageNumber;
                    }
                    if (i <= 10) continue;
                    while ((PageFlowFX.this.speed > (double)0.005f || PageFlowFX.this.speed < (double)-0.005f) && firstPage == PageFlowFX.this.pageNumber) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            if (!LogWriter.isOutput()) continue;
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                    }
                }
                PageFlowFX.this.currentlyAddingPages = false;
                return null;
            }
        };
        Thread th = new Thread((Runnable)task);
        if (!this.currentlyAddingPages) {
            this.currentlyAddingPages = true;
            th.setDaemon(true);
            th.start();
        }
    }

    private boolean checkMemory() {
        int threshold = 32000000;
        boolean debugMemory = false;
        if (this.runtime.maxMemory() - (this.runtime.totalMemory() - this.runtime.freeMemory()) < 32000000L) {
            if (this.pagesInMemory > 1) {
                boolean shrinkingSuccessful = true;
                while (this.runtime.maxMemory() - (this.runtime.totalMemory() - this.runtime.freeMemory()) < 32000000L) {
                    if (this.pagesToGenerate > 5) {
                        --this.pagesToGenerate;
                        int toRemove = this.pagesInMemory - (this.pagesToGenerate * 2 - 1);
                        if (toRemove <= 0) continue;
                        this.removeFurthestPages(toRemove);
                        continue;
                    }
                    shrinkingSuccessful = false;
                }
                if (shrinkingSuccessful) {
                    return false;
                }
                if (this.runtime.maxMemory() - (this.runtime.totalMemory() - this.runtime.freeMemory()) < 32000000L) {
                    if (!this.memoryWarningShown) {
                        if (!this.pageFlowEnding) {
                            this.isUpdateMemory = true;
                            this.memoryMessage = Messages.getMessage("PdfViewer.PageFlowLowMemory");
                        } else {
                            this.isUpdateMemory = false;
                        }
                        this.memoryWarningShown = true;
                    }
                    this.currentlyAddingPages = false;
                    return true;
                }
            } else {
                this.stop();
                if (!Platform.isFxApplicationThread()) {
                    Runnable doPaintComponent = new Runnable(){

                        @Override
                        public void run() {
                        }
                    };
                    Platform.runLater((Runnable)doPaintComponent);
                }
                if (!this.pageFlowEnding) {
                    this.pageFlowEnding = true;
                    this.isUpdateMemory = true;
                    this.memoryMessage = Messages.getMessage("PdfViewer.PageFlowNotEnoughMemory");
                } else {
                    this.isUpdateMemory = false;
                }
                return true;
            }
        }
        return false;
    }

    private void removeFurthestPages(int pagesToRemove) {
        int post;
        int pre;
        int max;
        int pagesRemoved = 0;
        int before = this.pageNumber - 1;
        int after = this.pageCount - this.pageNumber;
        int cursor = max = before > after ? before : after;
        while (pagesRemoved < pagesToRemove && cursor >= 40) {
            pre = this.pageNumber - cursor;
            if ((pre -= 1 - (pre & 1)) > 0 && this.pages[pre - 1] != null) {
                this.pages[pre - 1].dispose();
                ++pagesRemoved;
            }
            if (pagesRemoved == pagesToRemove) continue;
            post = this.pageNumber + cursor;
            if ((post -= 1 - (post & 1)) <= this.pageCount && this.pages[post - 1] != null) {
                this.pages[post - 1].dispose();
                ++pagesRemoved;
            }
            --cursor;
        }
        cursor = max;
        while (pagesRemoved < pagesToRemove && cursor >= 0) {
            pre = this.pageNumber - cursor;
            if (pre > 0 && this.pages[pre - 1] != null) {
                this.pages[pre - 1].dispose();
                ++pagesRemoved;
            }
            if (pagesRemoved == pagesToRemove) continue;
            post = this.pageNumber + cursor;
            if (post <= this.pageCount && this.pages[post - 1] != null) {
                this.pages[post - 1].dispose();
                ++pagesRemoved;
            }
            --cursor;
        }
    }

    private double getFullPageWidthOrHeight() {
        return this.newSceneHeight / 13.0 * 12.0;
    }

    private double getPageWidthOrHeight() {
        return this.newSceneHeight / (13.0 * this.scaling) * 12.0;
    }

    public PdfDecoderInt getPdfDecoderInt() {
        return this.pdf;
    }

    public DoubleProperty getPageNumber() {
        return this.pageNumberProperty;
    }

    private void setPageNumber(int pn) {
        this.pageNumberProperty.set((double)pn);
        this.pageNumber = pn;
    }

    public boolean isUpdateMemory() {
        return this.isUpdateMemory;
    }

    public String getMemoryMessage() {
        return this.memoryMessage;
    }

    private class ZoomBar
    extends Parent {
        private final Line zoomLine = new Line();
        private final Circle zoomCircle;
        private static final int distanceFromSide = 15;
        private boolean handlingMouse;

        ZoomBar() {
            this.zoomLine.setStrokeWidth(1.5);
            this.zoomLine.setStroke((Paint)Color.WHITESMOKE);
            this.zoomCircle = new Circle(5.0);
            this.zoomCircle.setStrokeWidth(2.0);
            this.zoomCircle.setStroke((Paint)Color.WHITE);
            this.zoomCircle.setFill((Paint)Color.GRAY);
            this.getChildren().addAll((Object[])new Node[]{this.zoomLine, this.zoomCircle});
        }

        public boolean isZoomBarHover(MouseEvent mouseEvent) {
            return mouseEvent.getX() < 30.0 && mouseEvent.getY() > this.getStartY() - 5.0 && mouseEvent.getY() < this.getEndY() + 5.0;
        }

        public boolean isZoomBarPress(MouseEvent mouseEvent) {
            if (mouseEvent.getX() < 30.0 && mouseEvent.getY() > this.getStartY() - 5.0 && mouseEvent.getY() < this.getEndY() + 5.0) {
                this.handlingMouse = true;
                this.isZoomBarDrag(mouseEvent);
                return true;
            }
            return false;
        }

        public boolean isZoomBarDrag(MouseEvent mouseEvent) {
            if (this.handlingMouse) {
                double y = mouseEvent.getY();
                double start = this.getStartY();
                double end = this.getEndY();
                if (y < start) {
                    y = start;
                }
                if (y > end) {
                    y = end;
                }
                if (y != this.zoomCircle.getCenterY()) {
                    this.zoomCircle.setCenterY(y);
                    double percent = (y - start) / (end - start);
                    PageFlowFX.this.scaling = 1.0 + percent;
                    for (Page page : PageFlowFX.this.pages) {
                        if (page == null) continue;
                        page.update();
                    }
                }
                return true;
            }
            return false;
        }

        public boolean isZoomBarRelease() {
            if (this.handlingMouse) {
                this.handlingMouse = false;
                return true;
            }
            return false;
        }

        public void update() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ZoomBar.this.zoomCircle.setCenterX(15.0);
                    ZoomBar.this.zoomLine.setStartX(15.5);
                    ZoomBar.this.zoomLine.setStartY(PageFlowFX.this.newSceneHeight * 0.2);
                    ZoomBar.this.zoomLine.setEndX(15.5);
                    ZoomBar.this.zoomLine.setEndY(PageFlowFX.this.newSceneHeight * 0.4);
                    double percent = 2.0 - PageFlowFX.this.scaling;
                    double start = ZoomBar.this.getStartY();
                    double end = ZoomBar.this.getEndY();
                    ZoomBar.this.zoomCircle.setCenterY(end - (end - start) * percent);
                }
            });
        }

        private double getStartY() {
            return PageFlowFX.this.newSceneHeight * 0.2;
        }

        private double getEndY() {
            return PageFlowFX.this.newSceneHeight * 0.4;
        }
    }

    private class NavBar
    extends Parent {
        private final Line navLine = new Line();
        private final Circle navCircle;
        private static final int distanceFromSides = 20;
        private static final int distanceFromBottom = 15;
        private boolean handlingMouse;

        NavBar() {
            this.navLine.setStrokeWidth(1.5);
            this.navLine.setStroke((Paint)Color.WHITE);
            this.navCircle = new Circle(5.0);
            this.navCircle.setStrokeWidth(2.0);
            this.navCircle.setStroke((Paint)Color.WHITE);
            this.navCircle.setFill((Paint)Color.GRAY);
            this.getChildren().addAll((Object[])new Node[]{this.navLine, this.navCircle});
        }

        public boolean isNavBarHover(MouseEvent mouseEvent) {
            return mouseEvent.getY() > PageFlowFX.this.newSceneHeight - 30.0;
        }

        public boolean isNavBarPress(MouseEvent mouseEvent) {
            if (mouseEvent.getY() > PageFlowFX.this.newSceneHeight - 30.0) {
                this.handlingMouse = true;
                return true;
            }
            return false;
        }

        public boolean isNavBarDrag(MouseEvent mouseEvent) {
            if (this.handlingMouse) {
                double x = mouseEvent.getX();
                if (x < 20.0) {
                    x = 20.0;
                }
                if (x > PageFlowFX.this.newSceneWidth - 20.0) {
                    x = PageFlowFX.this.newSceneWidth - 20.0;
                }
                if (x != this.navCircle.getCenterX()) {
                    this.navCircle.setCenterX(x);
                    double percent = (x - 20.0) / (PageFlowFX.this.newSceneWidth - 40.0);
                    PageFlowFX.this.pageFocus = (double)(PageFlowFX.this.pageCount - 1) * percent + 1.0;
                    int newPageNumber = (int)(PageFlowFX.this.pageFocus + 0.5);
                    if (PageFlowFX.this.pageNumber != newPageNumber) {
                        PageFlowFX.this.setPageNumber(newPageNumber);
                    }
                    PageFlowFX.this.addPages();
                    PageFlowFX.this.reorderPages(PageFlowFX.this.pageFocus, false);
                    for (Page page : PageFlowFX.this.pages) {
                        if (page == null) continue;
                        page.update();
                    }
                }
                return true;
            }
            return false;
        }

        public boolean isNavBarRelease(MouseEvent mouseEvent) {
            if (this.handlingMouse) {
                double x = mouseEvent.getX();
                if (x < 20.0) {
                    x = 20.0;
                }
                if (x > PageFlowFX.this.newSceneWidth - 20.0) {
                    x = PageFlowFX.this.newSceneWidth - 20.0;
                }
                double percent = (x - 20.0) / (PageFlowFX.this.newSceneWidth - 40.0);
                int newPageNumber = (int)((double)(PageFlowFX.this.pageCount - 1) * percent + 1.0 + 0.5);
                if (PageFlowFX.this.pageNumber != newPageNumber) {
                    PageFlowFX.this.setPageNumber(newPageNumber);
                }
                PageFlowFX.this.goTo(PageFlowFX.this.pageNumber);
                this.handlingMouse = false;
                return true;
            }
            return false;
        }

        public void update() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    NavBar.this.navCircle.setCenterY(PageFlowFX.this.newSceneHeight - 15.0);
                    NavBar.this.navLine.setStartX(20.0);
                    NavBar.this.navLine.setStartY(PageFlowFX.this.newSceneHeight - 15.0 + 0.5);
                    NavBar.this.navLine.setEndX(PageFlowFX.this.newSceneWidth - 20.0);
                    NavBar.this.navLine.setEndY(PageFlowFX.this.newSceneHeight - 15.0 + 0.5);
                    double percent = (PageFlowFX.this.pageFocus - 1.0) / (double)(PageFlowFX.this.pageCount - 1);
                    double x = 20.0 + (PageFlowFX.this.newSceneWidth - 40.0) * percent;
                    NavBar.this.navCircle.setCenterX(x);
                }
            });
        }
    }

    private class Page
    extends ImageView {
        private final Image lowResImage;
        private final int page;
        private final int rotation;
        private PerspectiveTransform trans;
        private ColorAdjust colorAdjust;
        private int mainTextureSize;
        private ImageView reflection;
        private PerspectiveTransform reflectionTransform;
        private double x;
        private double y;
        private double widthHeight;
        private double altWidthHeight;

        Page(int page) {
            this.rotation = PageFlowFX.this.displayRotation;
            this.page = page;
            this.lowResImage = PageFlowFX.this.getPageImage(page, this.rotation, 256);
            if (this.lowResImage == null) {
                this.dispose();
                this.widthHeight = 0.0;
                return;
            }
            this.setImage(this.lowResImage);
            this.setupMouseHandlers();
            if (PageFlowFX.this.enableReflection) {
                this.setupReflection();
            }
            this.colorAdjust = new ColorAdjust();
            if (PageFlowFX.this.enablePerspectiveTransform) {
                this.setupPerspectiveTransform();
            }
            this.setCache(true);
            this.setCacheHint(CacheHint.QUALITY);
            this.update();
        }

        public void setupReflection() {
            this.reflection = new ImageView();
            this.reflectionTransform = new PerspectiveTransform();
            this.reflectionTransform.setInput((Effect)new ColorAdjust(0.0, 0.0, -0.75, 0.0));
            this.reflection.setEffect((Effect)this.reflectionTransform);
            this.reflection.setImage(this.lowResImage);
        }

        public void disposeReflection() {
            this.reflection = null;
            this.reflectionTransform = null;
        }

        public void setupPerspectiveTransform() {
            this.trans = new PerspectiveTransform();
            this.trans.setInput((Effect)this.colorAdjust);
            this.setEffect((Effect)this.trans);
        }

        public void disposePerspectiveTransform() {
            this.trans = null;
            this.setEffect(null);
        }

        private void setupMouseHandlers() {
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    PageFlowFX.this.pageClickEvent = true;
                }
            });
            this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    PageFlowFX.this.pageClickEvent = false;
                }
            });
            this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    if (PageFlowFX.this.pageClickEvent) {
                        PageFlowFX.this.goTo(Page.this.page);
                    }
                }
            });
        }

        public void update() {
            this.widthHeight = PageFlowFX.this.getPageWidthOrHeight();
            this.y = -this.widthHeight / 40.0;
            double diff = (double)this.page - PageFlowFX.this.pageFocus;
            if (diff > 1.0) {
                diff = (diff - 1.0) / 5.0 + 1.0;
            } else if (diff < -1.0) {
                diff = (diff + 1.0) / 5.0 - 1.0;
            }
            this.x = diff * this.widthHeight;
            this.redraw();
        }

        private void redraw() {
            boolean update;
            boolean bl = update = !PageFlowFX.this.enablePerspectiveTransform || this.trans != null && (this.getRealX(this.x) + this.widthHeight > 0.0 && this.getRealX(this.x) < PageFlowFX.this.newSceneWidth || this.trans.getUrx() > 0.0 && this.trans.getUlx() < PageFlowFX.this.newSceneWidth);
            if (update) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        double diff = (double)Page.this.page - PageFlowFX.this.pageFocus;
                        double ddiff = Math.abs(diff);
                        if (ddiff > 1.0) {
                            ddiff = (ddiff - 1.0) / (double)(PageFlowFX.this.enablePerspectiveTransform ? 16 : 8) + 1.0;
                        }
                        double distanceScale = Math.pow(0.7, ddiff);
                        if (diff > 1.0) {
                            diff = 1.0;
                        }
                        if (diff < -1.0) {
                            diff = -1.0;
                        }
                        boolean rightSide = diff > 0.0;
                        if ((diff = Math.abs(diff)) == 0.0) {
                            Page.this.setEffect(null);
                        } else if (PageFlowFX.this.enablePerspectiveTransform) {
                            Page.this.setEffect((Effect)Page.this.trans);
                        }
                        Page.this.colorAdjust.setBrightness(-diff / 2.0);
                        double halfWidthHeight = Page.this.widthHeight / 2.0;
                        double halfDiff = diff / 2.0;
                        if (!PageFlowFX.this.enablePerspectiveTransform) {
                            halfDiff /= 8.0;
                        }
                        double quarterDiff = diff / 4.0;
                        double lx = Page.this.getRealX(halfWidthHeight + Page.this.x - (1.0 - halfDiff) * halfWidthHeight * distanceScale);
                        double rx = Page.this.getRealX(halfWidthHeight + Page.this.x + (1.0 - halfDiff) * halfWidthHeight * distanceScale);
                        if (PageFlowFX.this.enablePerspectiveTransform) {
                            Page.this.trans.setLlx(lx);
                            Page.this.trans.setUlx(lx);
                            Page.this.trans.setLrx(rx);
                            Page.this.trans.setUrx(rx);
                            if (rightSide) {
                                Page.this.trans.setLly(Page.this.getRealY(halfWidthHeight + Page.this.y + (1.0 - quarterDiff) * halfWidthHeight * distanceScale));
                                Page.this.trans.setUly(Page.this.getRealY(halfWidthHeight + Page.this.y - (1.0 - quarterDiff) * halfWidthHeight * distanceScale));
                                Page.this.trans.setLry(Page.this.getRealY(halfWidthHeight + Page.this.y + halfWidthHeight * distanceScale));
                                Page.this.trans.setUry(Page.this.getRealY(halfWidthHeight + Page.this.y - halfWidthHeight * distanceScale));
                            } else {
                                Page.this.trans.setLry(Page.this.getRealY(halfWidthHeight + Page.this.y + (1.0 - quarterDiff) * halfWidthHeight * distanceScale));
                                Page.this.trans.setUry(Page.this.getRealY(halfWidthHeight + Page.this.y - (1.0 - quarterDiff) * halfWidthHeight * distanceScale));
                                Page.this.trans.setLly(Page.this.getRealY(halfWidthHeight + Page.this.y + halfWidthHeight * distanceScale));
                                Page.this.trans.setUly(Page.this.getRealY(halfWidthHeight + Page.this.y - halfWidthHeight * distanceScale));
                            }
                        }
                        if (PageFlowFX.this.enableReflection) {
                            Page.this.reflectionTransform.setLlx(lx);
                            Page.this.reflectionTransform.setUlx(lx);
                            Page.this.reflectionTransform.setLrx(rx);
                            Page.this.reflectionTransform.setUrx(rx);
                            Page.this.reflectionTransform.setLly(Page.this.trans.getLly());
                            Page.this.reflectionTransform.setLry(Page.this.trans.getLry());
                            Page.this.reflectionTransform.setUly(Page.this.trans.getLly() + (Page.this.trans.getLly() - Page.this.trans.getUly()));
                            Page.this.reflectionTransform.setUry(Page.this.trans.getLry() + (Page.this.trans.getLry() - Page.this.trans.getUry()));
                        }
                        if (!PageFlowFX.this.enablePerspectiveTransform) {
                            Page.this.altWidthHeight = rx - lx;
                            if (diff == 0.0) {
                                Page.this.setFitWidth((int)Page.this.altWidthHeight);
                                Page.this.setFitHeight((int)Page.this.altWidthHeight);
                            } else {
                                Page.this.setFitWidth(Page.this.altWidthHeight);
                                Page.this.setFitHeight(Page.this.altWidthHeight);
                            }
                        } else if (diff == 0.0) {
                            Page.this.setFitWidth((int)Page.this.widthHeight);
                            Page.this.setFitHeight((int)Page.this.widthHeight);
                        } else {
                            Page.this.setFitWidth(Page.this.widthHeight);
                            Page.this.setFitHeight(Page.this.widthHeight);
                        }
                        if (diff == 0.0) {
                            Page.this.setX((int)Page.this.getRealX(Page.this.x));
                            Page.this.setY((int)Page.this.getRealY(Page.this.y));
                        } else {
                            Page.this.setX(Page.this.getRealX(Page.this.x));
                            Page.this.setY(Page.this.getRealY(Page.this.y));
                        }
                    }
                });
            }
        }

        public void setMain(boolean isMain) {
            if (isMain) {
                Thread t = new Thread("FX-setMain"){

                    @Override
                    public void run() {
                        if (PageFlowFX.this.checkMemory()) {
                            return;
                        }
                        Page.this.mainTextureSize = (int)PageFlowFX.this.getFullPageWidthOrHeight();
                        final Image img = PageFlowFX.this.getPageImage(Page.this.page, Page.this.rotation, Page.this.mainTextureSize);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (img != null) {
                                    Page.this.setImage(img);
                                }
                            }
                        });
                    }
                };
                t.setDaemon(true);
                t.start();
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Page.this.setImage(Page.this.lowResImage);
                    }
                });
            }
        }

        private ImageView getReflection() {
            return this.reflection;
        }

        private double getRealX(double x) {
            return PageFlowFX.this.sceneXOffset + this.getXOffset() + x;
        }

        private double getRealY(double y) {
            return PageFlowFX.this.sceneYOffset + this.getYOffset() + y;
        }

        private double getXOffset() {
            if (PageFlowFX.this.enablePerspectiveTransform) {
                return -this.widthHeight / 2.0;
            }
            return -this.altWidthHeight / 2.0;
        }

        private double getYOffset() {
            if (PageFlowFX.this.enablePerspectiveTransform) {
                return -this.widthHeight / 2.0;
            }
            return -this.altWidthHeight / 2.0;
        }

        public void dispose() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Page.this.setImage(null);
                }
            });
            PageFlowFX.this.pagesInMemory--;
            ((PageFlowFX)PageFlowFX.this).pages[this.page - 1] = null;
        }
    }
}

