/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display.javafx;

import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Transform;
import org.jpedal.PdfDecoderFX;
import org.jpedal.display.Display;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.commands.javafx.JavaFXPreferences;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.FXDisplay;
import org.jpedal.text.TextLines;

public class SingleDisplayFX
extends GUIDisplay
implements Display {
    final PdfDecoderFX pdf;
    private int[] cursorBoxOnScreen;
    Rectangle cursorRect;
    final Pane cursorBoxPane = new Pane();

    public SingleDisplayFX(int pageNumber, DynamicVectorRenderer currentDisplay, PdfDecoderFX pdf, DecoderOptions options) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.pageNumber = pageNumber;
        this.currentDisplay = currentDisplay;
        this.pdf = pdf;
        this.options = options;
        this.displayOffsets = pdf.getDisplayOffsets();
        this.pageData = pdf.getPdfPageData();
    }

    public SingleDisplayFX(PdfDecoderFX pdf, DecoderOptions options) {
        this.pdf = pdf;
        this.options = options;
        this.displayOffsets = pdf.getDisplayOffsets();
        this.pageData = pdf.getPdfPageData();
    }

    @Override
    public void refreshDisplay() {
        if (Platform.isFxApplicationThread()) {
            if (this.displayScalingDbl != null) {
                this.pdf.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)this.displayScalingDbl[0], (double)this.displayScalingDbl[1], (double)this.displayScalingDbl[2], (double)this.displayScalingDbl[3], (double)this.displayScalingDbl[4], (double)this.displayScalingDbl[5])});
            }
            if (this.currentDisplay != null) {
                this.paintPage(this.pdf.highlightsPane, this.pdf.getFormRenderer(), null);
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SingleDisplayFX.this.displayScalingDbl != null) {
                        SingleDisplayFX.this.pdf.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)SingleDisplayFX.this.displayScalingDbl[0], (double)SingleDisplayFX.this.displayScalingDbl[1], (double)SingleDisplayFX.this.displayScalingDbl[2], (double)SingleDisplayFX.this.displayScalingDbl[3], (double)SingleDisplayFX.this.displayScalingDbl[4], (double)SingleDisplayFX.this.displayScalingDbl[5])});
                    }
                    if (SingleDisplayFX.this.currentDisplay != null) {
                        SingleDisplayFX.this.paintPage(SingleDisplayFX.this.pdf.highlightsPane, SingleDisplayFX.this.pdf.getFormRenderer(), null);
                    }
                }
            });
        }
    }

    @Override
    public void setPageRotation(int newRotation) {
        super.setPageRotation(newRotation);
        this.refreshDisplay();
    }

    static Path getBorder(int crw, int crh) {
        Path border = new Path();
        border.getElements().add((Object)new MoveTo(-1.0, -1.0));
        border.getElements().add((Object)new LineTo((double)(crw + 2), -1.0));
        border.getElements().add((Object)new LineTo((double)(crw + 2), (double)(crh + 2)));
        border.getElements().add((Object)new LineTo(-1.0, (double)(crh + 2)));
        border.getElements().add((Object)new ClosePath());
        border.setStroke((Paint)Color.rgb((int)0, (int)0, (int)0));
        return border;
    }

    @Override
    public void disableScreen() {
        if (this.currentDisplay != null) {
            Group FXpane = ((FXDisplay)this.currentDisplay).getFXPane();
            if (this.pdf.getChildren().contains((Object)FXpane)) {
                int count = this.pdf.getChildren().size();
                for (int i = 0; i < count; ++i) {
                    this.pdf.getChildren().remove(0);
                }
            }
        }
    }

    @Override
    public void paintPage(Pane box, AcroRenderer formRenderer, TextLines textLines) {
        boolean debugPane = false;
        Group fxPane = ((FXDisplay)this.currentDisplay).getFXPane();
        String pageNumberStr = String.valueOf(this.pageNumber);
        Rectangle clip = new Rectangle((double)this.crx, (double)this.cry, (double)this.crw, (double)this.crh);
        clip.setFill((Paint)Color.WHITE);
        if (box != null && box.getParent() != null) {
            ((Group)box.getParent()).getChildren().remove((Object)box);
        }
        fxPane.getChildren().addAll((Object[])new Node[]{box});
        this.pdf.setPrefSize(this.crw, this.crh);
        if (this.displayView == 1) {
            this.pdf.getChildren().clear();
            if (formRenderer.isXFA()) {
                Path border = SingleDisplayFX.getBorder(this.crw, this.crh);
                border.setFill((Paint)Color.WHITE);
                this.pdf.getChildren().addAll((Object[])new Node[]{border});
                border.setLayoutX((double)this.crx);
                border.setLayoutY((double)this.cry);
            }
            if (!this.pdf.getChildren().contains((Object)fxPane)) {
                this.pdf.getChildren().addAll((Object[])new Node[]{fxPane});
            }
            fxPane.setLayoutX((double)(-this.crx));
            fxPane.setLayoutY((double)(-this.cry));
        } else {
            Node pagePath = null;
            for (Node child : this.pdf.getChildren()) {
                if (child.getId() == null || !child.getId().equals(pageNumberStr) || !(child instanceof Path)) continue;
                pagePath = child;
            }
            if (pagePath != null) {
                this.pdf.getChildren().remove(pagePath);
            }
            fxPane.setId(pageNumberStr);
            if (!this.pdf.getChildren().contains((Object)fxPane)) {
                this.pdf.getChildren().addAll((Object[])new Node[]{fxPane});
            }
            int[] xReached = this.multiDisplayOptions.getxReached();
            int[] yReached = this.multiDisplayOptions.getyReached();
            int j = this.pageNumber;
            int cx = (int)((float)xReached[j] / this.scaling);
            int cy = (int)((float)yReached[j] / this.scaling);
            if (this.displayView == 3) {
                cx = this.currentOffset.getWidestPageR() - cx;
            }
            fxPane.setLayoutX((double)(-cx));
            fxPane.setLayoutY(this.pdf.getHeight() - (double)cy);
        }
        clip.setFill((Paint)Color.WHITE);
        fxPane.setClip((Node)clip);
        this.addForms(formRenderer);
    }

    private void addForms(AcroRenderer formRenderer) {
        int start = this.pageNumber;
        int end = this.pageNumber;
        if (this.displayView != 1) {
            start = this.getStartPage();
            end = this.getEndPage();
            if (start == 0 || end == 0 || this.lastEnd != end || this.lastStart != start) {
                this.lastFormPage = -1;
            }
            this.lastEnd = end;
            this.lastStart = start;
        }
        if (this.lastFormPage != this.pageNumber && formRenderer != null) {
            formRenderer.displayComponentsOnscreen(start, end);
            if (formRenderer.getCompData().hasformsOnPageDecoded(this.pageNumber)) {
                this.lastFormPage = this.pageNumber;
            }
        }
        if (formRenderer != null && this.currentOffset != null) {
            formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.indent, this.displayOffsets.getUserOffsetX(), this.displayOffsets.getUserOffsetY(), this.displayView, this.currentOffset.getWidestPageNR(), this.currentOffset.getWidestPageR());
            formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.indent);
        }
    }

    @Override
    public void init(float scaling, int displayRotation, int pageNumber, DynamicVectorRenderer currentDisplay, boolean isInit) {
        this.pageData = this.pdf.getPdfPageData();
        super.init(scaling, displayRotation, pageNumber, currentDisplay, isInit);
        this.setPageSize(pageNumber, scaling);
        this.lastFormPage = -1;
    }

    @Override
    public void setPageSize(int pageNumber, float scaling) {
        this.pageData.setScalingValue(scaling);
        this.topW = this.pageData.getCropBoxWidth(pageNumber);
        this.topH = this.pageData.getCropBoxHeight(pageNumber);
        double mediaH = this.pageData.getMediaBoxHeight(pageNumber);
        this.cropX = this.pageData.getCropBoxX(pageNumber);
        this.cropY = this.pageData.getCropBoxY(pageNumber);
        this.cropW = this.topW;
        this.cropH = this.topH;
        if (this.displayView == 1) {
            this.crx = (int)((double)this.insetW + this.cropX);
            this.cry = (int)((double)this.insetH - this.cropY);
        } else {
            this.crx = this.insetW;
            this.cry = this.insetH;
        }
        int offsetY = (int)(mediaH - this.cropH);
        if (!this.pageData.getMediaValue(pageNumber).isEmpty()) {
            offsetY -= this.pageData.getMediaBoxHeight(pageNumber) - (int)(this.cropY + this.cropH) - this.pageData.getCropBoxY(pageNumber);
        }
        this.crw = (int)this.cropW;
        this.crh = (int)this.cropH;
        this.cry += offsetY;
    }

    @Override
    public int[] getCursorBoxOnScreenAsArray() {
        return this.cursorBoxOnScreen;
    }

    @Override
    public void updateCursorBoxOnScreen(int[] newOutlineRectangle, int outlineColor, int pageNumber, int x_size, int y_size) {
        if (this.displayView != 1 && this.getPageSize(this.displayView)[0] == 0 && this.getPageSize(this.displayView)[1] == 0) {
            return;
        }
        if (newOutlineRectangle != null) {
            int x = newOutlineRectangle[0];
            int y = newOutlineRectangle[1];
            int w = newOutlineRectangle[2];
            int h = newOutlineRectangle[3];
            int cropX = this.pageData.getCropBoxX(pageNumber);
            int cropY = this.pageData.getCropBoxY(pageNumber);
            this.cursorBoxOnScreen = new int[]{x -= cropX, y -= cropY, w, h};
            if (DecoderOptions.showMouseBox) {
                this.cursorRect = new Rectangle((double)x, (double)y, (double)w, (double)h);
                this.cursorRect.setStroke((Paint)JavaFXPreferences.shiftColorSpaceToFX(outlineColor));
                this.cursorRect.setFill((Paint)Color.TRANSPARENT);
                if (this.pdf.getChildren().contains((Object)this.cursorBoxPane)) {
                    this.cursorBoxPane.getChildren().clear();
                    this.cursorBoxPane.getChildren().add((Object)this.cursorRect);
                    this.pdf.getChildren().remove((Object)this.cursorBoxPane);
                }
                this.pdf.getChildren().add((Object)this.cursorBoxPane);
            }
        } else {
            this.cursorBoxOnScreen = null;
            if (this.pdf.getChildren().contains((Object)this.cursorBoxPane)) {
                this.cursorBoxPane.getChildren().clear();
                this.pdf.getChildren().remove((Object)this.cursorBoxPane);
            }
        }
    }

    @Override
    public java.awt.Rectangle getDisplayedRectangle() {
        ScrollPane customFXHandle = ((JavaFxGUI)this.pdf.getExternalHandler(4)).getPageContainer();
        if (customFXHandle == null) {
            return new java.awt.Rectangle(0, 0, 0, 0);
        }
        Bounds bounds = customFXHandle.getViewportBounds();
        return this.getDisplayedRectangle(true, new java.awt.Rectangle((int)bounds.getMinX(), (int)(-bounds.getMinY()), (int)bounds.getWidth(), (int)bounds.getHeight()));
    }
}

