/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.MouseMode;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.AutoScroll;
import org.jpedal.examples.viewer.commands.Bookmark;
import org.jpedal.examples.viewer.commands.Buy;
import org.jpedal.examples.viewer.commands.Cascade;
import org.jpedal.examples.viewer.commands.ChangeLineArt;
import org.jpedal.examples.viewer.commands.Copy;
import org.jpedal.examples.viewer.commands.CurrentPage;
import org.jpedal.examples.viewer.commands.DeSelectAll;
import org.jpedal.examples.viewer.commands.DocInfo;
import org.jpedal.examples.viewer.commands.Exit;
import org.jpedal.examples.viewer.commands.ExtractSelectionAsImage;
import org.jpedal.examples.viewer.commands.Find;
import org.jpedal.examples.viewer.commands.FullScreen;
import org.jpedal.examples.viewer.commands.Help;
import org.jpedal.examples.viewer.commands.Highlight;
import org.jpedal.examples.viewer.commands.Info;
import org.jpedal.examples.viewer.commands.MouseModeCommand;
import org.jpedal.examples.viewer.commands.NavigateDocuments;
import org.jpedal.examples.viewer.commands.NextResults;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.commands.PageCount;
import org.jpedal.examples.viewer.commands.PageGrouping;
import org.jpedal.examples.viewer.commands.PageNavigator;
import org.jpedal.examples.viewer.commands.PanMode;
import org.jpedal.examples.viewer.commands.Pdf;
import org.jpedal.examples.viewer.commands.Preferences;
import org.jpedal.examples.viewer.commands.PreviousResult;
import org.jpedal.examples.viewer.commands.Quality;
import org.jpedal.examples.viewer.commands.RSSyndication;
import org.jpedal.examples.viewer.commands.ReplaceTextColor;
import org.jpedal.examples.viewer.commands.Rotate;
import org.jpedal.examples.viewer.commands.Rotation;
import org.jpedal.examples.viewer.commands.SaveFile;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.commands.Scaling;
import org.jpedal.examples.viewer.commands.Scroll;
import org.jpedal.examples.viewer.commands.SelectAll;
import org.jpedal.examples.viewer.commands.SetDisplayBackground;
import org.jpedal.examples.viewer.commands.SetPageColor;
import org.jpedal.examples.viewer.commands.SetReplacementThreshold;
import org.jpedal.examples.viewer.commands.SetTextColor;
import org.jpedal.examples.viewer.commands.SetUndrawnPageColor;
import org.jpedal.examples.viewer.commands.TextSelect;
import org.jpedal.examples.viewer.commands.Tile;
import org.jpedal.examples.viewer.commands.Tip;
import org.jpedal.examples.viewer.commands.UpdateGUILayout;
import org.jpedal.examples.viewer.commands.ViewStack;
import org.jpedal.examples.viewer.commands.VisitWebsite;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.generic.GUISearchList;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PrinterInt;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalActionHandler;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Commands {
    protected final ViewStack viewStack = new ViewStack();
    public boolean extractingAsImage;
    public static final int ABOUT = 1;
    public static final int BITMAP = 2;
    public static final int IMAGES = 3;
    public static final int TEXT = 4;
    public static final int SAVE = 5;
    public static final int PRINT = 6;
    public static final int EXIT = 7;
    public static final int AUTOSCROLL = 8;
    public static final int DOCINFO = 9;
    public static final int OPENFILE = 10;
    public static final int BOOKMARK = 11;
    public static final int FIND = 12;
    public static final int SNAPSHOT = 13;
    public static final int OPENURL = 14;
    public static final int VISITWEBSITE = 15;
    public static final int PREVIOUSDOCUMENT = 16;
    public static final int NEXTDOCUMENT = 17;
    public static final int PREVIOUSRESULT = 18;
    public static final int NEXTRESULT = 19;
    public static final int TIP = 20;
    public static final int CASCADE = 21;
    public static final int TILE = 22;
    public static final int PREFERENCES = 24;
    public static final int COPY = 25;
    public static final int SELECTALL = 26;
    public static final int DESELECTALL = 27;
    public static final int UPDATEGUILAYOUT = 28;
    public static final int MOUSEMODE = 29;
    public static final int PANMODE = 30;
    public static final int TEXTSELECT = 31;
    public static final int SEPARATECOVER = 32;
    public static final int EXTRACTTEXT = 33;
    public static final int EXTRACTASIMAGE = 34;
    public static final int FIRSTPAGE = 50;
    public static final int FBACKPAGE = 51;
    public static final int BACKPAGE = 52;
    public static final int FORWARDPAGE = 53;
    public static final int FFORWARDPAGE = 54;
    public static final int LASTPAGE = 55;
    public static final int GOTO = 56;
    public static final int SINGLE = 57;
    public static final int CONTINUOUS = 58;
    public static final int CONTINUOUS_FACING = 59;
    public static final int FACING = 60;
    public static final int PAGEFLOW = 61;
    public static final int FULLSCREEN = 62;
    public static final int QUALITY = 250;
    public static final int ROTATION = 251;
    public static final int SCALING = 252;
    public static final int CURRENTMENU = 300;
    public static final int CROP = 301;
    public static final int PAGETOOLSMENU = 303;
    public static final int CONTENTMENU = 304;
    public static final int ONEPERPAGE = 305;
    public static final int PDFMENU = 306;
    public static final int EXPORTMENU = 307;
    public static final int WINDOWMENU = 308;
    public static final int PAGELAYOUTMENU = 309;
    public static final int EDITMENU = 310;
    public static final int GOTOMENU = 311;
    public static final int VIEWMENU = 312;
    public static final int RESAVEASFORM = 315;
    public static final int OPENMENU = 316;
    public static final int FILEMENU = 317;
    public static final int SAVEFORM = 500;
    public static final int PDF = 501;
    public static final int ROTATE = 502;
    public static final int DELETE = 503;
    public static final int ADD = 504;
    public static final int SECURITY = 505;
    public static final int ADDHEADERFOOTER = 506;
    public static final int STAMPTEXT = 507;
    public static final int STAMPIMAGE = 508;
    public static final int SETCROP = 509;
    public static final int NUP = 510;
    public static final int HANDOUTS = 511;
    public static final int SIGN = 512;
    public static final int HIGHLIGHT = 600;
    public static final int SCROLL = 601;
    public static final int ADDVIEW = 700;
    public static final int FORWARD = 701;
    public static final int BACK = 702;
    public static final int PAGECOUNT = 703;
    public static final int CURRENTPAGE = 704;
    public static final int GETOUTLINEPANEL = 705;
    public static final int GETTHUMBNAILPANEL = 706;
    public static final int GETPAGECOUNTER = 707;
    public static final int PAGEGROUPING = 708;
    public static final int SETPAGECOLOR = 709;
    public static final int SETUNDRAWNPAGECOLOR = 710;
    public static final int REPLACETEXTCOLOR = 711;
    public static final int SETTEXTCOLOR = 712;
    public static final int CHANGELINEART = 713;
    public static final int SETDISPLAYBACKGROUND = 714;
    public static final int SETREPLACEMENTCOLORTHRESHOLD = 715;
    public static final int GETPDFNAME = 716;
    public static final int RSS = 997;
    public static final int HELP = 998;
    public static final int BUY = 999;
    public static final Integer FIRST_DOCUMENT_SEARCH_RESULT_NOW_SHOWN = 1;
    public static final Integer SEARCH_RETURNED_TO_START = 2;
    public static final Integer SEARCH_NOT_FOUND = 3;
    protected final Values commonValues;
    protected final GUIFactory currentGUI;
    protected PdfDecoderInt decode_pdf;
    protected final GUIThumbnailPanel thumbnails;
    protected final PropertiesFile properties;
    protected final GUISearchWindow searchFrame;
    protected final PrinterInt currentPrinter;
    protected final MouseMode mouseMode = new MouseMode();

    public Commands(Values commonValues, GUIFactory currentGUI, PdfDecoderInt decode_pdf, GUIThumbnailPanel thumbnails, PropertiesFile properties, GUISearchWindow searchFrame, PrinterInt currentPrinter) {
        this.commonValues = commonValues;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
        this.thumbnails = thumbnails;
        this.properties = properties;
        this.currentPrinter = currentPrinter;
        this.searchFrame = searchFrame;
    }

    private Object executeMenuBarCommands(int ID2, Object[] args) {
        Object status = null;
        switch (ID2) {
            case 1: {
                Info.execute(args, this.currentGUI);
                break;
            }
            case 5: {
                SaveFile.execute(args, this.currentGUI, this.commonValues);
                break;
            }
            case 7: {
                Exit.execute(args, this.thumbnails, this.currentGUI, this.commonValues, this.decode_pdf, this.properties);
                break;
            }
            case 8: {
                AutoScroll.execute(args, this.currentGUI);
                break;
            }
            case 9: {
                DocInfo.execute(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 10: {
                OpenFile.executeOpenFile(args, this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
                break;
            }
            case 11: {
                Bookmark.execute(args, this.currentGUI, this.decode_pdf);
                break;
            }
            case 12: {
                Find.execute(args, this.commonValues, this.currentGUI, this.decode_pdf, this.searchFrame);
                break;
            }
            case 14: {
                OpenFile.executeOpenURL(args, this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
                break;
            }
            case 15: {
                VisitWebsite.execute(args, this.currentGUI);
                break;
            }
            case 16: {
                NavigateDocuments.executePrevDoc(args, this.currentGUI, this.commonValues, this.searchFrame, this.decode_pdf, this.properties, this.thumbnails);
                break;
            }
            case 17: {
                NavigateDocuments.executeNextDoc(args, this.currentGUI, this.commonValues, this.searchFrame, this.decode_pdf, this.properties, this.thumbnails);
                break;
            }
            case 18: {
                status = PreviousResult.execute(args, this.commonValues, this.currentGUI, this.decode_pdf, this.searchFrame);
                break;
            }
            case 19: {
                status = NextResults.execute(args, this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf);
                break;
            }
            case 20: {
                Tip.execute(args, this.currentGUI, this.properties);
                break;
            }
            case 21: {
                Cascade.execute(args, this.currentGUI);
                break;
            }
            case 22: {
                Tile.execute(args, this.currentGUI);
                break;
            }
            case 24: {
                Preferences.execute(args, this.currentGUI);
                break;
            }
            case 25: {
                Copy.execute(this.currentGUI, this.decode_pdf, this.commonValues);
                break;
            }
            case 26: {
                SelectAll.execute(this.currentGUI, this.decode_pdf, this.commonValues);
                break;
            }
            case 27: {
                DeSelectAll.execute(this.currentGUI, this.decode_pdf);
                break;
            }
            case 28: {
                UpdateGUILayout.execute(args, this.currentGUI);
                break;
            }
            case 29: {
                MouseModeCommand.execute(args, this.currentGUI, this.mouseMode, this.decode_pdf);
                break;
            }
            case 30: {
                PanMode.execute(args, this.currentGUI, this.mouseMode, this.decode_pdf);
                break;
            }
            case 31: {
                TextSelect.execute(args, this.currentGUI, this.mouseMode);
                break;
            }
            case 34: {
                ExtractSelectionAsImage.execute(this.commonValues, this.currentGUI, this.decode_pdf);
            }
        }
        return status;
    }

    private void executeDisplayCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 50: {
                PageNavigator.goFirstPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 51: {
                PageNavigator.goFBackPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 52: {
                PageNavigator.goBackPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 53: {
                PageNavigator.goForwardPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 54: {
                PageNavigator.goFForwardPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 55: {
                PageNavigator.goLastPage(args, this.commonValues, this.decode_pdf, this.currentGUI);
                break;
            }
            case 56: {
                PageNavigator.goPage(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 62: {
                FullScreen.execute(args, this.currentGUI, this.thumbnails, this.commonValues, this.decode_pdf, this.properties);
            }
        }
    }

    private void executeDemoVersionCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 998: {
                Help.execute(args, this.currentGUI);
                break;
            }
            case 999: {
                Buy.execute(args, this.currentGUI);
                break;
            }
            case 997: {
                RSSyndication.execute(args, this.currentGUI);
            }
        }
    }

    private void executeComboCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 250: {
                Quality.execute(args, this.currentGUI, this.commonValues, this.decode_pdf);
                break;
            }
            case 252: {
                Scaling.execute(args, this.commonValues, this.decode_pdf, this.currentGUI, this.viewStack);
                break;
            }
            case 251: {
                Rotation.execute(args, this.currentGUI, this.commonValues);
            }
        }
    }

    private void executeExternalCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 500: {
                SaveForm.execute(args, this.currentGUI, this.decode_pdf, this.commonValues);
                break;
            }
            case 501: {
                Pdf.execute(args, this.commonValues, this.currentGUI, this.decode_pdf);
                break;
            }
            case 502: {
                Rotate.execute(args, this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
            }
        }
    }

    private void executePageCommands(int ID2, Object[] args) {
        switch (ID2) {
            case 600: {
                Highlight.execute(args, this.decode_pdf);
                break;
            }
            case 601: {
                Scroll.execute(args, this.commonValues, this.decode_pdf);
            }
        }
    }

    private Object executeViewerFunctionalityCommands(int ID2, Object[] args) {
        Object status = null;
        switch (ID2) {
            case 700: {
                this.viewStack.add((Integer)args[0], (Rectangle)args[1], (Integer)args[2]);
                break;
            }
            case 701: {
                if (this.viewStack.forward() == null) break;
                this.decode_pdf.getFormRenderer().getActionHandler().changeTo(null, this.viewStack.forward().getPage(), this.viewStack.forward().getLocation(), this.viewStack.forward().getType(), false);
                break;
            }
            case 702: {
                if (this.viewStack.back() == null) break;
                this.decode_pdf.getFormRenderer().getActionHandler().changeTo(null, this.viewStack.back().getPage(), this.viewStack.back().getLocation(), this.viewStack.back().getType(), false);
                break;
            }
            case 703: {
                status = PageCount.execute(this.decode_pdf);
                break;
            }
            case 704: {
                status = CurrentPage.execute(this.decode_pdf, this.currentGUI);
                break;
            }
            case 705: {
                this.currentGUI.setBookmarks(true);
                status = this.currentGUI.getOutlinePanel();
                break;
            }
            case 706: {
                this.currentGUI.setBookmarks(true);
                status = this.currentGUI.getThumbnailPanel();
                break;
            }
            case 707: {
                status = this.currentGUI.getPageCounter(GUI.PageCounter.PAGECOUNTER2);
                break;
            }
            case 708: {
                status = PageGrouping.execute(args, this.decode_pdf);
                break;
            }
            case 709: {
                SetPageColor.execute(args, this.decode_pdf);
                break;
            }
            case 710: {
                SetUndrawnPageColor.execute(args, this.decode_pdf);
                break;
            }
            case 711: {
                ReplaceTextColor.execute(args, this.decode_pdf);
                break;
            }
            case 712: {
                SetTextColor.execute(args, this.decode_pdf);
                break;
            }
            case 713: {
                ChangeLineArt.execute(args, this.decode_pdf);
                break;
            }
            case 714: {
                SetDisplayBackground.execute(args, this.decode_pdf);
                break;
            }
            case 715: {
                SetReplacementThreshold.execute(args, this.decode_pdf);
                break;
            }
            case 716: {
                status = this.decode_pdf.getFileName();
            }
        }
        return status;
    }

    public Object executeCommand(int ID2, Object[] args) {
        JPedalActionHandler jpedalAction;
        if (args != null && args.length == 1 && args[0] == null) {
            args = null;
        }
        Object status = null;
        this.currentGUI.setExecutingCommand(true);
        Map jpedalActionHandlers = (Map)this.decode_pdf.getExternalHandler(24);
        if (jpedalActionHandlers != null && (jpedalAction = (JPedalActionHandler)jpedalActionHandlers.get(ID2)) != null) {
            jpedalAction.actionPerformed(this.currentGUI, this);
            return null;
        }
        if (!Viewer.isFX()) {
            if (ID2 < 50) {
                status = this.executeMenuBarCommands(ID2, args);
            } else if (ID2 < 250) {
                this.executeDisplayCommands(ID2, args);
            } else if (ID2 < 300) {
                this.executeComboCommands(ID2, args);
            } else if (ID2 >= 500) {
                if (ID2 < 600) {
                    this.executeExternalCommands(ID2, args);
                } else if (ID2 < 700) {
                    this.executePageCommands(ID2, args);
                } else if (ID2 < 997) {
                    status = this.executeViewerFunctionalityCommands(ID2, args);
                } else if (ID2 < 1000) {
                    this.executeDemoVersionCommands(ID2, args);
                }
            }
        }
        if (!this.currentGUI.isCommandInThread()) {
            this.currentGUI.setExecutingCommand(false);
        }
        return status;
    }

    protected void openTransferedFile() throws PdfException {
        if (this.currentGUI.isSingle()) {
            this.decode_pdf.flushObjectValues(true);
        }
        this.decode_pdf.resetViewableArea();
        OpenFile.openFile(this.commonValues.getSelectedFile(), this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
    }

    public void handleTransferedFile(String file) throws PdfException {
        while (Values.getOpeningTransferedFile() || Values.isProcessing()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Values.setOpeningTransferedFile(true);
        boolean isURL = file.startsWith("http:") || file.startsWith("file:");
        try {
            if (!isURL) {
                this.commonValues.setFileIsURL(false);
                this.commonValues.setFileSize(new File(file).length() >> 10);
            } else {
                this.commonValues.setFileIsURL(true);
            }
            this.commonValues.setSelectedFile(file);
            this.currentGUI.setViewerTitle(null);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " getting paths");
        }
        File testFile = new File(this.commonValues.getSelectedFile());
        if (!isURL && !testFile.exists()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + this.commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (this.commonValues.getSelectedFile() != null && !Values.isProcessing()) {
            this.openTransferedFile();
            if (this.commonValues.isPDF()) {
                Values.setOpeningTransferedFile(false);
            }
        }
    }

    public void recentDocumentsOption() {
        this.currentGUI.setRecentDocument();
        String[] recentDocs = this.properties.getRecentDocuments();
        if (recentDocs == null) {
            return;
        }
        for (int i = 0; i < PropertiesFile.getNoRecentDocumentsToDisplay(); ++i) {
            if (recentDocs[i] == null) {
                recentDocs[i] = "";
            }
            try {
                String fileNameToAdd = recentDocs[i];
                this.currentGUI.getRecentDocument().createMenuItems(fileNameToAdd, i, this.currentGUI, this.commonValues, this.decode_pdf, this.properties, this.thumbnails, this.searchFrame);
                continue;
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public void setPdfDecoder(PdfDecoderInt decode_pdf) {
        this.decode_pdf = decode_pdf;
    }

    public GUISearchList getSearchList() {
        return this.searchFrame.getResults();
    }

    public MouseMode getMouseMode() {
        return this.mouseMode;
    }

    public ViewStack getViewStack() {
        return this.viewStack;
    }

    public static final boolean isPDFLinearized(String pdfUrl) {
        if (pdfUrl.startsWith("jar")) {
            return false;
        }
        boolean isLinear = false;
        try {
            URL url = new URL(pdfUrl);
            InputStream is = url.openStream();
            byte[] buffer = new byte[128];
            is.read(buffer);
            is.close();
            int len = buffer.length;
            for (int i = 0; i < len; ++i) {
                if (buffer[i] != 47 || buffer[i + 1] != 76 || buffer[i + 2] != 105 || buffer[i + 3] != 110 || buffer[i + 4] != 101 || buffer[i + 5] != 97 || buffer[i + 6] != 114) continue;
                isLinear = true;
                i = len;
            }
        }
        catch (IOException e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF] Exception " + e + " scanning URL " + pdfUrl);
            }
            e.printStackTrace();
        }
        return isLinear;
    }
}

