/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.ViewerInt;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PrinterInt;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Node;

public class Viewer
implements ViewerInt {
    public static final String PREFERENCES_DEFAULT = "jar:/org/jpedal/examples/viewer/res/preferences/Default.xml";
    public static final String PREFERENCES_NO_GUI = "jar:/org/jpedal/examples/viewer/res/preferences/NoGUI.xml";
    public static final String PREFERENCES_NO_SIDE_BAR = "jar:/org/jpedal/examples/viewer/res/preferences/NoSideTabOrTopButtons.xml";
    public static final String PREFERENCES_OPEN_AND_NAV_ONLY = "jar:/org/jpedal/examples/viewer/res/preferences/OpenAndNavOnly.xml";
    public static final String PREFERENCES_BEAN = "jar:/org/jpedal/examples/viewer/res/preferences/Bean.xml";
    protected Values commonValues = new Values();
    PrinterInt currentPrinter;
    PdfDecoderInt decode_pdf;
    GUIThumbnailPanel thumbnails;
    PropertiesFile properties = new PropertiesFile();
    protected GUIFactory currentGUI;
    GUISearchWindow searchFrame;
    protected Commands currentCommands;
    private boolean isSetup;
    public static boolean exitOnClose = true;
    public static boolean closeCalled;
    static boolean isFX;

    @Override
    public void openDefaultFile(String defaultFile) {
        String memFlag;
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (DecoderOptions.hires || hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (defaultFile != null) {
            File testExists = new File(defaultFile);
            boolean isURL = false;
            if (defaultFile.startsWith("http:") || defaultFile.startsWith("jar:") || defaultFile.startsWith("file:")) {
                LogWriter.writeLog("Opening http connection");
                isURL = true;
            }
            if (!isURL && !testExists.exists()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!isURL && testExists.isDirectory()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setFileSize(testExists.length() >> 10);
                this.commonValues.setSelectedFile(defaultFile);
                this.currentGUI.setViewerTitle(null);
                String page = System.getProperty("org.jpedal.page");
                String bookmark = System.getProperty("org.jpedal.bookmark");
                if (page != null && !isURL) {
                    try {
                        int pageNum = Integer.parseInt(page);
                        if (pageNum < 1) {
                            pageNum = -1;
                            System.err.println(page + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(page + " must be 1 or larger. Opening on page 1");
                        }
                        if (pageNum != -1) {
                            this.openFile(testExists, pageNum);
                        }
                    }
                    catch (Exception e) {
                        System.err.println(page + "is not a valid number for a page number. Opening on page 1 " + e);
                        LogWriter.writeLog(page + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (bookmark != null) {
                    this.openFile(testExists, bookmark);
                } else {
                    this.currentGUI.openFile(defaultFile);
                }
            }
        }
    }

    @Override
    public void openDefaultFileAtPage(String defaultFile, int page) {
        String memFlag;
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (DecoderOptions.hires || hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (defaultFile != null) {
            File testExists = new File(defaultFile);
            boolean isURL = false;
            if (defaultFile.startsWith("http:") || defaultFile.startsWith("jar:")) {
                LogWriter.writeLog("Opening http connection");
                isURL = true;
            }
            if (!isURL && !testExists.exists()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!isURL && testExists.isDirectory()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setSelectedFile(defaultFile);
                this.commonValues.setFileSize(testExists.length() >> 10);
                this.currentGUI.setViewerTitle(null);
                this.openFile(testExists, page);
            }
        }
    }

    public PdfDecoderInt getPdfDecoder() {
        return this.decode_pdf;
    }

    void init() {
    }

    public Viewer() {
        if (isFX) {
            return;
        }
        this.init();
        DecoderOptions.showErrorMessages = true;
        String prefFile = System.getProperty("org.jpedal.Viewer.Prefs");
        if (prefFile != null) {
            this.properties.loadProperties(prefFile);
        } else {
            this.properties.loadProperties();
        }
    }

    public Viewer(int modeOfOperation) {
        this.init();
        DecoderOptions.showErrorMessages = true;
        String prefFile = System.getProperty("org.jpedal.Viewer.Prefs");
        if (prefFile != null) {
            this.properties.loadProperties(prefFile);
        } else {
            this.properties.loadProperties();
        }
        this.commonValues.setModeOfOperation(modeOfOperation);
    }

    public Viewer(String prefs) {
        this.init();
        DecoderOptions.showErrorMessages = true;
        try {
            this.properties.loadProperties(prefs);
        }
        catch (Exception e) {
            System.err.println("Specified Preferrences file not found at " + prefs + ". If this file is within a jar ensure filename has jar: at the begining.\n\nLoading default properties. " + e);
            this.properties.loadProperties();
        }
    }

    public Viewer(Object rootContainer, String preferencesPath) {
        this.init();
        DecoderOptions.showErrorMessages = true;
        if (preferencesPath != null && !preferencesPath.isEmpty()) {
            try {
                this.properties.loadProperties(preferencesPath);
            }
            catch (Exception e) {
                System.err.println("Specified Preferrences file not found at " + preferencesPath + ". If this file is within a jar ensure filename has jar: at the begining.\n\nLoading default properties. " + e);
                this.properties.loadProperties();
            }
        } else {
            this.properties.loadProperties();
        }
        this.setRootContainer(rootContainer);
    }

    @Override
    public void setRootContainer(Object rootContainer) {
        this.currentGUI.setRootContainer(rootContainer);
    }

    @Override
    public void loadProperties(String props) {
        this.properties.loadProperties(props);
    }

    public void loadProperties(InputStream is) {
        this.properties.loadProperties(is);
    }

    @Override
    public void setupViewer() {
        boolean showFirstTimePopup;
        String searchType;
        String flag = System.getProperty("org.jpedal.suppressViewerPopups");
        boolean suppressViewerPopups = false;
        if (flag != null && flag.equalsIgnoreCase("true")) {
            suppressViewerPopups = true;
        }
        if ((searchType = this.properties.getValue("searchWindowType")) != null && !searchType.isEmpty()) {
            int type = Integer.parseInt(searchType);
            this.searchFrame.setViewStyle(type);
        } else {
            this.searchFrame.setViewStyle(2);
        }
        this.searchFrame.setUpdateListDuringSearch(this.properties.getValue("updateResultsDuringSearch").equals("true"));
        this.currentGUI.setSearchFrame(this.searchFrame);
        String setThumbnail = System.getProperty("org.jpedal.thumbnail");
        if (setThumbnail != null) {
            if (setThumbnail.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(true);
            } else if (setThumbnail.equals("false")) {
                this.thumbnails.setThumbnailsEnabled(false);
            }
        } else {
            this.thumbnails.setThumbnailsEnabled(true);
        }
        String customBundle = System.getProperty("org.jpedal.bundleLocation");
        if (customBundle != null) {
            ClassLoader loader = Messages.class.getClassLoader();
            String fileName = customBundle.replaceAll("\\.", "/") + '_' + Locale.getDefault().getLanguage() + ".properties";
            try {
                BufferedReader input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream(fileName)));
                input_stream.close();
            }
            catch (IOException ee) {
                Locale.setDefault(new Locale("en", "EN"));
                this.currentGUI.showMessageDialog("No locale file " + fileName + " has been defined for this Locale - using English as Default" + "\n Format is path, using '.' as break ie org.jpedal.international.messages");
            }
            this.init(ResourceBundle.getBundle(customBundle));
        } else {
            this.init(null);
        }
        this.currentGUI.init(this.currentCommands, this.currentPrinter);
        if (this.searchFrame.getViewStyle() == 1) {
            this.currentGUI.searchInTab(this.searchFrame);
        }
        if (!isFX) {
            this.decode_pdf.getDynamicRenderer().setMessageFrame((Container)this.currentGUI.getFrame());
        }
        String propValue = this.properties.getValue("showfirsttimepopup");
        boolean bl = showFirstTimePopup = !suppressViewerPopups && !propValue.isEmpty() && propValue.equals("true");
        if (showFirstTimePopup) {
            this.currentGUI.showFirstTimePopup();
            this.properties.setValue("showfirsttimepopup", "false");
        }
        boolean wasUpdateAvailable = false;
        propValue = this.properties.getValue("displaytipsonstartup");
        if (!suppressViewerPopups && !propValue.isEmpty() && propValue.equals("true")) {
            this.currentCommands.executeCommand(20, null);
        }
        this.isSetup = true;
    }

    protected void init(ResourceBundle bundle) {
        if (bundle == null) {
            try {
                Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " loading resource bundle.\n" + "Also check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            }
        } else {
            try {
                Messages.setBundle(bundle);
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception with bundle " + bundle);
                ee.printStackTrace();
            }
        }
        this.decode_pdf.addExternalHandler(this.currentGUI, 4);
        DecoderOptions.embedWidthData = true;
        this.decode_pdf.setExtractionMode(0, 1.0f);
        FontMappings.setFontReplacements();
    }

    public static void main(String[] args) {
        if (isFX) {
            System.out.println("Please run ViewerFx using java -cp jpedal.jar org.jpedal.examples.viewer.FXStartup");
            System.exit(1);
        }
        Viewer current = new Viewer();
        current.setupViewer();
        current.handleArguments(args);
    }

    @Override
    public void handleArguments(final String[] args) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (args.length > 0) {
                this.openDefaultFile(args[0]);
            } else if (this.properties.getValue("openLastDocument").equalsIgnoreCase("true") && this.properties.getRecentDocuments() != null && this.properties.getRecentDocuments().length > 1) {
                int lastPageViewed = Integer.parseInt(this.properties.getValue("lastDocumentPage"));
                if (lastPageViewed < 0) {
                    lastPageViewed = 1;
                }
                this.openDefaultFileAtPage(this.properties.getRecentDocuments()[0], lastPageViewed);
            }
        } else {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    if (args.length > 0) {
                        Viewer.this.openDefaultFile(args[0]);
                    } else if (Viewer.this.properties.getValue("openLastDocument").toLowerCase().equals("true") && Viewer.this.properties.getRecentDocuments() != null && Viewer.this.properties.getRecentDocuments().length > 1) {
                        int lastPageViewed = Integer.parseInt(Viewer.this.properties.getValue("lastDocumentPage"));
                        if (lastPageViewed < 0) {
                            lastPageViewed = 1;
                        }
                        Viewer.this.openDefaultFileAtPage(Viewer.this.properties.getRecentDocuments()[0], lastPageViewed);
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    private void openFile(File file, String bookmark) {
        try {
            boolean fileCanBeOpened = OpenFile.openUpFile(file.getCanonicalPath(), this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
            String bookmarkPage = null;
            int page = -1;
            if (this.decode_pdf.getOutlineAsXML() != null) {
                Node rootNode = this.decode_pdf.getOutlineAsXML().getFirstChild();
                if (rootNode != null) {
                    bookmarkPage = this.currentGUI.getBookmark(bookmark);
                }
                if (bookmarkPage != null) {
                    page = Integer.parseInt(bookmarkPage);
                }
            }
            if (bookmarkPage == null && (bookmarkPage = this.decode_pdf.getIO().convertNameToRef(bookmark)) != null) {
                OutlineObject namedDest = new OutlineObject(bookmarkPage);
                this.decode_pdf.getIO().readObject(namedDest);
                if (fileCanBeOpened) {
                    OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
                }
                this.decode_pdf.getFormRenderer().getActionHandler().gotoDest(namedDest, 3, 339034948);
            }
            if (bookmarkPage == null) {
                throw new PdfException("Unknown bookmark " + bookmark);
            }
            if (page > -1) {
                this.commonValues.setCurrentPage(page);
                if (fileCanBeOpened) {
                    OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " processing file");
            Values.setProcessing(false);
        }
    }

    private void openFile(File file, int page) {
        try {
            boolean fileCanBeOpened = OpenFile.openUpFile(file.getCanonicalPath(), this.commonValues, this.searchFrame, this.currentGUI, this.decode_pdf, this.properties, this.thumbnails);
            this.commonValues.setCurrentPage(page);
            if (fileCanBeOpened) {
                OpenFile.processPage(this.commonValues, this.decode_pdf, this.currentGUI, this.thumbnails);
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " processing file");
            Values.setProcessing(false);
        }
    }

    @Override
    public Object executeCommand(int commandID, Object[] args) {
        if (!this.isSetup) {
            throw new RuntimeException("You must call viewer.setupViewer(); before you call any commands");
        }
        return this.currentCommands.executeCommand(commandID, args);
    }

    public static boolean isProcessing() {
        return Values.isProcessing();
    }

    @Override
    public void addExternalHandler(Object newHandler, int type) {
        this.decode_pdf.addExternalHandler(newHandler, type);
    }

    @Override
    public void dispose() {
        this.commonValues = null;
        this.currentPrinter = null;
        if (this.thumbnails != null) {
            this.thumbnails.dispose();
        }
        this.thumbnails = null;
        if (this.properties != null) {
            this.properties.dispose();
        }
        this.properties = null;
        if (this.currentGUI != null) {
            this.currentGUI.dispose();
        }
        this.currentGUI = null;
        this.searchFrame = null;
        this.currentCommands = null;
        if (this.decode_pdf != null) {
            this.decode_pdf.dispose();
        }
        this.decode_pdf = null;
        Messages.dispose();
    }

    public static boolean isFX() {
        return isFX;
    }
}

