/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.Exit;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;

public class FullScreen {
    private static Window win;
    private static Point screenPosition;

    public static void execute(Object[] args, final GUIFactory currentGUI, GUIThumbnailPanel thumbnails, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties) {
        if (args == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            if (gs.isFullScreenSupported()) {
                // empty if block
            }
            if (win == null) {
                Frame frame = new Frame(gs.getDefaultConfiguration());
                win = new Window(frame);
            } else if (gs.getFullScreenWindow() != null && gs.getFullScreenWindow().equals(win)) {
                FullScreen.exitFullScreen(currentGUI);
                return;
            }
            if (currentGUI.getFrame() instanceof JFrame) {
                ((JFrame)currentGUI.getFrame()).getContentPane().remove((JSplitPane)currentGUI.getDisplayPane());
                ((Container)currentGUI.getFrame()).setVisible(false);
            } else {
                ((Container)currentGUI.getFrame()).remove((JSplitPane)currentGUI.getDisplayPane());
            }
            win.add((Component)((JSplitPane)currentGUI.getDisplayPane()), "Center");
            Button btn = new Button("Return");
            win.add((Component)btn, "North");
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FullScreen.exitFullScreen(currentGUI);
                }
            });
            try {
                screenPosition = ((Container)currentGUI.getFrame()).getLocation();
                gs.setFullScreenWindow(win);
                win.validate();
                currentGUI.scaleAndRotate();
            }
            catch (Error e) {
                currentGUI.showMessageDialog("Full screen mode not supported on this machine.\nJPedal will now exit " + e);
                Exit.exit(thumbnails, currentGUI, commonValues, decode_pdf, properties);
            }
        }
    }

    private static void exitFullScreen(final GUIFactory currentGUI) {
        Runnable doPaintComponent = new Runnable(){

            @Override
            public void run() {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                gs.setFullScreenWindow(null);
                win.remove((JSplitPane)currentGUI.getDisplayPane());
                if (currentGUI.getFrame() instanceof JFrame) {
                    ((JFrame)currentGUI.getFrame()).getContentPane().add((Component)((JSplitPane)currentGUI.getDisplayPane()), "Center");
                    ((Container)currentGUI.getFrame()).setVisible(true);
                    if (screenPosition != null) {
                        ((Container)currentGUI.getFrame()).setLocation(screenPosition);
                    }
                    screenPosition = null;
                } else {
                    ((Container)currentGUI.getFrame()).add((Component)((JSplitPane)currentGUI.getDisplayPane()), "Center");
                }
                ((JSplitPane)currentGUI.getDisplayPane()).invalidate();
                ((JSplitPane)currentGUI.getDisplayPane()).updateUI();
                if (currentGUI.getFrame() instanceof JFrame) {
                    ((JFrame)currentGUI.getFrame()).getContentPane().validate();
                } else {
                    ((Container)currentGUI.getFrame()).validate();
                }
                win.dispose();
                win = null;
                currentGUI.scaleAndRotate();
            }
        };
        SwingUtilities.invokeLater(doPaintComponent);
    }
}

