/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jpedal.display.GUIDisplay;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Info {
    private static final Font textFont1 = new Font("SansSerif", 0, 12);
    private static final Font headFont = new Font("SansSerif", 1, 14);

    public static void execute(Object[] args, GUIFactory currentGUI) {
        if (args == null) {
            Info.getInfoBox(currentGUI);
        }
    }

    private static void getInfoBox(GUIFactory currentGUI) {
        final JPanel details = new JPanel();
        details.setPreferredSize(new Dimension(400, 280));
        details.setOpaque(false);
        details.setLayout(new BoxLayout(details, 1));
        JLabel header1 = new JLabel(Messages.getMessage("PdfViewerInfo.title"));
        header1.setOpaque(false);
        header1.setFont(headFont);
        header1.setAlignmentX(0.5f);
        details.add(header1);
        details.add(Box.createRigidArea(new Dimension(0, 5)));
        String xmlText = Messages.getMessage("PdfViewerInfo1");
        if (!xmlText.isEmpty()) {
            JTextArea xml = new JTextArea();
            xml.setFont(textFont1);
            xml.setOpaque(false);
            xml.setText(xmlText + "\n\n                    Versions\n                     JPedal: " + "6.6b14" + "          " + "Java: " + System.getProperty("java.version"));
            xml.setLineWrap(true);
            xml.setWrapStyleWord(true);
            xml.setEditable(false);
            details.add(xml);
            xml.setAlignmentX(0.5f);
        }
        ImageIcon logo = new ImageIcon(Info.class.getClass().getResource("/org/jpedal/examples/viewer/res/logo.png"));
        details.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel idr = new JLabel(logo);
        idr.setAlignmentX(0.5f);
        details.add(idr);
        final JLabel url = new JLabel("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text"));
        url.setForeground(Color.blue);
        url.setHorizontalAlignment(0);
        url.setAlignmentX(0.5f);
        url.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (GUIDisplay.allowChangeCursor) {
                    details.setCursor(new Cursor(12));
                }
                url.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Link") + Messages.getMessage("PdfViewerJpedalLibrary.Text") + "</a></center>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (GUIDisplay.allowChangeCursor) {
                    details.setCursor(new Cursor(0));
                }
                url.setText("<html><center>" + Messages.getMessage("PdfViewerJpedalLibrary.Text"));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                block2: {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                    }
                    catch (Exception e1) {
                        if (!LogWriter.isOutput()) break block2;
                        LogWriter.writeLog("Exception attempting launch browser: " + e1);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        details.add(Box.createRigidArea(new Dimension(0, 10)));
        details.add(url);
        details.add(Box.createRigidArea(new Dimension(0, 5)));
        details.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        currentGUI.showMessageDialog((Object)details, Messages.getMessage("PdfViewerInfo3"), -1);
    }
}

