/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.TiffHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class PageNavigator {
    private static boolean pageTurnAnimating;
    private static int lastPageDecoded;
    private static TiffHelper tiffHelper;
    private static boolean pageChanging;

    public static void gotoPage(String page, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        int newPage;
        page = page.split("/")[0];
        try {
            newPage = Integer.parseInt(page);
            if (!decode_pdf.isPageAvailable(newPage)) {
                currentGUI.showMessageDialog("Page " + newPage + " is not yet loaded");
                currentGUI.setPageCounterText(GUI.PageCounter.PAGECOUNTER2, String.valueOf(commonValues.getCurrentPage()));
                return;
            }
            if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                if ((decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || decode_pdf.getDisplayView() != 4) && (newPage & 1) == 1 && newPage != 1) {
                    --newPage;
                } else if (!decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (newPage & 1) == 0) {
                    --newPage;
                }
            }
            if (newPage > decode_pdf.getPageCount() | newPage < 1) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPageLabel.text") + ' ' + page + ' ' + Messages.getMessage("PdfViewerOutOfRange.text") + ' ' + decode_pdf.getPageCount());
                newPage = commonValues.getCurrentPage();
                currentGUI.setPageNumber();
            }
        }
        catch (Exception e) {
            currentGUI.showMessageDialog('>' + page + "< " + Messages.getMessage("PdfViewerInvalidNumber.text") + ' ' + e);
            newPage = commonValues.getCurrentPage();
            currentGUI.setPageCounterText(GUI.PageCounter.PAGECOUNTER2, String.valueOf(commonValues.getCurrentPage()));
        }
        PageNavigator.navigatePages(newPage - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
        if (decode_pdf.getDisplayView() == 5) {
            PageNavigator.navigatePages(0, commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goPage(Object[] args, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            String page = currentGUI.showInputDialog(Messages.getMessage("PdfViewer.EnterPageNumber"), Messages.getMessage("PdfViewer.GotoPage"), 3);
            if (page != null) {
                PageNavigator.gotoPage(page, currentGUI, commonValues, decode_pdf);
            }
        } else {
            PageNavigator.gotoPage((String)args[0], currentGUI, commonValues, decode_pdf);
        }
    }

    public static void goLastPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null && commonValues.getPageCount() > 1 && commonValues.getPageCount() - commonValues.getCurrentPage() > 0) {
            PageNavigator.navigatePages(commonValues.getPageCount() - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goFirstPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null && commonValues.getPageCount() > 1 && commonValues.getCurrentPage() != 1) {
            PageNavigator.navigatePages(-(commonValues.getCurrentPage() - 1), commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goFForwardPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null) {
            if (commonValues.getPageCount() < commonValues.getCurrentPage() + 10) {
                PageNavigator.navigatePages(commonValues.getPageCount() - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
            } else {
                PageNavigator.navigatePages(10, commonValues, decode_pdf, currentGUI);
            }
        }
    }

    public static void goForwardPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null) {
            if (commonValues.getSelectedFile() != null) {
                PageNavigator.navigatePages(1, commonValues, decode_pdf, currentGUI);
            }
        } else {
            if (commonValues.getSelectedFile() != null) {
                PageNavigator.navigatePages(Integer.parseInt((String)args[0]), commonValues, decode_pdf, currentGUI);
            }
            while (Values.isProcessing()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Attempting to set propeties values " + e);
                }
            }
        }
    }

    public static void goBackPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null) {
            if (commonValues.getSelectedFile() != null) {
                PageNavigator.navigatePages(-1, commonValues, decode_pdf, currentGUI);
            }
        } else {
            if (commonValues.getSelectedFile() != null) {
                PageNavigator.navigatePages(-Integer.parseInt((String)args[0]), commonValues, decode_pdf, currentGUI);
            }
            while (Values.isProcessing()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Attempting to set propeties values " + e);
                }
            }
        }
    }

    public static void goFBackPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null) {
            if (commonValues.getCurrentPage() <= 10) {
                PageNavigator.navigatePages(-(commonValues.getCurrentPage() - 1), commonValues, decode_pdf, currentGUI);
            } else {
                PageNavigator.navigatePages(-10, commonValues, decode_pdf, currentGUI);
            }
        }
    }

    private static int getUpdatedPageNumber(int displayMode, int currentPage, int totalPageCount, int changeCount) {
        if (displayMode == 4 || displayMode == 3) {
            if (changeCount == -1 && currentPage != 2) {
                changeCount = -2;
            }
            if (changeCount == 1 && currentPage != totalPageCount - 1) {
                changeCount = 2;
            }
        }
        return currentPage + changeCount;
    }

    private static void changePage(PdfDecoderInt decode_pdf, GUIFactory currentGUI, Values commonValues, int updatedTotal) {
        commonValues.setCurrentPage(updatedTotal);
        if (decode_pdf.getDisplayView() == 2 || decode_pdf.getDisplayView() == 3) {
            currentGUI.decodePage();
            currentGUI.setPageNumber();
            pageChanging = false;
            return;
        }
        currentGUI.resetStatusMessage("Loading Page " + commonValues.getCurrentPage());
        decode_pdf.setPageParameters(currentGUI.getScaling(), commonValues.getCurrentPage());
        if (commonValues.isPDF()) {
            currentGUI.decodePage();
        }
    }

    private static void navigatePagePrevious(int count, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        int updatedTotal = PageNavigator.getUpdatedPageNumber(decode_pdf.getDisplayView(), commonValues.getCurrentPage(), decode_pdf.getPageCount(), count);
        if (!decode_pdf.isPageAvailable(updatedTotal)) {
            currentGUI.showMessageDialog("Page " + updatedTotal + " is not yet loaded");
            pageChanging = false;
            return;
        }
        if (!Values.isProcessing()) {
            if (updatedTotal <= commonValues.getPageCount()) {
                if (commonValues.isMultiTiff()) {
                    PageNavigator.changeTiffPage(commonValues, decode_pdf, currentGUI, count, updatedTotal);
                } else {
                    if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                        if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || decode_pdf.getDisplayView() != 4) {
                            if (updatedTotal > commonValues.getPageCount()) {
                                updatedTotal = commonValues.getPageCount();
                            }
                            if ((updatedTotal & 1) == 1 && updatedTotal != 1) {
                                --updatedTotal;
                            }
                            if (decode_pdf.getDisplayView() == 4) {
                                count = updatedTotal / 2 - commonValues.getCurrentPage() / 2;
                            }
                        } else {
                            if ((updatedTotal & 1) == 0) {
                                --updatedTotal;
                            }
                            count = (updatedTotal + 1) / 2 - (commonValues.getCurrentPage() + 1) / 2;
                        }
                    }
                    PageNavigator.changePage(decode_pdf, currentGUI, commonValues, updatedTotal);
                }
            }
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    private static void navigatePageNext(int count, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        int updatedTotal = PageNavigator.getUpdatedPageNumber(decode_pdf.getDisplayView(), commonValues.getCurrentPage(), decode_pdf.getPageCount(), count);
        if (!decode_pdf.isPageAvailable(updatedTotal)) {
            currentGUI.showMessageDialog("Page " + updatedTotal + " is not yet loaded");
            pageChanging = false;
            return;
        }
        if (!Values.isProcessing()) {
            if (updatedTotal >= 1) {
                if (commonValues.isMultiTiff()) {
                    PageNavigator.changeTiffPage(commonValues, decode_pdf, currentGUI, count, updatedTotal);
                } else {
                    if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                        if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || decode_pdf.getDisplayView() != 4) {
                            if (count == -1) {
                                --updatedTotal;
                            }
                            if (updatedTotal < 1) {
                                updatedTotal = 1;
                            }
                            if ((updatedTotal & 1) == 1 && updatedTotal != 1) {
                                --updatedTotal;
                            }
                            if (decode_pdf.getDisplayView() == 4) {
                                count = updatedTotal / 2 - commonValues.getCurrentPage() / 2;
                            }
                        } else {
                            if ((updatedTotal & 1) == 0) {
                                --updatedTotal;
                            }
                            if (decode_pdf.getDisplayView() == 4) {
                                count = (updatedTotal + 1) / 2 - (commonValues.getCurrentPage() + 1) / 2;
                            }
                        }
                    }
                    PageNavigator.changePage(decode_pdf, currentGUI, commonValues, updatedTotal);
                }
            }
        } else {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    public static void navigatePages(int count, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (count == 0) {
            return;
        }
        if (!pageChanging) {
            pageChanging = true;
            if (count > 0) {
                PageNavigator.navigatePageNext(count, commonValues, decode_pdf, currentGUI);
            } else {
                PageNavigator.navigatePagePrevious(count, commonValues, decode_pdf, currentGUI);
            }
            if (currentGUI.getThumbnailScrollBar() != null) {
                currentGUI.setThumbnailScrollBarValue(commonValues.getCurrentPage() - 1);
            }
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
            currentGUI.setPageNumber();
            pageChanging = false;
        }
    }

    private static void changeTiffPage(Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI, int count, int updatedTotal) {
        commonValues.setTiffImageToLoad(lastPageDecoded - 1 + count);
        PageNavigator.drawMultiPageTiff(commonValues, decode_pdf);
        commonValues.setCurrentPage(updatedTotal);
        lastPageDecoded = commonValues.getTiffImageToLoad() + 1;
        currentGUI.setPageNumber();
    }

    public static void drawMultiPageTiff(Values commonValues, PdfDecoderInt decode_pdf) {
    }

    public static void setPageTurnAnimating(boolean a, GUIFactory currentGUI) {
        pageTurnAnimating = a;
        if (a) {
            currentGUI.getButtons().getButton(53).setEnabled(false);
            currentGUI.getButtons().getButton(52).setEnabled(false);
            currentGUI.getButtons().getButton(54).setEnabled(false);
            currentGUI.getButtons().getButton(51).setEnabled(false);
            currentGUI.getButtons().getButton(55).setEnabled(false);
            currentGUI.getButtons().getButton(50).setEnabled(false);
        } else {
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
        }
    }

    public static boolean getPageTurnAnimating() {
        return pageTurnAnimating;
    }

    public static void setLastPageDecoded(int x) {
        lastPageDecoded = x;
    }

    public static TiffHelper getTiffHelper() {
        return tiffHelper;
    }

    public static void setTiffHelper(TiffHelper tiffHelp) {
        tiffHelper = tiffHelp;
    }

    static {
        lastPageDecoded = -1;
    }
}

