/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class SaveFile {
    public static void execute(Object[] args, GUIFactory currentGUI, Values commonValues) {
        if (args == null) {
            SaveFile.saveFile(currentGUI, commonValues);
        }
    }

    private static void saveFile(GUIFactory currentGUI, Values commonValues) {
        boolean finished = false;
        while (!finished) {
            JFileChooser chooser = new JFileChooser(commonValues.getInputDir());
            chooser.setSelectedFile(new File(commonValues.getInputDir() + '/' + commonValues.getSelectedFile()));
            chooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
            chooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
            chooser.setFileSelectionMode(0);
            int approved = chooser.showSaveDialog(null);
            if (approved == 0) {
                block9: {
                    int n;
                    FileInputStream fis = null;
                    FileOutputStream fos = null;
                    File file = chooser.getSelectedFile();
                    String fileToSave = file.getAbsolutePath();
                    if (!fileToSave.endsWith(".pdf")) {
                        fileToSave = fileToSave + ".pdf";
                        file = new File(fileToSave);
                    }
                    if (fileToSave.equals(commonValues.getSelectedFile())) {
                        return;
                    }
                    if (file.exists() && (n = currentGUI.showConfirmDialog(fileToSave + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                    try {
                        int bytes_read;
                        fis = new FileInputStream(commonValues.getSelectedFile());
                        fos = new FileOutputStream(fileToSave);
                        byte[] buffer = new byte[4096];
                        while ((bytes_read = fis.read(buffer)) != -1) {
                            fos.write(buffer, 0, bytes_read);
                        }
                    }
                    catch (Exception e1) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfViewerException.NotSaveInternetFile") + ' ' + e1);
                    }
                    try {
                        fis.close();
                        fos.close();
                    }
                    catch (IOException e2) {
                        if (!LogWriter.isOutput()) break block9;
                        LogWriter.writeLog("Exception attempting close IOStream: " + e2);
                    }
                }
                finished = true;
                continue;
            }
            return;
        }
    }
}

