/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;

public class SetCommand {
    public static void execute(Object[] args, GUIFactory currentGUI, PdfDecoderInt decode_pdf, Values commonValues) {
        StringTokenizer tok;
        String viewportWindow;
        if (args == null && (viewportWindow = currentGUI.showInputDialog("Entry the co-ordinates of the viewport, as x y width height")) != null && (tok = new StringTokenizer(viewportWindow)).countTokens() == 4) {
            int x = Integer.parseInt(tok.nextToken());
            int y = Integer.parseInt(tok.nextToken());
            int w = Integer.parseInt(tok.nextToken());
            int h = Integer.parseInt(tok.nextToken());
            try {
                AffineTransform scalingUsed = decode_pdf.getPages().setViewableArea(new int[]{x, y, w, h});
                commonValues.dx = (int)scalingUsed.getTranslateX();
                commonValues.dy = (int)scalingUsed.getTranslateY();
                commonValues.maxViewY = h;
                commonValues.viewportScale = scalingUsed.getScaleX();
            }
            catch (PdfException e1) {
                System.err.println("setViewportError = " + e1.getMessage());
                e1.printStackTrace();
                commonValues.maxViewY = 0;
                decode_pdf.resetViewableArea();
            }
        }
    }
}

