/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;

public class Tile {
    public static void execute(Object[] args, GUIFactory currentGUI) {
        if (args == null) {
            Tile.tile(currentGUI);
        }
    }

    private static void tile(GUIFactory currentGUI) {
        JDesktopPane desktopPane = (JDesktopPane)currentGUI.getMultiViewerFrames();
        JInternalFrame[] frames = desktopPane.getAllFrames();
        int frameCount = 0;
        for (JInternalFrame frame1 : frames) {
            if (frame1.isIcon()) continue;
            ++frameCount;
        }
        int rows = (int)Math.sqrt(frameCount);
        int cols = frameCount / rows;
        int extra = frameCount % rows;
        int width = desktopPane.getWidth() / cols;
        int height = desktopPane.getHeight() / rows;
        int r = 0;
        int c = 0;
        for (JInternalFrame frame : frames) {
            if (frame.isIcon()) continue;
            try {
                frame.setMaximum(false);
                frame.reshape(c * width, r * height, width, height);
                if (++r != rows) continue;
                r = 0;
                if (++c != cols - extra) continue;
                height = desktopPane.getHeight() / ++rows;
            }
            catch (PropertyVetoException e) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception attempting to set size" + e);
            }
        }
    }
}

