/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.generic;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;

public class GUIExtractText {
    protected static String extractTextList(PdfDecoderInt decode_pdf, Values commonValues, GUIFactory currentGUI, boolean isXML, int t_x1, int t_x2, int t_y1, int t_y2) throws PdfException {
        List words;
        int alterCoords;
        String extractedText = "";
        PdfGroupingAlgorithms.useUnrotatedCoords = true;
        PdfPageData pageData = decode_pdf.getPdfPageData();
        int rotation = pageData.getRotation(commonValues.getCurrentPage());
        if (rotation != 0 && (alterCoords = currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerRotatedCoords.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0)) == 0) {
            PdfGroupingAlgorithms.useUnrotatedCoords = false;
        }
        if ((words = decode_pdf.getGroupingObject().extractTextAsWordlist(t_x1, t_y1, t_x2, t_y2, commonValues.getCurrentPage(), true, null)) == null) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + t_x1 + " y1:" + t_y1 + " x2:" + t_x2 + " y2:" + t_y2);
        }
        if (words != null) {
            StringBuilder textOutput = new StringBuilder();
            Iterator wordIterator = words.iterator();
            while (wordIterator.hasNext()) {
                String currentWord = (String)wordIterator.next();
                if (!isXML) {
                    currentWord = Strip.convertToText(currentWord, decode_pdf.isXMLExtraction());
                }
                int wx1 = (int)Float.parseFloat((String)wordIterator.next());
                int wy1 = (int)Float.parseFloat((String)wordIterator.next());
                int wx2 = (int)Float.parseFloat((String)wordIterator.next());
                int wy2 = (int)Float.parseFloat((String)wordIterator.next());
                textOutput.append(currentWord).append(',').append(wx1).append(',').append(wy1).append(',').append(wx2).append(',').append(wy2).append('\n');
            }
            if (textOutput.toString() != null) {
                extractedText = textOutput.toString();
            }
        }
        return extractedText;
    }

    protected static String extractTextTable(Values commonValues, PdfDecoderInt decode_pdf, boolean isCSV, int t_x1, int t_x2, int t_y1, int t_y2) throws PdfException {
        Map content = !isCSV ? decode_pdf.getGroupingObject().extractTextAsTable(t_x1, t_y1, t_x2, t_y2, commonValues.getCurrentPage(), true, false, false, false, 0) : decode_pdf.getGroupingObject().extractTextAsTable(t_x1, t_y1, t_x2, t_y2, commonValues.getCurrentPage(), false, true, true, false, 1);
        if (content.get("content") != null) {
            return (String)content.get("content");
        }
        return "";
    }

    protected static String extractTextRectangle(Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI, boolean isXML, int t_x1, int t_x2, int t_y1, int t_y2) throws PdfException {
        String extractedText = decode_pdf.getGroupingObject().extractTextInRectangle(t_x1, t_y1, t_x2, t_y2, commonValues.getCurrentPage(), false, true);
        if (extractedText == null) {
            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound") + "\nx1:" + t_x1 + " y1:" + t_y1 + " x2:" + t_x2 + " y2:" + t_y2);
            return "";
        }
        if (!isXML) {
            extractedText = Strip.stripXML(extractedText, decode_pdf.isXMLExtraction()).toString();
        }
        return extractedText;
    }
}

