/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.utils.Messages;

public class JavaFXDocInfo {
    private static final Font headerFont = Font.font((String)"SanSerif", (FontWeight)FontWeight.BOLD, (double)14.0);
    private static final Font textFont = Font.font((String)"SanSerif", (double)12.0);
    private static final String lb = "\n";
    private static final StackPane treeContainer = new StackPane();

    public static void execute(Object[] args, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            if (!commonValues.isPDF()) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
            } else if (commonValues.getSelectedFile() == null) {
                currentGUI.showMessageDialog((Object)Messages.getMessage("PdfVieweremptyFile.message"), Messages.getMessage("PdfViewerTooltip.pageSize"), -1);
            } else {
                JavaFXDocInfo.getPropertiesBox(commonValues.getSelectedFile(), commonValues.getFileSize(), commonValues.getPageCount(), commonValues.getCurrentPage(), decode_pdf);
            }
        }
    }

    private static void getPropertiesBox(String selectedFile, long fileSize, int pageCount, int currentPage, PdfDecoderInt decode_pdf) {
        String xmlText;
        String user_dir = System.getProperty("user.dir");
        PdfFileInformation currentFileInformation = decode_pdf.getFileInformationData();
        int ptr = 0;
        if (ptr == -1) {
            ptr = selectedFile.lastIndexOf(47);
        }
        String file = selectedFile.substring(ptr + 1, selectedFile.length());
        String path = selectedFile.substring(0, ptr + 1);
        TabPane tabPane = new TabPane();
        tabPane.setId("docProp");
        Tab properties = new Tab("Properties");
        Tab fonts = new Tab("Fonts");
        Tab available = new Tab("Available");
        Tab aliases = new Tab("Aliases");
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        properties.setContent((Node)JavaFXDocInfo.getPropTab(currentFileInformation, file, path, user_dir, fileSize, pageCount, currentPage, decode_pdf));
        fonts.setContent((Node)JavaFXDocInfo.getFontTab(decode_pdf.getInfo(373243460)));
        available.setContent((Node)JavaFXDocInfo.getAvailableTab());
        aliases.setContent((Node)JavaFXDocInfo.getAliasesTab());
        tabPane.getTabs().addAll((Object[])new Tab[]{properties, fonts, available, aliases});
        if (JavaFXDocInfo.getFormsTab(decode_pdf) != null) {
            Tab forms = new Tab("Forms");
            forms.setContent((Node)JavaFXDocInfo.getFormsTab(decode_pdf));
            tabPane.getTabs().add((Object)forms);
        }
        if (ImageCommands.trackImages) {
            Tab image = new Tab("Image");
            image.setContent((Node)JavaFXDocInfo.getImageTab(decode_pdf));
            tabPane.getTabs().add((Object)image);
        }
        if (!(xmlText = currentFileInformation.getFileXMLMetaData()).isEmpty()) {
            Tab xml = new Tab("XML");
            xml.setContent((Node)JavaFXDocInfo.getXMLTab(xmlText));
            tabPane.getTabs().add((Object)xml);
        }
        FXDialog newDialog = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)tabPane, 400.0, 300.0);
        newDialog.show();
    }

    private static ScrollPane getPropTab(PdfFileInformation currentFileInformation, String file, String path, String user_dir, long size, int pageCount, int currentPage, PdfDecoderInt decode_pdf) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        if (currentFileInformation != null) {
            VBox content = new VBox();
            Text generalTitle = new Text(lb + Messages.getMessage("PdfViewerGeneral"));
            generalTitle.setFont(headerFont);
            StringBuffer pdfVersion = new StringBuffer("PDF");
            pdfVersion.append(decode_pdf.getPDFVersion());
            if (decode_pdf.getJPedalObject(2004845231) != null) {
                pdfVersion.append(" (").append(Messages.getMessage("PdfViewerLinearized.text")).append(") ");
            }
            Text generalContent = new Text(Messages.getMessage("PdfViewerFileName") + file + lb + Messages.getMessage("PdfViewerFilePath") + path + lb + Messages.getMessage("PdfViewerCurrentWorkingDir") + ' ' + user_dir + lb + Messages.getMessage("PdfViewerFileSize") + size + " K" + lb + Messages.getMessage("PdfViewerPageCount") + pageCount + lb + pdfVersion + lb);
            generalContent.setFont(textFont);
            Text propertiesTitle = new Text(Messages.getMessage("PdfViewerProperties"));
            propertiesTitle.setFont(headerFont);
            Text propertiesContent = new Text();
            propertiesContent.setFont(textFont);
            String[] values = currentFileInformation.getFieldValues();
            String[] fields = PdfFileInformation.getFieldNames();
            for (int i = 0; i < fields.length; ++i) {
                if (values[i].isEmpty()) continue;
                propertiesContent.setText(propertiesContent.getText() + fields[i] + " = " + values[i] + lb);
            }
            content.getChildren().addAll((Object[])new Node[]{generalTitle, generalContent, propertiesTitle, propertiesContent});
            PdfPageData currentPageSize = decode_pdf.getPdfPageData();
            if (currentPageSize != null) {
                Text pageCoordsTitle = new Text(Messages.getMessage("PdfViewerCoords.text"));
                pageCoordsTitle.setFont(headerFont);
                Text pageCoordsContent = new Text(Messages.getMessage("PdfViewermediaBox.text") + currentPageSize.getMediaValue(currentPage) + lb + Messages.getMessage("PdfViewercropBox.text") + currentPageSize.getCropValue(currentPage) + lb + Messages.getMessage("PdfViewerLabel.Rotation") + currentPageSize.getRotation(currentPage) + lb);
                pageCoordsContent.setFont(textFont);
                content.getChildren().addAll((Object[])new Node[]{pageCoordsTitle, pageCoordsContent});
            }
            scrollPane.setContent((Node)content);
        }
        return scrollPane;
    }

    private static ScrollPane getFontTab(String xmlTxt) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        StringBuilder xmlText = new StringBuilder("Font Substitution Mode: ");
        switch (FontMappings.getFontSubstitutionMode()) {
            case 1: {
                xmlText.append("Using File Name");
                break;
            }
            case 2: {
                xmlText.append("Using PostScript Name");
                break;
            }
            case 3: {
                xmlText.append("Using Family Name");
                break;
            }
            case 4: {
                xmlText.append("Using The Full Font Name");
                break;
            }
            default: {
                xmlText.append("Unknown Font Substitution Mode");
            }
        }
        xmlText.append(lb);
        if (!xmlTxt.isEmpty()) {
            VBox content = new VBox();
            Text generalTitle = new Text("\nGeneral");
            generalTitle.setFont(headerFont);
            Text fontContent = new Text(xmlText.toString());
            fontContent.setFont(textFont);
            Text fontListTitle = new Text("Fonts Used");
            fontListTitle.setFont(headerFont);
            Text fontListContent = new Text(xmlTxt);
            fontListContent.setFont(textFont);
            content.getChildren().addAll((Object[])new Node[]{generalTitle, fontContent, fontListTitle, fontListContent});
            scrollPane.setContent((Node)content);
        }
        return scrollPane;
    }

    private static ScrollPane getImageTab(PdfDecoderInt decode_pdf) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        String xmlTxt = decode_pdf.getInfo(1026635598);
        if (!xmlTxt.isEmpty()) {
            VBox content = new VBox();
            Text imageListTitle = new Text("\nImages Used");
            imageListTitle.setFont(headerFont);
            Text imageListContent = new Text(xmlTxt);
            imageListContent.setFont(textFont);
            content.getChildren().addAll((Object[])new Node[]{imageListTitle, imageListContent});
            scrollPane.setContent((Node)content);
        }
        return scrollPane;
    }

    private static ScrollPane getXMLTab(String xmlText) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        VBox content = new VBox();
        Text imageListTitle = new Text("\nXML Content");
        imageListTitle.setFont(headerFont);
        Text imageListContent = new Text(xmlText);
        imageListContent.setFont(textFont);
        content.getChildren().addAll((Object[])new Node[]{imageListTitle, imageListContent});
        scrollPane.setContent((Node)content);
        return scrollPane;
    }

    private static ScrollPane getFormsTab(PdfDecoderInt decode_pdf) {
        Object[] formsOnPage;
        ScrollPane scrollPane = null;
        AcroRenderer formRenderer = decode_pdf.getFormRenderer();
        if (formRenderer != null && (formsOnPage = formRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, decode_pdf.getPageNumber())) != null) {
            int formCount = formsOnPage.length;
            scrollPane = new ScrollPane();
            scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            VBox content = new VBox();
            Text tabTitle = new Text("\nPage Contains " + formCount + " Form Objects" + lb);
            tabTitle.setFont(headerFont);
            content.getChildren().addAll((Object[])new Node[]{tabTitle});
            for (Object aFormsOnPage : formsOnPage) {
                Object[] rawFormData;
                String formName = (String)aFormsOnPage;
                Object[] comp = formRenderer.getFormComponents(formName, ReturnValues.GUI_FORMS_FROM_NAME, -1);
                if (comp == null) continue;
                Text formObject = new Text(formName);
                formObject.setFont(headerFont);
                FormObject formObj = null;
                StringBuilder PDFrefs = new StringBuilder("PDF ref=");
                for (Object aRawFormData : rawFormData = formRenderer.getFormComponents(formName, ReturnValues.FORMOBJECTS_FROM_NAME, -1)) {
                    formObj = (FormObject)aRawFormData;
                    PDFrefs.append(' ').append(formObj.getObjectRefAsString());
                }
                String PDFType = "Type = " + PdfDictionary.showAsConstant(formObj.getParameterConstant(608780341)) + " Subtype=" + PdfDictionary.showAsConstant(formObj.getParameterConstant(1147962727));
                String standardDetails = "Java Class = " + comp[0].getClass();
                Text formObjInfo = new Text(PDFrefs + lb + PDFType + lb + standardDetails);
                formObjInfo.setFont(textFont);
                content.getChildren().addAll((Object[])new Node[]{formObject, formObjInfo});
            }
            scrollPane.setContent((Node)content);
        }
        return scrollPane;
    }

    private static ScrollPane getAliasesTab() {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        Text aliasesTitle = new Text("\nAliases Content");
        aliasesTitle.setFont(headerFont);
        Text aliasesContent = new Text();
        aliasesContent.setFont(textFont);
        for (Object nextFont : FontMappings.fontSubstitutionAliasTable.keySet()) {
            aliasesContent.setText(aliasesContent.getText() + nextFont + " ==> " + FontMappings.fontSubstitutionAliasTable.get(nextFont) + lb);
        }
        if (aliasesContent.getText() != null) {
            VBox content = new VBox();
            content.getChildren().addAll((Object[])new Node[]{aliasesTitle, aliasesContent});
            scrollPane.setContent((Node)content);
        }
        return scrollPane;
    }

    private static VBox getAvailableTab() {
        VBox container = new VBox();
        Text titleText = new Text("\nAvailable Fonts");
        titleText.setFont(headerFont);
        GridPane filterContainer = new GridPane();
        Text filterText = new Text("Filter Font List");
        filterText.setFont(textFont);
        final TextField filterField = new TextField();
        filterField.setMaxSize(150.0, 0.0);
        filterField.setFont(textFont);
        final RadioButton sortFolder = new RadioButton("Sort By Folder ");
        sortFolder.setFont(textFont);
        RadioButton sortName = new RadioButton("Sort By Name ");
        sortFolder.setFont(textFont);
        filterContainer.addColumn(1, new Node[]{sortFolder, sortName});
        filterContainer.addColumn(2, new Node[]{filterText, filterField});
        filterContainer.setAlignment(Pos.CENTER);
        filterContainer.setHgap(20.0);
        ToggleGroup docInfoGroup = new ToggleGroup();
        sortFolder.setSelected(true);
        docInfoGroup.getToggles().addAll((Object[])new Toggle[]{sortFolder, sortName});
        JavaFXDocInfo.getAvailableFonts(filterField, sortFolder.isSelected());
        ChangeListener<Toggle> updateSelectionListener = new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle old_toggle, Toggle new_toggle) {
                JavaFXDocInfo.getAvailableFonts(filterField, sortFolder.isSelected());
            }
        };
        docInfoGroup.selectedToggleProperty().addListener((ChangeListener)updateSelectionListener);
        filterText.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                JavaFXDocInfo.getAvailableFonts(filterField, sortFolder.isSelected());
            }
        });
        container.getChildren().addAll((Object[])new Node[]{titleText, filterContainer, treeContainer});
        container.setAlignment(Pos.CENTER);
        return container;
    }

    private static TreeItem populateAvailableFonts(TreeItem top, String filter, boolean sortFontsByDir) {
        block10: {
            if (FontMappings.fontSubstitutionTable == null) break block10;
            Set fonts = FontMappings.fontSubstitutionTable.keySet();
            Iterator fontList = FontMappings.fontSubstitutionTable.keySet().iterator();
            int fontCount = fonts.size();
            ArrayList<String> fontNames = new ArrayList<String>(fontCount);
            while (fontList.hasNext()) {
                fontNames.add(fontList.next().toString());
            }
            Collections.sort(fontNames);
            if (sortFontsByDir) {
                ArrayList<String> location = new ArrayList<String>();
                ArrayList<TreeItem> locationNode = new ArrayList<TreeItem>();
                for (int ii = 0; ii < fontCount; ++ii) {
                    Object nextFont = fontNames.get(ii);
                    String current = (String)FontMappings.fontSubstitutionLocation.get(nextFont);
                    int ptr = current.lastIndexOf(System.getProperty("file.separator"));
                    if (ptr == -1 && current.indexOf(47) != -1) {
                        ptr = current.lastIndexOf(47);
                    }
                    if (ptr != -1) {
                        current = current.substring(0, ptr);
                    }
                    if (filter != null && !((String)nextFont).toLowerCase().contains(filter.toLowerCase())) continue;
                    if (!location.contains(current)) {
                        location.add(current);
                        TreeItem loc = new TreeItem((Object)new TreeItem((Object)current));
                        top.getChildren().add((Object)loc);
                        locationNode.add(loc);
                    }
                    TreeItem FontTop = new TreeItem((Object)(nextFont + " = " + FontMappings.fontSubstitutionLocation.get(nextFont)));
                    int pos = location.indexOf(current);
                    ((TreeItem)locationNode.get(pos)).getChildren().add((Object)FontTop);
                    String loc = (String)FontMappings.fontPropertiesTable.get(nextFont + "_path");
                    Integer type = (Integer)FontMappings.fontPropertiesTable.get(nextFont + "_type");
                    Map properties = StandardFonts.getFontDetails(type, loc);
                    if (properties == null) continue;
                    for (Object key : properties.keySet()) {
                        Object value = properties.get(key);
                        TreeItem fontDetails = new TreeItem((Object)(key + " = " + value));
                        FontTop.getChildren().add((Object)fontDetails);
                    }
                }
            } else {
                for (int ii = 0; ii < fontCount; ++ii) {
                    Object nextFont = fontNames.get(ii);
                    if (filter != null && !((String)nextFont).toLowerCase().contains(filter.toLowerCase())) continue;
                    TreeItem fontTop = new TreeItem((Object)(nextFont + " = " + FontMappings.fontSubstitutionLocation.get(nextFont)));
                    top.getChildren().add((Object)fontTop);
                    Map properties = (Map)FontMappings.fontPropertiesTable.get(nextFont);
                    if (properties == null) continue;
                    for (Object key : properties.keySet()) {
                        Object value = properties.get(key);
                        TreeItem fontDetails = new TreeItem((Object)(key + " = " + value));
                        fontTop.getChildren().add((Object)fontDetails);
                    }
                }
            }
        }
        return top;
    }

    private static void getAvailableFonts(TextField filterText, boolean sortFontsByDir) {
        TreeItem fontlist = new TreeItem((Object)"Fonts");
        fontlist = JavaFXDocInfo.populateAvailableFonts(fontlist, filterText.getText(), sortFontsByDir);
        treeContainer.getChildren().clear();
        treeContainer.getChildren().add((Object)new TreeView(fontlist));
    }
}

