/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Separator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Border;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.utils.BrowserLauncher;

public class JavaFXInfo {
    public static void execute(Object[] args) {
        if (args == null) {
            JavaFXInfo.getInfoBox();
        }
    }

    private static void getInfoBox() {
        Text title = new Text("JavaFX Viewer Information");
        title.setTextAlignment(TextAlignment.CENTER);
        title.setFont(Font.font((String)"SansSerif", (FontWeight)FontWeight.BOLD, (double)14.0));
        Text info = new Text("OpenViewerFX is a JavaFX PDF Viewer written in JavaFX and released without any warranty or support under an LGPL license.\nThis Application is updated regularly and a supported, enhanced version is available as part of the commercial JPedal Java PDF library.");
        info.setText(info.getText() + "\n\n\t\tVersions: " + "6.6b14" + "          " + "Java: " + System.getProperty("java.version"));
        info.setWrappingWidth(350.0);
        info.setTextAlignment(TextAlignment.JUSTIFY);
        info.setFont(Font.font((String)"SansSerif", (FontWeight)FontWeight.NORMAL, (double)12.0));
        ImageView imageView = new ImageView(new Image("/org/jpedal/examples/viewer/res/logo2.png"));
        Hyperlink link = new Hyperlink("Learn more about the JPedal Commercial PDF Library");
        link.setBorder(Border.EMPTY);
        Button okButton = new Button("OK");
        okButton.setPadding(new Insets(7.0, 25.0, 7.0, 25.0));
        Separator sepBottom = new Separator();
        sepBottom.setPrefHeight(50.0);
        sepBottom.setVisible(false);
        sepBottom.setOrientation(Orientation.HORIZONTAL);
        Separator sepTop = new Separator();
        sepTop.setPrefHeight(50.0);
        sepTop.setVisible(false);
        sepTop.setOrientation(Orientation.HORIZONTAL);
        Separator sepAfterImg = new Separator();
        sepAfterImg.setPrefHeight(50.0);
        sepAfterImg.setVisible(false);
        sepAfterImg.setOrientation(Orientation.HORIZONTAL);
        Separator sepAfterLink = new Separator();
        sepAfterLink.setPrefHeight(50.0);
        sepAfterLink.setVisible(false);
        sepAfterLink.setOrientation(Orientation.HORIZONTAL);
        VBox vBox = new VBox();
        vBox.getChildren().addAll((Object[])new Node[]{title, sepTop, info, sepBottom, imageView, sepAfterImg, link, sepAfterLink, okButton});
        vBox.setAlignment(Pos.CENTER);
        vBox.setPadding(new Insets(10.0));
        final FXDialog newDialog = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)vBox, 400.0, 350.0);
        newDialog.setTitle("About OpenViewerFX");
        newDialog.setResizeable(false);
        link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                try {
                    BrowserLauncher.openURL("http://www.idrsolutions.com/java-pdf-library/");
                    newDialog.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        okButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                newDialog.close();
            }
        });
        newDialog.show();
    }
}

