/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.TiffHelper;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class JavaFXPageNavigator {
    private static boolean pageTurnAnimating;
    private static int lastPageDecoded;
    private static TiffHelper tiffHelper;
    private static boolean pageChanging;

    public static void gotoPage(String page, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        int newPage;
        page = page.split("/")[0];
        try {
            newPage = Integer.parseInt(page);
            if (!decode_pdf.isPageAvailable(newPage)) {
                currentGUI.showMessageDialog("Page " + newPage + " is not yet loaded");
                currentGUI.setPageCounterText(GUI.PageCounter.PAGECOUNTER2, String.valueOf(commonValues.getCurrentPage()));
                return;
            }
            if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                if ((decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || decode_pdf.getDisplayView() != 4) && (newPage & 1) == 1 && newPage != 1) {
                    --newPage;
                } else if (!decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (newPage & 1) == 0) {
                    --newPage;
                }
            }
            if (newPage > decode_pdf.getPageCount() | newPage < 1) {
                currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPageLabel.text") + ' ' + page + ' ' + Messages.getMessage("PdfViewerOutOfRange.text") + ' ' + decode_pdf.getPageCount());
                newPage = commonValues.getCurrentPage();
                currentGUI.setPageNumber();
            }
        }
        catch (Exception e) {
            currentGUI.showMessageDialog('>' + page + "< " + Messages.getMessage("PdfViewerInvalidNumber.text") + ' ' + e);
            newPage = commonValues.getCurrentPage();
            currentGUI.setPageCounterText(GUI.PageCounter.PAGECOUNTER2, String.valueOf(commonValues.getCurrentPage()));
        }
        JavaFXPageNavigator.navigatePages(newPage - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
        if (decode_pdf.getDisplayView() == 5) {
            JavaFXPageNavigator.navigatePages(0, commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goPage(Object[] args, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args == null) {
            String page = currentGUI.showInputDialog(Messages.getMessage("PdfViewer.EnterPageNumber"), Messages.getMessage("PdfViewer.GotoPage"), 3);
            if (page != null) {
                JavaFXPageNavigator.gotoPage(page, currentGUI, commonValues, decode_pdf);
            }
        } else {
            JavaFXPageNavigator.gotoPage((String)args[0], currentGUI, commonValues, decode_pdf);
        }
    }

    public static void goLastPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null && commonValues.getPageCount() > 1 && commonValues.getPageCount() - commonValues.getCurrentPage() > 0) {
            JavaFXPageNavigator.navigatePages(commonValues.getPageCount() - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goFirstPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null && commonValues.getPageCount() > 1 && commonValues.getCurrentPage() != 1) {
            JavaFXPageNavigator.navigatePages(-(commonValues.getCurrentPage() - 1), commonValues, decode_pdf, currentGUI);
        }
    }

    public static void goFForwardPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null) {
            if (commonValues.getPageCount() < commonValues.getCurrentPage() + 10) {
                JavaFXPageNavigator.navigatePages(commonValues.getPageCount() - commonValues.getCurrentPage(), commonValues, decode_pdf, currentGUI);
            } else {
                JavaFXPageNavigator.navigatePages(10, commonValues, decode_pdf, currentGUI);
            }
        }
    }

    public static void goForwardPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        block7: {
            block5: {
                block6: {
                    if (args != null) break block5;
                    if (commonValues.getSelectedFile() == null) break block6;
                    JavaFXPageNavigator.navigatePages(1, commonValues, decode_pdf, currentGUI);
                    break block7;
                }
                if (decode_pdf.getPageCount() <= 0) break block7;
                if (commonValues.getPageCount() != decode_pdf.getPageCount()) {
                    commonValues.setPageCount(decode_pdf.getPageCount());
                }
                JavaFXPageNavigator.navigatePages(1, commonValues, decode_pdf, currentGUI);
                break block7;
            }
            if (commonValues.getSelectedFile() != null) {
                JavaFXPageNavigator.navigatePages(Integer.parseInt((String)args[0]), commonValues, decode_pdf, currentGUI);
            }
            while (Values.isProcessing()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Attempting to set propeties values " + e);
                }
            }
        }
    }

    public static void goBackPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null) {
            if (commonValues.getSelectedFile() != null) {
                JavaFXPageNavigator.navigatePages(-1, commonValues, decode_pdf, currentGUI);
            }
        } else {
            if (commonValues.getSelectedFile() != null) {
                JavaFXPageNavigator.navigatePages(-Integer.parseInt((String)args[0]), commonValues, decode_pdf, currentGUI);
            }
            while (Values.isProcessing()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Attempting to set propeties values " + e);
                }
            }
        }
    }

    public static void goFBackPage(Object[] args, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (args == null && commonValues.getSelectedFile() != null) {
            if (commonValues.getCurrentPage() <= 10) {
                JavaFXPageNavigator.navigatePages(-(commonValues.getCurrentPage() - 1), commonValues, decode_pdf, currentGUI);
            } else {
                JavaFXPageNavigator.navigatePages(-10, commonValues, decode_pdf, currentGUI);
            }
        }
    }

    public static void navigatePages(int count, Values commonValues, PdfDecoderInt decode_pdf, GUIFactory currentGUI) {
        if (count == 0) {
            return;
        }
        if (!pageChanging) {
            pageChanging = true;
            if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                if (count == -1 && commonValues.getCurrentPage() != 2) {
                    count = -2;
                }
                if (count == 1 && commonValues.getCurrentPage() != decode_pdf.getPageCount() - 1) {
                    count = 2;
                }
            }
            int updatedTotal = commonValues.getCurrentPage() + count;
            if (count > 0) {
                if (!decode_pdf.isPageAvailable(updatedTotal)) {
                    currentGUI.showMessageDialog("Page " + updatedTotal + " is not yet loaded");
                    pageChanging = false;
                    return;
                }
                if (!Values.isProcessing()) {
                    if (updatedTotal <= commonValues.getPageCount()) {
                        if (commonValues.isMultiTiff()) {
                            commonValues.setTiffImageToLoad(lastPageDecoded - 1 + count);
                            JavaFXPageNavigator.drawMultiPageTiff(commonValues, decode_pdf);
                            commonValues.setCurrentPage(updatedTotal);
                            lastPageDecoded = commonValues.getTiffImageToLoad() + 1;
                            currentGUI.setPageNumber();
                        } else {
                            if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                                if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || decode_pdf.getDisplayView() != 4) {
                                    if (updatedTotal > commonValues.getPageCount()) {
                                        updatedTotal = commonValues.getPageCount();
                                    }
                                    if ((updatedTotal & 1) == 1 && updatedTotal != 1) {
                                        --updatedTotal;
                                    }
                                    if (decode_pdf.getDisplayView() == 4) {
                                        count = updatedTotal / 2 - commonValues.getCurrentPage() / 2;
                                    }
                                } else {
                                    if ((updatedTotal & 1) == 0) {
                                        --updatedTotal;
                                    }
                                    count = (updatedTotal + 1) / 2 - (commonValues.getCurrentPage() + 1) / 2;
                                }
                            }
                            commonValues.setCurrentPage(updatedTotal);
                            if (decode_pdf.getDisplayView() == 2 || decode_pdf.getDisplayView() == 3) {
                                currentGUI.decodePage();
                                currentGUI.setPageNumber();
                                pageChanging = false;
                                return;
                            }
                            currentGUI.resetStatusMessage("Loading Page " + commonValues.getCurrentPage());
                            decode_pdf.setPageParameters(currentGUI.getScaling(), commonValues.getCurrentPage());
                            if (commonValues.isPDF()) {
                                currentGUI.decodePage();
                            }
                        }
                    }
                } else {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                }
            } else {
                if (!decode_pdf.isPageAvailable(updatedTotal)) {
                    currentGUI.showMessageDialog("Page " + updatedTotal + " is not yet loaded");
                    pageChanging = false;
                    return;
                }
                if (!Values.isProcessing()) {
                    if (updatedTotal >= 1) {
                        if (commonValues.isMultiTiff()) {
                            commonValues.setTiffImageToLoad(lastPageDecoded - 1 + count);
                            JavaFXPageNavigator.drawMultiPageTiff(commonValues, decode_pdf);
                            commonValues.setCurrentPage(updatedTotal);
                            lastPageDecoded = commonValues.getTiffImageToLoad() + 1;
                            currentGUI.setPageNumber();
                        } else {
                            if (decode_pdf.getDisplayView() == 4 || decode_pdf.getDisplayView() == 3) {
                                if (decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || decode_pdf.getDisplayView() != 4) {
                                    if (count == -1) {
                                        --updatedTotal;
                                    }
                                    if (updatedTotal < 1) {
                                        updatedTotal = 1;
                                    }
                                    if ((updatedTotal & 1) == 1 && updatedTotal != 1) {
                                        --updatedTotal;
                                    }
                                    if (decode_pdf.getDisplayView() == 4) {
                                        count = updatedTotal / 2 - commonValues.getCurrentPage() / 2;
                                    }
                                } else {
                                    if ((updatedTotal & 1) == 0) {
                                        --updatedTotal;
                                    }
                                    if (decode_pdf.getDisplayView() == 4) {
                                        count = (updatedTotal + 1) / 2 - (commonValues.getCurrentPage() + 1) / 2;
                                    }
                                }
                            }
                            commonValues.setCurrentPage(updatedTotal);
                            if (decode_pdf.getDisplayView() == 2 || decode_pdf.getDisplayView() == 3) {
                                currentGUI.decodePage();
                                currentGUI.setPageNumber();
                                pageChanging = false;
                                return;
                            }
                            currentGUI.resetStatusMessage("loading page " + commonValues.getCurrentPage());
                            decode_pdf.setPageParameters(currentGUI.getScaling(), commonValues.getCurrentPage());
                            if (commonValues.isPDF()) {
                                currentGUI.decodePage();
                            }
                        }
                    }
                } else {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                }
            }
            if (currentGUI.getThumbnailScrollBar() != null) {
                currentGUI.setThumbnailScrollBarValue(commonValues.getCurrentPage() - 1);
            }
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
            currentGUI.setPageNumber();
            pageChanging = false;
        }
    }

    public static void drawMultiPageTiff(Values commonValues, PdfDecoderInt decode_pdf) {
    }

    public static void setPageTurnAnimating(boolean a, GUIFactory currentGUI) {
        pageTurnAnimating = a;
        if (a) {
            currentGUI.getButtons().getButton(53).setEnabled(false);
            currentGUI.getButtons().getButton(52).setEnabled(false);
            currentGUI.getButtons().getButton(54).setEnabled(false);
            currentGUI.getButtons().getButton(51).setEnabled(false);
            currentGUI.getButtons().getButton(55).setEnabled(false);
            currentGUI.getButtons().getButton(50).setEnabled(false);
        } else {
            currentGUI.getButtons().hideRedundentNavButtons(currentGUI);
        }
    }

    public static boolean getPageTurnAnimating() {
        return pageTurnAnimating;
    }

    public static void setLastPageDecoded(int x) {
        lastPageDecoded = x;
    }

    public static TiffHelper getTiffHelper() {
        return tiffHelper;
    }

    public static void setTiffHelper(TiffHelper tiffHelp) {
        tiffHelper = tiffHelp;
    }

    static {
        lastPageDecoded = -1;
    }
}

