/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jpedal.examples.viewer.Values;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class JavaFXSaveFile {
    public static void execute(Object[] args, GUIFactory currentGUI, Values commonValues) {
        if (args == null) {
            JavaFXSaveFile.saveFile(currentGUI, commonValues);
        }
    }

    private static void saveFile(GUIFactory currentGUI, Values commonValues) {
        boolean finished = false;
        while (!finished) {
            block9: {
                FileChooser fileChooser = new FileChooser();
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("PDF file (*.pdf)", new String[]{"*.pdf"}), new FileChooser.ExtensionFilter("FDF file (*.fdf)", new String[]{"*.fdf"})});
                String fileName = new File(commonValues.getSelectedFile()).getName();
                fileChooser.setInitialFileName(fileName);
                File file = fileChooser.showSaveDialog((Window)((Stage)currentGUI.getFrame()));
                FileInputStream fis = null;
                FileOutputStream fos = null;
                if (file != null) {
                    int n;
                    String fileToSave = file.getAbsolutePath();
                    if (!fileToSave.endsWith(".pdf")) {
                        fileToSave = fileToSave + ".pdf";
                        file = new File(fileToSave);
                    }
                    if (fileToSave.equals(commonValues.getSelectedFile())) {
                        return;
                    }
                    if (file.exists() && (n = currentGUI.showConfirmDialog(fileToSave + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                    try {
                        int bytes_read;
                        fis = new FileInputStream(commonValues.getSelectedFile());
                        fos = new FileOutputStream(fileToSave);
                        byte[] buffer = new byte[4096];
                        while ((bytes_read = fis.read(buffer)) != -1) {
                            fos.write(buffer, 0, bytes_read);
                        }
                    }
                    catch (Exception e1) {
                        currentGUI.showMessageDialog(Messages.getMessage("PdfViewerException.NotSaveInternetFile") + ' ' + e1);
                    }
                    try {
                        fis.close();
                        fos.close();
                    }
                    catch (Exception e2) {
                        if (!LogWriter.isOutput()) break block9;
                        LogWriter.writeLog("Exception attempting to Read File: " + e2);
                    }
                }
            }
            finished = true;
        }
    }
}

