/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIDisplay;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.RecentDocumentsFactory;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.gui.CommandListener;
import org.jpedal.examples.viewer.gui.FXAdditionalData;
import org.jpedal.examples.viewer.gui.generic.GUICombo;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.gui.generic.GUIOutline;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.external.AnnotationHandler;
import org.jpedal.external.CustomMessageHandler;
import org.jpedal.gui.GUIFactory;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.StatusBar;
import org.jpedal.linear.LinearThread;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.StringUtils;

public abstract class GUI
implements GUIFactory {
    protected static int expandedSize = 190;
    protected static int collapsedSize = 30;
    boolean isJavaFX;
    public static String windowTitle;
    protected RecentDocumentsFactory recent;
    protected CommandListener currentCommandListener;
    protected Commands currentCommands;
    protected CustomMessageHandler customMessageHandler;
    public static boolean showMessages;
    protected GUIMenuItems menuItems;
    protected PdfLayerList layersObject;
    protected boolean finishedDecoding;
    public static final int CURSOR = 1;
    public static final int GRAB_CURSOR = 1;
    public static final int GRABBING_CURSOR = 2;
    public static final int DEFAULT_CURSOR = 3;
    public static final int PAN_CURSOR = 4;
    public static final int PAN_CURSORL = 5;
    public static final int PAN_CURSORTL = 6;
    public static final int PAN_CURSORT = 7;
    public static final int PAN_CURSORTR = 8;
    public static final int PAN_CURSORR = 9;
    public static final int PAN_CURSORBR = 10;
    public static final int PAN_CURSORB = 11;
    public static final int PAN_CURSORBL = 12;
    protected Font textFont = new Font("Serif", 0, 12);
    protected Font headFont = new Font("SansSerif", 1, 14);
    protected boolean previewOnSingleScroll = true;
    protected static final int glowThickness = 11;
    protected final Color glowOuterColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    protected final Color glowInnerColor = new Color(0.8f, 0.75f, 0.45f, 0.8f);
    private boolean commandInThread;
    private boolean executingCommand;
    protected boolean hiResPrinting;
    protected Map objs;
    protected boolean bookmarksGenerated;
    protected GUISearchWindow searchFrame;
    protected String pageTitle;
    protected String bookmarksTitle;
    protected String signaturesTitle;
    protected String layersTitle;
    public static final boolean debugFX = false;
    protected PdfDecoderInt decode_pdf;
    protected static final int minimumScreenWidth = 700;
    protected GUIOutline tree;
    protected boolean allowScrolling = true;
    protected boolean confirmClose;
    protected float[] scalingFloatValues = new float[]{1.0f, 1.0f, 1.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
    protected float scaling = 1.0f;
    protected static int inset;
    protected int rotation;
    protected GUICombo rotationBox;
    protected GUICombo qualityBox;
    protected GUICombo scalingBox;
    protected static int defaultSelection;
    protected final Values commonValues;
    protected final GUIThumbnailPanel thumbnails;
    protected final PropertiesFile properties;
    protected String propValue;
    protected String propValue2;

    public GUI(PdfDecoderInt decode_pdf, Values commonValues, GUIThumbnailPanel thumbnails, PropertiesFile properties) {
        this.decode_pdf = decode_pdf;
        this.commonValues = commonValues;
        this.thumbnails = thumbnails;
        this.properties = properties;
    }

    public boolean useHiResPrinting() {
        return this.hiResPrinting;
    }

    public void setHiResPrinting(boolean hiResPrinting) {
        this.hiResPrinting = hiResPrinting;
    }

    public void setProperties(String item, boolean value) {
        this.properties.setValue(item, String.valueOf(value));
    }

    public void setPreferences(int dpi, int search, int border, boolean scroll, int pageMode, boolean updateDefaultValue, int maxNoOfMultiViewers, boolean useHiResPrinting) {
        this.decode_pdf.setBorderPresent(border == 1);
        this.properties.setValue("borderType", String.valueOf(border));
        this.allowScrolling = scroll;
        this.properties.setValue("autoScroll", String.valueOf(scroll));
        this.decode_pdf.getDPIFactory().setDpi(dpi);
        this.properties.setValue("resolution", String.valueOf(dpi));
        if (pageMode < 1 || pageMode > 5) {
            pageMode = 1;
        }
        this.decode_pdf.setPageMode(pageMode);
        this.properties.setValue("startView", String.valueOf(pageMode));
        String propValue = this.properties.getValue("searchWindowType");
        if (!propValue.isEmpty() && !propValue.equals(String.valueOf(search)) && showMessages) {
            ShowGUIMessage.showGUIMessage(Messages.getMessage("PageLayoutViewMenu.ResetSearch"), null);
        }
        this.properties.setValue("searchWindowType", String.valueOf(search));
        this.properties.setValue("automaticupdate", String.valueOf(updateDefaultValue));
        this.commonValues.setMaxMiltiViewers(maxNoOfMultiViewers);
        this.properties.setValue("maxmultiviewers", String.valueOf(maxNoOfMultiViewers));
        this.hiResPrinting = useHiResPrinting;
        this.properties.setValue("useHiResPrinting", String.valueOf(useHiResPrinting));
    }

    @Override
    public boolean allowScrolling() {
        return this.allowScrolling;
    }

    @Override
    public boolean confirmClose() {
        return this.confirmClose;
    }

    @Override
    public void setAutoScrolling(boolean allowScrolling) {
        this.allowScrolling = allowScrolling;
    }

    @Override
    public void toogleAutoScrolling() {
        this.allowScrolling = !this.allowScrolling;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    @Override
    public Values getValues() {
        return this.commonValues;
    }

    protected void addCombo(String title, String tooltip, int ID2) {
        GUICombo combo = null;
        switch (ID2) {
            case 250: {
                combo = this.qualityBox;
                break;
            }
            case 252: {
                combo = this.scalingBox;
                break;
            }
            case 251: {
                combo = this.rotationBox;
            }
        }
        combo.setID(ID2);
        if (!tooltip.isEmpty()) {
            combo.setToolTipText(tooltip);
        }
        this.addGUIComboBoxes(combo);
        this.addComboListenerAndLabel(combo, title);
    }

    @Override
    public Map getHotspots() {
        return Collections.unmodifiableMap(this.objs);
    }

    public void setScaling(float s) {
        this.scaling = s;
        this.scalingBox.setSelectedIndex((int)this.scaling);
    }

    public static int getPDFDisplayInset() {
        return inset;
    }

    public void createUniqueAnnotationIcons() {
        if (this.objs == null) {
            this.objs = new HashMap();
        } else {
            this.objs.clear();
        }
        ((AnnotationHandler)this.decode_pdf.getExternalHandler(25)).handleAnnotations(this.decode_pdf, this.objs, this.commonValues.getCurrentPage());
    }

    public void setDpi(int dpi) {
        this.decode_pdf.getDPIFactory().setDpi(dpi);
    }

    @Override
    public void dispose() {
        this.tree = null;
        this.scalingFloatValues = null;
        this.rotationBox = null;
        this.qualityBox = null;
        this.scalingBox = null;
    }

    public void init(Commands currentCommands) {
        this.currentCommandListener = new CommandListener(currentCommands);
        this.customMessageHandler = (CustomMessageHandler)this.decode_pdf.getExternalHandler(15);
        if (this.customMessageHandler != null) {
            DecoderOptions.showErrorMessages = false;
            showMessages = false;
        }
        try {
            String val;
            this.propValue = this.properties.getValue("pageInsets");
            if (!this.propValue.isEmpty()) {
                inset = Integer.parseInt(this.propValue);
            }
            this.propValue = this.properties.getValue("changeTextAndLineart");
            if (!this.propValue.isEmpty() && this.propValue.equalsIgnoreCase("true")) {
                currentCommands.executeCommand(713, new Object[]{Boolean.parseBoolean(this.propValue)});
            }
            this.propValue = this.properties.getValue("windowTitle");
            windowTitle = !this.propValue.isEmpty() ? this.propValue : "LGPL PDF JavaFX Viewer 6.6b14";
            this.propValue = this.properties.getValue("vbgColor");
            if (!this.propValue.isEmpty()) {
                currentCommands.executeCommand(709, new Object[]{Integer.parseInt(this.propValue)});
            }
            this.propValue = this.properties.getValue("replaceDocumentTextColors");
            if (!this.propValue.isEmpty() && this.propValue.equalsIgnoreCase("true")) {
                this.propValue = this.properties.getValue("vfgColor");
                if (!this.propValue.isEmpty()) {
                    currentCommands.executeCommand(712, new Object[]{Integer.parseInt(this.propValue)});
                }
            }
            this.propValue = this.properties.getValue("TextColorThreshold");
            if (!this.propValue.isEmpty()) {
                currentCommands.executeCommand(715, new Object[]{Integer.parseInt(this.propValue)});
            }
            this.propValue = this.properties.getValue("autoScroll");
            if (!this.propValue.isEmpty()) {
                this.allowScrolling = Boolean.getBoolean(this.propValue);
            }
            this.propValue = this.properties.getValue("confirmClose");
            if (!this.propValue.isEmpty()) {
                this.confirmClose = this.propValue.equals("true");
            }
            this.propValue = this.properties.getValue("resolution");
            if (!this.propValue.isEmpty()) {
                this.decode_pdf.getDPIFactory().setDpi(Integer.parseInt(this.propValue));
            }
            this.propValue = this.properties.getValue("startView");
            if (!this.propValue.isEmpty()) {
                int pageMode = Integer.parseInt(this.propValue);
                if (pageMode < 1 || pageMode > 5) {
                    pageMode = 1;
                }
                this.decode_pdf.setPageMode(pageMode);
            }
            this.propValue = this.properties.getValue("maxmuliviewers");
            if (!this.propValue.isEmpty()) {
                this.commonValues.setMaxMiltiViewers(Integer.parseInt(this.propValue));
            }
            this.propValue = this.properties.getValue("useHiResPrinting");
            if (!this.propValue.isEmpty()) {
                this.hiResPrinting = Boolean.valueOf(this.propValue);
            }
            if (!(val = this.properties.getValue("highlightBoxColor")).isEmpty()) {
                DecoderOptions.highlightColor = new Color(Integer.parseInt(val));
            }
            this.propValue = this.properties.getValue("highlightTextColor");
            if (!this.propValue.isEmpty()) {
                DecoderOptions.backgroundColor = new Color(Integer.parseInt(this.propValue));
            }
            this.propValue = this.properties.getValue("showMouseSelectionBox");
            if (!this.propValue.isEmpty()) {
                DecoderOptions.showMouseBox = Boolean.valueOf(this.propValue);
            }
            this.propValue = this.properties.getValue("enhancedViewerMode");
            if (!this.propValue.isEmpty()) {
                this.decode_pdf.useNewGraphicsMode(Boolean.valueOf(this.propValue));
            }
            this.propValue = this.properties.getValue("highlightComposite");
            if (!this.propValue.isEmpty()) {
                float value = Float.parseFloat(this.propValue);
                if (value > 1.0f) {
                    value = 1.0f;
                }
                if (value < 0.0f) {
                    value = 0.0f;
                }
                DecoderOptions.highlightComposite = value;
            }
            this.propValue = this.properties.getValue("borderType");
            if (!this.propValue.isEmpty()) {
                this.decode_pdf.setBorderPresent(Integer.parseInt(this.propValue) == 1);
            }
            this.propValue = this.properties.getValue("allowCursorToChange");
            if (!this.propValue.isEmpty()) {
                GUIDisplay.allowChangeCursor = this.propValue.equalsIgnoreCase("true");
            }
            this.propValue = this.properties.getValue("invertHighlights");
            if (!this.propValue.isEmpty()) {
                BaseDisplay.invertHighlight = Boolean.valueOf(this.propValue);
            }
            this.propValue = this.properties.getValue("enhancedFacingMode");
            if (!this.propValue.isEmpty()) {
                GUIDisplay.default_turnoverOn = Boolean.valueOf(this.propValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentCommands = currentCommands;
        this.setViewerTitle(windowTitle);
        this.setViewerIcon();
        this.decode_pdf.setInset(inset, inset);
    }

    @Override
    public boolean isCommandInThread() {
        return this.commandInThread;
    }

    @Override
    public void setCommandInThread(boolean b) {
        this.commandInThread = b;
    }

    @Override
    public boolean isExecutingCommand() {
        return this.executingCommand;
    }

    @Override
    public void setExecutingCommand(boolean b) {
        this.executingCommand = b;
    }

    protected static void getFlattenedTreeNodes(TreeNode theNode, List items) {
        items.add(theNode);
        Enumeration<? extends TreeNode> theChildren = theNode.children();
        while (theChildren.hasMoreElements()) {
            GUI.getFlattenedTreeNodes(theChildren.nextElement(), items);
        }
    }

    public int getGlowThickness() {
        return 11;
    }

    public Color getGlowOuterColor() {
        return this.glowOuterColor;
    }

    public Color getGlowInnerColor() {
        return this.glowInnerColor;
    }

    @Override
    public void setSearchFrame(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
    }

    protected void setRotation() {
        if (this.rotation > 360) {
            this.rotation -= 360;
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (Values.isProcessing() || !Viewer.isFX()) {
            // empty if block
        }
    }

    public int getSelectedComboIndex(int ID2) {
        switch (ID2) {
            case 250: {
                return this.qualityBox.getSelectedIndex();
            }
            case 252: {
                return this.scalingBox.getSelectedIndex();
            }
            case 251: {
                return this.rotationBox.getSelectedIndex();
            }
        }
        return -1;
    }

    public void setSelectedComboIndex(int ID2, int index) {
        switch (ID2) {
            case 250: {
                this.qualityBox.setSelectedIndex(index);
                break;
            }
            case 252: {
                this.scalingBox.setSelectedIndex(index);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedIndex(index);
            }
        }
    }

    public Object getSelectedComboItem(int ID2) {
        switch (ID2) {
            case 250: {
                return this.qualityBox.getSelectedItem();
            }
            case 252: {
                return this.scalingBox.getSelectedItem();
            }
            case 251: {
                return this.rotationBox.getSelectedItem();
            }
        }
        return null;
    }

    public void setSelectedComboItem(int ID2, String index) {
        switch (ID2) {
            case 250: {
                this.qualityBox.setSelectedItem(index);
                break;
            }
            case 252: {
                if (StringUtils.isNumber(index)) {
                    index = index + '%';
                }
                this.scalingBox.setSelectedItem(index);
                break;
            }
            case 251: {
                this.rotationBox.setSelectedItem(index);
            }
        }
    }

    public void setPdfDecoder(PdfDecoderInt decode_pdf) {
        this.decode_pdf = decode_pdf;
    }

    public void decodeGUIPage(GUIFactory currentGUI) {
        block36: {
            FXAdditionalData additionaValuesforPage;
            AcroRenderer formRenderer;
            LinearThread linearizedBackgroundRenderer;
            this.decode_pdf.getPages().setHighlightedImage(null);
            currentGUI.resetRotationBox();
            if (this.thumbnails.isShownOnscreen()) {
                this.thumbnails.terminateDrawing();
            }
            if (this.thumbnails.isShownOnscreen() && ((linearizedBackgroundRenderer = (LinearThread)this.decode_pdf.getJPedalObject(-1276915978)) == null || linearizedBackgroundRenderer != null && !linearizedBackgroundRenderer.isAlive())) {
                currentGUI.setupThumbnailPanel();
            }
            if (this.decode_pdf.getDisplayView() == 1) {
                currentGUI.setPageCounterText(PageCounter.PAGECOUNTER2, String.valueOf(this.commonValues.getCurrentPage()));
                currentGUI.setPageCounterText(PageCounter.PAGECOUNTER3, Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.commonValues.getPageCount());
            }
            currentGUI.updateTextBoxSize();
            currentGUI.setTabsNotInitialised(false);
            this.decode_pdf.setExtractionMode(65);
            this.decode_pdf.getTextLines().clearHighlights();
            if (this.decode_pdf.getDisplayView() == 4) {
                currentGUI.scaleAndRotate();
                currentGUI.scrollToPage(this.commonValues.getCurrentPage());
                this.decode_pdf.getPages().decodeOtherPages(this.commonValues.getCurrentPage(), this.commonValues.getPageCount());
                return;
            }
            if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 3) {
                currentGUI.scaleAndRotate();
                currentGUI.scrollToPage(this.commonValues.getCurrentPage());
                if (!Viewer.isFX()) {
                    return;
                }
            } else if (this.decode_pdf.getDisplayView() == 5) {
                return;
            }
            currentGUI.resetComboBoxes(false);
            currentGUI.getButtons().setPageLayoutButtonsEnabled(false);
            Values.setProcessing(true);
            try {
                String status;
                if (!Viewer.isFX()) {
                    ((StatusBar)currentGUI.getStatusBar()).updateStatus("Decoding Page", 0);
                }
                try {
                    this.decode_pdf.decodePage(this.commonValues.getCurrentPage());
                    this.decode_pdf.waitForDecodingToFinish();
                    if (this.decode_pdf.getPageDecodeStatus(64)) {
                        status = "Too many shapes on page";
                        currentGUI.showMessageDialog("Too many shapes on page");
                    }
                    if (!this.decode_pdf.getPageDecodeStatus(2)) {
                        status = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                        currentGUI.showMessageDialog(status);
                    }
                    if (this.decode_pdf.getPageDecodeStatus(32)) {
                        status = Messages.getMessage("PdfCustomGui.ttHintingRequired");
                        currentGUI.showMessageDialog(status);
                    }
                    if (this.decode_pdf.getPageDecodeStatus(4)) {
                        status = "This page contains non-embedded CID fonts \n" + this.decode_pdf.getPageDecodeStatusReport(4) + "\nwhich may need mapping to display correctly.\n" + "See http://www.idrsolutions.com/how-do-fonts-work";
                        currentGUI.showMessageDialog(status);
                    }
                    if (this.decode_pdf.getExternalHandler(25) != null) {
                        FormFactory formfactory = this.decode_pdf.getFormRenderer().getFormFactory();
                        if (formfactory.getType() == 1) {
                            Runnable doPaintComponent2 = new Runnable(){

                                @Override
                                public void run() {
                                    GUI.this.createUniqueAnnotationIcons();
                                }
                            };
                            SwingUtilities.invokeLater(doPaintComponent2);
                        } else {
                            this.createUniqueAnnotationIcons();
                        }
                    }
                    if (!Viewer.isFX()) {
                        ((StatusBar)currentGUI.getStatusBar()).updateStatus("Displaying Page", 0);
                    }
                }
                catch (Exception e) {
                    System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + e + ' ' + Messages.getMessage("PdfViewerError.DecodePage"));
                    e.printStackTrace();
                    Values.setProcessing(false);
                }
                if (DecoderOptions.showErrorMessages && (status = this.decode_pdf.getPageDecodeReport()).contains("java.lang.OutOfMemoryError")) {
                    status = Messages.getMessage("PdfViewer.OutOfMemoryDisplayError") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError1") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError2") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError3") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError4") + Messages.getMessage("PdfViewer.OutOfMemoryDisplayError5");
                    currentGUI.showMessageDialog(status);
                }
                Values.setProcessing(false);
                currentGUI.setViewerTitle(null);
                OpenFile.setPageProperties(this.getSelectedComboItem(251), this.getSelectedComboItem(252));
                if (this.decode_pdf.getPageCount() > 0 && this.thumbnails.isShownOnscreen() && this.decode_pdf.getDisplayView() == 1) {
                    this.thumbnails.generateOtherVisibleThumbnails(this.commonValues.getCurrentPage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Values.setProcessing(false);
                currentGUI.setViewerTitle(null);
            }
            currentGUI.selectBookmark();
            if (!Viewer.isFX()) {
                ((StatusBar)currentGUI.getStatusBar()).setProgress(100);
            }
            currentGUI.setMultibox(new int[0]);
            currentGUI.resetComboBoxes(true);
            if (this.decode_pdf.getPageCount() > 1) {
                currentGUI.getButtons().setPageLayoutButtonsEnabled(true);
            }
            this.commonValues.setFormsChanged(false);
            boolean showMessage = false;
            String formsFlag = System.getProperty("org.jpedal.listenforms");
            if (formsFlag != null) {
                showMessage = true;
            }
            if ((formRenderer = this.decode_pdf.getFormRenderer()) == null) {
                return;
            }
            Object[] formsOnPage = formRenderer.getFormComponents(null, ReturnValues.FORM_NAMES, this.commonValues.getCurrentPage());
            if (formsOnPage == null) {
                if (showMessage) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
                }
                return;
            }
            int formCount = formsOnPage.length;
            JPanel formPanel = new JPanel();
            if (showMessage) {
                formPanel.setLayout(new BoxLayout(formPanel, 1));
                JLabel formHeader = new JLabel("This page contains " + formCount + " form objects");
                formHeader.setFont(this.headFont);
                formPanel.add(formHeader);
                formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
                JTextPane instructions = new JTextPane();
                instructions.setPreferredSize(new Dimension(450, 180));
                instructions.setEditable(false);
                instructions.setText("This provides a simple example of Forms handling. We have added a listener to each form so clicking on it shows the form name.\n\nCode is in addExampleListeners() in org.examples.viewer.Viewer\n\nThis could be easily be extended to interface with a database directly or collect results on an action and write back using itext.\n\nForms have been converted into Swing components and are directly accessible (as is the original data).\n\nIf you don't like the standard SwingSet you can replace with your own set.");
                instructions.setFont(this.textFont);
                formPanel.add(instructions);
                formPanel.add(Box.createRigidArea(new Dimension(10, 10)));
            }
            if (showMessage) {
                final JDialog displayFrame = new JDialog((Frame)null, true);
                displayFrame.setDefaultCloseOperation(2);
                if (this.commonValues.getModeOfOperation() != 1) {
                    displayFrame.setLocationRelativeTo(null);
                    displayFrame.setLocation(((Container)currentGUI.getFrame()).getLocationOnScreen().x + 10, ((Container)currentGUI.getFrame()).getLocationOnScreen().y + 10);
                }
                JScrollPane scroll = new JScrollPane();
                scroll.getViewport().add(formPanel);
                scroll.setHorizontalScrollBarPolicy(30);
                scroll.setVerticalScrollBarPolicy(20);
                displayFrame.setSize(500, 500);
                displayFrame.setTitle("List of forms on this page");
                displayFrame.getContentPane().setLayout(new BorderLayout());
                displayFrame.getContentPane().add((Component)scroll, "Center");
                JPanel buttonBar = new JPanel();
                buttonBar.setLayout(new BorderLayout());
                displayFrame.getContentPane().add((Component)buttonBar, "South");
                JButton no = new JButton(Messages.getMessage("PdfViewerButton.Close"));
                no.setFont(new Font("SansSerif", 0, 12));
                buttonBar.add((Component)no, "East");
                no.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        displayFrame.dispose();
                    }
                });
                displayFrame.setVisible(true);
            }
            if (this.isJavaFX && (additionaValuesforPage = (FXAdditionalData)this.decode_pdf.getExternalHandler(33)) != null) {
                DynamicVectorRenderer fxDisplay = this.decode_pdf.getDynamicRenderer();
                try {
                    fxDisplay.drawAdditionalObjectsOverPage(additionaValuesforPage.getType(), null, additionaValuesforPage.getObj());
                }
                catch (PdfException ex) {
                    if (!LogWriter.isOutput()) break block36;
                    LogWriter.writeLog("Exception attempting to draw additional objects " + ex);
                }
            }
        }
        if (currentGUI.getFrame() != null) {
            currentGUI.reinitialiseTabs(currentGUI.getDividerLocation() > currentGUI.getStartSize());
        }
        this.finishedDecoding = true;
        currentGUI.scaleAndRotate();
    }

    @Override
    public void setViewerTitle(String title) {
        if (title == null) {
            title = windowTitle + ' ' + this.commonValues.getSelectedFile();
            PdfObject linearObj = (PdfObject)this.decode_pdf.getJPedalObject(2004845231);
            if (linearObj != null) {
                LinearThread linearizedBackgroundReaderer = (LinearThread)this.decode_pdf.getJPedalObject(-1276915978);
                title = linearizedBackgroundReaderer != null && linearizedBackgroundReaderer.isAlive() ? title + " (still loading)" : title + " (Linearized)";
            }
            if (this.commonValues.isFormsChanged()) {
                title = "* " + title;
            }
        }
        this.setTitle(title);
    }

    protected void setTitle(String title) {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setViewerIcon() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void addComboListenerAndLabel(GUICombo combo, String title) {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void addGUIComboBoxes(GUICombo combo) {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupCenterPanelBackground() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupComboBoxes() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupKeyboardControl() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupPDFDisplayPane() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupBorderPanes() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void createOtherToolBars() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupBottomToolBarItems() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupPDFBorder() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void createTopMenuBar() {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void createMainViewerWindow(int width, int height) {
        throw new UnsupportedOperationException("Should be over-ridden in SwingGUI or JavaFxGUI");
    }

    protected void setupSidebarTitles() {
        this.pageTitle = Messages.getMessage("PdfViewerJPanel.thumbnails");
        this.bookmarksTitle = Messages.getMessage("PdfViewerJPanel.bookmarks");
        this.layersTitle = Messages.getMessage("PdfViewerJPanel.layers");
        this.signaturesTitle = Messages.getMessage("PdfViewerJPanel.signatures");
    }

    static {
        showMessages = true;
        inset = 25;
    }

    public static enum PageCounter {
        PAGECOUNTER1,
        PAGECOUNTER2,
        PAGECOUNTER3,
        ALL;

    }

    public static enum ScrollPolicy {
        VERTICAL_AS_NEEDED,
        HORIZONTAL_AS_NEEDED,
        VERTICAL_NEVER,
        HORIZONTAL_NEVER;

    }
}

