/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.BaseTransferHandler;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;

public class SingleViewTransferHandler
extends BaseTransferHandler {
    public SingleViewTransferHandler(Values commonValues, GUIFactory currentGUI, Commands currentCommands) {
        super(commonValues, currentGUI, currentCommands);
    }

    @Override
    public boolean importData(JComponent src, Transferable transferable) {
        try {
            Object dragImport = this.getImport(transferable);
            if (dragImport instanceof String) {
                String url = (String)dragImport;
                if (url.indexOf("file:/") != url.lastIndexOf("file:/")) {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                } else {
                    this.openFile(url);
                }
            } else if (dragImport instanceof List) {
                List files = (List)dragImport;
                if (files.size() == 1) {
                    File file = (File)files.get(0);
                    this.openFile(file.getAbsolutePath());
                } else {
                    this.currentGUI.showMessageDialog("You may only import 1 file at a time");
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected void openFile(String file) throws PdfException {
        boolean isValid;
        String testFile = file.toLowerCase();
        boolean bl = isValid = testFile.endsWith(".pdf") || testFile.endsWith(".fdf") || testFile.endsWith(".tif") || testFile.endsWith(".tiff") || testFile.endsWith(".png") || testFile.endsWith(".jpg") || testFile.endsWith(".jpeg");
        if (isValid) {
            this.currentCommands.handleTransferedFile(file);
        } else {
            this.currentGUI.showMessageDialog("You may only import a valid PDF or image");
        }
    }
}

