/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.awt.Font;
import java.awt.image.BufferedImage;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.jpedal.PdfDecoderInt;
import org.jpedal.ThumbnailDecoder;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Values;
import org.jpedal.objects.PdfPageData;

public class JavaFXThumbnailPanel
extends Tab
implements GUIThumbnailPanel {
    private static final boolean debugThumbnails = false;
    private boolean showThumbnailsdefault;
    private boolean generateOtherVisibleThumbnails;
    private boolean showThumbnails;
    private final PdfDecoderInt decode_pdf;
    private final ThumbnailDecoder thumbDecoder;
    private static final int thumbH = 100;
    private static final int thumbW = 70;
    private Task<Void> worker;
    private boolean drawing;
    private static final boolean debug = true;
    private boolean interrupt;
    private Button[] pageButton;
    private final VBox content;
    private final ScrollPane scroll;
    private int lastPage;
    private boolean[] isLandscape;
    private int[] pageHeight;
    private BufferedImage[] images;
    private boolean[] buttonDrawn;
    private final ThumbPainter painter;
    private final BorderListener border;
    private final Border selectedBorder;
    private final Border hoverBorder;
    private final Border emptyBorder;

    public JavaFXThumbnailPanel(final PdfDecoderInt decode_pdf) {
        this.showThumbnails = this.showThumbnailsdefault = true;
        this.border = new BorderListener();
        this.painter = new ThumbPainter();
        this.decode_pdf = decode_pdf;
        this.thumbDecoder = new ThumbnailDecoder(decode_pdf);
        this.content = new VBox();
        this.scroll = new ScrollPane((Node)this.content);
        this.content.setAlignment(Pos.CENTER);
        this.scroll.viewportBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds oldb, Bounds newb) {
                JavaFXThumbnailPanel.this.content.setPrefWidth(newb.getWidth());
                if (JavaFXThumbnailPanel.this.drawing) {
                    JavaFXThumbnailPanel.this.terminateDrawing();
                }
                decode_pdf.waitForDecodingToFinish();
                if (decode_pdf.isOpen()) {
                    JavaFXThumbnailPanel.this.drawThumbnails();
                }
            }
        });
        this.selectedBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.RED, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.hoverBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.emptyBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(2.0))});
        this.setContent((Node)this.scroll);
    }

    @Override
    public boolean isShownOnscreen() {
        return this.showThumbnails;
    }

    @Override
    public void terminateDrawing() {
        this.generateOtherVisibleThumbnails = false;
        if (this.drawing) {
            this.interrupt = true;
        }
    }

    @Override
    public void setIsDisplayedOnscreen(boolean b) {
        this.showThumbnails = b;
    }

    @Override
    public Object[] getButtons() {
        return this.pageButton;
    }

    @Override
    public void addComponentListener() {
        this.scroll.vvalueProperty().addListener((ChangeListener)this.painter);
    }

    @Override
    public synchronized void generateOtherVisibleThumbnails(int currentPage) {
        this.generateOtherVisibleThumbnails = true;
        if (currentPage == -1 || currentPage == this.lastPage || this.pageButton == null) {
            return;
        }
        int count = this.decode_pdf.getPageCount();
        for (int i = 0; i < count; ++i) {
            if (!this.generateOtherVisibleThumbnails) {
                return;
            }
            this.pageButton[i].setBorder(this.emptyBorder);
        }
        if (currentPage - 1 < this.pageButton.length && count > 1 && currentPage > 0) {
            this.pageButton[currentPage - 1].setBorder(this.selectedBorder);
        }
        double pos = this.scroll.getVmax() / (double)count * (double)(currentPage - 1);
        this.scroll.setVvalue(pos);
        if (!this.generateOtherVisibleThumbnails) {
            return;
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        if (!this.generateOtherVisibleThumbnails) {
            return;
        }
        this.drawThumbnails();
    }

    @Override
    public void setupThumbnails(int pages, Font textFont, String message, PdfPageData pageData) {
        this.lastPage = -1;
        this.content.getChildren().clear();
        Image blankPortrait = JavaFXThumbnailPanel.createBlankThumbnail(70, 100);
        Image blankLandscape = JavaFXThumbnailPanel.createBlankThumbnail(100, 70);
        this.isLandscape = new boolean[pages];
        this.pageHeight = new int[pages];
        this.pageButton = new Button[pages];
        this.images = new BufferedImage[pages];
        this.buttonDrawn = new boolean[pages];
        for (int i = 0; i < pages; ++i) {
            Button imageButton;
            Image usedPortrait;
            int ph;
            int page = i + 1;
            int cropWidth = pageData.getCropBoxWidth(page);
            int cropHeight = pageData.getCropBoxHeight(page);
            int rotation = pageData.getRotation(page);
            if (rotation == 0 | rotation == 180) {
                ph = pageData.getMediaBoxHeight(page);
                usedPortrait = blankPortrait;
            } else {
                ph = pageData.getMediaBoxWidth(page);
                usedPortrait = blankLandscape;
            }
            if (cropWidth > cropHeight) {
                this.pageButton[i] = imageButton = new Button(message + ' ' + page, (Node)new ImageView(usedPortrait));
                this.isLandscape[i] = true;
            } else {
                this.pageButton[i] = imageButton = new Button(message + ' ' + page, (Node)new ImageView(usedPortrait));
                this.isLandscape[i] = false;
            }
            this.pageHeight[i] = ph;
            this.pageButton[i].setContentDisplay(ContentDisplay.TOP);
            this.pageButton[i].setStyle("-fx-padding:0;-fx-background-color:transparent;");
            if (i == 0 && pages > 1) {
                this.pageButton[0].setBorder(this.selectedBorder);
            } else {
                this.pageButton[i].setBorder(this.emptyBorder);
            }
            this.pageButton[i].prefWidthProperty().bind((ObservableValue)this.content.prefWidthProperty());
            this.content.getChildren().add((Object)this.pageButton[i]);
            this.pageButton[i].setOnMouseEntered((EventHandler)this.border);
            this.pageButton[i].setOnMouseExited((EventHandler)this.border);
        }
    }

    @Override
    public void resetToDefault() {
        this.showThumbnails = this.showThumbnailsdefault;
    }

    @Override
    public void removeAllListeners() {
        this.scroll.vvalueProperty().removeListener((ChangeListener)this.painter);
        for (Button btn : this.pageButton) {
            btn.setOnMouseExited(null);
            btn.setOnMouseEntered(null);
            btn.setOnAction(null);
        }
    }

    @Override
    public void setThumbnailsEnabled(boolean newValue) {
        this.showThumbnailsdefault = newValue;
        this.showThumbnails = newValue;
    }

    @Override
    public void dispose() {
    }

    @Override
    public synchronized BufferedImage getImage(int page) {
        if (this.images == null || this.images[--page] == null) {
            if (page > -1) {
                BufferedImage image;
                int h = 100;
                if (this.isLandscape[page]) {
                    h = 70;
                }
                this.images[page] = image = this.thumbDecoder.getPageAsThumbnail(page + 1, h);
                return image;
            }
            return null;
        }
        return this.images[page];
    }

    @Override
    public void drawThumbnails() {
        if (!this.isSelected()) {
            return;
        }
        if (this.decode_pdf.isLoadingLinearizedPDF()) {
            return;
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        this.worker = new Task<Void>(){

            protected Void call() throws Exception {
                if (JavaFXThumbnailPanel.this.buttonDrawn != null && JavaFXThumbnailPanel.this.pageButton != null) {
                    JavaFXThumbnailPanel.this.drawing = true;
                    try {
                        double minY = JavaFXThumbnailPanel.this.scroll.getVvalue() * JavaFXThumbnailPanel.this.content.getHeight() - JavaFXThumbnailPanel.this.scroll.getHeight() * JavaFXThumbnailPanel.this.scroll.getVvalue();
                        Rectangle visible = new Rectangle(0.0, minY, JavaFXThumbnailPanel.this.scroll.getWidth(), JavaFXThumbnailPanel.this.scroll.getHeight());
                        int pages = JavaFXThumbnailPanel.this.decode_pdf.getPageCount();
                        for (int i = 0; i < pages; ++i) {
                            JavaFXThumbnailPanel.this.decode_pdf.waitForDecodingToFinish();
                            if (JavaFXThumbnailPanel.this.interrupt || i > JavaFXThumbnailPanel.this.pageButton.length) {
                                i = pages;
                                continue;
                            }
                            if (JavaFXThumbnailPanel.this.buttonDrawn[i] || JavaFXThumbnailPanel.this.pageButton[i] == null || !visible.intersects(JavaFXThumbnailPanel.this.pageButton[i].getBoundsInParent())) continue;
                            int h = 100;
                            if (JavaFXThumbnailPanel.this.isLandscape[i]) {
                                h = 70;
                            }
                            BufferedImage page = JavaFXThumbnailPanel.this.thumbDecoder.getPageAsThumbnail(i + 1, h);
                            if (JavaFXThumbnailPanel.this.interrupt) continue;
                            JavaFXThumbnailPanel.this.createThumbnail(page, i);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                JavaFXThumbnailPanel.this.interrupt = false;
                JavaFXThumbnailPanel.this.drawing = false;
                return null;
            }
        };
        new Thread((Runnable)this.worker, "Thumbnail Thread").start();
    }

    private static Image createBlankThumbnail(int w, int h) {
        Canvas canvas = new Canvas((double)w, (double)h);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.setFill((Paint)Color.WHITE);
        gc.fillRect(0.2, 0.2, (double)w - 0.5, (double)h - 0.5);
        gc.setFill((Paint)Color.BLACK);
        gc.strokeRect(0.2, 0.2, (double)w - 0.5, (double)h - 0.5);
        gc.strokeLine(0.0, 0.0, (double)w, (double)h);
        gc.strokeLine(0.0, (double)h, (double)w, 0.0);
        return canvas.snapshot(null, null);
    }

    private void createThumbnail(BufferedImage page, final int i) {
        if (page != null) {
            WritableImage image = SwingFXUtils.toFXImage((BufferedImage)page, null);
            if (Platform.isFxApplicationThread()) {
                ((ImageView)this.pageButton[i].getGraphic()).setImage((Image)image);
                this.buttonDrawn[i] = true;
                this.images[i] = page;
            } else {
                Platform.runLater((Runnable)new Runnable((Image)image, page){
                    final /* synthetic */ Image val$image;
                    final /* synthetic */ BufferedImage val$page;
                    {
                        this.val$image = image;
                        this.val$page = bufferedImage;
                    }

                    @Override
                    public void run() {
                        ((ImageView)JavaFXThumbnailPanel.this.pageButton[i].getGraphic()).setImage(this.val$image);
                        ((JavaFXThumbnailPanel)JavaFXThumbnailPanel.this).buttonDrawn[i] = true;
                        ((JavaFXThumbnailPanel)JavaFXThumbnailPanel.this).images[i] = this.val$page;
                    }
                });
            }
        }
    }

    private class BorderListener
    implements EventHandler<MouseEvent> {
        private BorderListener() {
        }

        public void handle(MouseEvent event) {
            Button source = (Button)event.getSource();
            boolean isSelected = source.getBorder().equals((Object)JavaFXThumbnailPanel.this.selectedBorder);
            if (event.getEventType().equals(MouseEvent.MOUSE_ENTERED) && !isSelected) {
                source.setBorder(JavaFXThumbnailPanel.this.hoverBorder);
            } else if (event.getEventType().equals(MouseEvent.MOUSE_EXITED) && !isSelected) {
                source.setBorder(JavaFXThumbnailPanel.this.emptyBorder);
            }
        }
    }

    private class ThumbPainter
    implements ChangeListener<Number> {
        private boolean requestMade;
        private final Timeline trapMultipleMovements = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)250.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!ThumbPainter.this.requestMade) {
                    ThumbPainter.this.requestMade = true;
                    if (!Values.isProcessing) {
                        if (JavaFXThumbnailPanel.this.drawing) {
                            JavaFXThumbnailPanel.this.terminateDrawing();
                        }
                        ThumbPainter.this.requestMade = false;
                        JavaFXThumbnailPanel.this.drawThumbnails();
                    }
                }
            }
        }, new KeyValue[0])});

        private ThumbPainter() {
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (this.trapMultipleMovements.getStatus() == Animation.Status.RUNNING) {
                this.trapMultipleMovements.stop();
            }
            this.trapMultipleMovements.setCycleCount(1);
            this.trapMultipleMovements.playFromStart();
        }
    }
}

