/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx.dialog;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXMessageDialog;

public class FXInputDialog
extends FXMessageDialog {
    private final StringProperty input = new SimpleStringProperty();

    public FXInputDialog(Stage parent, String message) {
        super(parent, Modality.APPLICATION_MODAL, message);
        final TextField textField = new TextField();
        BorderPane contentPane = this.getBorderPane();
        Button cancelButton = new Button("Cancel");
        this.input.bind((ObservableValue)textField.textProperty());
        textField.textProperty().set((Object)"");
        contentPane.getCenter().boundsInLocalProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds oldBounds, Bounds newBounds) {
                textField.setPrefWidth(newBounds.getWidth());
            }
        });
        cancelButton.setPrefWidth(55.0);
        cancelButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                FXInputDialog.this.cancel();
            }
        });
        this.getCenterGroup().getChildren().add((Object)textField);
        this.getButtonGroup().getChildren().add((Object)cancelButton);
    }

    public String showInputDialog() {
        this.showAndWait();
        if (this.isCancelled) {
            return null;
        }
        return (String)this.input.get();
    }
}

