/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertiesFile {
    private final String separator = System.getProperty("file.separator");
    private String userDir = System.getProperty("user.dir");
    private String configFile = this.userDir + this.separator + ".properties.xml";
    private InputStream configInputStream;
    private boolean isReadOnly;
    private Document doc;
    private static final int noOfRecentDocs = 6;
    private String[] properties = new String[]{"Flag to show popup information first time viewer is used", "showfirsttimepopup", "false", "The amount of days left of the trial", "daysLeft", "", "Show message about rhino and it's use", "showrhinomessage", "false", "Set how the search functionality is displayed\n0 : External Window\n1 : Side Tab Bar\n2 : Menu bar", "searchWindowType", "2", "Set if border should be shown\n0 : Hide Border\n1 : Show Border", "borderType", "1", "Flag to turn on hiRes printing", "useHiResPrinting", "true", "This is set the number of pixels used to represent an inch on screen", "resolution", "110", "Flag to allow cursor to change such as when over text", "allowCursorToChange", "true", "Flag to allow view to scroll when dragging the mouse", "autoScroll", "true", "No longer used, please use startView", "pageMode", "1", "Flag to allow tips to be displayed at start up", "displaytipsonstartup", "false", "Flag to allow the viewer to auto update", "automaticupdate", "true", "Value shows what version of the library is being used", "currentversion", "6.6b14", "Show message when using tiffs", "showtiffmessage", "true", "The maximum number of viewers when using the multi viewer example", "maxmultiviewers", "20", "Shows the contents of the menu bar, menubar remains but empty if set to false", "MenuBarMenu", "true", "Shows the File menu on the menu bar", "FileMenu", "true", "Shows the Open menu on the File menu", "OpenMenu", "true", "Shows the Open menuitem on the Open menu", "Open", "true", "Shows the Open url menuitem on the Open menu", "Openurl", "true", "ENDCHILDREN", "Shows the Save menuitem on the File menu", "Save", "true", "Shows the Resave forms menuitem on the File menu", "Resaveasforms", "false", "Shows the Find menuitem on the File menu", "Find", "true", "Shows the Document Properties menuitem on the File menu", "Documentproperties", "true", "Shows the Sign pdf menuitem on the File menu", "Signpdf", "true", "Shows the Print menuitem on the File menu", "Print", "true", "Shows the Recent Documents menuitem on the File menu", "Recentdocuments", "true", "Shows the Exit menuitem on the File menu", "Exit", "true", "ENDCHILDREN", "Shows the Edit menu on the menu bar", "EditMenu", "true", "Shows the Copy menuitem on the Edit menu", "Copy", "true", "Shows the Select all menuitem on the Edit menu", "Selectall", "true", "Shows the Deselect all menuitem on the Edit menu", "Deselectall", "true", "Shows the Preferences menuitem on the Edit menu", "Preferences", "true", "ENDCHILDREN", "Shows the View menu on the menu bar", "ViewMenu", "true", "Shows the Goto menu on the View menu", "GotoMenu", "true", "Shows the First Page menuitem on the GoTo menu", "Firstpage", "true", "Shows the Back Page menuitem on the GoTo menu", "Backpage", "true", "Shows the Next Page menuitem on the GoTo menu", "Forwardpage", "true", "Shows the Last Page menuitem on the GoTo menu", "Lastpage", "true", "Shows the GoTo Page menuitem on the GoTo menu", "Goto", "true", "Shows the Previous Document menuitem on the GoTo menu", "Previousdocument", "true", "Shows the Next Document menuitem on the GoTo menu", "Nextdocument", "true", "ENDCHILDREN", "Shows the PageLayout menu on the View menu", "PagelayoutMenu", "true", "Shows the Single Page Mode menuitem on the PageLayout menu", "Single", "true", "Shows the Continuous Page Mode menuitem on the PageLayout menu", "Continuous", "true", "Shows the Facing Page Mode menuitem on the PageLayout menu", "Facing", "true", "Shows the Continuous Facing Page Mode menuitem on the PageLayout menu", "Continuousfacing", "true", "Shows the PageFlow Page Mode menuitem on the PageLayout menu", "PageFlow", "true", "ENDCHILDREN", "Shows the Separate Cover menuitem on the View menu", "separateCover", "true", "Shows the Text Select Mouse Mode menuitem on the View menu", "textSelect", "true", "Shows the Pan Mouse Mode menuitem on the View menu", "panMode", "true", "Shows the Fullscreen menuitem on the View menu", "Fullscreen", "true", "ENDCHILDREN", "Shows the Window menu on the menu bar", "WindowMenu", "true", "Shows the Cascade windows menuitem on the Window menu", "Cascade", "true", "Shows the Tile windows menuitem on the Window menu", "Tile", "true", "ENDCHILDREN", "Shows the Export menu on the menu bar", "ExportMenu", "false", "Shows the Pdf menu on the Export menu", "PdfMenu", "true", "Shows the One per page menuitem on the Pdf menu", "Oneperpage", "true", "Shows the Nup menuitem on the Pdf menu", "Nup", "true", "Shows the Handouts menuitem on the Pdf menu", "Handouts", "true", "ENDCHILDREN", "Shows the Content menu on the Export menu", "ContentMenu", "true", "Shows the Images menuitem on the Content menu", "Images", "true", "Shows the Text menuitem on the Content menu", "Text", "true", "ENDCHILDREN", "Shows the Bitmap menuitem on the Export menu", "Bitmap", "true", "ENDCHILDREN", "Shows the Page Tools menu on the menu bar", "PagetoolsMenu", "false", "Shows the Rotate Page menuitem on the Page Tools menu", "Rotatepages", "true", "Shows the Delete Page menuitem on the Page Tools menu", "Deletepages", "true", "Shows the Add Page menuitem on the Page Tools menu", "Addpage", "true", "Shows the Add header and footer menuitem on the Page Tools menu", "Addheaderfooter", "true", "Shows the stamp text menuitem on the Page Tools menu", "Stamptext", "true", "Shows the stamp image menuitem on the Page Tools menu", "Stampimage", "false", "Shows the crop menuitem on the Page Tools menu", "Crop", "true", "ENDCHILDREN", "Shows the Help menu on the menu bar", "HelpMenu", "true", "Shows the Visit website menuitem on the help menu", "Visitwebsite", "true", "Shows the tip of the day menuitem on the help menu", "Tipoftheday", "true", "Shows the check for updates menuitem on the help menu", "Checkupdates", "true", "Shows the about menuitem on the help menu", "About", "true", "ENDCHILDREN", "ENDCHILDREN", "Show the content of the Button bar, button bar remain but empty if false", "ButtonsMenu", "true", "Show the open file button on the button bar", "Openfilebutton", "true", "Show the print button on the button bar", "Printbutton", "true", "Show the search button on the button bar", "Searchbutton", "true", "Show the document properties button on the button bar", "Propertiesbutton", "false", "Show the about button on the button bar", "Aboutbutton", "false", "Show the snapshot button on the button bar", "Snapshotbutton", "true", "Show the cursor button on the button bar", "CursorButton", "true", "Show the mouse mode button on the button bar", "MouseModeButton", "true", "ENDCHILDREN", "Show the contents of the display options bar, Display options bar remain empty if false", "DisplayOptionsMenu", "true", "Show the scaling options on the display options bar", "Scalingdisplay", "true", "Show the rotation options on the display options bar", "Rotationdisplay", "true", "Show the image optimisation options on the display options bar", "Imageopdisplay", "false", "Show the progress bar / display on the display options bar", "Progressdisplay", "true", "Show the download progress display on the display options bar", "Downloadprogressdisplay", "true", "ENDCHILDREN", "Show the contents of the navigation bar, navigation bar remains but empty if false", "NavigationBarMenu", "true", "Show the memory diplay on the navigation bar", "Memorybottom", "true", "Show the first page button on the navigation bar", "Firstbottom", "true", "Show the back 10 pages button on the navigation bar", "Back10bottom", "true", "Show the back 1 page button on the navigation bar", "Backbottom", "true", "Show the goto page button on the navigation bar", "Gotobottom", "true", "Show the forward 1 page button on the navigation bar", "Forwardbottom", "true", "Show the forward 10 page button on the navigation bar", "Forward10bottom", "true", "Show the last page button on the navigation bar", "Lastbottom", "true", "Show the single page display button on the navigation bar", "Singlebottom", "true", "Show the continuous page display button on the navigation bar", "Continuousbottom", "true", "Show the continuous facing page display button on the navigation bar", "Continuousfacingbottom", "true", "Show the facing page display button on the navigation bar", "Facingbottom", "true", "Show the pageflow page display button on the navigation bar", "PageFlowbottom", "true", "ENDCHILDREN", "Show the contents of the side tab bar, side tab remain but is empty if false", "SideTabBarMenu", "true", "Show the page tab, when applicable, on the side tab bar", "Pagetab", "true", "Show the bookmarks tab, when applicable, on the side tab bar", "Bookmarkstab", "true", "Show the layers tab, when applicable, on the side tab bar", "Layerstab", "true", "Show the signatures tab, when applicable, on the side tab bar", "Signaturestab", "true", "ENDCHILDREN", "This removes the menu bar entirely if set to false", "ShowMenubar", "true", "This removes the button bar entirely if set to false", "ShowButtons", "true", "This removes the display options bar entirely if set to false", "ShowDisplayoptions", "true", "This removes the navigation bar entirely if set to false", "ShowNavigationbar", "true", "This removes the side tab bar entirely if set to false", "ShowSidetabbar", "true", "The integer RGB value for the highlight color", "highlightBoxColor", "-16777216", "The integer RGB value for the highlighted text color", "highlightTextColor", "16750900", "Flag to replace document text colors with user defined value", "replaceDocumentTextColors", "false", "Integer RGB value for replace text colors", "vfgColor", "0", "Integer RGB value to replace document page color", "vbgColor", "16777215", "All color values (R,G and B), must be under this value in order to change text color", "TextColorThreshold", "255", "Flag to replace the background color of the display pane", "replacePdfDisplayBackground", "false", "Color to use as display pane color if flag is set", "pdfDisplayBackground", "16777215", "Allows text color change to also change color of shapes and line art", "changeTextAndLineart", "false", "Transparency value to be used for the highlight box color", "highlightComposite", "0.35", "This overrides the highlight box color and inverts the color of anything within the highlight area", "invertHighlights", "false", "Flag to open last document upon openning the viewer", "openLastDocument", "false", "Page to open last document to", "lastDocumentPage", "1", "The inset of the page in the play area", "pageInsets", "25", "The length of the tabbed pane when it has been collapsed", "sideTabBarCollapseLength", "32", "The length of the tabbed pane when it has been expanded", "sideTabBarExpandLength", "190", "Keep side tab bar consitent across multiple files, overrides startSideTabOpen on file open", "consistentTabBar", "false", "Flag to allow for the right click menu to be used in the viewer", "allowRightClick", "true", "Flag to allow the mouse scroll wheel to zoom in / out of display", "allowScrollwheelZoom", "true", "Flag to set if the properties file can be modified using the preferences window", "readOnly", "false", "Flag to use enhanced viewer mode", "enhancedViewerMode", "true", "Flag to use enhanced facing mode", "enhancedFacingMode", "true", "Text to use in the window title", "windowTitle", "", "Flag to control if we requestion confirmation to close the viewer", "confirmClose", "false", "Location where the icons to be used by the viewer are stored", "iconLocation", "/org/jpedal/examples/simpleviewer/res/", "Flag to control if we show a message when entering page flow mode", "showpageflowmessage", "true", "Specify a default printer to use", "defaultPrinter", "", "Flag to output additional printer / printing info", "debugPrinter", "false", "Default printing DPI", "defaultDPI", "600", "Default printing page size", "defaultPagesize", "", "List of printers to ignore", "printerBlacklist", "", "Flag to allow the use of hinting for true type fonts", "useHinting", "false", "Voice name to be used for text to speech functionality", "voice", "kevin16(general domain)", "Flag to turn on previews in single page mode when scrolling", "previewOnSingleScroll", "true", "Flag to show the bounding box of the mouse selection", "showMouseSelectionBox", "false", "Flag if we should spearate the cover of document when in facing mode", "separateCoverOn", "true", "Flag to set the JavaFX transition type", "transitionType", "None", "Flag to track the users scaling between sessions", "trackScaling", "false", "Scaling value to use on viewer start up, used/modified when tracking between sessions", "startScaling", "Fit Page", "Flag to track the users display mode between sessions", "trackView", "false", "Display Mode value to use on viewer start up, used/modified when tracking between sessions", "startView", "1", "Flag to track the if the side bar tab is open between sessions", "trackSideTabOpen", "false", "Flag if side tab bar should be open on viewer start up and file opening, used/modified when tracking between sessions", "startSideTabOpen", "false", "Flag to track the currently selected tab on side bar between sessions", "trackSelectedSideTab", "false", "Side tab bar to be selected on viewer start up / file openning, used/modified when tracking between sessions", "startSelectedSideTab", "", "Flag to track the viewer window size between sessions", "trackViewerSize", "false", "Viewer width to use on viewer start up, used/modified when tracking between sessions", "startViewerWidth", "-1", "Viewer height to use on viewer start up, used/modified when tracking between sessions", "startViewerHeight", "-1", "Flag to track the side tab bar expanded width between sessions", "trackSideTabExpandedSize", "false", "Allow search result list to update during search (SWING VERSION ONLY)", "updateResultsDuringSearch", "true"};
    int position;
    private boolean endMenu;

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public PropertiesFile() {
        try {
            String jarLoc = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            this.userDir = jarLoc.substring(0, jarLoc.lastIndexOf(47));
            this.configFile = !this.userDir.isEmpty() ? this.userDir + this.separator + ".properties.xml" : ".properties.xml";
            if (DecoderOptions.isRunningOnWindows && this.configFile.length() > 1) {
                this.configFile = this.configFile.substring(1);
                this.configFile = this.configFile.replaceAll("\\\\", "/");
            }
        }
        catch (Exception e) {
            this.userDir = System.getProperty("user.dir");
            this.configFile = this.userDir + this.separator + ".properties.xml";
        }
    }

    public void loadProperties() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            File config = null;
            if (this.configInputStream != null) {
                try {
                    this.doc = db.parse(this.configInputStream);
                    this.isReadOnly = true;
                }
                catch (Exception e) {
                    this.doc = db.newDocument();
                }
            } else {
                config = new File(this.configFile);
                if (config.exists() && config.length() > 0L) {
                    try {
                        this.doc = db.parse(config);
                    }
                    catch (Exception e) {
                        this.doc = db.newDocument();
                    }
                } else {
                    this.doc = db.newDocument();
                }
            }
            if (this.configInputStream == null && (config != null && (config.canWrite() || !config.exists() && !config.canWrite()) && !this.getValue("readOnly").toLowerCase().equals("true") || config.length() == 0L)) {
                int value;
                this.isReadOnly = false;
                this.checkAllElementsPresent();
                String v1 = this.getValue("vfgColor");
                String v2 = this.getValue("vbgColor");
                String v3 = this.getValue("sbbgColor");
                if (!(v1.isEmpty() || v2.isEmpty() || v3.isEmpty() || (value = Integer.parseInt(v1) + Integer.parseInt(v2) + Integer.parseInt(v3)) != -3)) {
                    this.setValue("vfgColor", "");
                    this.setValue("vbgColor", "16777215");
                    this.setValue("sbbgColor", "16777215");
                }
            } else {
                this.isReadOnly = true;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " generating properties file");
        }
    }

    public String[] getRecentDocuments() {
        String[] recentDocuments;
        try {
            NodeList nl = this.doc.getElementsByTagName("recentfiles");
            ArrayList<String> fileNames = new ArrayList<String>();
            if (nl != null && nl.getLength() > 0) {
                NodeList allRecentDocs = ((Element)nl.item(0)).getElementsByTagName("*");
                for (int i = 0; i < allRecentDocs.getLength(); ++i) {
                    Node item = allRecentDocs.item(i);
                    NamedNodeMap attrs = item.getAttributes();
                    fileNames.add(attrs.getNamedItem("name").getNodeValue());
                }
            }
            while (fileNames.size() > 6) {
                fileNames.remove(0);
            }
            Collections.reverse(fileNames);
            recentDocuments = fileNames.toArray(new String[6]);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " getting recent documents");
            return null;
        }
        return recentDocuments;
    }

    public void addRecentDocument(String file) {
        try {
            Element recentElement = (Element)this.doc.getElementsByTagName("recentfiles").item(0);
            PropertiesFile.checkExists(file, recentElement);
            Element elementToAdd = this.doc.createElement("file");
            elementToAdd.setAttribute("name", file);
            recentElement.appendChild(elementToAdd);
            PropertiesFile.removeOldFiles(recentElement);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " adding recent document to properties file");
        }
    }

    public void setValue(String elementName, String newValue) {
        try {
            NodeList nl = this.doc.getElementsByTagName(elementName);
            Element element = (Element)nl.item(0);
            if (element == null || newValue == null) {
                ShowGUIMessage.showGUIMessage("The property " + elementName + " was either not found in the properties file or the value " + newValue + " was not set.", "Property not found.");
            } else {
                element.setAttribute("value", newValue);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " setting value in properties file");
        }
    }

    public NodeList getChildren(String item) {
        return this.doc.getElementsByTagName(item).item(0).getChildNodes();
    }

    public String getValue(String elementName) {
        NamedNodeMap attrs;
        try {
            NodeList nl = this.doc.getElementsByTagName(elementName);
            Element element = (Element)nl.item(0);
            if (element == null) {
                return "";
            }
            attrs = element.getAttributes();
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " generating properties file");
            return "";
        }
        return attrs.getNamedItem("value").getNodeValue();
    }

    private static void removeOldFiles(Element recentElement) throws Exception {
        NodeList allRecentDocs = recentElement.getElementsByTagName("*");
        while (allRecentDocs.getLength() > 6) {
            recentElement.removeChild(allRecentDocs.item(0));
        }
    }

    private static void checkExists(String file, Element recentElement) throws Exception {
        NodeList allRecentDocs = recentElement.getElementsByTagName("*");
        for (int i = 0; i < allRecentDocs.getLength(); ++i) {
            Node item = allRecentDocs.item(i);
            NamedNodeMap attrs = item.getAttributes();
            String value = attrs.getNamedItem("name").getNodeValue();
            if (!value.equals(file)) continue;
            recentElement.removeChild(item);
        }
    }

    public void writeDoc() throws Exception {
        if (!this.isReadOnly && !this.getValue("readOnly").equalsIgnoreCase("true")) {
            InputStream stylesheet = this.getClass().getResourceAsStream("/org/jpedal/examples/viewer/res/xmlstyle.xslt");
            StreamResult str = new StreamResult(this.configFile);
            StreamSource ss = new StreamSource(stylesheet);
            DOMSource dom = new DOMSource(this.doc);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(ss);
            transformer.transform(dom, str);
            stylesheet.close();
            if (ss != null) {
                ss.getInputStream().close();
            }
            if (str != null && str.getOutputStream() != null) {
                str.getOutputStream().close();
            }
        }
    }

    public void dispose() {
        this.doc = null;
        this.properties = null;
        this.configFile = null;
    }

    private void checkAllElementsPresent() throws Exception {
        Element propertiesElement;
        this.position = 0;
        NodeList allElements = this.doc.getElementsByTagName("*");
        ArrayList<String> elementsInTree = new ArrayList<String>(allElements.getLength());
        for (int i = 0; i < allElements.getLength(); ++i) {
            elementsInTree.add(allElements.item(i).getNodeName());
        }
        if (elementsInTree.contains("properties")) {
            propertiesElement = (Element)this.doc.getElementsByTagName("properties").item(0);
        } else {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.newDocument();
            propertiesElement = this.doc.createElement("properties");
            this.doc.appendChild(propertiesElement);
        }
        if (!elementsInTree.contains("recentfiles")) {
            Element recent = this.doc.createElement("recentfiles");
            propertiesElement.appendChild(recent);
        }
        allElements = propertiesElement.getChildNodes();
        this.addProperties(allElements, propertiesElement);
    }

    private static int checkNodelistForValue(NodeList tree, String value, boolean comments) {
        int nodePosition = -1;
        for (int i = 0; i < tree.getLength(); ++i) {
            if (comments) {
                if (tree.item(i).getNodeType() == 8 && tree.item(i).getNodeValue().equals(value)) {
                    nodePosition = i;
                }
            } else if (tree.item(i).getNodeName().equals(value)) {
                nodePosition = i;
            }
            if (nodePosition == -1 && tree.item(i).hasChildNodes()) {
                nodePosition = PropertiesFile.checkNodelistForValue(tree.item(i).getChildNodes(), value, comments);
            }
            if (nodePosition == -1) continue;
            i = tree.getLength();
        }
        return nodePosition;
    }

    private void addMenuElement(NodeList tree, Element menu) {
        int containsNode = PropertiesFile.checkNodelistForValue(tree, this.properties[this.position + 1], false);
        int containsComment = PropertiesFile.checkNodelistForValue(tree, this.properties[this.position], true);
        if (containsNode == -1) {
            menu.appendChild(this.doc.createComment(this.properties[this.position]));
            ++this.position;
            Element property = this.doc.createElement(this.properties[this.position]);
            ++this.position;
            property.setAttribute("value", this.properties[this.position]);
            menu.appendChild(property);
            ++this.position;
            this.addProperties(tree, property);
        } else {
            Element property = (Element)this.doc.getElementsByTagName(this.properties[this.position + 1]).item(0);
            if (containsComment == -1) {
                menu.insertBefore(this.doc.createComment(this.properties[this.position]), tree.item(containsNode));
            }
            ++this.position;
            ++this.position;
            ++this.position;
            this.addProperties(tree, property);
        }
    }

    private void addChildElements(NodeList tree, Element menu) {
        if (!this.properties[this.position].equals("ENDCHILDREN")) {
            int containsNode = PropertiesFile.checkNodelistForValue(tree, this.properties[this.position + 1], false);
            int containsComment = PropertiesFile.checkNodelistForValue(tree, this.properties[this.position], true);
            if (containsNode == -1) {
                menu.appendChild(this.doc.createComment(this.properties[this.position]));
                ++this.position;
                Element property = this.doc.createElement(this.properties[this.position]);
                ++this.position;
                property.setAttribute("value", this.properties[this.position]);
                menu.appendChild(property);
            } else {
                if (containsComment == -1) {
                    menu.insertBefore(this.doc.createComment(this.properties[this.position]), tree.item(containsNode));
                }
                ++this.position;
                if (this.properties[this.position].equals("currentversion")) {
                    NodeList nl = this.doc.getElementsByTagName(this.properties[this.position]);
                    Element element = (Element)nl.item(0);
                    if (element == null) {
                        ShowGUIMessage.showGUIMessage("The property " + this.properties[this.position] + " was either not found in the properties file.", "Property not found.");
                    } else if (!this.properties[this.position + 1].equals("6.6b14")) {
                        float propVersion;
                        float progVersion = Float.parseFloat("6.6b14".substring(0, 4));
                        String propVer = "0";
                        String version = element.getAttribute("value");
                        if (version.length() > 3) {
                            propVer = version.substring(0, 4);
                        }
                        if (progVersion > (propVersion = Float.parseFloat(propVer))) {
                            element.setAttribute("value", "6.6b14");
                        }
                    }
                }
                ++this.position;
            }
        } else {
            this.endMenu = true;
        }
        ++this.position;
    }

    private void addProperties(NodeList tree, Element menu) {
        while (this.position < this.properties.length) {
            if (this.properties[this.position + 1].endsWith("Menu")) {
                this.addMenuElement(tree, menu);
                continue;
            }
            this.addChildElements(tree, menu);
            if (!this.endMenu) continue;
            this.endMenu = false;
            break;
        }
    }

    public static int getNoRecentDocumentsToDisplay() {
        return 6;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void loadProperties(InputStream is) {
        this.configInputStream = is;
        this.loadProperties();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadProperties(String configFile) {
        if (configFile.startsWith("jar:")) {
            configFile = configFile.substring(4);
            InputStream is = this.getClass().getResourceAsStream(configFile);
            if (is == null) throw new RuntimeException("unable to open resource stream for " + configFile);
            this.configInputStream = is;
        } else {
            if (configFile.startsWith("http:")) {
                try {
                    URL url = new URL(configFile);
                    URLConnection con = url.openConnection();
                    con.setDoOutput(true);
                    this.configInputStream = url.openStream();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.configInputStream == null) {
                File p;
                if (configFile.startsWith("file:/")) {
                    configFile = configFile.substring(6);
                }
                if (!(p = new File(configFile)).exists() && (p.exists() || p.canWrite())) {
                    throw new RuntimeException();
                }
                this.configFile = configFile;
                this.isReadOnly = !p.canWrite();
            }
        }
        this.loadProperties();
    }

    public Document getDoc() {
        return this.doc;
    }
}

