/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.UnicodeReader;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.CIDEncodings;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;

public class PdfFont
implements Serializable {
    PdfObject ToUnicode;
    String truncatedName;
    private Rectangle BBox;
    public String CMapName;
    boolean handleOddSapFontMapping;
    boolean isFirstScan = true;
    int isDouble = -1;
    private static final int noWidth = -1;
    protected boolean containsHexNumbers;
    protected boolean allNumbers;
    protected String embeddedFontName;
    protected String embeddedFamilyName;
    protected String copyright;
    private float missingWidth = -1.0f;
    boolean isSingleByte;
    protected boolean isFontVertical;
    private float lastWidth = -1.0f;
    public PdfJavaGlyphs glyphs = new PdfJavaGlyphs();
    private String[] cachedValue = new String[256];
    private String rawFontName;
    final Map nonStandardMappings = new HashMap(256);
    public boolean hasDoubleBytes;
    protected String substituteFont;
    protected boolean renderPage;
    private static final float xscale = 0.001f;
    protected int embeddedEnc = 1;
    protected String[] diffs;
    public boolean isFontEmbedded;
    protected boolean TTstreamisCID;
    protected String fontID = "";
    protected int maxCharCount = 256;
    protected boolean hasEncoding = true;
    protected int fontTypes;
    protected String substituteFontFile;
    private int spaceChar = -1;
    String[] diffTable;
    protected final Map rawDiffKeys = new HashMap();
    private int[] diffCharTable;
    private float[] widthTable;
    private float possibleSpaceWidth = -1.0f;
    protected PdfObjectReader currentPdfFile;
    protected final ClassLoader loader = this.getClass().getClassLoader();
    public double[] FontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    public float[] FontBBox = new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    protected boolean isHex;
    private String[] unicodeMappings;
    protected int fontEnc = -1;
    protected boolean isCIDFont;
    private String[] CMAP;
    private String CIDfontEncoding;
    private float defaultWidth = 1.0f;
    protected boolean isFontSubstituted;
    protected int italicAngle;
    private byte[] stream;
    private int[] CIDToGIDMap;

    public PdfFont() {
    }

    public PdfFont(PdfObjectReader current_pdf_file) {
        this.init(current_pdf_file);
    }

    public String getTruncatedName() {
        return this.truncatedName;
    }

    private static void setStandardFontMappings() {
        String value;
        String key;
        int i;
        int count = StandardFonts.files_names.length;
        for (i = 0; i < count; ++i) {
            key = StandardFonts.files_names_bis[i].toLowerCase();
            if (key.equals(value = StandardFonts.javaFonts[i].toLowerCase()) || FontMappings.fontSubstitutionAliasTable.containsKey(key)) continue;
            FontMappings.fontSubstitutionAliasTable.put(key, value);
        }
        for (i = 0; i < count; ++i) {
            key = StandardFonts.files_names[i].toLowerCase();
            if (!key.equals(value = StandardFonts.javaFonts[i].toLowerCase()) && !FontMappings.fontSubstitutionAliasTable.containsKey(key)) {
                FontMappings.fontSubstitutionAliasTable.put(key, value);
            }
            StandardFonts.javaFontList.put(StandardFonts.files_names[i], "x");
        }
    }

    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    private void setCIDFontWidths(String values) {
        if ((values = values.substring(1, values.length() - 1).trim()).isEmpty()) {
            return;
        }
        this.widthTable = new float[65536];
        for (int ii = 0; ii < 65536; ++ii) {
            this.widthTable[ii] = -1.0f;
        }
        StringTokenizer widthValues = new StringTokenizer(values, " []", true);
        String currentValue = "";
        String lastValue = "";
        String nextValue = "";
        int pointer = 0;
        int lastPointer = 0;
        while (widthValues.hasMoreTokens() && (nextValue = widthValues.nextToken()).equals(" ")) {
        }
        boolean isDone = false;
        while (!isDone) {
            if (nextValue.equals("R")) {
                String ref = lastValue + ' ' + currentValue + " R";
                int number = Integer.parseInt(lastValue);
                int generation = Integer.parseInt(currentValue);
                pointer = lastPointer;
                FontObject widthObj = new FontObject(ref);
                byte[] data = this.currentPdfFile.getObjectReader().readObjectAsByteArray(widthObj, this.currentPdfFile.getObjectReader().isCompressed(number, generation), number, generation);
                String text = new String(data);
                int start = text.indexOf(91);
                int end = text.lastIndexOf(93);
                if (start > -1 && end > -1 && start < end) {
                    text = text.substring(start, end);
                }
                StringTokenizer widthValues2 = new StringTokenizer(text, " []");
                while (widthValues2.hasMoreTokens()) {
                    String val = widthValues2.nextToken();
                    this.widthTable[pointer] = Float.parseFloat(val) / 1000.0f;
                    ++pointer;
                }
                if (widthValues.hasMoreTokens()) {
                    while (widthValues.hasMoreTokens() && (nextValue = widthValues.nextToken()).equals(" ")) {
                    }
                    continue;
                }
                isDone = true;
                continue;
            }
            lastValue = currentValue;
            currentValue = nextValue;
            lastPointer = pointer;
            pointer = Integer.parseInt(currentValue);
            while ((currentValue = widthValues.nextToken()).equals(" ")) {
            }
            if (currentValue.equals("[")) {
                while (true) {
                    if ((currentValue = widthValues.nextToken()).equals(" ")) {
                        continue;
                    }
                    if (currentValue.equals("]")) break;
                    this.widthTable[pointer] = Float.parseFloat(currentValue) / 1000.0f;
                    ++pointer;
                }
                if (widthValues.hasMoreTokens()) {
                    while (widthValues.hasMoreTokens() && (nextValue = widthValues.nextToken()).equals(" ")) {
                    }
                    continue;
                }
                isDone = true;
                continue;
            }
            int endPointer = 1 + Integer.parseInt(currentValue);
            lastValue = currentValue;
            while ((currentValue = widthValues.nextToken()).equals(" ")) {
            }
            if (widthValues.hasMoreTokens()) {
                while (widthValues.hasMoreTokens() && (nextValue = widthValues.nextToken()).equals(" ")) {
                }
            } else {
                isDone = true;
            }
            if (nextValue.equals("R")) continue;
            for (int ii = pointer; ii < endPointer; ++ii) {
                this.widthTable[ii] = Float.parseFloat(currentValue) / 1000.0f;
            }
        }
    }

    public final boolean isCIDFont() {
        return this.isCIDFont;
    }

    protected final void init(PdfObjectReader current_pdf_file) {
        this.currentPdfFile = current_pdf_file;
        if (this.isCIDFont) {
            this.maxCharCount = 65536;
        }
        this.glyphs.init(this.maxCharCount, this.isCIDFont);
    }

    public final String getUnicodeMapping(int char_int) {
        if (this.unicodeMappings == null) {
            return null;
        }
        return this.unicodeMappings[char_int];
    }

    public final void putFontEncoding(int enc) {
        if (enc == 2 && this.getBaseFontName().equals("Symbol")) {
            this.putFontEncoding(4);
            enc = 4;
        }
        this.fontEnc = enc;
        StandardFonts.checkLoaded(enc);
    }

    public final String getUnicodeValue(String displayValue, int rawInt) {
        String textValue = this.getUnicodeMapping(rawInt);
        if (textValue == null) {
            textValue = displayValue;
        }
        if (!displayValue.isEmpty()) {
            char displayChar = displayValue.charAt(0);
            switch (displayChar) {
                case '\u00ad': {
                    if (this.fontEnc != 2 && this.fontEnc != 1) break;
                    textValue = "-";
                    break;
                }
                case '\ufb00': {
                    textValue = "ff";
                    break;
                }
                case '\ufb01': {
                    textValue = "fi";
                    break;
                }
                case '\ufb04': {
                    textValue = "ffl";
                }
            }
        }
        return textValue;
    }

    public final String getGlyphValue(int rawInt) {
        if (this.cachedValue[rawInt] != null) {
            return this.cachedValue[rawInt];
        }
        String return_value = null;
        if (this.isCIDFont) {
            String unicodeMappings = this.getUnicodeMapping(rawInt);
            if (unicodeMappings != null) {
                return_value = unicodeMappings;
            }
            if (return_value == null) {
                String newChar;
                String fontEncoding = this.CIDfontEncoding;
                if (this.diffTable != null) {
                    return_value = this.diffTable[rawInt];
                } else if (fontEncoding != null) {
                    String newChar2;
                    if (fontEncoding.startsWith("Identity-")) {
                        return_value = String.valueOf((char)rawInt);
                    } else if (this.CMAP != null && (newChar2 = this.CMAP[rawInt]) != null) {
                        return_value = newChar2;
                    }
                } else if (fontEncoding == null && this.CMAP != null && this.CMapName != null && !this.CMapName.endsWith("-V") && !this.CMapName.endsWith("-H") && (newChar = this.CMAP[rawInt]) != null) {
                    return_value = newChar;
                }
                if (return_value == null) {
                    return_value = String.valueOf((char)rawInt);
                }
            }
        } else {
            return_value = this.getStandardGlyphValue(rawInt);
        }
        this.cachedValue[rawInt] = return_value;
        return return_value;
    }

    private String handleCIDEncoding(PdfObject Encoding, PdfObject fontObject) {
        block15: {
            boolean isIdentity;
            BufferedReader CIDstream = null;
            int encodingType = Encoding.getGeneralType(1232564598);
            String encodingName = CIDEncodings.getNameForEncoding(encodingType);
            if (encodingName == null) {
                if (encodingType == 2038913669) {
                    encodingName = "Identity-H";
                } else if (encodingType == 2038913683) {
                    encodingName = "Identity-V";
                    this.isFontVertical = true;
                } else {
                    encodingName = Encoding.getGeneralStringValue();
                }
            }
            this.CMapName = Encoding.getName(827223669);
            if (this.CMapName != null) {
                this.stream = this.currentPdfFile.readStream(Encoding, true, true, false, false, false, Encoding.getCacheName(this.currentPdfFile.getObjectReader()));
                encodingName = this.CMapName;
                String CMAPstream = new String(this.stream);
                CMAPstream = CMAPstream.replaceAll(" begincidchar ", "\nbegincidchar\n");
                CMAPstream = CMAPstream.replaceAll(" endcidchar", "\nendcidchar");
                CMAPstream = CMAPstream.replaceAll(" begincidrange ", "\begincidrange\n");
                CMAPstream = CMAPstream.replaceAll(" endcidrange", "\nendcidrange");
                CIDstream = new BufferedReader(new StringReader(CMAPstream));
            }
            boolean bl = isIdentity = encodingType == 2038913669 || encodingType == 2038913683;
            if (!isIdentity && fontObject != null) {
                String name = fontObject.getName(678461817);
                if (encodingType != -1 && name != null && name.contains("Identity")) {
                    isIdentity = true;
                    this.handleOddSapFontMapping = true;
                    this.isSingleByte = true;
                }
            }
            if (CIDstream == null) {
                this.CIDfontEncoding = encodingName;
            }
            if (isIdentity) {
                this.glyphs.setIsIdentity(true);
            } else {
                this.glyphs.setIsIdentity(false);
                this.CMAP = new String[65536];
                this.glyphs.CMAP_Translate = new int[65536];
                if (CIDstream != null) {
                    this.readCIDCMap(CIDstream);
                }
            }
            if (CIDstream != null) {
                try {
                    CIDstream.close();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block15;
                    LogWriter.writeLog("2.Problem reading encoding for CID font " + this.fontID + ' ' + encodingName + " Check CID.jar installed " + e);
                }
            }
        }
        return this.CMapName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readCIDCMap(BufferedReader CIDstream) {
        String line = "";
        boolean inDefinition = false;
        boolean inMap = false;
        while (true) {
            int end;
            int begin;
            StringTokenizer CIDentry;
            block18: {
                try {
                    line = CIDstream.readLine();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block18;
                    LogWriter.writeLog("[PDF] Error reading line from font");
                }
            }
            if (line == null) {
                return;
            }
            if (line.contains("endcidrange")) {
                inDefinition = false;
            } else if (line.contains("endcidchar")) {
                inMap = false;
            }
            if (!inDefinition) {
                if (inMap) {
                    try {
                        CIDentry = new StringTokenizer(line, " <>[]");
                        if (CIDentry.countTokens() == 2) {
                            begin = Integer.parseInt(CIDentry.nextToken(), 16);
                            this.glyphs.CMAP_Translate[begin] = end = Integer.parseInt(CIDentry.nextToken());
                        }
                    }
                    catch (Exception ef) {
                        ef.getStackTrace();
                    }
                }
            } else {
                CIDentry = new StringTokenizer(line, " <>[]");
                boolean multiple_values = false;
                if (line.indexOf(91) != -1) {
                    multiple_values = true;
                }
                begin = Integer.parseInt(CIDentry.nextToken(), 16);
                end = Integer.parseInt(CIDentry.nextToken(), 16);
                String value = CIDentry.nextToken();
                int charCount = value.length();
                boolean isHex = false;
                for (int ptr = 0; ptr < charCount; ++ptr) {
                    char c = value.charAt(ptr);
                    if (c >= '0' && c <= '9') continue;
                    isHex = true;
                    ptr = charCount;
                }
                int entry = isHex ? Integer.parseInt(value, 16) : Integer.parseInt(value, 10);
                for (int i = begin; i < end + 1; ++i) {
                    if (multiple_values) {
                        entry = Integer.parseInt(CIDentry.nextToken(), 16);
                        this.CMAP[i] = String.valueOf((char)entry);
                        continue;
                    }
                    this.CMAP[i] = String.valueOf((char)entry);
                    ++entry;
                }
            }
            if (line.contains("begincidrange")) {
                inDefinition = true;
                continue;
            }
            if (!line.contains("begincidchar")) continue;
            inMap = true;
        }
    }

    private String getStandardGlyphValue(int char_int) {
        String unicode_char = this.getUnicodeMapping(char_int);
        if (unicode_char != null) {
            return unicode_char;
        }
        String return_value = "";
        int font_encoding = this.getFontEncoding(true);
        String mapped_char = this.getMappedChar(char_int, true);
        if (mapped_char != null) {
            String char_mapping = StandardFonts.getUnicodeName(this.fontEnc + mapped_char);
            if (char_mapping != null) {
                return_value = char_mapping;
            } else {
                char_mapping = StandardFonts.getUnicodeName(mapped_char);
                if (char_mapping != null) {
                    return_value = char_mapping;
                } else if (mapped_char.length() == 1) {
                    return_value = mapped_char;
                } else if (mapped_char.length() > 1) {
                    boolean isHex;
                    char c = mapped_char.charAt(0);
                    char c2 = mapped_char.charAt(1);
                    if (c == 'B' || c == 'C' || c == 'c' || c == 'G') {
                        mapped_char = mapped_char.substring(1);
                        try {
                            int val = this.isHex ? Integer.valueOf(mapped_char, 16) : Integer.parseInt(mapped_char);
                            return_value = String.valueOf((char)val);
                        }
                        catch (Exception e) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Exception in handling char value " + e);
                            }
                            return_value = "";
                        }
                    } else {
                        return_value = "";
                    }
                    boolean bl = isHex = (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') && (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F');
                    if (return_value.isEmpty() && this.fontTypes == 1228944679 && mapped_char.length() == 2 && isHex) {
                        return_value = String.valueOf((char)Integer.parseInt(mapped_char, 16));
                    }
                    if (return_value.isEmpty()) {
                        if (this.fontTypes == 1228944679) {
                            return_value = String.valueOf((char)char_int);
                        } else if (this.diffTable != null && this.diffTable[char_int] != null && this.fontEnc == 2 && (return_value = this.diffTable[char_int]).indexOf(95) != -1) {
                            return_value = return_value.replaceAll("_", "");
                        }
                    }
                } else {
                    return_value = "";
                }
            }
        } else if (font_encoding > -1) {
            return_value = StandardFonts.getEncodedChar(font_encoding, char_int);
        }
        return return_value;
    }

    public final void setDefaultDisplayFont(String fontName) {
        this.glyphs.defaultFont = fontName;
    }

    public final Font getJavaFontX(int size) {
        Font f;
        if (DecoderOptions.Helper != null && (f = DecoderOptions.Helper.getJavaFontX(this, size)) != null) {
            return f;
        }
        return new Font(this.glyphs.font_family_name, this.glyphs.style, size);
    }

    public final String getFontName() {
        StandardFonts.loadStandardFontWidth(this.glyphs.fontName);
        return this.glyphs.fontName;
    }

    public final String getCopyright() {
        return this.copyright;
    }

    public final String getBaseFontName() {
        return this.glyphs.getBaseFontName();
    }

    public final float getCurrentFontSpaceWidth() {
        int space_value = this.spaceChar;
        float width = space_value != -1 ? this.getWidth(space_value) : this.possibleSpaceWidth;
        if (width == -1.0f || width == 0.0f) {
            width = 0.2f;
        }
        return width;
    }

    public final float getSpaceWidthHTML() {
        float width = 0.0f;
        if (this.spaceChar != -1) {
            width = this.getWidth(this.spaceChar);
        }
        if (width == -1.0f || width == 0.0f) {
            width = 0.25f;
        }
        return width;
    }

    public final int getFontEncoding(boolean notNull) {
        int result = this.fontEnc;
        if (result == -1 && notNull) {
            result = 1;
        }
        return result;
    }

    public final float getWidth(int charInt) {
        if (charInt == -1) {
            return this.lastWidth;
        }
        float width = -1.0f;
        if (this.widthTable != null && charInt != -1 && charInt < this.maxCharCount) {
            width = this.widthTable[charInt];
        }
        if (width == -1.0f) {
            if (this.isCIDFont) {
                width = this.defaultWidth;
            } else {
                Float value;
                String charName = this.getMappedChar(charInt, false);
                if (charName != null && charName.equals(".notdef")) {
                    charName = StandardFonts.getUnicodeChar(this.getFontEncoding(true), charInt);
                }
                if ((value = StandardFonts.getStandardWidth(this.glyphs.logicalfontName, charName)) == null && this.rawFontName != null) {
                    StandardFonts.loadStandardFontWidth(this.rawFontName);
                    value = StandardFonts.getStandardWidth(this.rawFontName, charName);
                }
                width = value != null ? value.floatValue() : (this.missingWidth != -1.0f ? this.missingWidth * 0.001f : 0.0f);
            }
        }
        this.lastWidth = width;
        return width;
    }

    public void createCIDFont(PdfObject pdfObject, PdfObject Descendent) throws PdfFontException {
        PdfObject FontDescriptor;
        PdfObject CIDToGID;
        int Width;
        this.cachedValue = new String[65536];
        String CMapName = null;
        PdfObject Encoding = pdfObject.getDictionary(1232564598);
        if (Encoding != null) {
            CMapName = this.handleCIDEncoding(Encoding, pdfObject);
        }
        this.ToUnicode = pdfObject.getDictionary(1919185554);
        if (this.ToUnicode != null) {
            UnicodeReader uniReader = new UnicodeReader(this.currentPdfFile.readStream(this.ToUnicode, true, true, false, false, false, this.ToUnicode.getCacheName(this.currentPdfFile.getObjectReader())));
            this.unicodeMappings = uniReader.readUnicode();
            this.hasDoubleBytes = uniReader.hasDoubleByteValues();
        }
        String widths = Descendent.getName(39);
        String verticalWidths = Descendent.getName(9986);
        if (verticalWidths != null) {
            widths = verticalWidths;
        }
        if (widths != null) {
            this.setCIDFontWidths(widths);
        }
        if ((Width = Descendent.getInt(5159)) >= 0) {
            this.defaultWidth = (float)Width / 1000.0f;
        }
        if (this.handleOddSapFontMapping) {
            this.defaultWidth = 0.5f;
        }
        if ((CIDToGID = Descendent.getDictionary(946823533)) != null) {
            byte[] stream = this.currentPdfFile.readStream(CIDToGID, true, true, false, false, false, null);
            if (stream != null) {
                int j = 0;
                int count = stream.length;
                this.CIDToGIDMap = new int[count / 2];
                for (int i = 0; i < count; i += 2) {
                    this.CIDToGIDMap[j] = ((stream[i] & 0xFF) << 8) + (stream[i + 1] & 0xFF);
                    ++j;
                }
                this.glyphs.setGIDtoCID(this.CIDToGIDMap);
            } else if (CIDToGID.getParameterConstant(946823533) == -1) {
                CMapName = this.handleCIDEncoding(new FontObject(2038913669), null);
            }
        }
        String ordering = null;
        PdfObject CIDSystemInfo = Descendent.getDictionary(1972801240);
        if (CIDSystemInfo != null) {
            ordering = CIDSystemInfo.getTextStreamValue(1635480172);
        }
        if (ordering != null) {
            if (CIDToGID != null || !ordering.contains("Identity")) {
                if (ordering.contains("Japan")) {
                    this.TTstreamisCID = false;
                } else if (!ordering.contains("Korean") && !ordering.contains("Chinese") && ordering.equals("Identity") && (CMapName == null || CMapName.contains("Ident"))) {
                    this.glyphs.setIsIdentity(true);
                }
            }
            if (this.substituteFontFile != null && LogWriter.isOutput()) {
                LogWriter.writeLog("Using font " + this.substituteFontFile + " for " + ordering);
            }
        }
        if (Descendent != null && (FontDescriptor = Descendent.getDictionary(-1044665361)) != null) {
            this.setBoundsAndMatrix(FontDescriptor);
            this.setName(FontDescriptor);
        }
    }

    public void readWidths(PdfObject pdfObject, boolean setSpace) throws Exception {
        float shortestWidth = 0.0f;
        int count = 0;
        float[] floatWidthValues = pdfObject.getFloatArray(876896124);
        if (floatWidthValues != null && floatWidthValues.length > 0) {
            this.widthTable = new float[this.maxCharCount];
            for (int ii = 0; ii < this.maxCharCount; ++ii) {
                this.widthTable[ii] = -1.0f;
            }
            int firstCharNumber = pdfObject.getInt(1283093660);
            int lastCharNumber = pdfObject.getInt(795440262);
            float ratio = (float)(1.0 / this.FontMatrix[0]);
            if (ratio < 0.0f) {
                ratio = -ratio;
            }
            int j = 0;
            int widthCount = floatWidthValues.length;
            for (int i = firstCharNumber; i < lastCharNumber + 1; ++i) {
                if (j < widthCount) {
                    float nextValue = floatWidthValues[j];
                    float widthValue = this.fontTypes == 1228944679 ? nextValue / ratio : nextValue * 0.001f;
                    if (widthValue > 0.0f) {
                        shortestWidth += widthValue;
                        ++count;
                    }
                    this.widthTable[i] = widthValue;
                } else {
                    this.widthTable[i] = 0.0f;
                }
                ++j;
            }
        }
        if (setSpace && count > 0) {
            this.possibleSpaceWidth = shortestWidth / (float)(2 * count);
        }
    }

    public void createFont(PdfObject pdfObject, String fontID, boolean renderPage, ObjectStore objectStore, Map substitutedFonts) throws Exception {
        this.init(fontID, renderPage);
        PdfObject pdfFontDescriptor = pdfObject.getDictionary(-1044665361);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfFontDescriptor);
    }

    protected void setName(PdfObject pdfObject) {
        String baseFontName = pdfObject.getName(678461817);
        if (baseFontName == null) {
            baseFontName = pdfObject.getName(879786873);
        }
        if (baseFontName == null) {
            baseFontName = this.fontID;
        }
        if (baseFontName.contains("#20")) {
            baseFontName = PdfFont.cleanupFontName(baseFontName);
        }
        this.glyphs.setBaseFontName(baseFontName);
        this.truncatedName = pdfObject.getStringValue(678461817, 2);
        if (this.truncatedName == null) {
            this.truncatedName = pdfObject.getStringValue(879786873, 2);
        }
        if (this.truncatedName == null) {
            this.truncatedName = this.fontID;
        }
        if (this.truncatedName.contains("#20") || this.truncatedName.contains("#2D")) {
            this.truncatedName = PdfFont.cleanupFontName(this.truncatedName);
        }
        this.glyphs.fontName = this.truncatedName;
        if (this.truncatedName.equals("Arial-BoldMT")) {
            this.glyphs.logicalfontName = "Arial,Bold";
            StandardFonts.loadStandardFontWidth(this.glyphs.logicalfontName);
        } else if (this.truncatedName.equals("ArialMT")) {
            this.glyphs.logicalfontName = "Arial";
            StandardFonts.loadStandardFontWidth(this.glyphs.logicalfontName);
        } else {
            this.glyphs.logicalfontName = this.truncatedName;
        }
    }

    public void resetNameForHTML(String newName) {
        this.glyphs.fontName = newName;
        this.glyphs.baseFontName = newName;
    }

    protected void setEncoding(PdfObject pdfObject, PdfObject pdfFontDescriptor) {
        PdfObject Encoding;
        PdfObject ToUnicode = pdfObject.getDictionary(1919185554);
        if (ToUnicode != null) {
            this.unicodeMappings = new UnicodeReader(this.currentPdfFile.readStream(ToUnicode, true, true, false, false, false, ToUnicode.getCacheName(this.currentPdfFile.getObjectReader()))).readUnicode();
        }
        if ((Encoding = pdfObject.getDictionary(1232564598)) != null) {
            this.handleFontEncoding(pdfObject, Encoding);
        } else {
            this.handleNoEncoding(0, pdfObject);
        }
        if (pdfFontDescriptor != null) {
            this.missingWidth = pdfFontDescriptor.getInt(-1884569950);
        }
    }

    protected void setBoundsAndMatrix(PdfObject pdfFontDescriptor) {
        if (pdfFontDescriptor != null) {
            float[] newFontBBox;
            double[] newFontmatrix = pdfFontDescriptor.getDoubleArray(-2105119560);
            if (newFontmatrix != null) {
                this.FontMatrix = newFontmatrix;
            }
            if ((newFontBBox = pdfFontDescriptor.getFloatArray(676429196)) != null) {
                this.FontBBox = newFontBBox;
            }
        }
    }

    protected void init(String fontID, boolean renderPage) {
        this.fontID = fontID;
        this.renderPage = renderPage;
    }

    private int handleNoEncoding(int encValue, PdfObject pdfObject) {
        int enc = pdfObject.getGeneralType(1232564598);
        if (enc == 5) {
            this.putFontEncoding(5);
            this.glyphs.defaultFont = "Zapf Dingbats";
            StandardFonts.checkLoaded(5);
            encValue = 5;
        } else if (enc == 4) {
            this.putFontEncoding(4);
            encValue = 4;
        } else {
            this.putFontEncoding(1);
        }
        this.hasEncoding = false;
        return encValue;
    }

    private void handleFontEncoding(PdfObject pdfObject, PdfObject Encoding) {
        PdfArrayIterator Diffs;
        int subType = pdfObject.getParameterConstant(1147962727);
        int encValue = this.getFontEncoding(false);
        if (encValue == -1) {
            encValue = subType == 1217103210 ? 0 : 1;
        }
        if ((Diffs = Encoding.getMixedArray(1954328750)) != null && Diffs.getTokenCount() > 0) {
            this.glyphs.setIsSubsetted(true);
            byte[][] rawData = null;
            if (Encoding != null) {
                rawData = Encoding.getByteArray(1954328750);
            }
            if (rawData != null) {
                this.containsHexNumbers = true;
                this.allNumbers = true;
                for (byte[] aRawData : rawData) {
                    char c;
                    int jj;
                    if (aRawData == null || aRawData[0] != 47) continue;
                    int length = aRawData.length;
                    int charCount = 0;
                    if (length == 3 && this.containsHexNumbers) {
                        for (jj = 1; jj < 3; ++jj) {
                            c = (char)aRawData[jj];
                            if ((c < '0' || c > '9') && (c < 'A' || c > 'F')) continue;
                            charCount = (char)(charCount + 1);
                        }
                    }
                    if (charCount != 2) {
                        this.containsHexNumbers = false;
                    }
                    if (!this.allNumbers || length >= 4) continue;
                    for (jj = 2; jj < length; ++jj) {
                        c = (char)aRawData[jj];
                        if (c >= '0' && c <= '9') continue;
                        this.allNumbers = false;
                        jj = length;
                    }
                }
            }
            int pointer = 0;
            while (Diffs.hasMoreTokens()) {
                int type = Diffs.getNextValueType();
                if (type == 1) {
                    pointer = Diffs.getNextValueAsInteger();
                } else {
                    if (type == 2) {
                        if (this.diffCharTable == null) {
                            this.diffCharTable = new int[this.maxCharCount];
                        }
                        this.diffCharTable[pointer] = Diffs.getNextValueAsInteger(false);
                    }
                    String rawKey = Diffs.getNextValueAsString(false);
                    this.rawDiffKeys.put(rawKey.substring(1), pointer);
                    this.putMappedChar(pointer, Diffs.getNextValueAsFontChar(pointer, this.containsHexNumbers, this.allNumbers));
                    ++pointer;
                }
                if (pointer != 256) continue;
            }
            this.isHex = Diffs.hasHexChars();
            int spaceChar = Diffs.getSpaceChar();
            if (spaceChar != -1) {
                this.spaceChar = spaceChar;
            }
        }
        int EncodingType = -1;
        if (Encoding != null) {
            this.hasEncoding = true;
            int newEncodingType = Encoding.getGeneralType(1232564598);
            if (newEncodingType == -1) {
                newEncodingType = this.getBaseFontName().equals("ZapfDingbats") ? 5 : Encoding.getParameterConstant(1537782955);
            }
            EncodingType = newEncodingType != -1 ? newEncodingType : this.handleNoEncoding(encValue, pdfObject);
            if (this.spaceChar == -1 && (newEncodingType == 2 || newEncodingType == 6 || newEncodingType == 0)) {
                this.spaceChar = 32;
            }
        }
        this.putFontEncoding(EncodingType);
    }

    public final int getDiffChar(String glypName) {
        int value = -1;
        Integer newVal = (Integer)this.nonStandardMappings.get(glypName);
        if (newVal != null) {
            value = newVal;
        }
        return value;
    }

    protected final void putMappedChar(int charInt, String mappedChar) {
        if (this.diffTable == null) {
            this.diffTable = new String[this.maxCharCount];
        }
        if (!(charInt > 255 && this.maxCharCount == 256 || this.diffTable[charInt] != null || mappedChar == null || mappedChar.startsWith("glyph"))) {
            this.diffTable[charInt] = mappedChar;
        }
    }

    public String getDiffMapping(int charInt) {
        if (this.diffTable == null) {
            return null;
        }
        return this.diffTable[charInt];
    }

    public final String getMappedChar(int charInt, boolean remap) {
        String result = null;
        if (this.diffTable != null) {
            result = this.diffTable[charInt];
        }
        if (remap && result != null && result.equals(".notdef")) {
            result = " ";
        }
        if (result == null && charInt < 335) {
            result = StandardFonts.getUnicodeChar(this.getFontEncoding(true), charInt);
        }
        if (result == null && charInt > 40 && this.getFontEncoding(true) == 2) {
            result = charInt == 173 ? "hyphen" : "bullet";
        }
        if (this.isFontEmbedded && result == null) {
            if (this.diffs != null) {
                result = this.diffs[charInt];
            }
            if (result == null && charInt < 335) {
                result = StandardFonts.getUnicodeChar(this.embeddedEnc, charInt);
            }
        }
        return result;
    }

    public final String getEmbeddedChar(int charInt) {
        String embeddedResult = null;
        if (this.isFontEmbedded) {
            if (this.diffs != null) {
                embeddedResult = this.diffs[charInt];
            }
            if (embeddedResult == null && charInt < 256) {
                embeddedResult = StandardFonts.getUnicodeChar(this.embeddedEnc, charInt);
            }
        }
        return embeddedResult;
    }

    public final int getFontType() {
        return this.fontTypes;
    }

    public String getSubstituteFont() {
        return this.substituteFontFile;
    }

    public float getGlyphWidth(String charGlyph, int rawInt, String displayValue) {
        float currentWidth = 0.0f;
        if (this.fontTypes == 1217103210 && this.isFontEmbedded) {
            currentWidth = this.glyphs.getTTWidth(charGlyph, rawInt, displayValue, false);
        } else if (!this.isFontEmbedded) {
            if (rawInt < 255) {
                currentWidth = this.getWidth(rawInt);
            }
            if (currentWidth == 0.0f) {
                Float value = StandardFonts.getStandardWidth("Arial", charGlyph);
                currentWidth = value != null ? value.floatValue() : 0.0f;
            }
        }
        return currentWidth;
    }

    public PdfJavaGlyphs getGlyphData() {
        this.glyphs.setHasWidths(true);
        return this.glyphs;
    }

    public void setFont(String font, int textSize) {
        this.glyphs.setFont(font, textSize);
    }

    public boolean is1C() {
        return this.glyphs.is1C();
    }

    public boolean isFontSubsetted() {
        return this.glyphs.isSubsetted;
    }

    public void setValuesForGlyph(int rawInt, String charGlyph, String displayValue, String embeddedChar) {
        this.glyphs.setValuesForGlyph(rawInt, charGlyph, displayValue, embeddedChar);
    }

    private static String cleanupFontName(String baseFontName) {
        int length = baseFontName.length();
        StringBuilder cleanedName = new StringBuilder(length);
        for (int aa = 0; aa < length; ++aa) {
            char c = baseFontName.charAt(aa);
            if (c == ' ' || c == '-') continue;
            if (c == '#' && baseFontName.charAt(aa + 1) == '2' && (baseFontName.charAt(aa + 2) == '0' || baseFontName.charAt(aa + 2) == 'D')) {
                if (baseFontName.charAt(aa + 2) == 'D') {
                    cleanedName.append('-');
                }
                aa += 2;
                continue;
            }
            cleanedName.append(c);
        }
        return cleanedName.toString();
    }

    public Rectangle getBoundingBox() {
        if (this.BBox == null) {
            float[] standardBB = StandardFonts.getFontBounds(this.getFontName());
            this.BBox = standardBB == null ? (!this.isFontEmbedded ? new Rectangle(0, 0, 1000, 1000) : new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1]))) : new Rectangle((int)standardBB[0], (int)standardBB[1], (int)(standardBB[2] - standardBB[0]), (int)(standardBB[3] - standardBB[1]));
        }
        return this.BBox;
    }

    public void setRawFontName(String baseFont) {
        this.rawFontName = baseFont;
    }

    public static String getSpaces(float currentGap, float spaceWidth, float currentThreshold) {
        String space = "";
        if (spaceWidth > 0.0f) {
            if (currentGap > spaceWidth && currentGap / spaceWidth < 300.0f && (currentThreshold < 1.0f || currentGap > spaceWidth * currentThreshold)) {
                while (currentGap >= spaceWidth) {
                    space = ' ' + space;
                    currentGap -= spaceWidth;
                }
            } else if (currentGap > spaceWidth * currentThreshold) {
                space = space + ' ';
            }
        }
        return space;
    }

    public int getDiffChar(int index) {
        if (this.diffCharTable == null) {
            return 0;
        }
        return this.diffCharTable[index];
    }

    public float[] getFontBounds() {
        return this.FontBBox;
    }

    public boolean isFontVertical() {
        return this.isFontVertical;
    }

    public void setLastWidth(float lastWidth) {
        this.lastWidth = lastWidth;
    }

    public String getFontID() {
        return this.fontID;
    }

    public boolean isSingleByte() {
        return this.isSingleByte;
    }

    public boolean isBrokenFont() {
        return this.handleOddSapFontMapping;
    }

    public boolean hasToUnicode() {
        return this.unicodeMappings != null;
    }

    public float getDefaultWidth(int idx) {
        if (idx == -1) {
            return this.defaultWidth;
        }
        if (this.widthTable == null) {
            return -1.0f;
        }
        return this.widthTable[idx];
    }

    public int isDoubleBytes(int firstVal, int secondByte, boolean secondByteIsEscaped) {
        if (this.hasDoubleBytes) {
            return 1;
        }
        if (this.isFirstScan) {
            this.isDouble = firstVal == secondByte && firstVal > 0 || !this.isHex && secondByte == 41 && !secondByteIsEscaped || this.getMappedChar(firstVal, true) != null && this.getMappedChar(secondByte, true) != null ? 0 : 1;
            this.isFirstScan = false;
        }
        return this.isDouble;
    }

    public int isDoubleBytes() {
        return this.isDouble;
    }

    public PdfObject getToUnicode() {
        return this.ToUnicode;
    }

    public int[] getCIDToGIDMap() {
        return this.CIDToGIDMap;
    }

    public String[] getCMAP() {
        return this.CMAP;
    }

    static {
        PdfFont.setStandardFontMappings();
    }
}

