/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class Type1
extends PdfFont {
    protected boolean isCID;
    private static final int c1 = 52845;
    private static final int c2 = 22719;
    private int skipBytes = 4;
    protected int[] blueValues;
    protected int[] otherBlues;
    protected int[] familyBlues;
    protected int[] familyOtherBlues;
    protected Double blueScale;
    protected Integer blueShift;
    protected Integer blueFuzz;
    protected Double stdHW;
    protected Double stdVW;
    protected int[] stemSnapH;
    protected int[] stemSnapV;
    protected Boolean forceBold;
    protected Integer languageGroup;
    public static final String[] T1CcharCodes1Byte = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "closePathT1", "callsubr", "return", "escape", "hsbwT1", "endchar", "-Reserved-", "blend", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "intint", "callgsubr", "vhcurveto", "hvcurveto"};
    public static final String[] T1C = new String[]{"dotSection", "vstem3", "hstem3", "and", "or", "not", "seacT1", "swbT1", "store", "abs", "add", "sub", "div", "load", "neg", "eq", "callothersubT1", "pop", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "setcurrentpointT1", "hflex", "flex", "hflex1", "flex1"};
    boolean trackIndices;
    public static final char[] DEF_CHARS = "def".toCharArray();

    protected final void readType1FontFile(byte[] content) throws Exception {
        block13: {
            String line;
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Embedded Type1 font used " + this.getBaseFontName());
            }
            BufferedReader br = new BufferedReader(new StringReader(new String(content)));
            while ((line = br.readLine()) != null) {
                int endP;
                if (line.startsWith("/Encoding 256 array")) {
                    this.readDiffEncoding(br);
                    continue;
                }
                if (line.startsWith("/lenIV")) {
                    StringTokenizer vals = new StringTokenizer(line);
                    vals.nextToken();
                    this.skipBytes = Integer.parseInt(vals.nextToken());
                    continue;
                }
                if (!line.contains("/FontMatrix")) continue;
                String values = "";
                int startP = line.indexOf(91);
                if (startP != -1) {
                    endP = line.indexOf(93);
                    values = line.substring(startP + 1, endP);
                } else {
                    startP = line.indexOf(123);
                    if (startP != -1) {
                        endP = line.indexOf(125);
                        values = line.substring(startP + 1, endP);
                    }
                }
                StringTokenizer matrixValues = new StringTokenizer(values);
                for (int i = 0; i < 6; ++i) {
                    this.FontMatrix[i] = Double.parseDouble(matrixValues.nextToken());
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block13;
                    LogWriter.writeLog("Exception " + e + " closing stream");
                }
            }
        }
        int glyphCount = 0;
        if (this.renderPage) {
            glyphCount = this.readEncodedContent(content);
        }
        this.glyphs.setGlyphCount(glyphCount);
        if (!this.renderPage || glyphCount > 0) {
            this.isFontEmbedded = true;
        }
        this.glyphs.setFontEmbedded(true);
    }

    private void readDiffEncoding(BufferedReader br) throws Exception {
        String line;
        while ((line = br.readLine()) != null && !(line = line.trim()).startsWith("readonly")) {
            int code;
            StringTokenizer info;
            if (!line.startsWith("dup") || !line.contains("/") || (info = new StringTokenizer(line, " /")).countTokens() < 3) continue;
            info.nextToken();
            String rawVal = info.nextToken();
            int ptr = rawVal.indexOf(35);
            if (ptr == -1) {
                code = Integer.parseInt(rawVal);
            } else {
                String base = rawVal.substring(0, ptr);
                String val = rawVal.substring(ptr + 1, rawVal.length());
                code = Integer.parseInt(val, Integer.parseInt(base));
            }
            String name = info.nextToken();
            this.putChar(code, name);
            char c = name.charAt(0);
            if (c != 'B' && c != 'C' && c != 'c' && c != 'G') continue;
            int i = 1;
            int l = name.length();
            while (!this.isHex && i < l) {
                this.isHex = Character.isLetter(name.charAt(i++));
            }
        }
    }

    protected final void putChar(int charInt, String mappedChar) {
        if (this.diffs == null) {
            this.diffs = new String[this.maxCharCount];
        }
        this.diffs[charInt] = mappedChar;
        if (!this.hasEncoding && !this.isCID) {
            if (StandardFonts.getUnicodeName(mappedChar) != null) {
                this.putMappedChar(charInt, mappedChar);
            } else if (!this.isHex) {
                this.nonStandardMappings.put(mappedChar, charInt);
            }
        }
    }

    private int readEncodedContent(byte[] cont) throws Exception {
        int languageGroupStart;
        int glyphCount;
        block64: {
            String line;
            int i;
            glyphCount = 0;
            String rd = "rd";
            String nd = "nd";
            int size = cont.length;
            int charstringStart = -1;
            int end = -1;
            for (i = 4; i < size; ++i) {
                if (cont[i - 3] != 101 || cont[i - 2] != 120 || cont[i - 1] != 101 || cont[i] != 99) continue;
                charstringStart = i + 1;
                while (cont[charstringStart] == 10 || cont[charstringStart] == 13) {
                    ++charstringStart;
                }
                i = size;
            }
            if (charstringStart != -1) {
                for (i = charstringStart; i < size - 10; ++i) {
                    if (cont[i] != 99 || cont[i + 1] != 108 || cont[i + 2] != 101 || cont[i + 3] != 97 || cont[i + 4] != 114 || cont[i + 5] != 116 || cont[i + 6] != 111 || cont[i + 7] != 109 || cont[i + 8] != 97 || cont[i + 9] != 114 || cont[i + 10] != 107) continue;
                    end = i - 1;
                    while (cont[end] == 10 || cont[end] == 13) {
                        --end;
                    }
                    i = size;
                }
            }
            if (end == -1) {
                end = size;
            }
            int r = 55665;
            int n = 4;
            boolean isAscii = true;
            for (i = charstringStart; i < charstringStart + 8; ++i) {
                char c = (char)cont[i];
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
                isAscii = false;
                break;
            }
            if (charstringStart != -1) {
                FastByteArrayOutputStream bos = new FastByteArrayOutputStream(end - charstringStart);
                if (this.isFontSubstituted && !isAscii) {
                    charstringStart = charstringStart + 2 + this.skipBytes;
                }
                for (i = charstringStart; i < end; ++i) {
                    int cipher;
                    if (!isAscii) {
                        cipher = cont[i] & 0xFF;
                    } else {
                        int chars = 0;
                        StringBuilder tmp = new StringBuilder();
                        while (chars < 2) {
                            cipher = cont[i] & 0xFF;
                            ++i;
                            if (cipher == 10 || cipher == 13 || cipher == 9 || cipher == 32) continue;
                            tmp.append((char)cipher);
                            ++chars;
                        }
                        --i;
                        cipher = Integer.parseInt(tmp.toString(), 16);
                    }
                    int plain = cipher ^ r >> 8;
                    r = (cipher + r) * 52845 + 22719 & 0xFFFF;
                    if (i <= charstringStart + 4) continue;
                    bos.write(plain);
                }
                cont = bos.toByteArray();
            }
            BufferedReader br = new BufferedReader(new StringReader(new String(cont)));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("/lenIV")) continue;
                StringTokenizer vals = new StringTokenizer(line);
                vals.nextToken();
                this.skipBytes = Integer.parseInt(vals.nextToken());
            }
            br.close();
            int l = cont.length;
            charstringStart = -1;
            int subrsStart = -1;
            int blueValuesStart = -1;
            int otherBluesStart = -1;
            int familyBluesStart = -1;
            int familyOtherBluesStart = -1;
            int blueScaleStart = -1;
            int blueShiftStart = -1;
            int blueFuzzStart = -1;
            int stdHWStart = -1;
            int stdVWStart = -1;
            int stemSnapHStart = -1;
            int stemSnapVStart = -1;
            int forceBoldStart = -1;
            languageGroupStart = -1;
            char[] charstringsChars = "/CharStrings".toCharArray();
            char[] subrsChars = "/Subrs".toCharArray();
            char[] blueValuesChars = "/BlueValues".toCharArray();
            char[] otherBluesChars = "/OtherBlues".toCharArray();
            char[] familyBluesChars = "/FamilyBlues".toCharArray();
            char[] familyOtherBluesChars = "/FamilyOtherBlues".toCharArray();
            char[] blueScaleChars = "/BlueScale".toCharArray();
            char[] blueShiftChars = "/BlueShift".toCharArray();
            char[] blueFuzzChars = "/BlueFuzz".toCharArray();
            char[] stdHWChars = "/StdHW".toCharArray();
            char[] stdVWChars = "/StdVW".toCharArray();
            char[] stemSnapHChars = "/StemSnapH".toCharArray();
            char[] stemSnapVChars = "/StemSnapV".toCharArray();
            char[] forceBoldChars = "/ForceBold".toCharArray();
            char[] languageGroupChars = "/LanguageGroup".toCharArray();
            for (int p = 0; p < l && p != l; ++p) {
                if (charstringStart == -1 && p + 11 < l && Type1.checkForString(cont, p, charstringsChars)) {
                    charstringStart = p + 11;
                } else if (subrsStart == -1 && p + 5 < l && Type1.checkForString(cont, p, subrsChars)) {
                    subrsStart = p + 6;
                } else if (blueValuesStart == -1 && p + 11 < l && Type1.checkForString(cont, p, blueValuesChars)) {
                    blueValuesStart = p + 11;
                } else if (otherBluesStart == -1 && p + 11 < l && Type1.checkForString(cont, p, otherBluesChars)) {
                    otherBluesStart = p + 11;
                } else if (familyBluesStart == -1 && p + 12 < l && Type1.checkForString(cont, p, familyBluesChars)) {
                    familyBluesStart = p + 12;
                } else if (familyOtherBluesStart == -1 && p + 17 < l && Type1.checkForString(cont, p, familyOtherBluesChars)) {
                    familyOtherBluesStart = p + 17;
                } else if (blueScaleStart == -1 && p + 10 < l && Type1.checkForString(cont, p, blueScaleChars)) {
                    blueScaleStart = p + 10;
                } else if (blueShiftStart == -1 && p + 10 < l && Type1.checkForString(cont, p, blueShiftChars)) {
                    blueShiftStart = p + 10;
                } else if (blueFuzzStart == -1 && p + 9 < l && Type1.checkForString(cont, p, blueFuzzChars)) {
                    blueFuzzStart = p + 9;
                } else if (stdHWStart == -1 && p + 6 < l && Type1.checkForString(cont, p, stdHWChars)) {
                    stdHWStart = p + 6;
                } else if (stdVWStart == -1 && p + 6 < l && Type1.checkForString(cont, p, stdVWChars)) {
                    stdVWStart = p + 6;
                } else if (stemSnapHStart == -1 && p + 10 < l && Type1.checkForString(cont, p, stemSnapHChars)) {
                    stemSnapHStart = p + 10;
                } else if (stemSnapVStart == -1 && p + 10 < l && Type1.checkForString(cont, p, stemSnapVChars)) {
                    stemSnapVStart = p + 10;
                } else if (forceBoldStart == -1 && p + 10 < l && Type1.checkForString(cont, p, forceBoldChars)) {
                    forceBoldStart = p + 10;
                } else if (languageGroupStart == -1 && p + 14 < l && Type1.checkForString(cont, p, languageGroupChars)) {
                    languageGroupStart = p + 14;
                }
                if (subrsStart > -1 && charstringStart > -1 && blueValuesStart > -1 && otherBluesStart > -1 && familyBluesStart > -1 && familyOtherBluesStart > -1 && blueScaleStart > -1 && blueShiftStart > -1 && blueFuzzStart > -1 && stdHWStart > -1 && stdVWStart > -1 && stemSnapHStart > -1 && stemSnapVStart > -1 && forceBoldStart > -1 && languageGroupStart > -1) break;
            }
            if (charstringStart == -1) {
                this.isFontSubstituted = false;
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No glyph data found");
                }
            } else {
                glyphCount = this.extractFontData(this.skipBytes, cont, charstringStart, "rd", l, "nd");
            }
            if (subrsStart > -1) {
                this.extractSubroutineData(this.skipBytes, cont, subrsStart, charstringStart, "rd", l, "nd");
            }
            if (blueValuesStart > -1) {
                this.blueValues = Type1.readIntArray(cont, blueValuesStart);
            }
            if (otherBluesStart > -1) {
                this.otherBlues = Type1.readIntArray(cont, otherBluesStart);
            }
            if (familyBluesStart > -1) {
                this.familyBlues = Type1.readIntArray(cont, familyBluesStart);
            }
            if (familyOtherBluesStart > -1) {
                this.familyOtherBlues = Type1.readIntArray(cont, familyOtherBluesStart);
            }
            if (stdHWStart > -1) {
                this.stdHW = Type1.readReal(cont, stdHWStart);
            }
            if (stdVWStart > -1) {
                this.stdVW = Type1.readReal(cont, stdVWStart);
            }
            if (stemSnapHStart > -1) {
                this.stemSnapH = Type1.readIntArray(cont, stemSnapHStart);
            }
            if (stemSnapVStart > -1) {
                this.stemSnapV = Type1.readIntArray(cont, stemSnapVStart);
            }
            if (blueScaleStart > -1) {
                this.blueScale = Type1.readReal(cont, blueScaleStart);
            }
            if (blueShiftStart > -1) {
                this.blueShift = Type1.readInteger(cont, blueShiftStart);
            }
            if (blueFuzzStart > -1) {
                this.blueFuzz = Type1.readInteger(cont, blueFuzzStart);
            }
            if (forceBoldStart > -1) {
                int forceBoldEnd = -1;
                for (int j = forceBoldStart; j < l && forceBoldEnd == -1; ++j) {
                    if (!Type1.checkForString(cont, j, DEF_CHARS)) continue;
                    forceBoldEnd = j;
                }
                String val = new String(cont, forceBoldStart, forceBoldEnd - forceBoldStart);
                try {
                    this.forceBold = Boolean.parseBoolean(val);
                }
                catch (NumberFormatException e) {
                    if (!LogWriter.isOutput()) break block64;
                    LogWriter.writeLog("Caught an Exception " + e);
                }
            }
        }
        if (languageGroupStart > -1) {
            this.languageGroup = Type1.readInteger(cont, languageGroupStart);
        }
        return glyphCount;
    }

    static Integer readInteger(byte[] data, int offset) {
        int l = data.length;
        int end = -1;
        for (int j = offset; j < l && end == -1; ++j) {
            if (!Type1.checkForString(data, j, DEF_CHARS)) continue;
            end = j;
        }
        String val = new String(data, offset, end - offset);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception in handling Integer in Type1 " + e);
            }
            return null;
        }
    }

    static Double readReal(byte[] data, int offset) {
        int l = data.length;
        int end = -1;
        for (int j = offset; j < l && end == -1; ++j) {
            if (!Type1.checkForString(data, j, DEF_CHARS) && data[j] != 93 && data[j] != 10) continue;
            end = j;
        }
        String val = new String(data, offset, end - offset);
        if (val.contains("[")) {
            String[] stringParts = val.split("\\[");
            if (stringParts.length < 2) {
                return null;
            }
            val = stringParts[1];
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception in handling real in Type1 " + e);
            }
            return null;
        }
    }

    private static int[] readIntArray(byte[] data, int start) {
        int j;
        int[] result = null;
        int l = data.length;
        int end = -1;
        for (j = start; j < l && end == -1; ++j) {
            if (data[j] != 93 && data[j] != 47 && data[j] != 10) continue;
            end = j;
        }
        if (end != -1) {
            String values = new String(data, start, end - start);
            if (values.contains("[")) {
                String[] stringParts = values.split("\\[");
                if (stringParts.length < 2) {
                    return null;
                }
                values = stringParts[1];
            }
            values = values.trim();
            String[] stringValues = values.split(" ");
            result = new int[stringValues.length];
            for (j = 0; j < stringValues.length; ++j) {
                try {
                    result[j] = Integer.parseInt(stringValues[j].split("\\.")[0]);
                    continue;
                }
                catch (NumberFormatException e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception in handling IntArray " + e);
                    }
                    result[j] = -1;
                }
            }
        }
        return result;
    }

    private static boolean checkForString(byte[] data, int offset, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (data[offset + i] == chars[i]) continue;
            return false;
        }
        return true;
    }

    private void extractSubroutineData(int skipBytes, byte[] cont, int start, int charStart, String rd, int l, String nd) {
        char c;
        while (cont[start] == 32 || cont[start] == 10 || cont[start] == 13) {
            ++start;
        }
        StringBuilder tmp = new StringBuilder();
        while ((c = (char)cont[start]) != ' ') {
            tmp.append(c);
            ++start;
        }
        int count = Integer.parseInt(tmp.toString());
        for (int i = 0; i < count; ++i) {
            char c2;
            while (start < l && !((cont[start - 2] == 100 && cont[start - 1] == 117 && cont[start] == 112) | start == charStart)) {
                ++start;
            }
            if (start == charStart) {
                i = count;
                continue;
            }
            while (cont[start + 1] == 32) {
                ++start;
            }
            StringBuilder glyph = new StringBuilder("subrs");
            while ((c2 = (char)cont[++start]) != ' ') {
                glyph.append(c2);
            }
            tmp = new StringBuilder();
            while ((c2 = (char)cont[++start]) != ' ') {
                tmp.append(c2);
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            start = start + rd.length() + 1;
            byte[] stream = Type1.getStream(skipBytes, start, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream, i);
            start = start + byteCount + nd.length();
        }
    }

    private int extractFontData(int skipBytes, byte[] cont, int start, String rd, int l, String nd) {
        int total = cont.length;
        int glyphCount = 0;
        while (start < total && cont[start] != 47) {
            ++start;
        }
        int end = start;
        while (start < l) {
            if (cont[end] == 47) {
                end += 2;
                while (end < total && (cont[end - 1] != 124 || cont[end] != 45 && cont[end] != 48 || cont[end + 1] != 10 && cont[end + 1] != 13) && (cont[end - 1] != 78 || cont[end] != 68)) {
                    ++end;
                }
            }
            if (total - end < 3 || cont[end - 1] != 47 && cont[end] == 101 && cont[end + 1] == 110 && cont[end + 2] == 100) break;
            ++end;
        }
        while (start <= end) {
            char c;
            char c2;
            StringBuilder glyph = new StringBuilder(20);
            while ((c2 = (char)cont[++start]) != ' ') {
                glyph.append(c2);
            }
            if (this.trackIndices) {
                this.glyphs.setIndexForCharString(glyphCount, glyph.toString());
            }
            ++start;
            StringBuilder tmp = new StringBuilder();
            while ((c = (char)cont[start]) != ' ') {
                tmp.append(c);
                ++start;
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            start = start + rd.length() + 1;
            byte[] stream = Type1.getStream(skipBytes, start, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream, glyphCount);
            ++glyphCount;
            for (start = start + byteCount + nd.length(); start <= end && cont[start] != 47; ++start) {
            }
        }
        return glyphCount;
    }

    private static byte[] getStream(int skipBytes, int start, int byteCount, byte[] cont) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        int r = 4330;
        for (int i = 0; i < byteCount; ++i) {
            int cipher = cont[start + i] & 0xFF;
            int plain = cipher ^ r >> 8;
            r = (cipher + r) * 52845 + 22719 & 0xFFFF;
            if (i < skipBytes) continue;
            bos.write(plain);
        }
        return bos.toByteArray();
    }
}

