/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javafx.scene.shape.Path;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.render.T3Display;
import org.jpedal.render.T3Renderer;
import org.jpedal.utils.LogWriter;

public class T3Glyph
implements PdfGlyph {
    private boolean lockColours;
    T3Renderer glyphDisplay;
    private int maxWidth;
    private int maxHeight;
    float glyphScale;
    private int glyphNumber;

    public T3Glyph(T3Renderer glyphDisplay, int x, int y, boolean lockColours) {
        this.glyphScale = 1.0f;
        this.glyphNumber = -1;
        this.glyphDisplay = glyphDisplay;
        this.maxWidth = x;
        this.maxHeight = y;
        this.lockColours = lockColours;
    }

    public void setScaling(float glyphScaling) {
        this.glyphScale = glyphScaling;
    }

    @Override
    public Area getShape() {
        return null;
    }

    @Override
    public void render(int type, Graphics2D g2, float scaling, boolean isFormGlyph) {
        this.glyphDisplay.setScalingValues(0.0, 0.0, scaling);
        float OLDglyphScale = this.glyphScale;
        if (isFormGlyph) {
            this.glyphScale = scaling * this.glyphScale;
        }
        AffineTransform aff = null;
        if (this.glyphScale != 1.0f) {
            aff = g2.getTransform();
            g2.scale(this.glyphScale, this.glyphScale);
        }
        this.glyphDisplay.setG2(g2);
        this.glyphDisplay.paint(null, null, null);
        if (aff != null) {
            g2.setTransform(aff);
        }
        this.glyphScale = OLDglyphScale;
    }

    @Override
    public float getmaxWidth() {
        if (this.maxWidth == 0 && this.glyphScale <= 1.0f) {
            return 1.0f / this.glyphScale;
        }
        return this.maxWidth;
    }

    @Override
    public void setT3Colors(PdfPaint strokeColor, PdfPaint nonstrokeColor, boolean lockColours) {
        this.glyphDisplay.lockColors(strokeColor, nonstrokeColor, lockColours);
    }

    @Override
    public boolean ignoreColors() {
        return this.lockColours;
    }

    @Override
    public int getGlyphNumber() {
        return this.glyphNumber;
    }

    @Override
    public void setGlyphNumber(int no) {
        this.glyphNumber = no;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        byte[] dvr = this.glyphDisplay.serializeToByteArray(null);
        os.writeObject(dvr);
        os.writeInt(this.maxWidth);
        os.writeInt(this.maxHeight);
        os.writeBoolean(this.lockColours);
    }

    public T3Glyph(ObjectInput os) {
        block2: {
            this.glyphScale = 1.0f;
            this.glyphNumber = -1;
            try {
                byte[] dvr = (byte[])os.readObject();
                this.glyphDisplay = new T3Display(dvr, null);
                this.maxWidth = os.readInt();
                this.maxHeight = os.readInt();
                this.lockColours = os.readBoolean();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public void setWidth(float width) {
    }

    @Override
    public int getFontBB(int type) {
        return 0;
    }

    @Override
    public void setStrokedOnly(boolean b) {
    }

    @Override
    public boolean containsBrokenData() {
        return false;
    }

    @Override
    public Path getPath() {
        throw new UnsupportedOperationException("getPath Not supported yet.");
    }
}

