/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph.objects;

import org.jpedal.fonts.objects.FontData;

public class T1GlyphNumber {
    private static final String nybChars = "0123456789.ee -";

    public static final int getNumber(byte[] fontDataAsArray, int pos, double[] values, int valuePointer, boolean is1C) {
        double x = 0.0;
        int b0 = fontDataAsArray[pos] & 0xFF;
        if (b0 < 28 || b0 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (b0 == 28) {
            x = (fontDataAsArray[pos + 1] << 8) + (fontDataAsArray[pos + 2] & 0xFF);
            pos += 3;
        } else if (b0 == 255) {
            if (is1C) {
                x = ((fontDataAsArray[pos + 1] & 0xFF) << 8) + (fontDataAsArray[pos + 2] & 0xFF);
                x += (double)(((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF)) / 65536.0;
                if (fontDataAsArray[pos + 1] < 0) {
                    x -= 65536.0;
                }
            } else {
                x = ((fontDataAsArray[pos + 1] & 0xFF) << 24) + ((fontDataAsArray[pos + 2] & 0xFF) << 16) + ((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF);
            }
            pos += 5;
        } else if (b0 == 29) {
            x = ((fontDataAsArray[pos + 1] & 0xFF) << 24) + ((fontDataAsArray[pos + 2] & 0xFF) << 16) + ((fontDataAsArray[pos + 3] & 0xFF) << 8) + (fontDataAsArray[pos + 4] & 0xFF);
            pos += 5;
        } else if (b0 == 30) {
            char[] buf = new char[65];
            ++pos;
            int i = 0;
            while (i < 64) {
                int b = fontDataAsArray[pos++] & 0xFF;
                int nyb0 = b >> 4 & 0xF;
                int nyb1 = b & 0xF;
                if (nyb0 == 15) break;
                buf[i++] = nybChars.charAt(nyb0);
                if (i == 64) break;
                if (nyb0 == 12) {
                    buf[i++] = 45;
                }
                if (i == 64 || nyb1 == 15) break;
                buf[i++] = nybChars.charAt(nyb1);
                if (i == 64) break;
                if (nyb1 != 12) continue;
                buf[i++] = 45;
            }
            x = Double.valueOf(new String(buf, 0, i));
        } else if (b0 < 247) {
            x = b0 - 139;
            ++pos;
        } else if (b0 < 251) {
            x = (b0 - 247 << 8) + (fontDataAsArray[pos + 1] & 0xFF) + 108;
            pos += 2;
        } else {
            x = -(b0 - 251 << 8) - (fontDataAsArray[pos + 1] & 0xFF) - 108;
            pos += 2;
        }
        values[valuePointer] = x;
        return pos;
    }

    public static final int getNumber(FontData fontDataAsObject, int pos, double[] values, int valuePointer, boolean is1C) {
        double x = 0.0;
        int b0 = fontDataAsObject.getByte(pos) & 0xFF;
        if (b0 < 28 || b0 == 31) {
            System.err.println("!!!!Incorrect type1C operand");
        } else if (b0 == 28) {
            x = (fontDataAsObject.getByte(pos + 1) << 8) + (fontDataAsObject.getByte(pos + 2) & 0xFF);
            pos += 3;
        } else if (b0 == 255) {
            if (is1C) {
                int top = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 2) & 0xFF);
                if (top > 32768) {
                    top = 65536 - top;
                }
                double numb = top;
                double dec = ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
                x = numb + dec / 65536.0;
                if (fontDataAsObject.getByte(pos + 1) < 0) {
                    x = -x;
                }
            } else {
                x = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 24) + ((fontDataAsObject.getByte(pos + 2) & 0xFF) << 16) + ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
            }
            pos += 5;
        } else if (b0 == 29) {
            x = ((fontDataAsObject.getByte(pos + 1) & 0xFF) << 24) + ((fontDataAsObject.getByte(pos + 2) & 0xFF) << 16) + ((fontDataAsObject.getByte(pos + 3) & 0xFF) << 8) + (fontDataAsObject.getByte(pos + 4) & 0xFF);
            pos += 5;
        } else if (b0 == 30) {
            char[] buf = new char[65];
            ++pos;
            int i = 0;
            while (i < 64) {
                int b = fontDataAsObject.getByte(pos++) & 0xFF;
                int nyb0 = b >> 4 & 0xF;
                int nyb1 = b & 0xF;
                if (nyb0 == 15) break;
                buf[i++] = nybChars.charAt(nyb0);
                if (i == 64) break;
                if (nyb0 == 12) {
                    buf[i++] = 45;
                }
                if (i == 64 || nyb1 == 15) break;
                buf[i++] = nybChars.charAt(nyb1);
                if (i == 64) break;
                if (nyb1 != 12) continue;
                buf[i++] = 45;
            }
            x = Double.valueOf(new String(buf, 0, i));
        } else if (b0 < 247) {
            x = b0 - 139;
            ++pos;
        } else if (b0 < 251) {
            x = (b0 - 247 << 8) + (fontDataAsObject.getByte(pos + 1) & 0xFF) + 108;
            pos += 2;
        } else {
            x = -(b0 - 251 << 8) - (fontDataAsObject.getByte(pos + 1) & 0xFF) - 108;
            pos += 2;
        }
        values[valuePointer] = x;
        return pos;
    }
}

