/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.objects;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jpedal.utils.LogWriter;

public class FontData {
    private byte[] fontData;
    private boolean isInMemory;
    private int fullLength;
    private int offset;
    public static int maxSizeAllowedInMemory = -1;
    private int blockSize;
    private RandomAccessFile fontFile;

    public FontData(String cachedFile) {
        block3: {
            this.blockSize = 8192;
            try {
                this.fontFile = new RandomAccessFile(cachedFile, "r");
                this.fullLength = (int)this.fontFile.length();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        if (this.fullLength < maxSizeAllowedInMemory) {
            this.blockSize = maxSizeAllowedInMemory;
            this.adjustForCache(0);
            this.isInMemory = true;
        }
    }

    public byte getByte(int pointer) {
        if (!this.isInMemory) {
            pointer = this.adjustForCache(pointer);
        }
        if (pointer >= this.fontData.length) {
            return 0;
        }
        return this.fontData[pointer];
    }

    private int adjustForCache(int pointer) {
        if (this.fontData == null || pointer < this.offset || pointer >= this.offset + this.blockSize - 1) {
            block3: {
                try {
                    this.fontFile.seek(pointer);
                    this.fontData = new byte[this.blockSize];
                    this.fontFile.read(this.fontData);
                }
                catch (IOException e) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            this.offset = pointer;
        }
        return pointer - this.offset;
    }

    private int adjustForCache(int pointer, int blockSize) {
        block2: {
            try {
                this.fontFile.seek(pointer);
                this.fontData = new byte[blockSize];
                this.fontFile.read(this.fontData);
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.offset = pointer;
        return pointer - this.offset;
    }

    public byte[] getBytes(int startPointer, int length) {
        if (!this.isInMemory) {
            startPointer = this.adjustForCache(startPointer, length + 1);
        }
        byte[] block = new byte[length];
        System.arraycopy(this.fontData, startPointer, block, 0, length);
        return block;
    }

    public int length() {
        if (this.isInMemory) {
            return this.fontData.length;
        }
        return this.fullLength;
    }

    public void close() {
        block3: {
            if (this.fontFile != null) {
                try {
                    this.fontFile.close();
                }
                catch (IOException e) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }
}

